/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.authentication.util;

import com.filenet.apiimpl.authentication.util.AuthnLogLog4j;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Collection;
import java.util.Enumeration;
import javax.security.auth.Destroyable;
import javax.security.auth.Subject;

public class AuthnUtil {
    private static final String FNAME = "[AuthnUtil] ";
    private static boolean isInitLogger = true;
    private static AuthnLogLog4j logLog4j = null;

    private AuthnUtil() {
    }

    public static void setSysOutMode() {
        isInitLogger = false;
        logLog4j = null;
    }

    private static AuthnLogLog4j getLog4j() {
        if (isInitLogger) {
            isInitLogger = false;
            logLog4j = Log4jSetup.logLog4j;
        }
        return logLog4j;
    }

    public static synchronized void log(Object msg) {
        AuthnLogLog4j logger = AuthnUtil.getLog4j();
        if (logger != null) {
            logger.log(msg);
        } else {
            System.out.println(msg);
        }
    }

    public static synchronized void log(Object msg, Throwable t) {
        AuthnLogLog4j logger = AuthnUtil.getLog4j();
        if (logger != null) {
            logger.log(msg, t);
        } else {
            System.out.println(msg);
            t.printStackTrace();
        }
    }

    public static synchronized void warn(Object msg) {
        AuthnLogLog4j logger = AuthnUtil.getLog4j();
        if (logger != null) {
            logger.warn(msg);
        } else {
            System.out.println(msg);
        }
    }

    public static synchronized void warn(Object msg, Throwable t) {
        AuthnLogLog4j logger = AuthnUtil.getLog4j();
        if (logger != null) {
            logger.warn(msg, t);
        } else {
            System.out.println(msg);
            t.printStackTrace();
        }
    }

    public static synchronized void error(Object msg) {
        AuthnLogLog4j logger = AuthnUtil.getLog4j();
        if (logger != null) {
            logger.error(msg);
        } else {
            System.out.println(msg);
        }
    }

    public static synchronized void error(Object msg, Throwable t) {
        AuthnLogLog4j logger = AuthnUtil.getLog4j();
        if (logger != null) {
            logger.error(msg, t);
        } else {
            System.out.println(msg);
            t.printStackTrace();
        }
    }

    public static void destroyCred(Object c) {
        if (c instanceof char[]) {
            char[] a = (char[])c;
            for (int i = 0; i < a.length; ++i) {
                a[i] = '\u0000';
            }
            return;
        }
        if (c instanceof Destroyable) {
            try {
                ((Destroyable)c).destroy();
                return;
            }
            catch (Exception e) {}
        } else if (c instanceof String) {
            return;
        }
        try {
            Method m = c.getClass().getMethod("dispose", null);
            m.invoke(c, (Object[])null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void displayClassloaders(String where, Class cls) {
        StringBuffer buf = new StringBuffer();
        if (where == null || where.length() == 0 || where.charAt(0) != '[') {
            buf.append(FNAME);
        }
        buf.append(where);
        buf.append(": classloaders...");
        for (ClassLoader cl = cls.getClassLoader(); cl != null; cl = cl.getParent()) {
            buf.append('\n');
            buf.append("  ");
            AuthnUtil.displayObj(buf, cl);
        }
        AuthnUtil.log(buf.toString());
    }

    public static void displaySubject(String where, Subject subject) {
        StringBuffer buf = new StringBuffer();
        if (where == null || where.length() == 0 || where.charAt(0) != '[') {
            buf.append(FNAME);
        }
        buf.append(where);
        buf.append(": ");
        if (subject == null) {
            buf.append("subject is null!\n");
        } else {
            buf.append("contents of subject (");
            AuthnUtil.displayObj(buf, subject);
            for (Principal p : subject.getPrincipals()) {
                AuthnUtil.displayPrincipal(buf, p, 1);
            }
            AuthnUtil.displayCreds(buf, "public", subject.getPublicCredentials());
            AuthnUtil.displayCreds(buf, "private", subject.getPrivateCredentials());
        }
        AuthnUtil.log(buf.toString());
    }

    public static void displayObject(String where, Object obj) {
        StringBuffer buf = new StringBuffer();
        if (where == null || where.length() == 0 || where.charAt(0) != '[') {
            buf.append(FNAME);
        }
        buf.append(where);
        buf.append(": ");
        AuthnUtil.displayObj(buf, obj);
        AuthnUtil.log(buf.toString());
    }

    private static void displayPrincipal(StringBuffer buf, Principal principal, int level) {
        buf.append('\n');
        for (int i = 0; i < level; ++i) {
            buf.append("  ");
        }
        buf.append('[');
        buf.append(level);
        buf.append("] principal: ");
        buf.append(principal.getName());
        buf.append(" (");
        AuthnUtil.displayObj(buf, principal);
        buf.append(')');
        if (principal instanceof Group) {
            Group group = (Group)principal;
            int mems = 0;
            Enumeration mem = group.members();
            while (mem.hasMoreElements()) {
                Principal subprin = (Principal)mem.nextElement();
                AuthnUtil.displayPrincipal(buf, subprin, level + 1);
                ++mems;
            }
            if (mems == 0) {
                buf.append('\n');
                for (int i = 0; i <= level; ++i) {
                    buf.append("  ");
                }
                buf.append("<no members>");
            }
        }
    }

    private static void displayCreds(StringBuffer buf, String type, Collection creds) {
        for (Object cred : creds) {
            buf.append("\n  ");
            buf.append(type);
            buf.append(" credential: ");
            buf.append(cred.toString());
            buf.append(" (");
            AuthnUtil.displayObj(buf, cred);
            buf.append(")");
        }
    }

    private static void displayObj(StringBuffer buf, Object obj) {
        if (obj == null) {
            buf.append("null");
        } else {
            buf.append(obj.getClass().getName());
            buf.append('@');
            buf.append(Integer.toHexString(System.identityHashCode(obj)));
        }
    }

    private static class Log4jSetup {
        static AuthnLogLog4j logLog4j = null;

        private Log4jSetup() {
        }

        static {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> cLogger = Class.forName("org.apache.log4j.Logger", false, cl);
                logLog4j = new AuthnLogLog4j();
            }
            catch (Exception e) {
                System.out.println("[AuthnUtil] cannot use log4j, enabling System.out logging : " + e.getLocalizedMessage());
                logLog4j = null;
            }
        }
    }
}

