/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.util;

import com.filenet.apiimpl.wsi.WSICredential;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class WSILoginModule
implements LoginModule {
    public static final String PARAM_DEBUG = "debug";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private WSICredential credential = null;
    private String username = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to get authentication information");
        }
        String password = null;
        this.username = (String)this.sharedState.get("javax.security.auth.login.name");
        password = (String)this.sharedState.get("javax.security.auth.login.password");
        if (this.username == null) {
            Callback[] callbacks = null;
            callbacks = new Callback[]{new TextOutputCallback(0, "FileNet Content Engine Authentication"), new NameCallback("user name:"), new PasswordCallback("password:", false)};
            try {
                this.callbackHandler.handle(callbacks);
                this.username = ((NameCallback)callbacks[1]).getName();
                char[] tmpPassword = ((PasswordCallback)callbacks[2]).getPassword();
                password = tmpPassword != null ? new String(tmpPassword) : null;
                ((PasswordCallback)callbacks[2]).clearPassword();
                this.sharedState.put("javax.security.auth.login.name", this.username);
                this.sharedState.put("javax.security.auth.login.password", password);
            }
            catch (IOException ioe) {
                throw new LoginException(ioe.toString());
            }
            catch (UnsupportedCallbackException uce) {
                throw new LoginException("Error: no CallbackHandler available to get authentication information");
            }
        }
        this.credential = new WSICredential(this.username, password);
        return true;
    }

    public boolean commit() throws LoginException {
        if (this.credential == null) {
            return false;
        }
        if (!this.subject.getPrivateCredentials().contains(this.credential)) {
            this.subject.getPrivateCredentials().add(this.credential);
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.credential == null) {
            return false;
        }
        this.username = null;
        this.credential = null;
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrivateCredentials().remove(this.credential);
        this.username = null;
        this.credential = null;
        return true;
    }
}

