/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.util;

import com.filenet.api.core.Connection;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.UserPasswordToken;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.SubSystem;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserContext {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(UserContext.class, SubSystem.API);
    private Locale loc;
    private ArrayList subjects = new ArrayList();
    private int creatorThreadIdentity = System.identityHashCode(Thread.currentThread());
    private static ThreadLocal tl = new ThreadLocal();

    public UserContext() {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("UserContext <" + System.identityHashCode(this) + "> created in Thread  <" + this.creatorThreadIdentity + ">");
        }
    }

    public Subject getSubject() {
        return this.subjects.isEmpty() ? null : (Subject)this.subjects.get(this.subjects.size() - 1);
    }

    public static <T> Object doAs(Subject subject, PrivilegedExceptionAction<T> pea) {
        J2EEUtil j2ee = J2EEUtil.getInstance();
        return j2ee.doAs(subject, pea);
    }

    public static Subject getAmbientSubject() {
        J2EEUtil j2ee = J2EEUtil.getInstance();
        return j2ee.getCurrentSubject();
    }

    public synchronized void pushSubject(Subject sub) {
        if (sub == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "Subject");
        }
        this.subjects.add(sub);
    }

    public synchronized Subject popSubject() {
        return this.subjects.isEmpty() ? null : (Subject)this.subjects.remove(this.subjects.size() - 1);
    }

    public void setLocale(Locale locale) {
        this.loc = locale;
    }

    public Locale getLocale() {
        return this.loc == null ? Locale.getDefault() : this.loc;
    }

    private int getCreatorThreadIdentity() {
        return this.creatorThreadIdentity;
    }

    private synchronized UserContext cloneContext() {
        UserContext uc = new UserContext();
        uc.loc = this.loc;
        uc.subjects = (ArrayList)this.subjects.clone();
        return uc;
    }

    public static Subject createSubject(Connection conn, String user, String password, String optionalJAASStanzaName) {
        ConnectionImpl ci = (ConnectionImpl)conn;
        String providerURL = ci.getProviderURL();
        if (providerURL == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "Connection");
        }
        if (password == null || password.length() == 0) {
            throw new EngineRuntimeException(ExceptionCode.PASSWORD_IS_EMPTY_ERROR);
        }
        UserPasswordToken upt = new UserPasswordToken(user, password, optionalJAASStanzaName);
        upt.setProviderURL(ci.getProviderURL());
        return upt.getSubject(ci);
    }

    public static UserContext get() {
        UserContext cntx = (UserContext)tl.get();
        if (cntx == null) {
            cntx = new UserContext();
            tl.set(cntx);
        }
        return cntx;
    }

    public static void set(UserContext uc) {
        int currentThreadIdentity = System.identityHashCode(Thread.currentThread());
        if (uc != null && uc.getCreatorThreadIdentity() != currentThreadIdentity) {
            if (logger.isDetailTraceEnabled()) {
                StringBuffer msg = new StringBuffer();
                if (uc == null) {
                    msg.append("UserContext.set() invoked in Thread <" + currentThreadIdentity + "> for UserContext <null>.  UserContext will be cloned.");
                } else {
                    msg.append("UserContext.set() invoked in Thread <" + currentThreadIdentity + "> for UserContext <" + System.identityHashCode(uc) + "> and Principal <" + UserContext.getPrincipal(uc.getSubject()) + ">.  UserContext will be cloned.");
                }
                logger.traceDetail(msg.toString());
            }
            UserContext cloneUC = uc.cloneContext();
            tl.set(cloneUC);
        } else {
            if (logger.isDetailTraceEnabled()) {
                if (uc == null) {
                    logger.traceDetail("UserContext.set() invoked in its creator Thread <" + currentThreadIdentity + "> for UserContext <null>.");
                } else {
                    logger.traceDetail("UserContext.set() invoked in its creator Thread <" + currentThreadIdentity + "> for UserContext <" + System.identityHashCode(uc) + "> and Principal <" + UserContext.getPrincipal(uc.getSubject()) + ">.");
                }
            }
            tl.set(uc);
        }
    }

    private static String getPrincipal(Subject sub) {
        if (sub == null || sub.getPrincipals() == null || sub.getPrincipals().isEmpty()) {
            return "";
        }
        StringBuffer principals = new StringBuffer();
        int i = 0;
        Iterator<Principal> iter = sub.getPrincipals().iterator();
        while (iter.hasNext()) {
            if (i > 0) {
                principals.append("; ");
            }
            Principal principal = iter.next();
            principals.append("Principal[" + i++ + "]=" + ((Object)principal).toString());
        }
        return principals.toString();
    }
}

