/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.util;

import com.filenet.api.core.Connection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.Factory;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyFilter;
import com.filenet.apiimpl.util.UTF8Helper;
import java.security.Key;
import java.security.KeyFactory;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;

public class Encryption {
    protected Key key = null;
    protected String encryptionAlgorithm = null;

    protected Encryption(EngineObject eo) {
        Domain domain = this.getDomain(eo);
        this.getEncryptionProperties(domain);
    }

    protected Domain getDomain(EngineObject eo) {
        Connection conn = eo.getConnection();
        PropertyFilter pf = new PropertyFilter();
        pf.addIncludeProperty(0, null, null, "PublicKey EncryptionAlgorithm", null);
        Domain domain = Factory.Domain.fetchInstance(conn, null, pf);
        return domain;
    }

    protected void getEncryptionProperties(Domain domain) {
        byte[] publicKey = domain.get_PublicKey();
        this.encryptionAlgorithm = domain.get_EncryptionAlgorithm();
        if (null == publicKey || 0 == publicKey.length) {
            throw new EngineRuntimeException(ExceptionCode.SECURITY_DOMAIN_ENCRYPTION_UNDEFINED, "PublicKey");
        }
        if (null == this.encryptionAlgorithm || 0 == this.encryptionAlgorithm.length()) {
            throw new EngineRuntimeException(ExceptionCode.SECURITY_DOMAIN_ENCRYPTION_UNDEFINED, "EncryptionAlgorithm");
        }
        try {
            X509EncodedKeySpec ks = new X509EncodedKeySpec(publicKey);
            String algorithm = this.encryptionAlgorithm.split("/")[0];
            KeyFactory kf = KeyFactory.getInstance(algorithm);
            this.key = kf.generatePublic(ks);
        }
        catch (Exception e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    protected byte[] encrypt(byte[] plainText) {
        byte[] cipherText = (byte[])plainText.clone();
        Arrays.fill(plainText, (byte)-1);
        return cipherText;
    }

    public static byte[] encrypt(EngineObject eo, String plainText) {
        return Encryption.encrypt(eo, plainText.toCharArray());
    }

    public static byte[] encrypt(EngineObject eo, char[] plainText) {
        byte[] cipherText = null;
        if (null != plainText) {
            cipherText = UTF8Helper.encode(plainText);
            Arrays.fill(plainText, ' ');
        }
        return cipherText;
    }

    public static byte[] encrypt(EngineObject eo, byte[] plainText) {
        byte[] cipherText = null;
        if (null != plainText) {
            cipherText = (byte[])plainText.clone();
        }
        return cipherText;
    }
}

