/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.query;

import com.filenet.api.collection.ClassDescriptionSet;
import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.collection.RepositoryRowSet;
import com.filenet.api.constants.MergeMode;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.query.SearchSQL;
import com.filenet.api.query.SearchTemplateParameters;
import com.filenet.api.query.StoredSearch;
import com.filenet.apiimpl.query.RepositorySearch;
import com.filenet.apiimpl.query.RepositoryStoredSearch;

public final class SearchScope {
    private ObjectStore[] objectStores = null;
    private MergeMode mergeMode = null;

    public SearchScope(ObjectStore objectStore) {
        this.objectStores = new ObjectStore[1];
        this.objectStores[0] = objectStore;
    }

    public SearchScope(ObjectStore[] objectStores, MergeMode mergeMode) {
        if (objectStores == null || objectStores.length < 1) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectStores");
        }
        this.objectStores = (ObjectStore[])objectStores.clone();
        this.mergeMode = mergeMode;
    }

    public RepositoryRowSet fetchRows(SearchSQL searchSQL, Integer pageSize, PropertyFilter filter, Boolean continuable) {
        RepositorySearch rs = new RepositorySearch();
        if (this.objectStores.length > 1) {
            return rs.fetchRows(this.objectStores, searchSQL, this.mergeMode, pageSize, filter, continuable);
        }
        return rs.fetchRows(this.objectStores[0], searchSQL, pageSize, filter, continuable);
    }

    public IndependentObjectSet fetchObjects(SearchSQL searchSQL, Integer pageSize, PropertyFilter filter, Boolean continuable) {
        RepositorySearch rs = new RepositorySearch();
        if (this.objectStores.length > 1) {
            return rs.fetchObjects(this.objectStores, searchSQL, this.mergeMode, pageSize, filter, continuable);
        }
        return rs.fetchObjects(this.objectStores[0], searchSQL, pageSize, filter, continuable);
    }

    public RepositoryRowSet fetchRows(StoredSearch storedSearch, String searchClauseFromClass, SearchTemplateParameters templateData, Integer pageSize, PropertyFilter filter, Boolean continuable) {
        RepositoryStoredSearch rs = new RepositoryStoredSearch();
        if (this.objectStores.length > 1) {
            return rs.fetchRows(this.objectStores, storedSearch, searchClauseFromClass, templateData, this.mergeMode, pageSize, filter, continuable);
        }
        return rs.fetchRows(this.objectStores[0], storedSearch, searchClauseFromClass, templateData, pageSize, filter, continuable);
    }

    public IndependentObjectSet fetchObjects(StoredSearch storedSearch, String searchClauseFromClass, SearchTemplateParameters templateData, Integer pageSize, PropertyFilter filter, Boolean continuable) {
        RepositoryStoredSearch rs = new RepositoryStoredSearch();
        if (this.objectStores.length > 1) {
            return rs.fetchObjects(this.objectStores, storedSearch, searchClauseFromClass, templateData, this.mergeMode, pageSize, filter, continuable);
        }
        return rs.fetchObjects(this.objectStores[0], storedSearch, searchClauseFromClass, templateData, pageSize, filter, continuable);
    }

    public ClassDescriptionSet fetchSearchableClassDescriptions(String[] classNames, PropertyFilter filter) {
        RepositorySearch rs = new RepositorySearch();
        if (this.objectStores.length > 1) {
            return rs.fetchSearchableClassDescriptions(this.objectStores, this.mergeMode, classNames, filter);
        }
        return rs.fetchSearchableClassDescriptions(this.objectStores[0], classNames, filter);
    }

    public MergeMode getMergeMode() {
        if (this.objectStores != null && this.objectStores.length > 1) {
            return this.mergeMode;
        }
        return MergeMode.UNION;
    }

    public ObjectStore[] getObjectStores() {
        return (ObjectStore[])this.objectStores.clone();
    }
}

