/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.query;

import com.filenet.api.constants.JoinComparison;
import com.filenet.api.constants.JoinOperator;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;

public class SearchSQL {
    private String selectList = null;
    private String fromClauseInit = null;
    private String fromClauseAdd = null;
    private String whereClause = null;
    private String orderByClause = null;
    private String folderRest = null;
    private String freetextOnProp = null;
    private String containsOnProp = null;
    private String freetextOnCont = null;
    private String freetextOnContJoin = null;
    private String containsOnCont = null;
    private String containsOnContFrom = null;
    private String distinctAll = null;
    private Integer maxRecords = null;
    private Integer timeLimit = null;
    private String queryString = null;
    private static final String SQL_WITH_INCLUDE_SUBCLASSES = "WITH INCLUDESUBCLASSES";
    private static final String SQL_WITH_EXCLUDE_SUBCLASSES = "WITH EXCLUDESUBCLASSES";
    private static final String SQL_INNER_JOIN = "INNER JOIN";
    private static final String SQL_LEFT_OUTER_JOIN = "LEFT OUTER JOIN";
    private static final String SQL_RIGHT_OUTER_JOIN = "RIGHT OUTER JOIN";
    private static final String SQL_FULL_OUTER_JOIN = "FULL OUTER JOIN";
    private static final String SQL_INFOLDER = "INFOLDER";
    private static final String SQL_ON = "ON";
    private static final String SQL_AS = "AS";
    private static final String SQL_OPTIONS = "OPTIONS";
    private static final String SQL_TOP = "TOP";
    private static final String SQL_TIMELIMIT = "TIMELIMIT";
    private static final String SQL_SELECT = "SELECT";
    private static final String SQL_FROM = "FROM";
    private static final String SQL_WHERE = "WHERE";
    private static final String SQL_ORDER_BY = "ORDER BY";
    private static final String SQL_FREETEXT = "FREETEXT";
    private static final String SQL_CONTAINS = "CONTAINS";
    private static final String SQL_DISTINCT = "DISTINCT";
    private static final String SQL_ALL = "ALL";
    private static final String SQL_AND = "AND";
    private static final String SPACE = " ";

    public SearchSQL() {
    }

    public SearchSQL(String queryString) {
        this.queryString = queryString;
    }

    public void setSelectList(String selectList) {
        this.validateRequiredSQLParameter("selectList", selectList);
        this.queryString = null;
        this.selectList = selectList;
    }

    public void setFromClauseInitialValue(String symbolicClassName, String aliasName, boolean includeSubclasses) {
        this.validateRequiredSQLParameter("symbolicClassName", symbolicClassName);
        this.queryString = null;
        this.fromClauseInit = symbolicClassName;
        if (aliasName != null) {
            this.fromClauseInit = this.fromClauseInit + " AS " + aliasName;
        }
        this.fromClauseInit = includeSubclasses ? this.fromClauseInit + " WITH INCLUDESUBCLASSES" : this.fromClauseInit + " WITH EXCLUDESUBCLASSES";
    }

    public void setFromClauseAdditionalJoin(JoinOperator joinOperator, String symbolicClassName, String aliasName, String joinVar1, JoinComparison joinComparison, String joinVar2, boolean includeSubclasses) {
        if (this.fromClauseInit == null || this.fromClauseInit.length() == 0) {
            throw new EngineRuntimeException(ExceptionCode.API_FROM_INIT_VALUE_NOT_SET, null);
        }
        if (joinOperator == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "joinOperator");
        }
        if (joinComparison == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "joinComparison");
        }
        this.validateRequiredSQLParameter("symbolicClassName", symbolicClassName);
        this.validateRequiredSQLParameter("joinVar1", joinVar1);
        this.validateRequiredSQLParameter("joinVar2", joinVar2);
        this.queryString = null;
        switch (joinOperator.getValue()) {
            case 0: {
                this.fromClauseAdd = SQL_INNER_JOIN;
                break;
            }
            case 1: {
                this.fromClauseAdd = SQL_LEFT_OUTER_JOIN;
                break;
            }
            case 2: {
                this.fromClauseAdd = SQL_RIGHT_OUTER_JOIN;
                break;
            }
            case 3: {
                this.fromClauseAdd = SQL_FULL_OUTER_JOIN;
            }
        }
        this.fromClauseAdd = this.fromClauseAdd + SPACE + symbolicClassName;
        if (aliasName != null) {
            this.fromClauseAdd = this.fromClauseAdd + " AS " + aliasName;
        }
        this.fromClauseAdd = includeSubclasses ? this.fromClauseAdd + " WITH INCLUDESUBCLASSES ON" : this.fromClauseAdd + " WITH EXCLUDESUBCLASSES ON";
        this.fromClauseAdd = this.fromClauseAdd + SPACE + joinVar1 + SPACE + joinComparison.getOperator() + SPACE + joinVar2;
    }

    public void setWhereClause(String whereClause) {
        this.validateRequiredSQLParameter("whereClause", whereClause);
        this.queryString = null;
        this.whereClause = whereClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.validateRequiredSQLParameter("orderByClause", orderByClause);
        this.queryString = null;
        this.orderByClause = orderByClause;
    }

    public void setFolderRestriction(String symbolicClassName, String folderName) {
        this.validateRequiredSQLParameter("symbolicClassName", symbolicClassName);
        this.validateRequiredSQLParameter("folderName", folderName);
        this.queryString = null;
        if (!symbolicClassName.contains(".")) {
            symbolicClassName = symbolicClassName + ".this";
        }
        this.folderRest = symbolicClassName + SPACE + SQL_INFOLDER + SPACE + this.wrapWithQuotes(folderName);
    }

    public void setFreetextRestriction(String symbolicClassName, String searchExpression) {
        this.validateRequiredSQLParameter("symbolicClassName", symbolicClassName);
        this.validateRequiredSQLParameter("searchExpression", searchExpression);
        this.queryString = null;
        this.freetextOnCont = "FREETEXT(Content, " + this.wrapWithQuotes(searchExpression) + ")";
        this.freetextOnContJoin = "INNER JOIN ContentSearch ON " + symbolicClassName + ".This = ContentSearch.QueriedObject";
    }

    public void setContainsRestriction(String symbolicClassName, String searchExpression) {
        this.validateRequiredSQLParameter("symbolicClassName", symbolicClassName);
        this.validateRequiredSQLParameter("searchExpression", searchExpression);
        this.queryString = null;
        this.containsOnCont = "CONTAINS(Content, " + this.wrapWithQuotes(searchExpression) + ")";
        this.containsOnContFrom = "INNER JOIN ContentSearch ON " + symbolicClassName + ".This = ContentSearch.QueriedObject";
    }

    public void setContainsRestriction(String symbolicClassName, String searchExpression, String searchDialect) {
        this.validateRequiredSQLParameter("symbolicClassName", symbolicClassName);
        this.validateRequiredSQLParameter("searchExpression", searchExpression);
        this.validateSearchDialect("searchDialect", searchDialect);
        this.queryString = null;
        this.containsOnCont = searchDialect == null ? "CONTAINS(Content, " + this.wrapWithQuotes(searchExpression) + ")" : "CONTAINS(Content, " + this.wrapWithQuotes(searchExpression) + ", " + this.wrapWithQuotes(searchDialect) + ")";
        this.containsOnContFrom = "INNER JOIN ContentSearch ON " + symbolicClassName + ".This = ContentSearch.QueriedObject";
    }

    public void setDistinct() {
        this.queryString = null;
        this.distinctAll = SQL_DISTINCT;
    }

    public void setAll() {
        this.queryString = null;
        this.distinctAll = SQL_ALL;
    }

    public void setMaxRecords(int maxRecords) {
        if (maxRecords <= 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "batchSize");
        }
        this.queryString = null;
        this.maxRecords = new Integer(maxRecords);
    }

    public void setTimeLimit(int timeLimit) {
        if (timeLimit <= 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "timeLimit");
        }
        this.queryString = null;
        this.timeLimit = new Integer(timeLimit);
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
        this.selectList = null;
        this.fromClauseInit = null;
        this.fromClauseAdd = null;
        this.whereClause = null;
        this.orderByClause = null;
        this.folderRest = null;
        this.freetextOnProp = null;
        this.containsOnProp = null;
        this.freetextOnCont = null;
        this.freetextOnContJoin = null;
        this.containsOnCont = null;
        this.containsOnContFrom = null;
        this.distinctAll = null;
        this.maxRecords = null;
        this.timeLimit = null;
    }

    public String toString() {
        if (this.queryString != null && this.queryString.length() > 0) {
            return this.queryString;
        }
        if (this.fromClauseInit != null && this.fromClauseInit.length() > 0) {
            return this.Select() + this.From() + this.Where() + this.OrderBy() + this.Options();
        }
        throw new EngineRuntimeException(ExceptionCode.API_FROM_INIT_OR_QUERY_STRING_NOT_SET, null);
    }

    private String Select() {
        String select = SQL_SELECT;
        if (this.distinctAll != null) {
            select = select + SPACE + this.distinctAll;
        }
        if (this.maxRecords != null) {
            select = select + " TOP " + this.maxRecords.toString();
        }
        select = this.selectList != null && this.selectList.length() > 0 ? select + SPACE + this.selectList : select + " *";
        return select;
    }

    private String From() {
        String from = " FROM " + this.fromClauseInit;
        if (this.fromClauseAdd != null && this.fromClauseAdd.length() > 0) {
            from = from + SPACE + this.fromClauseAdd;
        }
        if (this.freetextOnContJoin != null && this.freetextOnContJoin.length() > 0) {
            from = from + SPACE + this.freetextOnContJoin;
        }
        if (this.containsOnContFrom != null && this.containsOnContFrom.length() > 0) {
            from = from + SPACE + this.containsOnContFrom;
        }
        return from;
    }

    private String Where() {
        String where = "";
        if (this.whereClause != null && this.whereClause.length() > 0) {
            where = where + this.whereClause;
        }
        if (this.folderRest != null && this.folderRest.length() > 0) {
            if (where.length() > 0) {
                where = where + " AND ";
            }
            where = where + this.folderRest;
        }
        if (this.freetextOnProp != null && this.freetextOnProp.length() > 0) {
            if (where.length() > 0) {
                where = where + " AND ";
            }
            where = where + this.freetextOnProp;
        }
        if (this.containsOnProp != null && this.containsOnProp.length() > 0) {
            if (where.length() > 0) {
                where = where + " AND ";
            }
            where = where + this.containsOnProp;
        }
        if (this.freetextOnCont != null && this.freetextOnCont.length() > 0) {
            if (where.length() > 0) {
                where = where + " AND ";
            }
            where = where + this.freetextOnCont;
        }
        if (this.containsOnCont != null && this.containsOnCont.length() > 0) {
            if (where.length() > 0) {
                where = where + " AND ";
            }
            where = where + this.containsOnCont;
        }
        if (where.length() > 0) {
            where = " WHERE " + where;
        }
        return where;
    }

    private String OrderBy() {
        String orderBy = "";
        if (this.orderByClause != null && this.orderByClause.length() > 0) {
            orderBy = " ORDER BY " + this.orderByClause;
        }
        return orderBy;
    }

    private String Options() {
        String options = "";
        if (this.timeLimit != null) {
            options = " OPTIONS (TIMELIMIT " + this.timeLimit.toString() + ")";
        }
        return options;
    }

    private String wrapWithQuotes(String literal) {
        literal = literal.trim();
        int len = literal.length();
        if (literal.charAt(0) != '\'' && literal.charAt(len - 1) != '\'') {
            return "'" + literal + "'";
        }
        return literal;
    }

    private void validateRequiredSQLParameter(String paramName, String paramValue) {
        if (paramValue == null || paramValue.length() == 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, paramName);
        }
    }

    private void validateSearchDialect(String paramName, String paramValue) {
        if (paramValue != null && !paramValue.equalsIgnoreCase("Lucene") && !paramValue.equalsIgnoreCase("K2VQL")) {
            throw new EngineRuntimeException(ExceptionCode.CBR_INVALID_SEARCH_DIALECT, paramValue);
        }
    }
}

