/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.property;

import com.filenet.api.constants.FilteredPropertyType;
import com.filenet.api.property.FilterElement;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PropertyFilter
implements Serializable {
    private List includePropertyList = new ArrayList();
    private List includeTypeList = new ArrayList();
    private List excludePropertyList = new ArrayList();
    private Integer maxRecursion;
    private Long maxSize;
    private Integer pageSize;
    private Boolean levelDependents;
    static final long serialVersionUID = 733422040975163154L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.setPageSize(new Integer(pageSize));
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setMaxRecursion(int maxRecursion) {
        this.setMaxRecursion(new Integer(maxRecursion));
    }

    public void setMaxRecursion(Integer maxRecursion) {
        this.maxRecursion = maxRecursion;
    }

    public Integer getMaxRecursion() {
        return this.maxRecursion;
    }

    public void setMaxSize(Long maxSize) {
        this.maxSize = maxSize;
    }

    public Long getMaxSize() {
        return this.maxSize;
    }

    public Boolean getLevelDependents() {
        return this.levelDependents;
    }

    public void setLevelDependents(boolean levelDependents) {
        this.setLevelDependents(levelDependents ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setLevelDependents(Boolean levelDependents) {
        this.levelDependents = levelDependents;
    }

    public void addIncludeProperty(FilterElement fe) {
        this.includePropertyList.add(fe);
    }

    public void addIncludeProperty(int maxRecursion, Long maxSize, Boolean levelDependents, String value, Integer pageSize) {
        this.addIncludeProperty(new FilterElement(new Integer(maxRecursion), maxSize, levelDependents, value, pageSize));
    }

    public void addIncludeProperty(int maxRecursion, Long maxSize, Boolean levelDependents, String value) {
        this.addIncludeProperty(new FilterElement(new Integer(maxRecursion), maxSize, levelDependents, value, null));
    }

    public FilterElement[] getIncludeProperties() {
        return this.includePropertyList.toArray(new FilterElement[this.includePropertyList.size()]);
    }

    public void addExcludeProperty(String value) {
        this.excludePropertyList.add(value);
    }

    public String[] getExcludeProperties() {
        return this.excludePropertyList.toArray(new String[this.excludePropertyList.size()]);
    }

    public void addIncludeType(FilterElement fe) {
        String[] fevs = fe.getValue().split(" ");
        for (int i = 0; i < fevs.length; ++i) {
            String fev = fevs[i];
            if (fev.equals("")) continue;
            FilteredPropertyType.getInstanceFromString(fev);
        }
        this.includeTypeList.add(fe);
    }

    public void addIncludeType(int maxRecursion, Long maxSize, Boolean levelDependents, FilteredPropertyType value, Integer pageSize) {
        this.addIncludeType(new FilterElement(new Integer(maxRecursion), maxSize, levelDependents, value, pageSize));
    }

    public void addIncludeType(int maxRecursion, Long maxSize, Boolean levelDependents, FilteredPropertyType value) {
        this.addIncludeType(new FilterElement(new Integer(maxRecursion), maxSize, levelDependents, value, null));
    }

    public FilterElement[] getIncludeTypes() {
        return this.includeTypeList.toArray(new FilterElement[this.includeTypeList.size()]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append(" Class=");
        sb.append(this.getClass().getName());
        sb.append(" MaxRecursions=");
        sb.append(this.maxRecursion);
        sb.append(" MaxSize=");
        sb.append(this.maxSize);
        sb.append(" PageSize=");
        sb.append(this.pageSize);
        sb.append(" LevelDependents=");
        sb.append(this.levelDependents);
        sb.append(" IncludePropertyList=");
        sb.append(this.includePropertyList);
        sb.append(" IncludeTypeList=");
        sb.append(this.includeTypeList);
        sb.append(" ExcludePropertyList=");
        sb.append(this.excludePropertyList);
        return sb.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int lp;
        s.readShort();
        this.maxRecursion = (Integer)s.readObject();
        this.maxSize = (Long)s.readObject();
        this.pageSize = (Integer)s.readObject();
        this.levelDependents = (Boolean)s.readObject();
        this.includePropertyList = new ArrayList();
        int size = s.readInt();
        for (lp = 0; lp < size; ++lp) {
            this.includePropertyList.add(s.readObject());
        }
        this.includeTypeList = new ArrayList();
        size = s.readInt();
        for (lp = 0; lp < size; ++lp) {
            this.includeTypeList.add(s.readObject());
        }
        this.excludePropertyList = new ArrayList();
        size = s.readInt();
        for (lp = 0; lp < size; ++lp) {
            this.excludePropertyList.add(s.readObject());
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int lp;
        s.writeShort(5);
        s.writeObject(this.maxRecursion);
        s.writeObject(this.maxSize);
        s.writeObject(this.pageSize);
        s.writeObject(this.levelDependents);
        int size = this.includePropertyList.size();
        s.writeInt(size);
        for (lp = 0; lp < size; ++lp) {
            s.writeObject(this.includePropertyList.get(lp));
        }
        size = this.includeTypeList.size();
        s.writeInt(size);
        for (lp = 0; lp < size; ++lp) {
            s.writeObject(this.includeTypeList.get(lp));
        }
        size = this.excludePropertyList.size();
        s.writeInt(size);
        for (lp = 0; lp < size; ++lp) {
            s.writeObject(this.excludePropertyList.get(lp));
        }
    }
}

