/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.jdbc;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.exception.ExceptionContext;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class Driver
implements java.sql.Driver {
    private static final String FP8 = "jdbc:filenetp8:";
    private static final int FP8_LENGTH = "jdbc:filenetp8:".length();
    private static boolean inStaticInit = true;
    public static final String URI_PROPERTY_KEY = "uri";
    public static final String OBJECTSTORES_PROPERTY_KEY = "objectstores";
    public static final String MERGEMODE_PROPERTY_KEY = "mergemode";
    public static final String PASSWORD_PROPERTY_KEY = "password";
    public static final String USER_PROPERTY_KEY = "user";
    public static final String LOCALE_PROPERTY_KEY = "locale";
    public static final String JAASCONFIGNAME_PROPERTY_KEY = "jaasconfigname";

    public Driver() {
        if (!inStaticInit) {
            boolean alreadyRegistered = false;
            Enumeration<java.sql.Driver> drivers = DriverManager.getDrivers();
            while (drivers.hasMoreElements()) {
                java.sql.Driver driver = drivers.nextElement();
                if (!driver.equals(this)) continue;
                alreadyRegistered = true;
                break;
            }
            if (!alreadyRegistered) {
                try {
                    DriverManager.registerDriver(this);
                }
                catch (SQLException e) {
                    throw new EngineRuntimeException(ExceptionCode.JDBC_DRIVER_STATIC_ERROR);
                }
            }
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            return false;
        }
        if (url.length() <= FP8_LENGTH) {
            return false;
        }
        return url.substring(0, FP8_LENGTH).equalsIgnoreCase(FP8);
    }

    public Connection connect(String url, Properties info) throws SQLException {
        try {
            Properties props = null;
            props = this.parseURL(url, info);
            if (props == null) {
                return null;
            }
            com.filenet.apiimpl.jdbc.Connection newConn = new com.filenet.apiimpl.jdbc.Connection(props, url, this);
            return newConn;
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (EngineRuntimeException eRe) {
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        catch (Exception ex) {
            Object[] params = new Object[]{url};
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_CONNECT_ERROR, params);
            eRe.initCause(ex);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Properties prop = new Properties();
        if (info == null) {
            info = new Properties();
        }
        if (url != null && url.startsWith(FP8)) {
            prop = this.parseURL(url, info);
        }
        DriverPropertyInfo uriProp = new DriverPropertyInfo(URI_PROPERTY_KEY, prop.getProperty(URI_PROPERTY_KEY));
        uriProp.required = true;
        ExceptionContext eContext = ExceptionContext.JDBC_DRIVER_URI;
        uriProp.description = eContext.toString(null);
        uriProp.value = prop.getProperty(URI_PROPERTY_KEY);
        DriverPropertyInfo objectStoresProp = new DriverPropertyInfo(OBJECTSTORES_PROPERTY_KEY, prop.getProperty(OBJECTSTORES_PROPERTY_KEY));
        objectStoresProp.required = true;
        eContext = ExceptionContext.JDBC_DRIVER_OBJECTSTORE;
        objectStoresProp.description = eContext.toString(null);
        objectStoresProp.value = prop.getProperty(OBJECTSTORES_PROPERTY_KEY);
        DriverPropertyInfo mergeModeProp = new DriverPropertyInfo(MERGEMODE_PROPERTY_KEY, prop.getProperty(MERGEMODE_PROPERTY_KEY));
        mergeModeProp.required = false;
        eContext = ExceptionContext.JDBC_DRIVER_MERGEMODE;
        mergeModeProp.description = eContext.toString(null) + " Available options are Union and Intersection.";
        mergeModeProp.choices = new String[]{"Union", "Intersection"};
        mergeModeProp.value = prop.getProperty(MERGEMODE_PROPERTY_KEY);
        DriverPropertyInfo localeProp = new DriverPropertyInfo(LOCALE_PROPERTY_KEY, prop.getProperty(LOCALE_PROPERTY_KEY));
        localeProp.required = false;
        eContext = ExceptionContext.JDBC_DRIVER_LOCALE;
        localeProp.description = eContext.toString(null);
        localeProp.value = prop.getProperty(LOCALE_PROPERTY_KEY);
        DriverPropertyInfo userProp = new DriverPropertyInfo(USER_PROPERTY_KEY, prop.getProperty(USER_PROPERTY_KEY));
        userProp.required = true;
        eContext = ExceptionContext.JDBC_DRIVER_USER;
        userProp.description = eContext.toString(null);
        userProp.value = prop.getProperty(USER_PROPERTY_KEY);
        DriverPropertyInfo passwordProp = new DriverPropertyInfo(PASSWORD_PROPERTY_KEY, prop.getProperty(PASSWORD_PROPERTY_KEY));
        passwordProp.required = true;
        eContext = ExceptionContext.JDBC_DRIVER_PASSWORD;
        passwordProp.description = eContext.toString(null);
        passwordProp.value = prop.getProperty(PASSWORD_PROPERTY_KEY);
        DriverPropertyInfo jassConfigName = new DriverPropertyInfo(JAASCONFIGNAME_PROPERTY_KEY, prop.getProperty(JAASCONFIGNAME_PROPERTY_KEY));
        jassConfigName.required = false;
        eContext = ExceptionContext.JDBC_DRIVER_JAASCONFIGNAME;
        jassConfigName.description = eContext.toString(null);
        jassConfigName.value = prop.getProperty(JAASCONFIGNAME_PROPERTY_KEY);
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[]{uriProp, objectStoresProp, mergeModeProp, userProp, passwordProp, jassConfigName, localeProp};
        return dpi;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Driver)) {
            return false;
        }
        java.sql.Driver drv = (java.sql.Driver)obj;
        if (drv.getMajorVersion() != this.getMajorVersion()) {
            return false;
        }
        return drv.getMinorVersion() == this.getMinorVersion();
    }

    private Properties parseURL(String url, Properties defaults) throws SQLException {
        SQLException sqlEx;
        EngineRuntimeException eRe;
        String paramsSplit;
        Properties urlProps;
        Properties properties = urlProps = defaults != null ? new Properties(defaults) : new Properties();
        if (defaults == null) {
            defaults = new Properties();
        }
        if (url == null) {
            return null;
        }
        if (url.length() <= FP8_LENGTH) {
            return null;
        }
        if (!url.substring(0, FP8_LENGTH).equalsIgnoreCase(FP8)) {
            return null;
        }
        int uriSplit = url.indexOf(63);
        String uriName = null;
        if (uriSplit == -1) {
            paramsSplit = null;
            uriName = url.substring(15);
        } else {
            paramsSplit = url.substring(uriSplit + 1, url.length());
            uriName = url.substring(15, uriSplit);
        }
        if (null == uriName) {
            EngineRuntimeException eRe2 = new EngineRuntimeException(ExceptionCode.JDBC_URI_IS_EMPTY_ERROR);
            SQLException sqlEx2 = new SQLException(eRe2.getLocalizedMessage());
            sqlEx2.initCause(eRe2);
            throw sqlEx2;
        }
        urlProps.put(URI_PROPERTY_KEY, uriName);
        String objectStoreNames = null;
        String mergeModeName = null;
        String jaasConfigName = null;
        String user = null;
        String pwd = null;
        String localeString = null;
        if (null != paramsSplit) {
            StringTokenizer tokenizer = new StringTokenizer(paramsSplit, "&");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                StringTokenizer internalTokenizer = new StringTokenizer(token, "=");
                int count = 0;
                while (internalTokenizer.hasMoreTokens()) {
                    String internaltoken = internalTokenizer.nextToken();
                    if (count != 0) continue;
                    if (internaltoken.equalsIgnoreCase(OBJECTSTORES_PROPERTY_KEY)) {
                        objectStoreNames = internalTokenizer.nextToken();
                    }
                    if (internaltoken.equalsIgnoreCase(MERGEMODE_PROPERTY_KEY)) {
                        mergeModeName = internalTokenizer.nextToken();
                    }
                    if (internaltoken.equalsIgnoreCase(LOCALE_PROPERTY_KEY)) {
                        localeString = internalTokenizer.nextToken();
                    }
                    if (internaltoken.equalsIgnoreCase(JAASCONFIGNAME_PROPERTY_KEY)) {
                        jaasConfigName = internalTokenizer.nextToken();
                    }
                    if (internaltoken.equalsIgnoreCase(USER_PROPERTY_KEY)) {
                        user = internalTokenizer.nextToken();
                    }
                    if (internaltoken.equalsIgnoreCase(PASSWORD_PROPERTY_KEY)) {
                        pwd = internalTokenizer.nextToken();
                    }
                    ++count;
                }
            }
        }
        if (null == objectStoreNames) {
            objectStoreNames = (String)defaults.get(OBJECTSTORES_PROPERTY_KEY);
        }
        if (null == objectStoreNames) {
            EngineRuntimeException eRe3 = new EngineRuntimeException(ExceptionCode.JDBC_OBJECTSTORE_IS_EMPTY_ERROR);
            SQLException sqlEx3 = new SQLException(eRe3.getLocalizedMessage());
            sqlEx3.initCause(eRe3);
            throw sqlEx3;
        }
        urlProps.put(OBJECTSTORES_PROPERTY_KEY, objectStoreNames);
        if (null == mergeModeName) {
            mergeModeName = (String)defaults.get(MERGEMODE_PROPERTY_KEY);
        }
        try {
            if (null != mergeModeName) {
                urlProps.put(MERGEMODE_PROPERTY_KEY, mergeModeName);
            } else {
                urlProps.put(MERGEMODE_PROPERTY_KEY, "Union");
            }
        }
        catch (Exception e) {
            urlProps.put(MERGEMODE_PROPERTY_KEY, "Union");
        }
        if (null == localeString) {
            localeString = (String)defaults.get(LOCALE_PROPERTY_KEY);
        }
        if (null == jaasConfigName) {
            jaasConfigName = (String)defaults.get(JAASCONFIGNAME_PROPERTY_KEY);
        }
        try {
            if (null != jaasConfigName) {
                urlProps.put(JAASCONFIGNAME_PROPERTY_KEY, jaasConfigName);
            } else {
                urlProps.put(JAASCONFIGNAME_PROPERTY_KEY, "FileNetP8");
            }
        }
        catch (Exception e) {
            urlProps.put(JAASCONFIGNAME_PROPERTY_KEY, "FileNetP8");
        }
        boolean isJaasConfigAmbient = false;
        if (null != jaasConfigName && jaasConfigName.equals("!")) {
            isJaasConfigAmbient = true;
        }
        if (null == user) {
            user = (String)defaults.get(USER_PROPERTY_KEY);
        }
        if (null != user) {
            urlProps.put(USER_PROPERTY_KEY, user);
        } else if (!isJaasConfigAmbient) {
            eRe = new EngineRuntimeException(ExceptionCode.JDBC_USER_IS_EMPTY_ERROR);
            sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        if (null == pwd) {
            pwd = (String)defaults.get(PASSWORD_PROPERTY_KEY);
        }
        if (null != pwd) {
            urlProps.put(PASSWORD_PROPERTY_KEY, pwd);
        } else if (!isJaasConfigAmbient) {
            eRe = new EngineRuntimeException(ExceptionCode.JDBC_PASSWORD_IS_EMPTY_ERROR);
            sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        return urlProps;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
            inStaticInit = false;
        }
        catch (SQLException e) {
            throw new EngineRuntimeException(ExceptionCode.JDBC_DRIVER_STATIC_ERROR);
        }
    }
}

