/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.exception;

import com.filenet.api.exception.ErrorLoggingLevel;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.LString;
import com.filenet.apiimpl.util.SubSystem;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ExceptionCode
extends LString
implements Serializable {
    private static final String RES_BASE_NAME = "res/ExceptionCode";
    private static final BaseLogger stLogger = BaseLogger.getBaseLogger(ExceptionCode.class, SubSystem.API);
    private static Map mapNameToExceptionCodeInstance = new HashMap();
    private transient boolean isFatal = false;
    private transient ErrorLoggingLevel mErrorLoggingLevel = ErrorLoggingLevel.Required;
    public static final Locale stDefaultLocale = Locale.getDefault();
    private String id;
    public static final ExceptionCode API_AFTER_LAST_PAGE_ELEMENT = new ExceptionCode("API_AFTER_LAST_PAGE_ELEMENT", "Attempted to get the current page or element count after moving past the last page.", "FNRCA0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_BEFORE_FIRST_PAGE_ELEMENT = new ExceptionCode("API_BEFORE_FIRST_PAGE_ELEMENT", "Attempted to get the current page or element count before moving to the first page.", "FNRCA0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_BEFORE_NEXT_PAGE_ELEMENT = new ExceptionCode("API_BEFORE_NEXT_PAGE_ELEMENT", "Attempted to get the current page or element count before moving to the next page after a reset operation.", "FNRCA0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_EMPTY_BATCH = new ExceptionCode("API_EMPTY_BATCH", "There are no objects in this batch to process.", "FNRCA0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_EXPECTED_UNEVALUATED_STATE = new ExceptionCode("API_EXPECTED_UNEVALUATED_STATE", "The property {0} must be in an unevaluated state", "FNRCA0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_FETCH_MERGE_PROPERTY_ERROR = new ExceptionCode("API_FETCH_MERGE_PROPERTY_ERROR", "Can not fetch and merge the new property values because the object has been changed on the server since it was last retrieved. Try using refresh first.", "FNRCA0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_FROM_INIT_OR_QUERY_STRING_NOT_SET = new ExceptionCode("API_FROM_INIT_OR_QUERY_STRING_NOT_SET", "Either the setFromClauseInitialValue or setQueryString method must be called prior to calling this method to retrieve the SQL statement.", "FNRCA0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_FROM_INIT_VALUE_NOT_SET = new ExceptionCode("API_FROM_INIT_VALUE_NOT_SET", "The setFromClauseInitialValue method must be called before an additional join using this method can be added.", "FNRCA0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_INDEX_OUT_OF_BOUNDS = new ExceptionCode("API_INDEX_OUT_OF_BOUNDS", "The specified index is outside the bounds of the collection.", "FNRCA0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_INITIALIZED = new ExceptionCode("API_INITIALIZED", "The API may only be initialized once and is already initialized.", "FNRCA0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_INVALID_CONFIGURATION_PARAMETER = new ExceptionCode("API_INVALID_CONFIGURATION_PARAMETER", "Invalid configuration parameter: {0}.", "FNRCA0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_INVALID_CONNECTION_PARAMETER = new ExceptionCode("API_INVALID_CONNECTION_PARAMETER", "Invalid connection parameter: {0}.", "FNRCA0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_INVALID_METADATA_CACHE_PARAMETER = new ExceptionCode("API_INVALID_METADATA_CACHE_PARAMETER", "This exception code is not used as of CE 4.5.1", "FNRCA0013");
    public static final ExceptionCode API_INVALID_PROPERTY_TYPE = new ExceptionCode("API_INVALID_PROPERTY_TYPE", "Invalid property type {0} expected {1}.", "FNRCA0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_INVALID_URI = new ExceptionCode("API_INVALID_URI", "An invalid URI was found for connection {0}.", "FNRCA0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_J2EE_UTIL_INIT_FAILED = new ExceptionCode("API_J2EE_UTIL_INIT_FAILED", "Failed to initialize the J2EE util class. The class {0} either cannot be found or is not a subclass of J2EEUtil.", "FNRCA0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_METHOD_NO_DEPENDENT_SUPPORT = new ExceptionCode("API_METHOD_NO_DEPENDENT_SUPPORT", "Method {0} not supported for dependent objects {1}", "FNRCA0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_MULTIPLY_FILED_IN_FOLDER = new ExceptionCode("API_MULTIPLY_FILED_IN_FOLDER", "The specified containee is filed multiple times in this folder - unable to determine which instance to unfile.", "FNRCA0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_NOT_A_CONTENT_TRANSFER = new ExceptionCode("API_NOT_A_CONTENT_TRANSFER", "The referenced ContentElement, {0}, is not a ContentTransfer", "FNRCA0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_NOT_A_RESERVATION = new ExceptionCode("API_NOT_A_RESERVATION", "This operation requires a reservation object.", "FNRCA0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_NOT_FILED_IN_FOLDER = new ExceptionCode("API_NOT_FILED_IN_FOLDER", "The specified containee is not filed in this folder.", "FNRCA0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_NO_CONTENT_ELEMENTS = new ExceptionCode("API_NO_CONTENT_ELEMENTS", "This exception code is not used as of CE 4.5.1", "FNRCA0022");
    public static final ExceptionCode API_PROPERTY_FETCH_FAILED = new ExceptionCode("API_PROPERTY_FETCH_FAILED", "Failed to fetch property {0} from server.", "FNRCA0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_PROPERTY_NOT_IN_CACHE = new ExceptionCode("API_PROPERTY_NOT_IN_CACHE", "The {0} property was not found in the properties collection.", "FNRCA0024", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_PROPERTY_TEMPLATE_NOT_FOUND = new ExceptionCode("API_PROPERTY_TEMPLATE_NOT_FOUND", "PropertyTemplate: {0}, not found in property template collection.", "FNRCA0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_READ_ONLY_COLLECTION = new ExceptionCode("API_READ_ONLY_COLLECTION", "This exception code is not used as of CE 4.5.1", "FNRCA0026");
    public static final ExceptionCode API_SAVE_BEFORE_REFRESH = new ExceptionCode("API_SAVE_BEFORE_REFRESH", "This exception code is not used as of CE 4.5.1", "FNRCA0027");
    public static final ExceptionCode API_SESSION_CLASS_NOT_FOUND = new ExceptionCode("API_SESSION_CLASS_NOT_FOUND", "This exception code is not used as of CE 4.5.1", "FNRCA0028");
    public static final ExceptionCode API_SESSION_NOT_IMPL_CORRECTLY = new ExceptionCode("API_SESSION_NOT_IMPL_CORRECTLY", "Session class {0} is not implemented correctly.", "FNRCA0029", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_SESSION_NOT_SET = new ExceptionCode("API_SESSION_NOT_SET", "This exception code is not used as of CE 4.5.1", "FNRCA0030");
    public static final ExceptionCode API_UNABLE_TO_USE_CONNECTION = new ExceptionCode("API_UNABLE_TO_USE_CONNECTION", "The URI for server communication cannot be determined from the connection object {0}.", "FNRCA0031", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_UNEXPECTED_JNDI_ERROR = new ExceptionCode("API_UNEXPECTED_JNDI_ERROR", "The JNDI cannot be accessed.", "FNRCA0032", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_UNSUPPORTED_API_CLASS = new ExceptionCode("API_UNSUPPORTED_API_CLASS", "Unsupported API class {0}", "FNRCA0033", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_UNSUPPORTED_PROPERTY_TYPE = new ExceptionCode("API_UNSUPPORTED_PROPERTY_TYPE", "Unsupported property type {0}.", "FNRCA0034", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PASSWORD_IS_EMPTY_ERROR = new ExceptionCode("PASSWORD_IS_EMPTY_ERROR", "The Password is null or empty.", "FNRCA0035", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_CONFLICTING_CLIENT_CONTEXT = new ExceptionCode("API_CONFLICTING_CLIENT_CONTEXT", "The call to {0} is not permitted because a conflicting client context has already been established.", "FNRCA0036", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_CHECKPOINT_UNSUPPORTED = new ExceptionCode("API_CHECKPOINT_UNSUPPORTED", "The PageIterator does not support PageIterator checkpoints.", "FNRCA0037", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_SEARCH_REQUIRED_VALUES_NULL = new ExceptionCode("API_SEARCH_REQUIRED_VALUES_NULL", "Required parameters for a Stored Search query are null.", "FNRCA0038", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_CANT_ATTACH_COLLECTION = new ExceptionCode("CBR_CANT_ATTACH_COLLECTION", "Can''t attach Verity collection to server {0}. Error: {1}", "FNRCB0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_CANT_CREATE_COLLECTION = new ExceptionCode("CBR_CANT_CREATE_COLLECTION", "Can''t create Verity collection. Name: {0}, Styleset: {1}, Collection path: {2}, Locale: {3}, Verity server: {4}, Index Area: {5}, New: {6}, Error: {7}. Typical causes of this error are: 1). The operating system user (NOT the user specified by VerityDomainConfiguration.UserName) that the Verity server is running as does not have file system access to the collection path. 2). The verity.cfg file has not been updated to allow the verity server to write to the collection path. 3). Style files are missing or other configuration error (see chained exception).", "FNRCB0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_CANT_WRITE_CONTENT_FILE = new ExceptionCode("CBR_CANT_WRITE_CONTENT_FILE", "Can''t write content file for element sequence #{0} for object {1}, class {2}, output directory {3}, index area {4}", "FNRCB0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_INCOMPLETE_CONFIG = new ExceptionCode("CBR_INCOMPLETE_CONFIG", "Verity administration host name and port must be in Verity configuration data", "FNRCB0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_NO_FILENAME_FOR_CONTENT = new ExceptionCode("CBR_NO_FILENAME_FOR_CONTENT", "Unable to get content element filename for element sequence #{0} for object {1}, class {2}", "FNRCB0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_INDEX_NON_REPOSITORY_OBJECT = new ExceptionCode("CBR_INDEX_NON_REPOSITORY_OBJECT", "Single item to full text index with array element #{0} is not a repository object", "FNRCB0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_INDEX_BAD_OBJECT_STORE = new ExceptionCode("CBR_INDEX_BAD_OBJECT_STORE", "Single item to full text index with array element #{0} does not have the same object store as the IndexJob", "FNRCB0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_NOT_INDEXABLE = new ExceptionCode("CBR_NOT_INDEXABLE", "Item to full text index with array element #{0} is not indexable.", "FNRCB0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_NO_INDEX_AREA_AVAILABLE = new ExceptionCode("CBR_NO_INDEX_AREA_AVAILABLE", "No index area is available to handle full text index request on object store {0}", "FNRCB0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_NO_INDEX_SERVER_AVAILABLE = new ExceptionCode("CBR_NO_INDEX_SERVER_AVAILABLE", "No index server is available to handle full text indexing requests on IndexArea {0}, ObjectStore {1}", "FNRCB0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_UNSUPPORTED_KEY = new ExceptionCode("CBR_UNSUPPORTED_KEY", "Old full text index key encountered -- re-indexation is required with this release.", "FNRCB0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_CANT_GET_ADMIN_CONFIG = new ExceptionCode("CBR_CANT_GET_ADMIN_CONFIG", "Can''t get Verity Admin server configuration for: {0}, error: {1}", "FNRCB0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_CANT_GET_SEARCH_CONFIG = new ExceptionCode("CBR_CANT_GET_SEARCH_CONFIG", "Can''t get Verity search server configuration for {0} of IndexArea {1}, error: {2}", "FNRCB0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_CANT_GET_BROKER_CONFIG = new ExceptionCode("CBR_CANT_GET_BROKER_CONFIG", "Can''t get Verity broker configuration for {0}, error: {1}", "FNRCB0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_CANT_GET_INDEX_SERVER_CONFIG = new ExceptionCode("CBR_CANT_GET_INDEX_SERVER_CONFIG", "Can''t get Verity index server configuration for {0} of IndexArea {1}, error: {2}", "FNRCB0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_NOT_MASTER_ADMIN_SERVER = new ExceptionCode("CBR_NOT_MASTER_ADMIN_SERVER", "VerityAdminMasterServerHostname/Port {0}:{1} refers to a slave server, not a master server", "FNRCB0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_CANT_AUTHENTICATE_ON_SEARCH = new ExceptionCode("CBR_CANT_AUTHENTICATE_ON_SEARCH", "The server could not authenticate with the Content Search Engine server. Broker name: {0}, Broker address: {1}, Domain: {2}, User: {3}, Error: {4}", "FNRCB0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_CANT_LOGON_TO_INDEX_SERVER = new ExceptionCode("CBR_CANT_LOGON_TO_INDEX_SERVER", "Can''t logon to index server. Index server name: {0}, Host name: {1}, Port: {2}, Domain: {3}, Error: {4}", "FNRCB0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_CANT_LOGON_TO_VERITY = new ExceptionCode("CBR_CANT_LOGON_TO_VERITY", "Can''t logon to Verity. Admin host: {0}, Admin port: {1}, Domain: {2}, User: {3}, Error: {4}", "FNRCB0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_CANT_DELETE_VERITY_WORKSPACE = new ExceptionCode("CBR_CANT_DELETE_VERITY_WORKSPACE", "Can''t delete Verity workspace. Index Server name: {0}, Host name: {1}, Port: {2}, Domain: {3}, Workspace name: {4}, Error: {5}", "FNRCB0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_CANT_CREATE_VERITY_WORKSPACE = new ExceptionCode("CBR_CANT_CREATE_VERITY_WORKSPACE", "Can''t create Verity workspace. Index Server name: {0}, Host name: {1}, Port: {2}, Domain: {3}, Workspace name: {4}, Error: {5}", "FNRCB0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_NO_TICKET_SERVER_FOR_ADMIN_SERVER = new ExceptionCode("CBR_NO_TICKET_SERVER_FOR_ADMIN_SERVER", "No ticket server is defined for administration server {0}, requested security group cannot be applied to collection.", "FNRCB0022", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_CANT_SET_GROUP_ON_COLLECTION = new ExceptionCode("CBR_CANT_SET_GROUP_ON_COLLECTION", "Can''t set group name on verity collection. Group: {0}, Ticket server alias: {1}, Ticket server address: {2}, Collection alias: {3}, Error: {4}", "FNRCB0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_FULLTEXTROWLIMIT_EXCEEDED = new ExceptionCode("CBR_FULLTEXTROWLIMIT_EXCEEDED", "The FullTextRowLimit has been exceeded. Not all results matching query were returned. Either increase FullTextRowLimit, or refine your full text query to return fewer rows.", "FNRCB0024", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_NOT_INDEXED = new ExceptionCode("CBR_NOT_INDEXED", "Documents submitted to be indexed were not processed (request will be retried).", "FNRCB0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_LOAD_TRANSLATORS_EXCEPTION = new ExceptionCode("CBR_LOAD_TRANSLATORS_EXCEPTION", "An exception occurred while attempting to load translation providers.", "FNRCB0026", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_DIALECT_NOT_SUPPORTED = new ExceptionCode("CBR_DIALECT_NOT_SUPPORTED", "The full text query dialect ''{0}'' is not supported in the current configuration.", "FNRCB0027", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_QUERY_PARSE_ERROR = new ExceptionCode("CBR_QUERY_PARSE_ERROR", "An error was detected while parsing the {0} full-text query. {1}", "FNRCB0028", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_INSO_INSTALL_ERROR = new ExceptionCode("CBR_INSO_INSTALL_ERROR", "An error was detected while install INSO binaries", "FNRCB0029", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_INSO_INSTALL_BINARY_NOT_FOUND = new ExceptionCode("CBR_INSO_INSTALL_BINARY_NOT_FOUND", "INSO binaries files not found", "FNRCB0030", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_VERITY_DOMAIN_CONFIG_NOT_ASSIGNED = new ExceptionCode("CBR_VERITY_DOMAIN_CONFIG_NOT_ASSIGNED", "Content Engine could not disable IBM Legacy Content Search Engine. A null value could not be assigned to the VerityDomainConfiguration property for the {0} object store.", "FNRCB0031", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_NO_BROKERS = new ExceptionCode("CBR_NO_BROKERS", "No Verity brokers can be found. This can happen if there is a communication problem with the Verity admin server or the index areas associated to object store {0} do not have search servers that are attached to a broker in the Verity configuration.", "FNRCB0032", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ERROR_GETTING_CONTENT_FILE = new ExceptionCode("CBR_ERROR_GETTING_CONTENT_FILE", "Can''t get content file for element sequence #{0} for object {1}, class {2}, output directory {3}, index area {4}, status {5}", "FNRCB0033", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_NO_TEXT_SEARCH_SERVER_FOR_SEARCH = new ExceptionCode("CBR_NO_TEXT_SEARCH_SERVER_FOR_SEARCH", "IBM Content Search Services could not run a query because no search server could be found to run the query. IBM Content Search Services might not be able to communicate with the servers for the {0} object store.", "FNRCB0034", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_ACCESSING_INDEX_FAILED = new ExceptionCode("CBR_TS_ACCESSING_INDEX_FAILED", "An IBM Content Search Services server could not access the {0} index or the directory that contains the index.", "FNRCB0035", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_ACCESSING_TEXT_SEARCH_SERVER_FAILED = new ExceptionCode("CBR_TS_ACCESSING_TEXT_SEARCH_SERVER_FAILED", "IBM Content Search Services could not communicate with the server that runs on the {0}:{1} host and port.", "FNRCB0036", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_EXEC_SEARCH_QUERY_FAILED = new ExceptionCode("CBR_TS_EXEC_SEARCH_QUERY_FAILED", "An IBM Content Search Services server could not run the following full-text search: {0}.", "FNRCB0037", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEX_CREATE_FAILED = new ExceptionCode("CBR_TS_INDEX_CREATE_FAILED", "An IBM Content Search Services server could not create an index.", "FNRCB0038", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_ADMIN_ACTION_FAILED_EXCEPTION = new ExceptionCode("CBR_TS_ADMIN_ACTION_FAILED_EXCEPTION", "IBM Content Search Services could not perform administrative functions for the server that runs on the {0}:{1} host and port.", "FNRCB0039", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEXING_FAILED_EXCEPTION = new ExceptionCode("CBR_TS_INDEXING_FAILED_EXCEPTION", "An IBM Content Search Services server could not complete an indexing operation while accessing the {0} index.", "FNRCB0040", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_QUERY_FAILED_EXCEPTION = new ExceptionCode("CBR_TS_QUERY_FAILED_EXCEPTION", "An IBM Content Search Services server could not run a full-text search. See the p8_server_error.log file for the error message stack that includes this error for more information on the specific cause of the error. For information about the location of this log, see \"Viewing the IBM FileNet P8 log files\" in the IBM FileNet P8 information center. If you cannot determine the cause of the error, restart the server. If the error continues to occur, contact IBM Software Support.", "FNRCB0041", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_NULL_PARAM = new ExceptionCode("CBR_TS_NULL_PARAM", "An IBM Content Search Services server could not perform a requested operation because the {0} parameter had a null value.", "FNRCB0042", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEX_CTOR = new ExceptionCode("CBR_TS_INDEX_CTOR", "The IBM Content Search Services server that runs on the {0}:{1} host and port could not index a document.", "FNRCB0043", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_NO_INDEX_FOUND_FOR_INDEXATION_ID = new ExceptionCode("CBR_TS_NO_INDEX_FOUND_FOR_INDEXATION_ID", "The IBM Content Search Services index is missing for objects with indexation ID {0}.", "FNRCB0044", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INVALID_SERVER_CONN_PARAMS = new ExceptionCode("CBR_TS_INVALID_SERVER_CONN_PARAMS", "The connection parameters for the following IBM Content Search Services server are invalid or missing: host={0}, port={1}.", "FNRCB0045", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INVALID_SERVER_CREDENTIAL = new ExceptionCode("CBR_TS_INVALID_SERVER_CREDENTIAL", "The IBM Content Search Services server connection token is invalid or missing.", "FNRCB0046", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_CANNOT_CONNECT_TO_SERVER = new ExceptionCode("CBR_TS_CANNOT_CONNECT_TO_SERVER", "The Content Engine server cannot connect to the IBM Content Search Services server {0} located on host {1}, port {2}.", "FNRCB0047", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INVALID_SERVER_STATUS_CHANGE = new ExceptionCode("CBR_TS_INVALID_SERVER_STATUS_CHANGE", "The IBM Content Search Services server status cannot be set to UNAVAILABLE by using the API.", "FNRCB0048", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_INVALID_SEARCH_DIALECT = new ExceptionCode("CBR_INVALID_SEARCH_DIALECT", "Content Engine could not run a query because the following invalid dialect was passed to the CONTAINS function: {0}.", "FNRCB0049", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_EMPTY_SEARCH_CRITERIA = new ExceptionCode("CBR_EMPTY_SEARCH_CRITERIA", "Content Engine could not run a query because the SQL statement for the query is not valid.", "FNRCB0050", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INVALID_INDEX_STATUS = new ExceptionCode("CBR_TS_INVALID_INDEX_STATUS", "The resource status of the IBM Content Search Services index {0} cannot be changed to {1}.", "FNRCB0051", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEX_EXCEEDS_MAX_SIZE = new ExceptionCode("CBR_TS_INDEX_EXCEEDS_MAX_SIZE", "The resource status of the IBM Content Search Services index {0} cannot be changed to OPEN because its current size of {1} KB exceeds the maximum size of {2} KB specified by its index area {3}.", "FNRCB0052", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEX_EXCEEDS_MAX_INDEXED_OBJECTS = new ExceptionCode("CBR_TS_INDEX_EXCEEDS_MAX_INDEXED_OBJECTS", "The resource status of the IBM Content Search Services index {0} cannot be changed to OPEN because the current number of its indexed objects, {1}, exceeds the maximum of {2} specified on its index area {3}.", "FNRCB0053", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_CANNOT_SWITCH_ON_VERITY = new ExceptionCode("CBR_CANNOT_SWITCH_ON_VERITY", "Content Engine could not enable IBM Legacy Content Search Engine: The attempt to assign a VerityDomainConfiguration object to the VerityDomainConfiguration property for the {0} object store failed.", "FNRCB0054", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_INVALID_SEARCH = new ExceptionCode("CBR_INVALID_SEARCH", "Content Engine could not run a query because the following inappropriate dialect was passed to the CONTAINS function: {0}. The dialect must be appropriate for the following content search engine that is currently enabled: {1}.", "FNRCB0055", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INVALID_INDEX_AREA_STATUS = new ExceptionCode("CBR_TS_INVALID_INDEX_AREA_STATUS", "The IBM Content Search Services index area {0} cannot be changed to status: {1}.", "FNRCB0056", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_BATCH_FAILED = new ExceptionCode("CBR_TS_BATCH_FAILED", "The batch operation for indexing objects to IBM Content Search Services has failed.", "FNRCB0057", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEXING_ABORTED = new ExceptionCode("CBR_TS_INDEXING_ABORTED", "The IBM Content Search Services indexing operation for indexation ID {0}, index path {1} has stopped.", "FNRCB0058", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEXING_TIMEOUT = new ExceptionCode("CBR_TS_INDEXING_TIMEOUT", "An indexing operation for indexation ID {0}, index path {1} was stopped because it timed out after {2} seconds.", "FNRCB0059", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_UNEXPECTED_SERVER_FOR_INDEX = new ExceptionCode("CBR_TS_UNEXPECTED_SERVER_FOR_INDEX", "The IBM Content Search Services server {0} was expected, but server {1} was found instead. The current indexing batch for IBM Content Search Services index {3} was stopped.", "FNRCB0060", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_MISSING_INDEX_LEASE_EXPIRY_TIME = new ExceptionCode("CBR_TS_MISSING_INDEX_LEASE_EXPIRY_TIME", "The IBM Content Search Services index does not have an expiration time. The current indexing batch for index {0} will be stopped.", "FNRCB0061", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_DEFER_INDEXING = new ExceptionCode("CBR_TS_DEFER_INDEXING", "IBM Content Search Services indexing is deferred for index {0} on index area {1} and object store {2}. {3}", "FNRCB0062", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_CANNOT_CREATE_INDEX_IN_INDEX_AREA = new ExceptionCode("CBR_TS_CANNOT_CREATE_INDEX_IN_INDEX_AREA", "IBM Content Search Services is unable to create an index in index area {0} of object store {1}.", "FNRCB0063", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_NO_INDEX_AREA_FOUND_FOR_INDEXATION_ID = new ExceptionCode("CBR_TS_NO_INDEX_AREA_FOUND_FOR_INDEXATION_ID", "The IBM Content Search Services index area is missing for objects with indexation ID {0}.", "FNRCB0064", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_MIGRATION_JOB_DELETE_NOT_ALLOWED = new ExceptionCode("CBR_MIGRATION_JOB_DELETE_NOT_ALLOWED", "Content Engine could not delete migration index job {0}.", "FNRCB0065", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_MIGRATION_JOB_ABORT_NOT_ALLOWED = new ExceptionCode("CBR_MIGRATION_JOB_ABORT_NOT_ALLOWED", "Content Engine could not stop migration index job {0}.", "FNRCB0066", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INVALID_INDEX_AREA_SITE = new ExceptionCode("CBR_TS_INVALID_INDEX_AREA_SITE", "The site for the IBM Content Search Services index area is not valid.", "FNRCB0067", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEX_DELETE_FAILED = new ExceptionCode("CBR_TS_INDEX_DELETE_FAILED", "An IBM Content Search Services server could not delete an index.", "FNRCB0068", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_TEXT_SEARCH_ENABLING_FAILED = new ExceptionCode("CBR_TS_TEXT_SEARCH_ENABLING_FAILED", "IBM Content Search Services was not enabled for the {0} object store because no index areas exist. Create an index area before attempting to enable IBM Content Search Services again.", "FNRCB0069", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_NO_TEXT_SEARCH_SERVER_FOR_DELETE = new ExceptionCode("CBR_TS_NO_TEXT_SEARCH_SERVER_FOR_DELETE", "IBM Content Search Services could not delete index {0} in object store {1}.", "FNRCB0070", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_JOB_PAUSE_NOT_ALLOWED = new ExceptionCode("CBR_TS_JOB_PAUSE_NOT_ALLOWED", "Content Engine did not pause the \"{0}\" index job. The index job has a status of {1} and a JobAbortRequested value of \"{2}\". To be paused, an index job must have a status of PENDING or IN_PROGRESS, and its JobAbortRequested property value must be null or false.", "FNRCB0071", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEX_DATA_DELETE_FAILED = new ExceptionCode("CBR_TS_INDEX_DATA_DELETE_FAILED", "IBM Content Search Services did not delete the \"{0}\" index as part of the reindexing that was performed for an index job. The reindexing completed successfully except for the deletion of the index. The index is no longer used and does not need to be reindexed again. To reclaim disk space, delete the index. For information about deleting the index, see \"Deleting an unused index\" in the IBM FileNet P8 information center.", "FNRCB0072", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEXING_LANGUAGE_VALIDATION_FAILED = new ExceptionCode("CBR_TS_INDEXING_LANGUAGE_VALIDATION_FAILED", "Content Engine did not save the entered \"{0}\" value for the Indexing Language property because it was not validated by IBM Content Search Services.", "FNRCB0073", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_REISSUE_INDEX_REQUEST_FAILED = new ExceptionCode("CBR_TS_REISSUE_INDEX_REQUEST_FAILED", "The processing of some index requests was delayed because IBM Content Search Services reassigned the requests to another index.", "FNRCB0074", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_JOB_RESUME_NOT_ALLOWED = new ExceptionCode("CBR_TS_JOB_RESUME_NOT_ALLOWED", "Content Engine did not resume the \"{0}\" index job. The index job has a status of {1}. To be resumed, an index job must have a status of PAUSED.", "FNRCB0075", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INSO_FILTER_MISSING_FOR_TEXT_EXTRACTION = new ExceptionCode("CBR_TS_INSO_FILTER_MISSING_FOR_TEXT_EXTRACTION", "Content Engine did not submit index requests to IBM Content Search Services because the required client files are not installed.", "FNRCB0076", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INSO_FILTER_MISSING_FOR_INDEXING = new ExceptionCode("CBR_TS_INSO_FILTER_MISSING_FOR_INDEXING", "Content Engine did not complete the submission of index requests to IBM Content Search Services because the required client files are not installed.", "FNRCB0077", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEXING_WARNING = new ExceptionCode("CBR_TS_INDEXING_WARNING", "IBM Content Search Services generated a warning while accessing the \"{0}\" index for an otherwise successful indexing operation.", "FNRCB0078", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_ACTION_NOT_FOUND = new ExceptionCode("CLASSIFY_ACTION_NOT_FOUND", "The DocumentClassificationAction object not found for MIME type {0}.", "FNRCL0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_COMPONENT_NOT_REGISTERED = new ExceptionCode("CLASSIFY_COMPONENT_NOT_REGISTERED", "Neither class name nor script text is set for mime type {0}.", "FNRCL0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_DOCUMENT_NOT_FOUND = new ExceptionCode("CLASSIFY_DOCUMENT_NOT_FOUND", "Cannot find document object for queue item {0}.", "FNRCL0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_HANDLER_THREW = new ExceptionCode("CLASSIFY_HANDLER_THREW", "Document classification handler threw an exception.", "FNRCL0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFIER_THREW = new ExceptionCode("CLASSIFIER_THREW", "Document classifier threw an exception.", "FNRCL0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFICATION_DATETIME_PARSE_FAILED = new ExceptionCode("CLASSIFICATION_DATETIME_PARSE_FAILED", "Failed to parse date/time value during XML classification. Date/time string is {0} and pattern used is {1}.", "FNRCL0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFICATION_DATETIME_PARSE_FAILED_SIMPLE = new ExceptionCode("CLASSIFICATION_DATETIME_PARSE_FAILED_SIMPLE", "Failed to parse date/time value during XML classification.", "FNRCL0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_NO_CONTENT_TO_CLASSIFY = new ExceptionCode("CLASSIFY_NO_CONTENT_TO_CLASSIFY", "No content to classify for document with id {0}.", "FNRCL0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_STATUS_UPDATE_FAILURE = new ExceptionCode("CLASSIFY_STATUS_UPDATE_FAILURE", "Failed updating classification status of document with id {0}.", "FNRCL0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_UNKNOWN_MIME_TYPE = new ExceptionCode("CLASSIFY_UNKNOWN_MIME_TYPE", "Unknown MIME type for document with id {0}.", "FNRCL0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CACHE_AREA_ACCESS_FAILED = new ExceptionCode("CONTENT_CACHE_AREA_ACCESS_FAILED", "Access to the content cache area directory failed.", "FNRCC0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CACHE_FILE_STREAM_ALREADY_CLOSED = new ExceptionCode("CONTENT_CACHE_FILE_STREAM_ALREADY_CLOSED", "The cache file input stream is already closed.", "FNRCC0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CACHE_INTERNAL_ERROR = new ExceptionCode("CONTENT_CACHE_INTERNAL_ERROR", "A content cache error occurred internal to the server.", "FNRCC0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CACHE_SOURCE_STORAGE_AREA_FAILED = new ExceptionCode("CONTENT_CACHE_SOURCE_STORAGE_AREA_FAILED", "The content cache operation failed because there was a problem accessing the source storage area.", "FNRCC0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_INTERNAL_ERROR = new ExceptionCode("CONTENT_CA_INTERNAL_ERROR", "A content area error occurred internal to the server. See messages in the FileNet P8 server error log for the cause of this exception.", "FNRCC0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_CLOSE_FAILED = new ExceptionCode("CONTENT_CA_CLOSE_FAILED", "The close failed.", "FNRCC0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_CONSOLIDATING_CHUNKS_FAILED = new ExceptionCode("CONTENT_CA_CONSOLIDATING_CHUNKS_FAILED", "Consolidating a content element failed for {0}.", "FNRCC0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_CONTINUE_UPLOAD_FAILED = new ExceptionCode("CONTENT_CA_CONTINUE_UPLOAD_FAILED", "Continuation upload for large content failed: {0}.", "FNRCC0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_COOKIE_MISSING_PARAM = new ExceptionCode("CONTENT_CA_COOKIE_MISSING_PARAM", "The cookie {0} is missing a required parameter, {1}.", "FNRCC0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_DELETE_FAILED = new ExceptionCode("CONTENT_CA_DELETE_FAILED", "Unable to delete file: {0}.", "FNRCC0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_DELETE_FAILED_RETENTION_CHECK = new ExceptionCode("CONTENT_CA_DELETE_FAILED_RETENTION_CHECK", "Content Engine could not delete or move content because the retention period for the item has not expired. Current time: {0}; Retention time: {1}.", "FNRCC0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_DELETE_SCRUB_FAILED = new ExceptionCode("CONTENT_CA_DELETE_SCRUB_FAILED", "Unable to scrub file for secure delete: {0}.", "FNRCC0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_FAILED_TEMP_CREATION = new ExceptionCode("CONTENT_CA_FAILED_TEMP_CREATION", "Failed creating the temporary content file.", "FNRCC0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_FEDERATED_REQUIRES_FIXED_SA = new ExceptionCode("CONTENT_CA_FEDERATED_REQUIRES_FIXED_SA", "Federated content requires a FixedStorageArea; current StorageArea Id: ({0})", "FNRCC0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_FINISH_UPLOAD_FAILED = new ExceptionCode("CONTENT_CA_FINISH_UPLOAD_FAILED", "Finish upload failed.", "FNRCC0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_INVALID_COOKIE = new ExceptionCode("CONTENT_CA_INVALID_COOKIE", "Invalid cookie {0}.", "FNRCC0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_MIXED_FEDERATED_CONTENT = new ExceptionCode("CONTENT_CA_MIXED_FEDERATED_CONTENT", "Federated content elements cannot be mixed with non-federated content elements.", "FNRCC0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_OUTPUT_STREAM_ALREADY_SET = new ExceptionCode("CONTENT_CA_OUTPUT_STREAM_ALREADY_SET", "The output stream has already been set.", "FNRCC0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_READ_FAILED = new ExceptionCode("CONTENT_CA_READ_FAILED", "The read failed for objId={0}.", "FNRCC0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_READ_STREAM_ALREADY_SET = new ExceptionCode("CONTENT_CA_READ_STREAM_ALREADY_SET", "The stream has already been set for retrieval.", "FNRCC0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_SKIP_BACKWARD_NOT_SUPPORTED = new ExceptionCode("CONTENT_CA_SKIP_BACKWARD_NOT_SUPPORTED", "The stream does not support going backward.", "FNRCC0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_SKIP_FAILED = new ExceptionCode("CONTENT_CA_SKIP_FAILED", "The stream didn''t skip the expected amount, {0}; actual {1}.", "FNRCC0022", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_START_UPLOAD_FAILED = new ExceptionCode("CONTENT_CA_START_UPLOAD_FAILED", "Start upload failed {0}.", "FNRCC0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_STORE_CHUNK_FAILED = new ExceptionCode("CONTENT_CA_STORE_CHUNK_FAILED", "Storing a content chunk failed.", "FNRCC0024", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_UNABLE_TO_ABANDONED_DELETE_FILE = new ExceptionCode("CONTENT_CA_UNABLE_TO_ABANDONED_DELETE_FILE", "Unable to delete abandoned file ''{0}''.", "FNRCC0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_UNKNOWN_CONTENT_UPLOAD_COOKIE = new ExceptionCode("CONTENT_CA_UNKNOWN_CONTENT_UPLOAD_COOKIE", "Unknown content upload cookie {0}.", "FNRCC0026", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_UPLOAD_FAILED_WRITE = new ExceptionCode("CONTENT_CA_UPLOAD_FAILED_WRITE", "The upload failed due to a problem writing content.", "FNRCC0027", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_VALIDATION_FAILED_NOT_FOUND = new ExceptionCode("CONTENT_CA_VALIDATION_FAILED_NOT_FOUND", "Content validation failed because it does not exist or is inaccessible in the storage area: objId={0}; seqNo={1}; retrievalName={2}", "FNRCC0028", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_VALIDATION_FAILED_PENDING_FINALIZATION = new ExceptionCode("CONTENT_CA_VALIDATION_FAILED_PENDING_FINALIZATION", "Content validation failed due to pending finalization.  Please try validation again at a later time for objId={0}; seqNo={1}; retrievalName={2}", "FNRCC0029", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_VALIDATION_FAILED_SIZE = new ExceptionCode("CONTENT_CA_VALIDATION_FAILED_SIZE", "Content validation failed due to size mismatch:  expected [{0}]; actual [{1}] for objId={2}; seqNo={3}; retrievalName={4}", "FNRCC0030", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CONFIG_CREATE_TEMP_FOLDER_FAILED = new ExceptionCode("CONTENT_CONFIG_CREATE_TEMP_FOLDER_FAILED", "Failed to create sub folder {0} under comtent temporary directory root {1}.", "FNRCC0031", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CONFIG_TEMP_ROOT_DOES_NOT_EXIST = new ExceptionCode("CONTENT_CONFIG_TEMP_ROOT_DOES_NOT_EXIST", "The content temporary directory root {0} does not exist.", "FNRCC0032", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CONFIG_TEMP_ROOT_NOT_FOLDER = new ExceptionCode("CONTENT_CONFIG_TEMP_ROOT_NOT_FOLDER", "The content temporary directory root value does not specify a directory: {0}.", "FNRCC0033", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_DCA_APPEND_NOT_SUPPORTED = new ExceptionCode("CONTENT_DCA_APPEND_NOT_SUPPORTED", "The database does not support appending content.", "FNRCC0034", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_DCA_CONTENT_ELEMENT_NOT_FOUND = new ExceptionCode("CONTENT_DCA_CONTENT_ELEMENT_NOT_FOUND", "Cannot find the content element {0}.", "FNRCC0035", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_DCA_FAILED_INSERT = new ExceptionCode("CONTENT_DCA_FAILED_INSERT", "Failed inserting the content element.", "FNRCC0036", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_DCA_WRONG_LENGTH = new ExceptionCode("CONTENT_DCA_WRONG_LENGTH", "The Content insert has the wrong length: expected {0}; actual {1}.", "FNRCC0037", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_CREATE_FAILED = new ExceptionCode("CONTENT_FCA_CREATE_FAILED", "Create failed in rootDir {0}, for {1}.", "FNRCC0038", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_DELETE_FAILED = new ExceptionCode("CONTENT_FCA_DELETE_FAILED", "Delete failed {0}.", "FNRCC0039", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_DIR_ALREADY_EXISTS = new ExceptionCode("CONTENT_FCA_DIR_ALREADY_EXISTS", "Create failed, the directory already exists: {0}.", "FNRCC0040", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_DIR_CREATE_FAILED = new ExceptionCode("CONTENT_FCA_DIR_CREATE_FAILED", "Create failed, the directory wasn''t created: {0}.", "FNRCC0041", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_FAILED_RETRIEVING_EXTENSION = new ExceptionCode("CONTENT_FCA_FAILED_RETRIEVING_EXTENSION", "Failed loading content element extension: {0}.", "FNRCC0042", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_FAILED_RETRIEVING_OBJECT = new ExceptionCode("CONTENT_FCA_FAILED_RETRIEVING_OBJECT", "Failed loading content element document: {0}.", "FNRCC0043", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_FAILED_STAKEFILE_LOAD = new ExceptionCode("CONTENT_FCA_FAILED_STAKEFILE_LOAD", "Failed loading stakefile {0}.", "FNRCC0044", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_FILE_ALREADY_EXISTS = new ExceptionCode("CONTENT_FCA_FILE_ALREADY_EXISTS", "The file already exists {0}.", "FNRCC0045", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_FILE_DOES_NOT_EXIST = new ExceptionCode("CONTENT_FCA_FILE_DOES_NOT_EXIST", "The file does not exist {0}.", "FNRCC0046", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_INIT_FAILED = new ExceptionCode("CONTENT_FCA_INIT_FAILED", "Initialization failed.", "FNRCC0047", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_PARENT_OF_FILE_DOES_NOT_EXIST = new ExceptionCode("CONTENT_FCA_PARENT_OF_FILE_DOES_NOT_EXIST", "The parent directory of the file {0} does not exist.", "FNRCC0048", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_READ_FAILED = new ExceptionCode("CONTENT_FCA_READ_FAILED", "Read failed {0}; offset={1}.", "FNRCC0049", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_ROOT_DOES_NOT_EXIST = new ExceptionCode("CONTENT_FCA_ROOT_DOES_NOT_EXIST", "Create failed, the root folder does not exist: {0}.", "FNRCC0050", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_ROOT_NOT_A_DIRECTORY = new ExceptionCode("CONTENT_FCA_ROOT_NOT_A_DIRECTORY", "Create failed, the root folder value does not specify a directory: {0}.", "FNRCC0051", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_SAVE_FAILED = new ExceptionCode("CONTENT_FCA_SAVE_FAILED", "Save failed {0} at offset {1}.", "FNRCC0052", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_STAKEFILE_ALREADY_EXISTS = new ExceptionCode("CONTENT_FCA_STAKEFILE_ALREADY_EXISTS", "A stakefile already exists at this location {0}.", "FNRCC0053", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_STAKEFILE_CREATE_FAILED = new ExceptionCode("CONTENT_FCA_STAKEFILE_CREATE_FAILED", "Stakefile create failed {0}.", "FNRCC0054", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_STAKEFILE_INVALID_DATE_FORMAT = new ExceptionCode("CONTENT_FCA_STAKEFILE_INVALID_DATE_FORMAT", "Invalid date format found in stakefile {0}.", "FNRCC0055", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_UNABLE_TO_RENAME_FILE = new ExceptionCode("CONTENT_FCA_UNABLE_TO_RENAME_FILE", "\"{0}\" cannot be renamed to \"{1}\".", "FNRCC0056", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ADMIN_INVALID_COMMAND_CODE = new ExceptionCode("CONTENT_FCP_ADMIN_INVALID_COMMAND_CODE", "Expected command code [{0}].  Received invalid command code [{1}].", "FNRCC0057", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ADMIN_INVALID_FUNCTION = new ExceptionCode("CONTENT_FCP_ADMIN_INVALID_FUNCTION", "Invalid admin function type [{0}] specified.", "FNRCC0058", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CENTERA_GET_CLIP_CREATION_FAILED = new ExceptionCode("CONTENT_FCP_CENTERA_GET_CLIP_CREATION_FAILED", "Failed to get the Creation Time for Centera Clip [{0}].", "FNRCC0059", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CENTERA_GET_CLIP_RETENTION_FAILED = new ExceptionCode("CONTENT_FCP_CENTERA_GET_CLIP_RETENTION_FAILED", "Failed to get the Retention Reriod for Centera Clip [{0}].", "FNRCC0060", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CENTERA_GET_CLUSTER_TIME_FAILED = new ExceptionCode("CONTENT_FCP_CENTERA_GET_CLUSTER_TIME_FAILED", "Failed to get the Centera cluster current time.", "FNRCC0061", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CENTERA_GET_POOL_SETUP_VALUE_FAILED = new ExceptionCode("CONTENT_FCP_CENTERA_GET_POOL_SETUP_VALUE_FAILED", "Failed to get the Centera pool [{0}] setup.", "FNRCC0062", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CENTERA_LOAD_POOL_FILE_FAILED = new ExceptionCode("CONTENT_FCP_CENTERA_LOAD_POOL_FILE_FAILED", "Failed to load Pool information file: {0}.", "FNRCC0063", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CENTERA_OPEN_POOL_FAILED = new ExceptionCode("CONTENT_FCP_CENTERA_OPEN_POOL_FAILED", "Failed to open Pool to Centera device.", "FNRCC0064", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CENTERA_PROCESS_SITEMAP_FAILED = new ExceptionCode("CONTENT_FCP_CENTERA_PROCESS_SITEMAP_FAILED", "Failed to get the connection string from the sitmap XML data.", "FNRCC0065", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CENTERA_REFERRAL_URLS_TAGNUM_MISMATCH = new ExceptionCode("CONTENT_FCP_CENTERA_REFERRAL_URLS_TAGNUM_MISMATCH", "The tag index numbers in the referral URLs are not in the correct order. expected [{0}], actual [{1}].", "FNRCC0066", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_ALREADY_EXISTS = new ExceptionCode("CONTENT_FCP_CE_ALREADY_EXISTS", "Content element create failed, a content element with the name {0} already exists.", "FNRCC0067", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_DELETE_FAILED = new ExceptionCode("CONTENT_FCP_CE_DELETE_FAILED", "Content element delete failed for {0}.", "FNRCC0068", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_DOES_NOT_EXIST = new ExceptionCode("CONTENT_FCP_CE_DOES_NOT_EXIST", "No content element found for CE Sequence Number: [{0}].", "FNRCC0069", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_DUPLICATE_SEQ_NUM = new ExceptionCode("CONTENT_FCP_CE_DUPLICATE_SEQ_NUM", "Content element duplicate sequence number detected: [{0}].", "FNRCC0070", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_OPEN_FAILED = new ExceptionCode("CONTENT_FCP_CE_OPEN_FAILED", "Content element open failed.", "FNRCC0071", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_READ_FAILED = new ExceptionCode("CONTENT_FCP_CE_READ_FAILED", "Content element read failed.", "FNRCC0072", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_SEEK_FAILED = new ExceptionCode("CONTENT_FCP_CE_SEEK_FAILED", "Content element seek failed.", "FNRCC0073", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CONNECTION_FAILED = new ExceptionCode("CONTENT_FCP_CONNECTION_FAILED", "The fixed content provider could not establish a connection to the fixed content device.", "FNRCC0074", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CONTENT_CACHE_CHECK_FAILED = new ExceptionCode("CONTENT_FCP_CONTENT_CACHE_CHECK_FAILED", "Failed to determine whether content is cached.", "FNRCC0075", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CREATE_CE_FAILED = new ExceptionCode("CONTENT_FCP_CREATE_CE_FAILED", "Content element create failed for {0}.", "FNRCC0076", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_DOC_CREATE_FAILED = new ExceptionCode("CONTENT_FCP_DOC_CREATE_FAILED", "Document creation failed", "FNRCC0077", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_DOC_CREATE_FAILED_BAD_INPUT = new ExceptionCode("CONTENT_FCP_DOC_CREATE_FAILED_BAD_INPUT", "The document could not be created because the source file {0} could not be read.", "FNRCC0078", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_DOC_DELETE_FAILED = new ExceptionCode("CONTENT_FCP_DOC_DELETE_FAILED", "Document deletion failed.", "FNRCC0079", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_DOC_EXISTS_FAILED = new ExceptionCode("CONTENT_FCP_DOC_EXISTS_FAILED", "Failed to determine whether document exists.", "FNRCC0080", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_DOC_LOCKDOWN_FAILED = new ExceptionCode("CONTENT_FCP_DOC_LOCKDOWN_FAILED", "Failed to lockdown document.", "FNRCC0081", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_DIRECTORY_NOT_FOUND = new ExceptionCode("CONTENT_FCP_FSB_DIRECTORY_NOT_FOUND", "Directory not found: {0}.", "FNRCC0082", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_EXISTS_FAILED = new ExceptionCode("CONTENT_FCP_FSB_EXISTS_FAILED", "Failed to determine whether file exists {0}.", "FNRCC0083", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_INVALID_PROVIDER = new ExceptionCode("CONTENT_FCP_FSB_INVALID_PROVIDER", "Invalid Fixed Content Provider. The fixed content device is not a snaplock device", "FNRCC0084", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_MKDIR_FAILED = new ExceptionCode("CONTENT_FCP_FSB_MKDIR_FAILED", "Failed to make directory {0}.", "FNRCC0085", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_OPEN_FAILED = new ExceptionCode("CONTENT_FCP_FSB_OPEN_FAILED", "Failed to open file {0}.", "FNRCC0086", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_REFERRAL_NUM_SEQ_MISMATCH = new ExceptionCode("CONTENT_FCP_FSB_REFERRAL_NUM_SEQ_MISMATCH", "The number of CE sequence numbers [{0}] don''t match the number of federated paths [{1}] in the referral.", "FNRCC0087", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_SET_READ_ONLY_FAILED = new ExceptionCode("CONTENT_FCP_FSB_SET_READ_ONLY_FAILED", "Failed to set read-only file attribute for {0}.", "FNRCC0088", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_TMP_DIRECTORY_CREATE_FAILURE = new ExceptionCode("CONTENT_FCP_FSB_TMP_DIRECTORY_CREATE_FAILURE", "Unable to create tmp Directory: {0}.", "FNRCC0089", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_TMP_DIRECTORY_NOT_ACCESSIBLE = new ExceptionCode("CONTENT_FCP_FSB_TMP_DIRECTORY_NOT_ACCESSIBLE", "Cannot write to tmp Directory: {0}.", "FNRCC0090", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_GET_RETENTION_PERIOD_FAILED = new ExceptionCode("CONTENT_FCP_GET_RETENTION_PERIOD_FAILED", "Failed to get the retention period for the content element.", "FNRCC0091", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_INVALID_CONFIGURATION = new ExceptionCode("CONTENT_FCP_INVALID_CONFIGURATION", "Invalid configuration.", "FNRCC0092", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_INVALID_REFERRAL_URL = new ExceptionCode("CONTENT_FCP_INVALID_REFERRAL_URL", "Invalid Referral URL: [{0}]", "FNRCC0093", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_INVALID_RESOURCE_STRING = new ExceptionCode("CONTENT_FCP_INVALID_RESOURCE_STRING", "Invalid Resource String: [{0}]", "FNRCC0094", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_INVALID_SEEK_ORIGIN = new ExceptionCode("CONTENT_FCP_INVALID_SEEK_ORIGIN", "Invalid origin {0} was specified for seek operation.", "FNRCC0095", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_IS_FAILED_CONFIGURE_DOC_CLASSES = new ExceptionCode("CONTENT_FCP_IS_FAILED_CONFIGURE_DOC_CLASSES", "Failed to configure document classes for: domain [{0}]; domain id [{1}]; object store [{2}]; object store id [{3}].", "FNRCC0096", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_IS_FAILED_RETRIEVE_DOC_CLASSES = new ExceptionCode("CONTENT_FCP_IS_FAILED_RETRIEVE_DOC_CLASSES", "Error retrieving all document classes from Image Services server.", "FNRCC0097", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_IS_FAILED_RETRIEVE_DOC_PROPS = new ExceptionCode("CONTENT_FCP_IS_FAILED_RETRIEVE_DOC_PROPS", "Error retrieving document properties for [{0}].", "FNRCC0098", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_IS_INVALID_CSM_CACHE_NAME = new ExceptionCode("CONTENT_FCP_IS_INVALID_CSM_CACHE_NAME", "CSM cache name should be a valid NCH 3-part name (e.g. page_cache2:roadrunner:FileNet).  Actual value: [{0}]", "FNRCC0099", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_IS_INVALID_DOC_CLASS_NAME = new ExceptionCode("CONTENT_FCP_IS_INVALID_DOC_CLASS_NAME", "Invalid Image Services Document Class Name: [{0}].", "FNRCC0100", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_IS_MISMATCHED_PAGE_NUM = new ExceptionCode("CONTENT_FCP_IS_MISMATCHED_PAGE_NUM", "Mismatched Image Services page number.  Expected: [{0}]; Actual: [{1}] for CE seqence number: [{3}].", "FNRCC0101", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_IS_UNABLE_TO_RETRIEVE_IS_CLASS_DESC = new ExceptionCode("CONTENT_FCP_IS_UNABLE_TO_RETRIEVE_IS_CLASS_DESC", "A communication failure with the Image Services server has prevented the retrieval of the ImageServicesClassDescriptions property for this IMFixedContentDevice: {0}", "FNRCC0102", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_LOGOFF_FAILED = new ExceptionCode("CONTENT_FCP_LOGOFF_FAILED", "Logoff failed.", "FNRCC0103", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_MISMATCHED_CHECKSUM = new ExceptionCode("CONTENT_FCP_MISMATCHED_CHECKSUM", "Checksum failed, expected {0}; actual {1}.", "FNRCC0104", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_MISMATCHED_REFERRALURL_LENGTH = new ExceptionCode("CONTENT_FCP_MISMATCHED_REFERRALURL_LENGTH", "The number of referral URLs [{0}] did not match the number of CE sequence numbers [{1}].", "FNRCC0105", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_MISMATCHED_REFERRALURL_PARAM = new ExceptionCode("CONTENT_FCP_MISMATCHED_REFERRALURL_PARAM", "The referral URLs did not have the same ''{0}''.", "FNRCC0106", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_MISMATCHED_REF_VERSION = new ExceptionCode("CONTENT_FCP_MISMATCHED_REF_VERSION", "Referral version or provider did not match.  Expected (hex): [{0}]; Actual (hex): [{1}].", "FNRCC0107", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_NEGATIVE_RETENTION_PERIOD = new ExceptionCode("CONTENT_FCP_NEGATIVE_RETENTION_PERIOD", "Requested retention period offset is negative {0}.", "FNRCC0108", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_NO_CONTENT_ELEMENTS_EXIST = new ExceptionCode("CONTENT_FCP_NO_CONTENT_ELEMENTS_EXIST", "Content element open failed, no content elements match the sequence {0}.", "FNRCC0109", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_OPERATION_FAILED = new ExceptionCode("CONTENT_FCP_OPERATION_FAILED", "The [{1}] operation on the fixed content provider [{0}] failed.", "FNRCC0110", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_OPERATION_FAILED_ON_OPEN = new ExceptionCode("CONTENT_FCP_OPERATION_FAILED_ON_OPEN", "Fixed Content Provider open operation failed.  Provider: [{0}]  SeqNum: [{1}]  Referral: [{2}]", "FNRCC0111", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_OPERATION_FAILED_WITH_CONTENT = new ExceptionCode("CONTENT_FCP_OPERATION_FAILED_WITH_CONTENT", "The [{1}] operation on the fixed content provider [{0}] failed for the [{2}] content and the sequence numbers [{3}].", "FNRCC0112", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_OPERATION_FAILED_WITH_REFERRAL = new ExceptionCode("CONTENT_FCP_OPERATION_FAILED_WITH_REFERRAL", "The fixed content provider operation failed.  Provider: [{0}]  Operation: [{1}]  Referral: [{2}]", "FNRCC0113", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_OPERATION_NOT_SUPPORTED = new ExceptionCode("CONTENT_FCP_OPERATION_NOT_SUPPORTED", "Operation not supported for this Fixed Content Provider.  Provider: [{0}]  Operation: [{1}]", "FNRCC0114", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_RETENTION_PARAM_NOT_ALLOWED = new ExceptionCode("CONTENT_FCP_RETENTION_PARAM_NOT_ALLOWED", "The retentionPeriod parameter is set to NOT-ALLOWED: [{0}]", "FNRCC0115", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_SET_RETENTION_PERIOD_FAILED = new ExceptionCode("CONTENT_FCP_SET_RETENTION_PERIOD_FAILED", "Failed to set the retention period to [{0}] for the content element.", "FNRCC0116", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_UNEXPECTED_STATE = new ExceptionCode("CONTENT_FCP_UNEXPECTED_STATE", "The state was unexpected for this fixed content provider.", "FNRCC0117", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FXCA_CANNOT_GET_PROVIDER = new ExceptionCode("CONTENT_FXCA_CANNOT_GET_PROVIDER", "Failed loading the provider class {0}.", "FNRCC0118", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FXCA_INVALID_CONFIGURATION = new ExceptionCode("CONTENT_FXCA_INVALID_CONFIGURATION", "Invalid content area configuration", "FNRCC0119", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FXCA_OPERATION_FAILED_CONTENT_IS_MIGRATING = new ExceptionCode("CONTENT_FXCA_OPERATION_FAILED_CONTENT_IS_MIGRATING", "Operation [{0}] cannot be performed while content is being migrated to Fixed Content Device.", "FNRCC0120", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_GC_CANNOT_FIND_INDEX_NUMBER = new ExceptionCode("CONTENT_GC_CANNOT_FIND_INDEX_NUMBER", "Cannot find index number {0}.", "FNRCC0121", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_GC_CANNOT_FIND_SEQUENCE_NUMBER = new ExceptionCode("CONTENT_GC_CANNOT_FIND_SEQUENCE_NUMBER", "Cannot find sequence number {0}.", "FNRCC0122", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_GC_INDEX_NOT_CONTENT_TRANSFER = new ExceptionCode("CONTENT_GC_INDEX_NOT_CONTENT_TRANSFER", "Index {0} is not a ContentTransfer.", "FNRCC0123", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_MC_FAILED_MOVING_CONTENT = new ExceptionCode("CONTENT_MC_FAILED_MOVING_CONTENT", "MoveContent failed", "FNRCC0124", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_MC_UNSUPPORTED_VERSIONABLE_CLASS = new ExceptionCode("CONTENT_MC_UNSUPPORTED_VERSIONABLE_CLASS", "Unsupported Versionable class {0} for MoveContent", "FNRCC0125", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_PC_CLOSE_STREAM_FAILED = new ExceptionCode("CONTENT_PC_CLOSE_STREAM_FAILED", "PutContent failed because InputStream.close failed.", "FNRCC0126", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_PC_FAILED_NO_STORAGE_DEFINED = new ExceptionCode("CONTENT_PC_FAILED_NO_STORAGE_DEFINED", "PutContent failed.  No StorageArea or StoragePolicy has been defined for this content.", "FNRCC0127", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_PC_LAST_CHUNK_NOT_SET = new ExceptionCode("CONTENT_PC_LAST_CHUNK_NOT_SET", "Internal error: The lastChunk property has not been set.", "FNRCC0128", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_PC_STREAM_FAILED = new ExceptionCode("CONTENT_PC_STREAM_FAILED", "PutContent failed because of an InputStream exception.", "FNRCC0129", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_PC_UNEXPECTED_CONTENT_TYPE = new ExceptionCode("CONTENT_PC_UNEXPECTED_CONTENT_TYPE", "Unexpected PutContentRequest conte type; classname={0}; content={1}", "FNRCC0130", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_PC_UNKNOWN_STATE = new ExceptionCode("CONTENT_PC_UNKNOWN_STATE", "Unknown PutContent state: {0}, with cookie {1}.", "FNRCC0131", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_PC_WRITE_FAILED = new ExceptionCode("CONTENT_PC_WRITE_FAILED", "A document could not be created, checked into a library, or moved from one storage area to another.", "FNRCC0132", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_DELETES_NOT_ALLOWED = new ExceptionCode("CONTENT_SA_DELETES_NOT_ALLOWED", "Storage Area does not allow delete of content.", "FNRCC0133", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_EXCEEDED_CLOSURE_DATE = new ExceptionCode("CONTENT_SA_EXCEEDED_CLOSURE_DATE", "Storage Area [{0}] exceeded closure date [{1}].", "FNRCC0134", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_EXCEEDED_MAX_COUNT = new ExceptionCode("CONTENT_SA_EXCEEDED_MAX_COUNT", "Storage Area [{0}] exceeded maximum number of content elements limit of [{1}].", "FNRCC0135", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_EXCEEDED_MAX_SIZE = new ExceptionCode("CONTENT_SA_EXCEEDED_MAX_SIZE", "Storage Area [{0}] exceeded maximum size limit of [{1}(KB)].", "FNRCC0136", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_INVALID_DIRECTORY_STRUCTURE = new ExceptionCode("CONTENT_SA_INVALID_DIRECTORY_STRUCTURE", "Invalid directory structure packed value: [{0}].", "FNRCC0137", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_INVALID_RETENTION_PERIOD = new ExceptionCode("CONTENT_SA_INVALID_RETENTION_PERIOD", "Invalid Retention Period value: [{0}].", "FNRCC0138", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_INVALID_STATUS_CHANGE = new ExceptionCode("CONTENT_SA_INVALID_STATUS_CHANGE", "Invalid Status value; you cannot change from {0} to {1}.", "FNRCC0139", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_NO_STORAGE_AREA_FOR_RESERVATION = new ExceptionCode("CONTENT_SA_NO_STORAGE_AREA_FOR_RESERVATION", "No open Storage Areas are available for the reservation.", "FNRCC0140", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_STORAGE_AREA_NOT_OPEN = new ExceptionCode("CONTENT_SA_STORAGE_AREA_NOT_OPEN", "StorageArea [{0}] not open, Status value is [{1}].", "FNRCC0141", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_UNKNOWN_CLASS = new ExceptionCode("CONTENT_SA_UNKNOWN_CLASS", "Unknown StorageArea class {0}.", "FNRCC0142", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_UNKNOWN_STORAGE_AREA = new ExceptionCode("CONTENT_SA_UNKNOWN_STORAGE_AREA", "Unknown StorageArea {0}.", "FNRCC0143", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_STREAM_INIT_FAILED = new ExceptionCode("CONTENT_STREAM_INIT_FAILED", "Stream initialization failed for {0}.", "FNRCC0144", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SQ_SERIALIZED_OBJECT_IS_NULL = new ExceptionCode("CONTENT_SQ_SERIALIZED_OBJECT_IS_NULL", "No content elements have been serialized with this storage queue item.", "FNRCC0145", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SQ_UNKNOWN_COMMAND = new ExceptionCode("CONTENT_SQ_UNKNOWN_COMMAND", "Unknown command: {0}", "FNRCC0146", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_TTL_STREAM_EXPIRED = new ExceptionCode("CONTENT_TTL_STREAM_EXPIRED", "The stream has expired.", "FNRCC0147", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_FINALIZE_FAILED_SIZE = new ExceptionCode("CONTENT_CA_FINALIZE_FAILED_SIZE", "Failed to finalize content element due to size mismatch:  expected [{0}]; actual [{1}].", "FNRCC0148", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_INVALID_REFERRAL_VERSION = new ExceptionCode("CONTENT_FCP_INVALID_REFERRAL_VERSION", "Invalid Referral Version: [{0}]", "FNRCC0149", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CFS_METADATA_PARSE_ERROR = new ExceptionCode("CONTENT_CFS_METADATA_PARSE_ERROR", "An error occured while parsing the XML that contains the metadata for a federated document", "FNRCC0150", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CFS_INTERNAL_ERROR = new ExceptionCode("CONTENT_CFS_INTERNAL_ERROR", "A content federation error occurred internal to the server.  Refer to log messages or the cause of this exception for details.", "FNRCC0151", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CFS_DB_ERROR = new ExceptionCode("CONTENT_CFS_DB_ERROR", "An error occurred accessing the federation database.", "FNRCC0152", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CLOSE_FAILED = new ExceptionCode("CONTENT_FCP_CLOSE_FAILED", "Close failed.", "FNRCC0153", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_TESTOPERATIONSUCCESS_FAILED = new ExceptionCode("CONTENT_FCP_CE_TESTOPERATIONSUCCESS_FAILED", "Test operation success failed.", "FNRCC0154", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_USESVERSIONS_FAILED = new ExceptionCode("CONTENT_FCP_CE_USESVERSIONS_FAILED", "The usesVersions operation failed for this provider.", "FNRCC0155", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_EXISTS_FAILED = new ExceptionCode("CONTENT_FCP_CE_EXISTS_FAILED", "The exists operation failed for this provider.", "FNRCC0156", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_NO_OPEN_STORAGE_AREA_FOR_CFS = new ExceptionCode("CONTENT_SA_NO_OPEN_STORAGE_AREA_FOR_CFS", "No open storage areas are available for the CFS Importer with object store id=[{0}] and fixed content device id=[{1}]", "FNRCC0157", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_POOL_MAX_REACHED = new ExceptionCode("CONTENT_FCP_POOL_MAX_REACHED", "The maximum number [{0}] of concurrent requests to the fixed content device [{1}] has been reached. Please try your request again later.", "FNRCC0158", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_DOC_FREEZE_FAILED = new ExceptionCode("CONTENT_FCP_DOC_FREEZE_FAILED", "Failed to freeze content for the document.", "FNRCC0159", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_INVALID_REFERRALURL_COUNT = new ExceptionCode("CONTENT_FCP_INVALID_REFERRALURL_COUNT", "The number of referral URLs [{0}] did not match the expected number for this provider [{1}].", "FNRCC0160", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_INVALID_CONTENT_ELEMENT_SEQUENCE = new ExceptionCode("CONTENT_FCP_INVALID_CONTENT_ELEMENT_SEQUENCE", "The content element sequence number [{0}] is invalid for this provider, expecting [{1}].", "FNRCC0161", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_DEVICE_QUERY_FAILED = new ExceptionCode("CONTENT_FCP_DEVICE_QUERY_FAILED", "Fixed content device query failed.", "FNRCC0162", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TEMP_FILE_OPERATION_FAILED = new ExceptionCode("CONTENT_FCP_TEMP_FILE_OPERATION_FAILED", "Temporary file operation failed.", "FNRCC0163", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_OPERATION_NON_RETRIABLE_FAILURE = new ExceptionCode("CONTENT_OPERATION_NON_RETRIABLE_FAILURE", "The content operation [{0}] failed with non-retriable exception.", "FNRCC0164", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_DOC_FREEZE_NOT_SUPPORTED = new ExceptionCode("CONTENT_FCP_DOC_FREEZE_NOT_SUPPORTED", "Freeze content is not supported for the document.", "FNRCC0165", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_API_FAILURE = new ExceptionCode("CONTENT_FCP_TSM_API_FAILURE", "Failure reported by TSM API, device Id {0}, method: {1}, return code: {2} {3}", "FNRCC0166", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_WRONG_MGMT_CLASS = new ExceptionCode("CONTENT_FCP_TSM_WRONG_MGMT_CLASS", "Unexpected management class result from tsmBindMC, storage area id {0}, found: {1}, expected: {2}", "FNRCC0167", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_NO_OBJECT = new ExceptionCode("CONTENT_FCP_TSM_NO_OBJECT", "The TSM object does not exist, device id {0} object name: {1}", "FNRCC0168", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_RETENTION_EVENT = new ExceptionCode("CONTENT_FCP_TSM_RETENTION_EVENT", "Failed to execute retention event {0}, error code: {1} device id {2} tsm object: {3}", "FNRCC0169", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_OBJECT_CREATE_FAILED = new ExceptionCode("CONTENT_FCP_TSM_OBJECT_CREATE_FAILED", "TSM Object creation failed, content id {0}, migration id {1}, mgmt class name: {2}, object name: {3}", "FNRCC0170", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_INVALID_RETENTION_INITIATED_STATE = new ExceptionCode("CONTENT_FCP_TSM_INVALID_RETENTION_INITIATED_STATE", "The Retention Initiated state is invalid, expected pending or started, state: {0} device id {1} tsm object: {2}", "FNRCC0171", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_INVALID_REFERRAL_BLOB = new ExceptionCode("CONTENT_FCP_TSM_INVALID_REFERRAL_BLOB", "Failed to decode the TSM binary referral blob, the referral is corrupt or invalid, device id {0} referral length: {1}", "FNRCC0172", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_API_INITIALIZATION = new ExceptionCode("CONTENT_FCP_TSM_API_INITIALIZATION", "Unable to initialize TsmJavaApi using API name [{0}] or [{1}].  Please verify that your application server has been configured to point to the proper TSM API native library.", "FNRCC0173", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_CREATE_OPT_FILE = new ExceptionCode("CONTENT_FCP_TSM_CREATE_OPT_FILE", "Failed to create TSM options file [{0}].", "FNRCC0174", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_LOAD_OPT_FILE = new ExceptionCode("CONTENT_FCP_TSM_LOAD_OPT_FILE", "Failed to load the TSM options file [{0}].", "FNRCC0175", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_MISSING_OPT_FILE = new ExceptionCode("CONTENT_FCP_TSM_MISSING_OPT_FILE", "The TSM options file does not exist [{0}].", "FNRCC0176", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_WRITE_OPT_FILE = new ExceptionCode("CONTENT_FCP_TSM_WRITE_OPT_FILE", "Failed to write the TSM options file [{0}].", "FNRCC0177", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_RETRYABLE_READ_FAILURE = new ExceptionCode("CONTENT_RETRYABLE_READ_FAILURE", "The attempt to read document id [{0}], element [{1}] failed.", "FNRCC0178", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_TOO_MANY_CONTENT_ELEMENTS = new ExceptionCode("CONTENT_FCP_TSM_TOO_MANY_CONTENT_ELEMENTS", "TSM Object creation failed, content id {0}, content element count {1}, max objects per transaction: {2}", "FNRCC0179", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_DOC_UNLOCK_FAILED = new ExceptionCode("CONTENT_FCP_DOC_UNLOCK_FAILED", "Failed to unlock document.", "FNRCC0180", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_RETRYABLE_API_FAILURE = new ExceptionCode("CONTENT_FCP_TSM_RETRYABLE_API_FAILURE", "Failure reported by TSM API, device Id {0}, method: {1}, return code: {2} {3}", "FNRCC0181", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_OFFLINE_CONTENT = new ExceptionCode("CONTENT_FCP_TSM_OFFLINE_CONTENT", "The TSM content object is offline and the maximum number of concurrent tape readers [{0}] has been exceeded for the TSM Fixed Content Device [{1}].", "FNRCC0182", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CACHE_INTERNAL_TIMEOUT = new ExceptionCode("CONTENT_CACHE_INTERNAL_TIMEOUT", "The content cache timed out populating a cache file.  This is an internal error that is handled in the server.", "FNRCC0183", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_OPERATION_FAILED_WITH_CONTEXT = new ExceptionCode("CONTENT_FCP_OPERATION_FAILED_WITH_CONTEXT", "The fixed content provider operation failed.", "FNRCC0184", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_HCP_INVALID_REFERRAL_BLOB = new ExceptionCode("CONTENT_FCP_HCP_INVALID_REFERRAL_BLOB", "Failed to decode the HCP binary referral blob, the referral is corrupt or invalid, device id {0} referral length: {1}", "FNRCC0185", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FXCA_CONTENT_EXCEEDS_MAX_SIZE = new ExceptionCode("CONTENT_FXCA_CONTENT_EXCEEDS_MAX_SIZE", "The size of a content element [{0}] exceeds the maximum size supported by the Fixed Content Device [{1}].", "FNRCC0186", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FXCA_FCP_REJECTED_RETENTION_CREATE = new ExceptionCode("CONTENT_FXCA_FCP_REJECTED_RETENTION_CREATE", "The fixed content provider rejected the retention date [{0}] during document check-in.", "FNRCC0187", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FXCA_FCP_REJECTED_RETENTION_ALTER = new ExceptionCode("CONTENT_FXCA_FCP_REJECTED_RETENTION_ALTER", "The fixed content provider rejected the new value for the retention date [{0}], current value [{1}].", "FNRCC0188", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CRYPTOGRAPHIC_SERVICE_MISSING = new ExceptionCode("CONTENT_CRYPTOGRAPHIC_SERVICE_MISSING", "Content Engine did not enable content encryption for the for the following reason: The AES/CTR/NoPadding encryption algorithm is not available in the server environment.", "FNRCC0189", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_KEY_GENERATION_FAILURE = new ExceptionCode("CONTENT_KEY_GENERATION_FAILURE", "Content Engine failed to generate a new content encryption key.", "FNRCC0190", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CRYPTOGRAPHIC_OP_FAILED = new ExceptionCode("CONTENT_CRYPTOGRAPHIC_OP_FAILED", "Content Engine failed to encrypt or decrypt data by using the encryption key information that is stored in the \"[0}\" object store.", "FNRCC0191", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_KEY_MISSING = new ExceptionCode("CONTENT_KEY_MISSING", "Content Engine did not find the encryption key that is associated with the \"{0}\" index in the \"{1}\" object store.", "FNRCC0192", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CIPHER_FAILURE = new ExceptionCode("CONTENT_CIPHER_FAILURE", "Content Engine failed to encrypt or decrypt content for the following reason: The initialization of a cryptographic cipher instance failed.", "FNRCC0193", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ENCRYPTION_ERROR = new ExceptionCode("CONTENT_ENCRYPTION_ERROR", "Content Engine failed to encrypt content for the \"{0}\" object.", "FNRCC0194", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_BAD_BATCH_RESULT = new ExceptionCode("DB_BAD_BATCH_RESULT", "The batch statement did not return the appropriate number of results.", "FNRCD0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_BAD_DATABASE_VENDOR = new ExceptionCode("DB_BAD_DATABASE_VENDOR", "The database vendor cannot be determined from the JNDI data source or is an unsupported type. Check the data source and verify the database connection.", "FNRCD0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_BAD_DATATYPE = new ExceptionCode("DB_BAD_DATATYPE", "Bad data type: {0}", "FNRCD0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_BAD_INPUT_BINDING_INDEX = new ExceptionCode("DB_BAD_INPUT_BINDING_INDEX", "Invalid index into input bindings.", "FNRCD0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_BAD_OUTPUT_BINDING_TYPE = new ExceptionCode("DB_BAD_OUTPUT_BINDING_TYPE", "Invalid output binding datatype.", "FNRCD0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_CANT_EXTRACT_CONNECTION_PARAMETERS = new ExceptionCode("DB_CANT_EXTRACT_CONNECTION_PARAMETERS", "The database parameters cannot be extracted from the connection.", "FNRCD0006", false, ErrorLoggingLevel.Optional);
    public static final ExceptionCode DB_COLUMN_DOES_NOT_EXIST = new ExceptionCode("DB_COLUMN_DOES_NOT_EXIST", "The referenced database column does not exist on specified table.", "FNRCD0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_CONNECTION_REESTABLISHED = new ExceptionCode("DB_CONNECTION_REESTABLISHED", "The connection to the database failed but has been reestablished.", "FNRCD0008", false, ErrorLoggingLevel.Optional);
    public static final ExceptionCode DB_ERROR = new ExceptionCode("DB_ERROR", "The database access failed with the following error: ErrorCode {0}, Message ''{1}''", "FNRCD0009", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_ERROR_R = new ExceptionCode("DB_ERROR_R", "This exception code is not used as of CE 5.0", "FNRCD0010");
    public static final ExceptionCode DB_FINISH_EXECUTE = new ExceptionCode("DB_FINISH_EXECUTE", "Must finish prior execution before starting new execution.", "FNRCD0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_INVALID_EXECUTION = new ExceptionCode("DB_INVALID_EXECUTION", "Invalid attempt to add more execution statements.", "FNRCD0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_INVALID_STATEMENT = new ExceptionCode("DB_INVALID_STATEMENT", "The following statement is considered invalid by the implementation: {0}", "FNRCD0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_NOTHING_TO_INSERT = new ExceptionCode("DB_NOTHING_TO_INSERT", "Nothing to insert.", "FNRCD0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_NOT_UNIQUE = new ExceptionCode("DB_NOT_UNIQUE", "The update or insert failed due to an attempt to create a duplicate value in a unique index.", "FNRCD0015", false, ErrorLoggingLevel.Optional);
    public static final ExceptionCode DB_NO_COUNT_IN_RESULT = new ExceptionCode("DB_NO_COUNT_IN_RESULT", "The database result does not have a count.", "FNRCD0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_NO_INSERT_TABLE = new ExceptionCode("DB_NO_INSERT_TABLE", "Must specify table name for insert.", "FNRCD0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_NO_RESULT = new ExceptionCode("DB_NO_RESULT", "The given statement did not return any result.", "FNRCD0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_OBJECT_DOES_NOT_EXIST = new ExceptionCode("DB_OBJECT_DOES_NOT_EXIST", "The referenced database object cannot be located.", "FNRCD0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_OUT_OF_MEMORY = new ExceptionCode("DB_OUT_OF_MEMORY", "The underlying database does not have enough memory or heap space to process the current command.", "FNRCD0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_SEQUENCE_EXHAUSTED = new ExceptionCode("DB_SEQUENCE_EXHAUSTED", "The range of values for the sequence is exhausted.  The sequence must be updated with a larger range of values.", "FNRCD0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_ROWLENGTH_LIMIT_EXCEEDED = new ExceptionCode("DB_ROWLENGTH_LIMIT_EXCEEDED", "The summation of column lengths exceeds the capacity of the underlying database.", "FNRCD0022", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_TABLE_DOES_NOT_EXIST = new ExceptionCode("DB_TABLE_DOES_NOT_EXIST", "The table that was referenced in the database query cannot be found.", "FNRCD0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_UNABLE_TO_ALTER_COLUMN = new ExceptionCode("DB_UNABLE_TO_ALTER_COLUMN", "The column cannot be altered via the application server.  Please ask your DBA to issue the following statement against database {0}, then re-attempt the operation.", "FNRCD0024", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_UNEXPECTED_SQL_RESULT = new ExceptionCode("DB_UNEXPECTED_SQL_RESULT", "One of the SQL statements did not return an expected result.", "FNRCD0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_NO_TABLESPACE_VERSIONS = new ExceptionCode("DB_NO_TABLESPACE_VERSIONS", "The ALTER operation failed because the zOS table space in database ''{0}'' is out of versions.  The z/OS DBA must run the REORG TABLESPACE, MODIFY RECOVERY and COPY utilities against the table space pertaining to the table listed in the following SQL command.  Once these commands have completed (in the order listed), the offending operation can be retried and general use of the table can resume.  It is recommended that the Content Engine application be stopped during this period.", "FNRCD0026", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_DITA_COMPONENT_FILED_IN_MULTIPLE_FOLDERS = new ExceptionCode("CLASSIFY_DITA_COMPONENT_FILED_IN_MULTIPLE_FOLDERS", "DITA component filed in multiple folders {0}.", "FNRCQ0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_DITA_COMPONENT_NOT_FILED_IN_ANY_FOLDER = new ExceptionCode("CLASSIFY_DITA_COMPONENT_NOT_FILED_IN_ANY_FOLDER", "DITA component not filed in any folder {0}.", "FNRCQ0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_DITA_INVALID_PATH = new ExceptionCode("CLASSIFY_DITA_INVALID_PATH", "Invalid Path {0}.", "FNRCQ0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_DITA_UNSUPPORTED_TYPE = new ExceptionCode("CLASSIFY_DITA_UNSUPPORTED_TYPE", "The DITA classifier does not support this DITA type {0}.", "FNRCQ0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_DITA_REQUIRED_VALUE_NOT_FOUND = new ExceptionCode("CLASSIFY_DITA_REQUIRED_VALUE_NOT_FOUND", "A required DITA value was not found {0}.", "FNRCQ0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_DITA_INVALID_NODE_TEXT_FORMAT = new ExceptionCode("CLASSIFY_DITA_INVALID_NODE_TEXT_FORMAT", "Invalid format for node text data, expected pair {0}.", "FNRCQ0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_DITA_RENDER_FAILED = new ExceptionCode("PUBLISH_DITA_RENDER_FAILED", "The DITA Open Toolkit render operation failed, return value {0}.", "FNRCQ0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_DITA_INVALID_WORKSPACE_FOLDER = new ExceptionCode("PUBLISH_DITA_INVALID_WORKSPACE_FOLDER", "The DITA temp workspace folder is not a folder {0}.", "FNRCQ0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_DITA_UNABLE_TO_DELETE = new ExceptionCode("PUBLISH_DITA_UNABLE_TO_DELETE", "Unable to delete temp DITA file or folder {0}.", "FNRCQ0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_DITA_UNABLE_TO_CREATE = new ExceptionCode("PUBLISH_DITA_UNABLE_TO_CREATE", "Unable to create temp DITA file or folder {0}.", "FNRCQ0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_DITA_JAVA_HOME_UNDEFINED = new ExceptionCode("PUBLISH_DITA_JAVA_HOME_UNDEFINED", "JAVA_HOME environment variable not defined.", "FNRCQ0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_DITA_INVALID_DITAVAL = new ExceptionCode("PUBLISH_DITA_INVALID_DITAVAL", "DITAVAL file requires DocumentTitle, ContentSize and ContentElement properties.", "FNRCQ0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_DITA_INVALID_DITAOT_LIB = new ExceptionCode("PUBLISH_DITA_INVALID_DITAOT_LIB", "DITA Open Toolkit lib folder not found or invalid.", "FNRCQ0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_DITA_INVALID_DITAOT = new ExceptionCode("PUBLISH_DITA_INVALID_DITAOT", "DITA Open Toolkit not installed in specified DITAHome location {0}.", "FNRCQ0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_DITA_PUBLICATION_NOT_FOUND = new ExceptionCode("PUBLISH_DITA_PUBLICATION_NOT_FOUND", "The DITA publication file was not found {0}.", "FNRCQ0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_ACCESS_DENIED = new ExceptionCode("E_ACCESS_DENIED", "The requester has insufficient access rights to perform the requested operation.", "FNRCE0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BAD_CLASSID = new ExceptionCode("E_BAD_CLASSID", "Class \"{0}\" not found.", "FNRCE0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BAD_FILTER_EXPRESSION = new ExceptionCode("E_BAD_FILTER_EXPRESSION", "Bad filter expression \"{0}\".", "FNRCE0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BAD_INDEX = new ExceptionCode("E_BAD_INDEX", "The index specified does not reference a valid property or list element.", "FNRCE0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BAD_OBJECT = new ExceptionCode("E_BAD_OBJECT", "An inappropriate object was passed as parameter to this function. For example, the object does not support a required interface or is of an inappropriate class.", "FNRCE0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BAD_OPERATOR = new ExceptionCode("E_BAD_OPERATOR", "The operator \"{0}\" is not defined in the metadata of the current scope.", "FNRCE0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BAD_PARAMETER = new ExceptionCode("E_BAD_PARAMETER", "Invalid input parameter: Name={0}, Value={1}.", "FNRCE0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BAD_PROPERTYID = new ExceptionCode("E_BAD_PROPERTYID", "The property identifier {0} is not valid for class {1}.", "FNRCE0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BAD_URL = new ExceptionCode("E_BAD_URL", "The resource URL is not syntactically valid.", "FNRCE0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BAD_VALUE = new ExceptionCode("E_BAD_VALUE", "The value given for a property or list element lies outside the permitted range or value set, or exceeds the maximum length allowed.", "FNRCE0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_CLASS_LOADING_ERROR = new ExceptionCode("E_CLASS_LOADING_ERROR", "Unable to load class: {0}.", "FNRCE0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_CLASS_NOT_SEARCHABLE = new ExceptionCode("E_CLASS_NOT_SEARCHABLE", "Class \"{0}\" referred to in the From Expression is not searchable.", "FNRCE0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_CLOSED_STREAM = new ExceptionCode("E_CLOSED_STREAM", "An operation was attempted on a stream that has been closed.", "FNRCE0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_CONFLICTING_OPERATION = new ExceptionCode("E_CONFLICTING_OPERATION", "The combination of operations specified for the object is invalid.", "FNRCE0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_CONSTRAINT_VIOLATED = new ExceptionCode("E_CONSTRAINT_VIOLATED", "The operation violates a constraint of the implementation.", "FNRCE0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_DATABASE_ERROR = new ExceptionCode("E_DATABASE_ERROR", "Unable to read from or write to the database.", "FNRCE0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_DATABASE_FULL = new ExceptionCode("E_DATABASE_FULL", "The database is full.", "FNRCE0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_DATATYPE_MISMATCH = new ExceptionCode("E_DATATYPE_MISMATCH", "The method invoked is inappropriate for the datatype of the property.", "FNRCE0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_DEADLOCK_ERROR = new ExceptionCode("E_DEADLOCK_ERROR", "The operation could not be completed due to a deadlock error. A retry might be appropriate.", "FNRCE0019", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_DUPLICATE_LIST_UPDATE = new ExceptionCode("E_DUPLICATE_LIST_UPDATE", "Duplicate entry detected in list update at position {0}", "FNRCE0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_ENUM_NAME_KEY_MATCH_FAILED = new ExceptionCode("E_ENUM_NAME_KEY_MATCH_FAILED", "Enum name \"{0}\" does not match key \"{1}\" in ExceptionCode enums.", "FNRCE0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_EXCEPTION_RETRY = new ExceptionCode("E_EXCEPTION_RETRY", "There was a problem communicating with the client application. The exception is not fatal and the request can be resubmitted to the server.", "FNRCE0022", false, ErrorLoggingLevel.Optional);
    public static final ExceptionCode E_FAILED = new ExceptionCode("E_FAILED", "The operation failed.", "FNRCE0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_FAILED_TO_GET_DATASOURCE = new ExceptionCode("E_FAILED_TO_GET_DATASOURCE", "The server cannot get the data source {0}.", "FNRCE0024", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_FOREIGN_OBJECT = new ExceptionCode("E_FOREIGN_OBJECT", "The property does not allow a reference to an object from a different object store.", "FNRCE0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_HEAP_FAILURE = new ExceptionCode("E_HEAP_FAILURE", "Ran out of memory.", "FNRCE0026", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_ILLEGAL_OPERATION = new ExceptionCode("E_ILLEGAL_OPERATION", "The operation is disallowed by the DMA Specification.", "FNRCE0027", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_ARGUMENT = new ExceptionCode("E_INVALID_ARGUMENT", "Invalid argument {0}.", "FNRCE0028", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_ENUM_VALUE = new ExceptionCode("E_INVALID_ENUM_VALUE", "The value supplied is invalid for this enum.", "FNRCE0029", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_ID = new ExceptionCode("E_INVALID_ID", "An ID in the form of GUID, Path, or Name is required.", "FNRCE0030", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_LOCALE_FORMAT = new ExceptionCode("E_INVALID_LOCALE_FORMAT", "The format of the provided locale \"{0}\" does not resemble that defined in RFC 3066.", "FNRCE0031", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_OBJECT_ADDRESS = new ExceptionCode("E_INVALID_OBJECT_ADDRESS", "An unsupported implementation of ObjectAddress was found {0}.", "FNRCE0032", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_OBJECT_TYPE = new ExceptionCode("E_INVALID_OBJECT_TYPE", "Invalid object type {0}.", "FNRCE0033", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_OBJ_FOR_SERIALIZATION = new ExceptionCode("E_INVALID_OBJ_FOR_SERIALIZATION", "Invalid object for serialization {0}.", "FNRCE0034", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_PROPERTY_MERGE = new ExceptionCode("E_INVALID_PROPERTY_MERGE", "A property merge of PropertyUpdateList requires a corresponding engine object collection value {0}; from {1} to {2}.", "FNRCE0035", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_REQUEST = new ExceptionCode("E_INVALID_REQUEST", "The parameter is incorrect.", "FNRCE0036", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_JBOSS_INVALID_CONFIGURATION = new ExceptionCode("E_JBOSS_INVALID_CONFIGURATION", "The JBoss configuration is invalid.", "FNRCE0037", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_LDAP_INVALID_CONFIGURATION = new ExceptionCode("E_LDAP_INVALID_CONFIGURATION", "Can''t detect LDAP vendor.  Check LDAP configuration.", "FNRCE0038", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_METHOD_NOT_IMPLEMENTED = new ExceptionCode("E_METHOD_NOT_IMPLEMENTED", "Method not implemented.", "FNRCE0039", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_NOT_AUTHENTICATED = new ExceptionCode("E_NOT_AUTHENTICATED", "The user is not authenticated.", "FNRCE0040", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_NOT_CREATABLE = new ExceptionCode("E_NOT_CREATABLE", "Creation of objects of the specified class is not supported.", "FNRCE0041", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_NOT_SUPPORTED = new ExceptionCode("E_NOT_SUPPORTED", "This method is not supported in the context of this session or object.", "FNRCE0042", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_NOT_UNIQUE = new ExceptionCode("E_NOT_UNIQUE", "A uniqueness requirement has been violated.", "FNRCE0043", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_NO_CURRENT_VERSION = new ExceptionCode("E_NO_CURRENT_VERSION", "The version series has no current version.", "FNRCE0044", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_NULL_ARGUMENT = new ExceptionCode("E_NULL_ARGUMENT", "Argument \"{0}\" is null.", "FNRCE0045", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_NULL_OR_INVALID_PARAM_VALUE = new ExceptionCode("E_NULL_OR_INVALID_PARAM_VALUE", "Parameter {0} is either null or has an invalid value.", "FNRCE0046", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_OBJECT_CLONE_FAILED = new ExceptionCode("E_OBJECT_CLONE_FAILED", "Failed to clone object {0}.", "FNRCE0047", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_OBJECT_DELETED = new ExceptionCode("E_OBJECT_DELETED", "The object {0} has been deleted since it was retrieved.", "FNRCE0048", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_OBJECT_LOCKED = new ExceptionCode("E_OBJECT_LOCKED", "The lock(s) on the persistent object {0} prohibit the attempted operation.", "FNRCE0049", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_OBJECT_MODIFIED = new ExceptionCode("E_OBJECT_MODIFIED", "The object {0} of class {1} was not changed or deleted because it was modified one or more times in the repository since the application retrieved it.", "FNRCE0050", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_OBJECT_NOT_FOUND = new ExceptionCode("E_OBJECT_NOT_FOUND", "The requested item was not found.", "FNRCE0051", false, ErrorLoggingLevel.Optional);
    public static final ExceptionCode E_OBJECT_NOT_LOCKABLE = new ExceptionCode("E_OBJECT_NOT_LOCKABLE", "The object cannot be locked - only Document, Folder & CustomObject objects can be locked.", "FNRCE0052", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_OBJECT_NOT_LOCKED = new ExceptionCode("E_OBJECT_NOT_LOCKED", "The object {0} is not locked.", "FNRCE0053", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_OBJECT_REFERENCED = new ExceptionCode("E_OBJECT_REFERENCED", "The object cannot be deleted because it is referenced by other objects.", "FNRCE0054", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_OBJECT_REFERENCES_OTHERS = new ExceptionCode("E_OBJECT_REFERENCES_OTHERS", "The object cannot be deleted because it holds references to other objects.", "FNRCE0055", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_PROPERTY_NOT_SEARCHABLE = new ExceptionCode("E_PROPERTY_NOT_SEARCHABLE", "Property {0} referred to in the Query Expression is not searchable.", "FNRCE0056", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_READ_ONLY = new ExceptionCode("E_READ_ONLY", "Method failed because an object or property is read-only.", "FNRCE0057", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_REQUIRED_VALUE_ABSENT = new ExceptionCode("E_REQUIRED_VALUE_ABSENT", "A required property value has not been set.", "FNRCE0058", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_RESERVATION_EXISTS = new ExceptionCode("E_RESERVATION_EXISTS", "The document is already checked out.", "FNRCE0059", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_RESOURCE_LOADING_ERROR = new ExceptionCode("E_RESOURCE_LOADING_ERROR", "Error occurred during loading of the resource file {0}.", "FNRCE0060", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_RESOURCE_NOT_FOUND = new ExceptionCode("E_RESOURCE_NOT_FOUND", "The indicated resource was not found.", "FNRCE0061", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_SERVER_ERROR = new ExceptionCode("E_SERVER_ERROR", "An error was returned from the server.", "FNRCE0062", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_TEMP_FILES_DIR_ERROR = new ExceptionCode("E_TEMP_FILES_DIR_ERROR", "Unable to create temporary files directory \"{0}\"", "FNRCE0063", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_TRANSACTION_TIMEOUT = new ExceptionCode("E_TRANSACTION_TIMEOUT", "This operation returned because the timeout period expired.", "FNRCE0064", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_UNEXPECTED = new ExceptionCode("E_UNEXPECTED", "An unexpected error occurred.", "FNRCE0065", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_UNEXPECTED_EXCEPTION = new ExceptionCode("E_UNEXPECTED_EXCEPTION", "An unexpected exception occurred.  The unexpected exception is chained to this exception.", "FNRCE0066", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_UNSUPPORTED_STREAM = new ExceptionCode("E_UNSUPPORTED_STREAM", "An unsupported stream was detected; version {0} type {1}.", "FNRCE0067", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_URL_PROTOCOL_NOT_SUPPORTED = new ExceptionCode("E_URL_PROTOCOL_NOT_SUPPORTED", "The URL protocol specified in the reference is not supported.", "FNRCE0068", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_UTIL_EXCEPTION_READING_OBJECT = new ExceptionCode("E_UTIL_EXCEPTION_READING_OBJECT", "Exception reading a serialized Object.", "FNRCE0069", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_UTIL_EXCEPTION_WRITING_OBJECT = new ExceptionCode("E_UTIL_EXCEPTION_WRITING_OBJECT", "Exception serializing an Object {0}.", "FNRCE0070", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_UTIL_LITTLE_ENDIAN_CONVERSION_FAILED = new ExceptionCode("E_UTIL_LITTLE_ENDIAN_CONVERSION_FAILED", "The little endian conversion failed.", "FNRCE0071", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_VALUE_NOT_SET = new ExceptionCode("E_VALUE_NOT_SET", "The requested property currently has no value.", "FNRCE0072", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_WEBLOGIC_INVALID_CONFIGURATION = new ExceptionCode("E_WEBLOGIC_INVALID_CONFIGURATION", "The WebLogic configuration is invalid.", "FNRCE0073", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_WEBSPHERE_INVALID_CONFIGURATION = new ExceptionCode("E_WEBSPHERE_INVALID_CONFIGURATION", "The WebSphere configuration is invalid.", "FNRCE0074", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_TRANSACTION_FAILURE = new ExceptionCode("E_TRANSACTION_FAILURE", "A transaction problem has occurred.", "FNRCE0075", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_CONTEXT = new ExceptionCode("E_INVALID_CONTEXT", "The method that was called is not valid in the current call context.", "FNRCE0076", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_NOT_IN_USER_TRANSACTION = new ExceptionCode("E_NOT_IN_USER_TRANSACTION", "The operation requires that a user (distributed) transaction be in effect.", "FNRCE0077", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_UPGRADE_REQUIRED = new ExceptionCode("E_UPGRADE_REQUIRED", "Object store \"{0}\" has an incompatible schema revision in the database - expected=\"{1}\" vs. database=\"{2}\".  This object store will be upgraded or an upgrade is already in progress.", "FNRCE0078", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_TASK_CHANGESTATE_PRECONDITION = new ExceptionCode("E_TASK_CHANGESTATE_PRECONDITION", "The precondition is not satisfied: {0}.", "FNRCE0079", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_TASK_CHANGESTATE_POSTCONDITION = new ExceptionCode("E_TASK_CHANGESTATE_POSTCONDITION", "The postcondition is not satisfied: {0}.", "FNRCE0080", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BACKGROUND_TASK_EXECUTOR_SHUTDOWN = new ExceptionCode("E_BACKGROUND_TASK_EXECUTOR_SHUTDOWN", "The background task executor has terminated: {0}.", "FNRCE0081", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BACKGROUND_TASK_TERMINATED = new ExceptionCode("E_BACKGROUND_TASK_TERMINATED", "The  background task has been terminated: {0}.", "FNRCE0082", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_ACTION_NO_HANDLER = new ExceptionCode("EVENT_ACTION_NO_HANDLER", "Unable to get the EventAction handler for {0}.", "FNRCV0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_BAD_EVENT_TYPE = new ExceptionCode("EVENT_BAD_EVENT_TYPE", "Bad event type {0}.", "FNRCV0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_BAD_SUBSCRIPTION_TYPE = new ExceptionCode("EVENT_BAD_SUBSCRIPTION_TYPE", "Bad subscription type {0}.", "FNRCV0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_CM_RESERVATION_NOT_ALLOWED = new ExceptionCode("EVENT_CM_RESERVATION_NOT_ALLOWED", "Code module value for Action object does not permit a reservation.", "FNRCV0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_EXTERNAL_FAILURE = new ExceptionCode("EVENT_EXTERNAL_FAILURE", "The Event handler threw an external failure.", "FNRCV0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_HANDLER_THREW = new ExceptionCode("EVENT_HANDLER_THREW", "An exception occurred in the event handler.", "FNRCV0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_NO_SCRIPT = new ExceptionCode("EVENT_NO_SCRIPT", "There is no script defined for the event action \"{0}\", id={1}.", "FNRCV0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_QUEUEITEM_NO_HANDLER = new ExceptionCode("EVENT_QUEUEITEM_NO_HANDLER", "Unable to get a handler for the QueueItem {0}.", "FNRCV0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_QUEUEITEM_UNKNOWN_CLASS = new ExceptionCode("EVENT_QUEUEITEM_UNKNOWN_CLASS", "Unknown QueueItem class {0}.", "FNRCV0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_HANDLER_VALIDATION_FAILED = new ExceptionCode("EVENT_HANDLER_VALIDATION_FAILED", "Unable to load event handler class from either associated code module or system classpath: {0}.", "FNRCV0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_USER_ABORT = new ExceptionCode("EVENT_USER_ABORT", "The event action is aborted by user.", "FNRCV0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_CM_CONTENTREFERENCE_NOT_ALLOWED = new ExceptionCode("EVENT_CM_CONTENTREFERENCE_NOT_ALLOWED", "Code module does not permit ContentReference object as content element.", "FNRCV0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_INFINITE_LOOP_DETECTED = new ExceptionCode("EVENT_INFINITE_LOOP_DETECTED", "Infinite loop in synchronous event processing detected. A maximum of {0} recursive event handler invocation is allowed within one execution thread.", "FNRCV0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_DUPLICATE_LIST_SUBSCRIBED_EVENT = new ExceptionCode("EVENT_DUPLICATE_LIST_SUBSCRIBED_EVENT", "Duplicate entry detected in subscribed event list.", "FNRCV0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_CM_INCOMPATIBLE_JAVA_VERSION = new ExceptionCode("EVENT_CM_INCOMPATIBLE_JAVA_VERSION", "Incompatible Java class: {0} detected in code module. JVM version for application server is: {1}. Please make sure that all Java classes in code module are compiled with compatible JDK (same or older version than application server JVM version).", "FNRCV0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_DOMAIN_ALREADY_EXISTS = new ExceptionCode("GCD_DOMAIN_ALREADY_EXISTS", "P8 domain already exists.", "FNRCG0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_CANNOT_LOAD = new ExceptionCode("GCD_CANNOT_LOAD", "Cannot load the GCD.", "FNRCG0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_CANNOT_LOCK = new ExceptionCode("GCD_CANNOT_LOCK", "Cannot lock the GCD for updates: {0}.", "FNRCG0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_CANNOT_SAVE = new ExceptionCode("GCD_CANNOT_SAVE", "Cannot save the GCD.", "FNRCG0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_DOMAIN_DOES_NOT_EXIST = new ExceptionCode("GCD_DOMAIN_DOES_NOT_EXIST", "The P8 domain does not exist.", "FNRCG0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_INVALID_CONFIGURATION = new ExceptionCode("GCD_INVALID_CONFIGURATION", "GCD configuration is invalid.", "FNRCG0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_INVALID_EPOCH_ID = new ExceptionCode("GCD_INVALID_EPOCH_ID", "Invalid epoch id {0}, expected {1}.", "FNRCG0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_JNDI_FAILURE = new ExceptionCode("GCD_JNDI_FAILURE", "Unable to get the GCD Configuration string from JNDI.", "FNRCG0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_MISSING_CONFIGURATION = new ExceptionCode("GCD_MISSING_CONFIGURATION", "Missing the GCD configuration.", "FNRCG0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_NO_REPLACE_COLLECTION = new ExceptionCode("GCD_NO_REPLACE_COLLECTION", "This node does not support replace collection.", "FNRCG0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_NO_SERVER_CALL_CONTEXT = new ExceptionCode("GCD_NO_SERVER_CALL_CONTEXT", "No server call context has been established.", "FNRCG0011", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_OBJECT_ALREADY_EXISTS = new ExceptionCode("GCD_OBJECT_ALREADY_EXISTS", "The object {0} already exists.", "FNRCG0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_UNEXPECTED_STATE = new ExceptionCode("GCD_UNEXPECTED_STATE", "Unexpected GCD state.", "FNRCG0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IMEX_IMPORT_CAN_NOT_FIND_CONTENT = new ExceptionCode("IMEX_IMPORT_CAN_NOT_FIND_CONTENT", "The import process can not find the content {0} for an object {1}", "FNRCX0001", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode IMEX_OBJECTSTORE_REFERENCE_NOT_AVAILABLE = new ExceptionCode("IMEX_OBJECTSTORE_REFERENCE_NOT_AVAILABLE", "The ObjectStore reference is not available for given IndependentObject", "FNRCX0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IMEX_EXPORT_MANIFEST_MISSING_OBJECT_STORE = new ExceptionCode("IMEX_EXPORT_MANIFEST_MISSING_OBJECT_STORE", "The Export Manifest file is missing the ObjectStore information. The SavedManifest node in the XML file is missing the primaryObjectStore attribute.", "FNRCX0003", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode IMEX_EXPORT_DERBY_DRIVER_CLASS_NOT_FOUND = new ExceptionCode("IMEX_EXPORT_DERBY_DRIVER_CLASS_NOT_FOUND", "The Apache Derby driver class was not found. This class is needed to create the export disk cache.", "FNRCX0004", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode IMEX_EXPORT_DERBY_SQL_EXCEPTION = new ExceptionCode("IMEX_EXPORT_DERBY_SQL_EXCEPTION", "Apache Derby experienced a sql exception.", "FNRCX0005", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode IMEX_EXPORT_DERBY_STARTUP_EXCEPTION = new ExceptionCode("IMEX_EXPORT_DERBY_STARTUP_EXCEPTION", "Apache Derby experienced a startup exception.", "FNRCX0006", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode IMEX_IMPORT_INVALID_XML_START = new ExceptionCode("IMEX_IMPORT_INVALID_XML_START", "The import process encountered an invalid dataset. The {0} XML tag was not found in the expected location. You might have selected the export manifest file instead of the converted deploy dataset file.", "FNRCX0007", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_CLASS_MAPPING_PARSE_ERROR = new ExceptionCode("IS_CLASS_MAPPING_PARSE_ERROR", "An error occurred while parsing the XML contained in the DocClassAndPropertyMappingXML property.", "FNRCI0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_ACTION_NOT_SUP = new ExceptionCode("IS_PD_ACTION_NOT_SUP", "Catalog Export Log action {0} is not supported.", "FNRCI0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_ANNOT_ERROR = new ExceptionCode("IS_PD_ANNOT_ERROR", "A CFS-IS Import Agent exception occurred during annotation processing.", "FNRCI0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_ANNOT_IRRECOVERABLE_ERR = new ExceptionCode("IS_PD_ANNOT_IRRECOVERABLE_ERR", "A CFS-IS Import Agent exception occurred during annotation processing. The annotation log will be deleted from the Image Service system. Fix the problem and re-export the annotation.", "FNRCI0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CANNOT_ADD_COMPENT = new ExceptionCode("IS_PD_CANNOT_ADD_COMPENT", "CFS-IS document {0} cannot be added to the list of completed entries.", "FNRCI0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CANNOT_CLEAR_INX_SHM = new ExceptionCode("IS_PD_CANNOT_CLEAR_INX_SHM", "The document processing data on the Image Services system cannot be cleared when the Content Engine is being shutdown.", "FNRCI0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CANNOT_FIND_COMPENT = new ExceptionCode("IS_PD_CANNOT_FIND_COMPENT", "The completed entry for document {0} canont be found.", "FNRCI0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CANNOT_GET_COMPENT = new ExceptionCode("IS_PD_CANNOT_GET_COMPENT", "The completed entry for document {0} cannot be retrieved.", "FNRCI0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CANNOT_RECOVER_DOC = new ExceptionCode("IS_PD_CANNOT_RECOVER_DOC", "Document {0} cannot be recovered.", "FNRCI0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CE_PROP_TYPE_NOT_SUP = new ExceptionCode("IS_PD_CE_PROP_TYPE_NOT_SUP", "Content Engine property type {0} is not supported.", "FNRCI0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CE_UNEXPECTED_PROP_TYPE = new ExceptionCode("IS_PD_CE_UNEXPECTED_PROP_TYPE", "The property type for Content Engine property {0} in document {1} is not expected.", "FNRCI0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_COMMIT_ERROR = new ExceptionCode("IS_PD_COMMIT_ERROR", "Got {0} catalog entries, only completed {1} entries.", "FNRCI0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CREATE_CONTENT_ELEMENT_ERROR = new ExceptionCode("IS_PD_CREATE_CONTENT_ELEMENT_ERROR", "The content element object cannot be created.", "FNRCI0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CREATE_CONTENT_REF_ERROR = new ExceptionCode("IS_PD_CREATE_CONTENT_REF_ERROR", "The content reference object cannot be created.", "FNRCI0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CREATE_CONTENT_XFER_ERROR = new ExceptionCode("IS_PD_CREATE_CONTENT_XFER_ERROR", "The content transfer object cannot be created.", "FNRCI0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_DCL_ID_NOT_FOUND = new ExceptionCode("IS_PD_DCL_ID_NOT_FOUND", "The ID for the external document class [{0}] cannot be obtained.", "FNRCI0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_DCL_NOT_MAPPED = new ExceptionCode("IS_PD_DCL_NOT_MAPPED", "The external document {0} cannot be processed. The external document class ID {1} is not mapped to a Content Engine document class.", "FNRCI0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_DCL_NOT_MATCH = new ExceptionCode("IS_PD_DCL_NOT_MATCH", "The update of the external document {0} to the Content Engine document {1} was rejected because the Content Engine document class ID {2} does not match the current document class mapping. The external document class {3} is mapped to the Content Engine document class {4} (ID={5}).", "FNRCI0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_DCL_TO_ID_ERROR = new ExceptionCode("IS_PD_DCL_TO_ID_ERROR", "The list of IDs for the Image Services document classes could not be retrieved.", "FNRCI0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_DELETE_DOC_ERROR = new ExceptionCode("IS_PD_DELETE_DOC_ERROR", "The Content Engine document {0} cannot be deleted.", "FNRCI0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_DN_NOT_FOUND = new ExceptionCode("IS_PD_DN_NOT_FOUND", "The Distinguished Name [{0}] cannot be found.", "FNRCI0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_DOC_ERROR = new ExceptionCode("IS_PD_DOC_ERROR", "A CFS-IS Import Agent exception occurred during document processing.", "FNRCI0022", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_FETCH_ANNOTATED_DOC_ERROR = new ExceptionCode("IS_PD_FETCH_ANNOTATED_DOC_ERROR", "The annotated document {0} cannot be retrieved.", "FNRCI0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_FETCH_CUSTOM_OBJ_ERROR = new ExceptionCode("IS_PD_FETCH_CUSTOM_OBJ_ERROR", "The Custom Object {0} cannot be retrieved.", "FNRCI0024", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_FETCH_DOC_ERROR = new ExceptionCode("IS_PD_FETCH_DOC_ERROR", "The document {0} cannot be retrieved.", "FNRCI0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_GET_LOG_ERROR = new ExceptionCode("IS_PD_GET_LOG_ERROR", "Federated entries from the Image Services system {0} cannot be retrieved. The operation is being retried.", "FNRCI0026", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_MAPPING_NOT_INIT = new ExceptionCode("IS_PD_MAPPING_NOT_INIT", "Document Class and Properties mapping have not been initialized.", "FNRCI0027", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_MISC_ERROR = new ExceptionCode("IS_PD_MISC_ERROR", "A CFS-IS Import Agent exception occurred.", "FNRCI0028", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_NEW_DIR_MISMATCH = new ExceptionCode("IS_PD_NEW_DIR_MISMATCH", "The Content Engine property value does not match the CFS-IS current catalog value.", "FNRCI0029", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_NO_DN = new ExceptionCode("IS_PD_NO_DN", "The Distinguished Name for the Image Services principal ID {0} cannot be retrieved.", "FNRCI0030", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_NO_FSA = new ExceptionCode("IS_PD_NO_FSA", "The Fixed Storage Area for the Fixed Content Device {0} cannot be found.", "FNRCI0031", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_OLD_DIR_MISMATCH = new ExceptionCode("IS_PD_OLD_DIR_MISMATCH", "The Content Engine property value does not match the CFS-IS previous catalog value.", "FNRCI0032", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_OS_GUID = new ExceptionCode("IS_PD_OS_GUID", "Failed to set up FN_IS_GUID for object store {0}.", "FNRCI0033", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_PARSER_ERROR = new ExceptionCode("IS_PD_PARSER_ERROR", "An error occurred while parsing the XML in the Custom Object {0}.", "FNRCI0034", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_PROP_ID_NOT_FOUND = new ExceptionCode("IS_PD_PROP_ID_NOT_FOUND", "The ID for the Image Services property [{0}] cannot be found.", "FNRCI0035", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_PROP_TO_ID_ERROR = new ExceptionCode("IS_PD_PROP_TO_ID_ERROR", "The list of IDs for the Image Services properties could not be retrieved.", "FNRCI0036", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_SAVE_BATCH_ERROR = new ExceptionCode("IS_PD_SAVE_BATCH_ERROR", "An error occurred while saving a batch of catalog entries.", "FNRCI0037", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_SAVE_DOC_ERROR = new ExceptionCode("IS_PD_SAVE_DOC_ERROR", "An error occurred while saving the Content Engine document {0}.", "FNRCI0038", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_SSI_LOGON_ERROR = new ExceptionCode("IS_PD_SSI_LOGON_ERROR", "SSI Logon to {0} failed, retrying.", "FNRCI0039", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_UNEXPECTED_INDEX_TYPE = new ExceptionCode("IS_PD_UNEXPECTED_INDEX_TYPE", "Image Services index type {0} in document {1} is not expected.", "FNRCI0040", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_UPDATE_DOC_ERROR = new ExceptionCode("IS_PD_UPDATE_DOC_ERROR", "Inbound update of the Image Services document ID {0} failed.", "FNRCI0041", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_XML_LEN_ERROR = new ExceptionCode("IS_PD_XML_LEN_ERROR", "The XML string in the Custom Object {0} is less than the minimum length of {1}.", "FNRCI0042", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_XML_VERSION_ERROR = new ExceptionCode("IS_PD_XML_VERSION_ERROR", "Wrong XMLVERSION in the Custom Object {0}. Expect {1}, got {2}.", "FNRCI0043", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PS_DOC_BUILDER_ERROR = new ExceptionCode("IS_PS_DOC_BUILDER_ERROR", "newDocumentBuilder method failed; object ''{0}. . .'' (retry in {1} minutes).", "FNRCI0044", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PS_PARSE_IO_ERROR = new ExceptionCode("IS_PS_PARSE_IO_ERROR", "I/O exception while parsing custom object; object: ''{0}. . .'' (retry in {1} minutes).", "FNRCI0045", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PS_PARSE_SAX_ERROR = new ExceptionCode("IS_PS_PARSE_SAX_ERROR", "SAX exception while parsing custom object; object: ''{0}. . .'' (retry in {1} minutes).", "FNRCI0046", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_CLOSE_NOT_ALLOWED = new ExceptionCode("IS_CLOSE_NOT_ALLOWED", "Image Services Replication cannot be shutdown.", "FNRCI0047", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_ALL_PUSH_WORKERS_BUSY = new ExceptionCode("IS_ALL_PUSH_WORKERS_BUSY", "No Push Worker task was available to handle the request.", "FNRCI0048", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PULL_WORKER_CALLED_WHILE_BUSY = new ExceptionCode("IS_PULL_WORKER_CALLED_WHILE_BUSY", "Pull Worker was requested while already busy.", "FNRCI0049", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_REPLICATION_PROVIDER_NOT_INITIALIZED = new ExceptionCode("IS_REPLICATION_PROVIDER_NOT_INITIALIZED", "The Image Services Replication Provider has not been initialized.", "FNRCI0050", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_REPLICATION_PROVIDER_ALREADY_INITIALIZED = new ExceptionCode("IS_REPLICATION_PROVIDER_ALREADY_INITIALIZED", "The Image Services Replication Provider cannot be reinitialized.", "FNRCI0051", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PULL_WORKER_INDEX_INVALID = new ExceptionCode("IS_PULL_WORKER_INDEX_INVALID", "An inbound worker was requested that does not exist.", "FNRCI0052", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_SSI_LOGON_ERROR = new ExceptionCode("IS_SSI_LOGON_ERROR", "SSI Logon failed for {0}.", "FNRCI0053", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_SSI_LOGOFF_ERROR = new ExceptionCode("IS_SSI_LOGOFF_ERROR", "SSI Logoff failed for {0}.", "FNRCI0054", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_CONNECT_ERROR = new ExceptionCode("IS_CONNECT_ERROR", "Failed to connect to the Image Services system {0} due to a network or cache resource problem.", "FNRCI0055", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_OUTBOUND_REPL_ERROR = new ExceptionCode("IS_OUTBOUND_REPL_ERROR", "Error encountered during outbound replication to IS.", "FNRCI0056", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_CANNOT_GET_DCL_MAPPING = new ExceptionCode("IS_CANNOT_GET_DCL_MAPPING", "The Image Services document class or properties mapping for Object Store {0} and {1} cannot be retrieved.", "FNRCI0057", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_DATE_PARSE_ERR = new ExceptionCode("IS_DATE_PARSE_ERR", "Error occurred while parsing the date {0}. Create or update action for document {1} will not be replicated. Image Services date string must conform to the ISO format of \"yyyy-MM-dd\" GMT.", "FNRCI0058", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PULLWORKER_ERROR = new ExceptionCode("IS_PULLWORKER_ERROR", "An error occurred in a CFS-IS inbound replication worker.", "FNRCI0059", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CE_PROP_UPDATED = new ExceptionCode("IS_PD_CE_PROP_UPDATED", "The property {1} in the document {0} will be overridden by the value from the Image Services system.", "FNRCI0060", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_REPL_GROUP_UNEXPECTED_EXCEPTION = new ExceptionCode("IS_REPL_GROUP_UNEXPECTED_EXCEPTION", "An unexpected exception occurred in a {0} function for Replication Group {1} and Image Services system {2}.", "FNRCI0061", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_REPL_GROUP_FUNCTION_ERROR = new ExceptionCode("IS_REPL_GROUP_FUNCTION_ERROR", "An error {0} occurred in a {1} function for Replication Group [{2}] and Image Services system {3}.", "FNRCI0062", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_ANNOT_NOT_SUPPORTED = new ExceptionCode("IS_ANNOT_NOT_SUPPORTED", "The annotation class is not supported, the number of content elements is not one or Annotated Content Element property is null.", "FNRCI0063", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_REPL_CANT_FETCH_OBJ = new ExceptionCode("IS_REPL_CANT_FETCH_OBJ", "Object {0} cannot be retrieved.", "FNRCI0064", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_INVALID_ANNOT_EXTID = new ExceptionCode("IS_INVALID_ANNOT_EXTID", "The external object identity {0} in annotation {1} is not valid.", "FNRCI0065", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_ANNOT_PERM_ERR = new ExceptionCode("IS_ANNOT_PERM_ERR", "Exception in the annotation access permission.", "FNRCI0066", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_ISR_NOT_CREATED = new ExceptionCode("IS_ISR_NOT_CREATED", "The Image Services Repository has not been created.", "FNRCI0067", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_STRING_EXCEED_MAX = new ExceptionCode("IS_STRING_EXCEED_MAX", "The length of the Content Engine String property {0} exceeds the Image Services supported maximum length of 239.", "FNRCI0068", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_RG_ALREADY_EXIST = new ExceptionCode("IS_RG_ALREADY_EXIST", "Replication group {0} [{1}] already exists for object store {2} and Image Services repository {3}.", "FNRCI0069", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_ANNOT_DATE_ERR = new ExceptionCode("IS_PD_ANNOT_DATE_ERR", "The inbound annotation update was rejected because the modify date is older than the last modified date for the current Content Engine annotation value. This error can result when the Image Services and Content Engine system clocks are not synchronized. The annotation entry will be deleted from the Image Services system.", "FNRCI0070", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_PROPERTY_UPDATE_ERR = new ExceptionCode("IS_PD_PROPERTY_UPDATE_ERR", "The Image Services document {0} was rejected because an {1} error occurred when setting the Content Engine property {2} to Image Services index {3} = ''{4}''. {5}", "FNRCI0071", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_CONFIRM_CLASS_MAPPING_ERROR = new ExceptionCode("IS_CONFIRM_CLASS_MAPPING_ERROR", "An error {0} occurred when sending class mapping changes to the Image Services system {1} for object store {2}. Operation is {3}, external class is [{4}].", "FNRCI0072", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_GET_DICT_TS_ERROR = new ExceptionCode("IS_PD_GET_DICT_TS_ERROR", "The data dictionary time stamp for the Image Services system cannot be retrieved.", "FNRCI0073", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_DOC_DELETE_NOT_ALLOWED = new ExceptionCode("IS_DOC_DELETE_NOT_ALLOWED", "The document cannot be deleted.", "FNRCI0074", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_INBOUND_DOC_UPDATE_ERROR = new ExceptionCode("IS_INBOUND_DOC_UPDATE_ERROR", "The update from the Image Services document {0} to the Content Engine document {1} cannot be processed because the Content Engine document has a replication error.", "FNRCI0075", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_REPL_LEAVE_GROUP_ERROR = new ExceptionCode("IS_REPL_LEAVE_GROUP_ERROR", "The replication group [{0}] cannot be deleted. The default mappings for object store {1} need to be removed from the Image Services system {2} using Remote Admin Console (RAC).", "FNRCI0076", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_ANNOT_DOC_ERROR = new ExceptionCode("IS_PD_ANNOT_DOC_ERROR", "The {0} action for the annotation {1} could not be processed because the Content Engine document cannot be found.", "FNRCI0077", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_ANNOT_REPL_ERROR = new ExceptionCode("IS_PD_ANNOT_REPL_ERROR", "The annotation {0} could not be processed because the replication group {1} did not match the document replication group {2}.", "FNRCI0078", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_ANNOT_DOC_REPL_ERROR = new ExceptionCode("IS_PD_ANNOT_DOC_REPL_ERROR", "The annotation {0} could not be processed because the document is not replicated.", "FNRCI0079", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_MOVECONTENT_CANT_NULL_RG = new ExceptionCode("IS_MOVECONTENT_CANT_NULL_RG", "The replication group and external object Id for the document {0} and its annotations cannot be removed during MoveContent post processing.", "FNRCI0080", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_PROPERTY_CONVERT_ERR = new ExceptionCode("IS_PD_PROPERTY_CONVERT_ERR", "The Image Services document {0} was rejected because an {1} error occurred converting the Image Services index {2} = ''{3}'' to the Content Engine type {4}.", "FNRCI0081", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_ANNOT_NOT_SUPPORTED_INFO = new ExceptionCode("IS_ANNOT_NOT_SUPPORTED_INFO", "Image Services annotations will not be federated for Object Store {0}.  To federate Image Services annotations, install the CFS-IS Extensions AddOn for the Object Store and then restart Content Engine.", "FNRCI0082", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_ANNOT_REPL_UPDATE_ERROR = new ExceptionCode("IS_PD_ANNOT_REPL_UPDATE_ERROR", "The update or delete action for annotation {0} could not be processed because the replication group {1} did not match the existing Content Engine annotation replication group {2}.", "FNRCI0083", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_ANNOT_NOT_REPL_ERROR = new ExceptionCode("IS_PD_ANNOT_NOT_REPL_ERROR", "The update or delete action for annotation {0} could not be processed because the existing Content Engine annotation is not replicated.", "FNRCI0084", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_GET_ANNOTATIONS_ERROR = new ExceptionCode("IS_PD_GET_ANNOTATIONS_ERROR", "An error occurred while getting all the annotations for the Content Engine document {0}.", "FNRCI0085", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_UPDATE_ANNOT_NOT_FOUND = new ExceptionCode("IS_PD_UPDATE_ANNOT_NOT_FOUND", "The Content Engine annotation cannot be retrieved for update. The annotation may have been deleted or it may not be replicated.", "FNRCI0086", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_CLASS_DEFAULT_MAPPED = new ExceptionCode("IS_CLASS_DEFAULT_MAPPED", "The class mapping cannot be updated or removed. The default mapping for the external class {0} and the object store {1} must be removed from the Image Services system {2} using Remote Admin Console (RAC).", "FNRCI0087", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_LOCK_INTERRUPT = new ExceptionCode("IS_LOCK_INTERRUPT", "The IS data dictionary information could not be retrieved because it timed out or was interrupted while waiting for a lock in {0}.", "FNRCI0088", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_ANNOT_ATTR_INVALID = new ExceptionCode("IS_ANNOT_ATTR_INVALID", "The {0} attribute in the {1} annotation is not valid.", "FNRCI0089", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_ANNOT_TOO_LARGE = new ExceptionCode("IS_ANNOT_TOO_LARGE", "The {0} annotation is too large to replicate to Image Services.", "FNRCI0090", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_ANNOT_INVALID = new ExceptionCode("IS_ANNOT_INVALID", "The document annotation {0} originating from the Image Services server is not valid. {1}", "FNRCI0091", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_AFTER_END_OF_RESULTSET_ERROR = new ExceptionCode("JDBC_AFTER_END_OF_RESULTSET_ERROR", "After end of result set", "FNRCJ0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_BEFORE_START_OF_RESULTSET_ERROR = new ExceptionCode("JDBC_BEFORE_START_OF_RESULTSET_ERROR", "Before start of result set", "FNRCJ0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_CANNOT_ABSOLUTE_ERROR = new ExceptionCode("JDBC_CANNOT_ABSOLUTE_ERROR", "Cannot absolute position to row 0", "FNRCJ0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_COLUMN_NOT_FOUND_ERROR = new ExceptionCode("JDBC_COLUMN_NOT_FOUND_ERROR", "Column {0} not found", "FNRCJ0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_CONNECTION_IS_READONLY_ERROR = new ExceptionCode("JDBC_CONNECTION_IS_READONLY_ERROR", "CE JDBC Driver is read-only. Hence Queries leading to data modification are not allowed.", "FNRCJ0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_CONNECT_ERROR = new ExceptionCode("JDBC_CONNECT_ERROR", "Connection could not be established with CE Server; The URL passed to JDBC Driver is : {0} ...", "FNRCJ0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_DRIVER_STATIC_ERROR = new ExceptionCode("JDBC_DRIVER_STATIC_ERROR", "CE JBDC Driver cannot be registered", "FNRCJ0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_ILLEGAL_FETCH_DIRECTION_ERROR = new ExceptionCode("JDBC_ILLEGAL_FETCH_DIRECTION_ERROR", "Illegal value for fetch direction", "FNRCJ0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_ILLEGAL_OPERATION_ON_RESULTSET_ERROR = new ExceptionCode("JDBC_ILLEGAL_OPERATION_ON_RESULTSET_ERROR", "Illegal operation on empty result set.", "FNRCJ0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_NOT_SUPPORTED_ERROR = new ExceptionCode("JDBC_NOT_SUPPORTED_ERROR", "JDBC method not supported or not implemented in driver: {0}.{1}", "FNRCJ0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_OBJECTSTORE_IS_EMPTY_ERROR = new ExceptionCode("JDBC_OBJECTSTORE_IS_EMPTY_ERROR", "The Object store property is not found in driver URL.", "FNRCJ0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_OBJECT_STORE_NOT_FOUND_ERROR = new ExceptionCode("JDBC_OBJECT_STORE_NOT_FOUND_ERROR", "{0} Object Store in URL is not found...", "FNRCJ0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_PASSWORD_IS_EMPTY_ERROR = new ExceptionCode("JDBC_PASSWORD_IS_EMPTY_ERROR", "The Password is null or empty in the JDBC URL", "FNRCJ0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_QUERY_GENERTED_NO_FIELDS_ERROR = new ExceptionCode("JDBC_QUERY_GENERTED_NO_FIELDS_ERROR", "Query generated no fields for ResultSet", "FNRCJ0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_QUERY_NOT_EXECUTED_ERROR = new ExceptionCode("JDBC_QUERY_NOT_EXECUTED_ERROR", "Cannot execute query {0}...", "FNRCJ0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_RESULTSETMETADATA_COLUMN_INDEX_ERROR = new ExceptionCode("JDBC_RESULTSETMETADATA_COLUMN_INDEX_ERROR", "Column index out of range.", "FNRCJ0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_RESULTSET_CLOSED_ERROR = new ExceptionCode("JDBC_RESULTSET_CLOSED_ERROR", "Operation not allowed after ResultSet closed", "FNRCJ0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_STATEMENT_CLOSED_ERROR = new ExceptionCode("JDBC_STATEMENT_CLOSED_ERROR", "No operations allowed after statement closed", "FNRCJ0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_STATEMENT_FETCH_DIRECTION_ERROR = new ExceptionCode("JDBC_STATEMENT_FETCH_DIRECTION_ERROR", "Illegal value for setFetchDirection()", "FNRCJ0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_STATEMENT_FETCH_SIZE_ERROR = new ExceptionCode("JDBC_STATEMENT_FETCH_SIZE_ERROR", "Illegal value for setFetchSize", "FNRCJ0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_STATEMENT_QUERY_NULL_OR_EMPTY_ERROR = new ExceptionCode("JDBC_STATEMENT_QUERY_NULL_OR_EMPTY_ERROR", "Query cannot be empty or null", "FNRCJ0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_URI_IS_EMPTY_ERROR = new ExceptionCode("JDBC_URI_IS_EMPTY_ERROR", "The URL found in JDBC URL String is not proper.", "FNRCJ0022", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_USER_IS_EMPTY_ERROR = new ExceptionCode("JDBC_USER_IS_EMPTY_ERROR", "The Username is null or empty in the JDBC URL", "FNRCJ0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_VALUE_GENERATED_ERROR = new ExceptionCode("JDBC_VALUE_GENERATED_ERROR", "Value must be between 0 and getMaxRows()", "FNRCJ0024", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_INVALID_CURSOR_OPERATION = new ExceptionCode("JDBC_INVALID_CURSOR_OPERATION", "Operation not allowed for TYPE_FORWARD_ONLY ResultSet objects", "FNRCJ0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_CONNECT_ACCESS_ERROR = new ExceptionCode("JDBC_CONNECT_ACCESS_ERROR", "Access denied connecting to ObjectStore {0}", "FNRCJ0026", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_BAD_AUDITDEF_PARENT = new ExceptionCode("METADATA_BAD_AUDITDEF_PARENT", "Bad parent_id in AuditDefinition with event_class_id {0}", "FNRCM0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_BAD_CARDINALITY_ON_MERGE = new ExceptionCode("METADATA_BAD_CARDINALITY_ON_MERGE", "Merged properties don''t have same cardinality.  Property name: {0}", "FNRCM0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_BAD_MERGE_SCOPE = new ExceptionCode("METADATA_BAD_MERGE_SCOPE", "Multiple object store searches must have at least two object stores.", "FNRCM0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_BAD_SUBTREE_CLASS = new ExceptionCode("METADATA_BAD_SUBTREE_CLASS", "Read class \"{0}\" not in subtree \"{1}\"", "FNRCM0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_BAD_TYPES_ON_MERGE = new ExceptionCode("METADATA_BAD_TYPES_ON_MERGE", "Merged properties don''t have same datatype.  Property name: {0}.", "FNRCM0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_CACHE_SERIALIZE = new ExceptionCode("METADATA_CACHE_SERIALIZE", "Serialization error of metadata cache {0}.", "FNRCM0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_DDSTATE_NULL = new ExceptionCode("METADATA_DDSTATE_NULL", "Record in DDState has null column(s)", "FNRCM0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_DUP_CLASS_ALIAS = new ExceptionCode("METADATA_DUP_CLASS_ALIAS", "Duplicate alias id: {0}, on class {1}.", "FNRCM0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_DUP_OBJECT_STORE_IN_SCOPE = new ExceptionCode("METADATA_DUP_OBJECT_STORE_IN_SCOPE", "Multiple object store search has the same object store in it multiple times.", "FNRCM0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_DUP_PROP_ALIAS = new ExceptionCode("METADATA_DUP_PROP_ALIAS", "Duplicate alias id: {0}, on property {1}.", "FNRCM0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_FAILURE_READING_METADATA_FILE = new ExceptionCode("METADATA_FAILURE_READING_METADATA_FILE", "Failed to read static metadata file:  {0}.", "FNRCM0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_INCOMPATIBLE_REVISIONS = new ExceptionCode("METADATA_INCOMPATIBLE_REVISIONS", "Incompatible schema revisions: \"{0}\" and \"{1}\"", "FNRCM0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_INCOMPATIBLE_REVISION_ID_DB = new ExceptionCode("METADATA_INCOMPATIBLE_REVISION_ID_DB", "The schema revision for the database of object store \"{0}\" is \"{2}\", which is incompatible with the schema revision \"{1}\" of the Content Engine software.", "FNRCM0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_INVALID_CVL = new ExceptionCode("METADATA_INVALID_CVL", "Invalid value for CVL.", "FNRCM0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_INVALID_DEFAULT = new ExceptionCode("METADATA_INVALID_DEFAULT", "Invalid default value for property {0}", "FNRCM0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_INVALID_SEARCH_MD_RESULT = new ExceptionCode("METADATA_INVALID_SEARCH_MD_RESULT", "Server error; get search metata was expected to return a single value for {0}", "FNRCM0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_LOAD_CLASS_ERROR = new ExceptionCode("METADATA_LOAD_CLASS_ERROR", "Unable to load class: {0}.", "FNRCM0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_NO_DDSTATE = new ExceptionCode("METADATA_NO_DDSTATE", "No record in DDState table.", "FNRCM0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_NO_ROOT_CLASS = new ExceptionCode("METADATA_NO_ROOT_CLASS", "Root class not in static metadata: {0}.", "FNRCM0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_NO_SUBCLASS_PROPS = new ExceptionCode("METADATA_NO_SUBCLASS_PROPS", "Subclass properties on this class are unknown: {0}.", "FNRCM0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_PERSISTER_NOT_DEFINED = new ExceptionCode("METADATA_PERSISTER_NOT_DEFINED", "No persister defined for class {0}.", "FNRCM0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_PRIMARY_ID_NULL = new ExceptionCode("METADATA_PRIMARY_ID_NULL", "Primary Id of property {0} is null.", "FNRCM0022", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_REFLECTIVE_PROPERTY_INVALID = new ExceptionCode("METADATA_REFLECTIVE_PROPERTY_INVALID", "Reflective property {0} (in \"Constraint\" column) of metadata is invalid for class {1}, property {2}", "FNRCM0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_REQUIRED_CLASS_INVALID = new ExceptionCode("METADATA_REQUIRED_CLASS_INVALID", "Required class {0} (in \"DefaultValue\" column) of metadata is invalid for class {1}, property {2}.", "FNRCM0024", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_RETRIEVER_METADATA_CACHE_MERGE_FAIL = new ExceptionCode("METADATA_RETRIEVER_METADATA_CACHE_MERGE_FAIL", "Class {0} cannot be merged into cache due to a duplicate name/id.  Class to merge has name \"{1}\", ids: ({2}).  Class already present has name \"{3}\", ids: ({4})", "FNRCM0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_RETRIEVER_NOT_DEFINED = new ExceptionCode("METADATA_RETRIEVER_NOT_DEFINED", "No retriever defined for class {0}.", "FNRCM0026", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_RETRIEVE_ABOVE_ROOT_IN_DB = new ExceptionCode("METADATA_RETRIEVE_ABOVE_ROOT_IN_DB", "Found class in DB that is above root of subtree (system error) {0}", "FNRCM0027", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_ROOT_NOT_IN_DB = new ExceptionCode("METADATA_ROOT_NOT_IN_DB", "Root class not in database: {0}.", "FNRCM0028", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_STATIC_LOAD_FAILED = new ExceptionCode("METADATA_STATIC_LOAD_FAILED", "Error loading static metadata.", "FNRCM0029", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_TOO_MANY_ROOTS = new ExceptionCode("METADATA_TOO_MANY_ROOTS", "Too many root classes in metadata.  Offender is: {0}", "FNRCM0030", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_UNEXPECTED_CREATE_ERROR = new ExceptionCode("METADATA_UNEXPECTED_CREATE_ERROR", "Unexpected exception creating ObjectStoreCache: {0}.", "FNRCM0031", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_OS_CACHE_LOAD_ERROR = new ExceptionCode("METADATA_OS_CACHE_LOAD_ERROR", "The object store cache failed to load for object store {0}.", "FNRCM0032", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_STALE_CACHE = new ExceptionCode("METADATA_STALE_CACHE", "The metadata cache for object store {0} is stale.  The Content Engine will retry this request against a refreshed cache.", "FNRCM0033", true, ErrorLoggingLevel.Optional);
    public static final ExceptionCode METADATA_BAD_CHANGEPREPROCESSORDEF_PARENT = new ExceptionCode("METADATA_BAD_CHANGEPREPROCESSORDEF_PARENT", "The change preprocessor definition identified by ActionId {0} and DisplayName {1} has a bad parent_id.", "FNRCM0034", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_ADDON_CREATION_FAILED = new ExceptionCode("PERSIST_ADDON_CREATION_FAILED", "A failure occurred while creating AddOn \"{0}\" in Domain \"{1}\".", "FNRCP0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_ADDON_INSTALLATION_FAILED = new ExceptionCode("PERSIST_ADDON_INSTALLATION_FAILED", "The installation of the AddOn {0} into the object store {1} failed.", "FNRCP0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_BAD_FILTERED_PROPERTY_ID = new ExceptionCode("PERSIST_BAD_FILTERED_PROPERTY_ID", "Bad filtered property ID \"{0}\".", "FNRCP0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANNOT_GET_DATABASE_VERSION = new ExceptionCode("PERSIST_CANNOT_GET_DATABASE_VERSION", "Unable to get the database version.", "FNRCP0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANT_CBR_ENABLE = new ExceptionCode("PERSIST_CANT_CBR_ENABLE", "Cannot set CBREnabled equal to true until the object store has been enabled for CBR.", "FNRCP0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANT_CHANGE_CBR_LOCALE = new ExceptionCode("PERSIST_CANT_CHANGE_CBR_LOCALE", "The CBRLocale of object store {0} may not be changed when any VerityCollection objects exist in that object store.", "FNRCP0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CBR_LOCALE_NOT_SET = new ExceptionCode("PERSIST_CBR_LOCALE_NOT_SET", "The CBRLocale property of the object store must be set before any IndexAreas are created", "FNRCP0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_COMPOUND_DOCUMENT_INTEGRITY = new ExceptionCode("PERSIST_COMPOUND_DOCUMENT_INTEGRITY", "An attempted operation would violate compound document integrity rules.", "FNRCP0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_INVALID_DATABASE_CHARSET = new ExceptionCode("PERSIST_INVALID_DATABASE_CHARSET", "The character set for this database is invalid.", "FNRCP0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_INVALID_JOB_IDX_ID = new ExceptionCode("PERSIST_INVALID_JOB_IDX_ID", "IndexationId {0} in the IndexJobCollectionItem object does not refer to an existing VerityCollection or CmTextSearchIndex object", "FNRCP0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_INVALID_SUBSCRIPTION_TARGET = new ExceptionCode("PERSIST_INVALID_SUBSCRIPTION_TARGET", "Invalid subscription target.", "FNRCP0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_NO_COLUMN = new ExceptionCode("PERSIST_NO_COLUMN", "No column defined for property {0} on class {1}.", "FNRCP0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_OBJSTR_DATABASE_TABLES_EXIST = new ExceptionCode("PERSIST_OBJSTR_DATABASE_TABLES_EXIST", "Database tables already exist for ObjectStore: {0}.", "FNRCP0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_SINGLETON_CLASS = new ExceptionCode("PERSIST_SINGLETON_CLASS", "Only one instance of class {0} can be created.  The existing instance must be deleted before a new one can be created.", "FNRCP0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_UNEXPECTED_PROPERTY_CARDINALITY = new ExceptionCode("PERSIST_UNEXPECTED_PROPERTY_CARDINALITY", "Unexpected property cardinality", "FNRCP0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_UNSUPPORTED_DATABASE = new ExceptionCode("PERSIST_UNSUPPORTED_DATABASE", "Unsupported database, type {0}.", "FNRCP0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_UNSUPPORTED_DATABASE_VERSION = new ExceptionCode("PERSIST_UNSUPPORTED_DATABASE_VERSION", "Unsupported database version {0} (must have at least {1}).", "FNRCP0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANT_DELETE_INUSE_INDEX_AREA = new ExceptionCode("PERSIST_CANT_DELETE_INUSE_INDEX_AREA", "Can''t delete a VerityIndexArea when the VerityCollections property is not empty.  Set the isCBREnabled property to false and then run an IndexJob so the VerityCollections will be deleted before attempting to delete the IndexArea.", "FNRCP0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANT_DELETE_VERITY_COLLECTION = new ExceptionCode("PERSIST_CANT_DELETE_VERITY_COLLECTION", "Can''t delete a VerityCollection from an IndexArea.  Set the isCBREnabled property to false and run an IndexJob instead.", "FNRCP0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_INVALID_PATH = new ExceptionCode("PERSIST_INVALID_PATH", "Property {0} contains a path name ({1}) that does not exist in the file system of the CE server.", "FNRCP0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_INVALID_PATH_NO_WRITE = new ExceptionCode("PERSIST_INVALID_PATH_NO_WRITE", "Property {0} contains a path name ({1}) that exists in the file system of the CE server, but cannot be written.", "FNRCP0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_VERITY_MASTER_ADMIN_PORT_INCONSISTENT = new ExceptionCode("PERSIST_VERITY_MASTER_ADMIN_PORT_INCONSISTENT", "If either the VerityMasterAdminServerHostname or VerityMasterAdminServerPort is non-null, both must be non-null.", "FNRCP0022", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANT_CHANGE_ROOT_DIRECTORY_PATH = new ExceptionCode("PERSIST_CANT_CHANGE_ROOT_DIRECTORY_PATH", "The VerityIndexArea.RootDirectoryPath property cannot be changed when a VerityCollection exists in that IndexArea.  Create a new IndexArea to put new collections on a new path.  Run an IndexJob to move existing data to that new path if desired.", "FNRCP0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANT_USE_ZERO_GUID = new ExceptionCode("PERSIST_CANT_USE_ZERO_GUID", "Creating an object with a Id of all zeroes is not allowed.  Class of object in create attempt was {0}", "FNRCP0024", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_INVALID_TEMP_DIRECTORY_PATH = new ExceptionCode("PERSIST_INVALID_TEMP_DIRECTORY_PATH", "The VerityIndexArea.TempDirectoryPath ({0}) contains a path name that does not exist in the file system of the CE server.  This path must be visible to both the Verity servers and the CE servers.", "FNRCP0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_UNSUPPORTED_FEDERATED_OP = new ExceptionCode("PERSIST_UNSUPPORTED_FEDERATED_OP", "The current operation ({0}) is not supported or invalid for the federated document.", "FNRCP0026", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_INVALID_AUDIT_FILTERING_FILTER_EXPRESSION = new ExceptionCode("PERSIST_INVALID_AUDIT_FILTERING_FILTER_EXPRESSION", "The filter expression value {1} is invalid for the audit definition {0}.", "FNRCP0027", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_INVALID_AUDIT_FILTERING_FILTERED_PROPERTY = new ExceptionCode("PERSIST_INVALID_AUDIT_FILTERING_FILTERED_PROPERTY", "The filter expression value {1} is invalid for the audit definition property {0}.", "FNRCP0028", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_INVALID_PRECONDITION = new ExceptionCode("PERSIST_INVALID_PRECONDITION", "The precondition expression {0} is invalid.", "FNRCP0029", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_INVALID_POSTCONDITION = new ExceptionCode("PERSIST_INVALID_POSTCONDITION", "The postcondition expression {0} is invalid.", "FNRCP0030", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_TS_ROOT_DIRECTORY_PATH_NOT_SET = new ExceptionCode("PERSIST_TS_ROOT_DIRECTORY_PATH_NOT_SET", "IBM Content Search Services could not set the root directory path for the {0} index area.", "FNRCP0031", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_TASK_RELATIONSHIP_INTEGRITY = new ExceptionCode("PERSIST_TASK_RELATIONSHIP_INTEGRITY", "An attempted operation would violate task relationship integrity rules.", "FNRCP0032", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_BAD_AUDIT_DISPOSITION_RULE = new ExceptionCode("PERSIST_BAD_AUDIT_DISPOSITION_RULE", "The specified disposition rule contains a syntax error or an invalid property name:  {0}", "FNRCP0033", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANT_DELETE_TEXTSEARCH_INDEX = new ExceptionCode("PERSIST_CANT_DELETE_TEXTSEARCH_INDEX", "Application code that calls the Content Engine API methods could not delete an index for IBM Content Search Services. The index is in the {0} index area for the {1} object store.", "FNRCP0034", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANT_DELETE_INUSE_TEXTSEARCH_INDEX_AREA = new ExceptionCode("PERSIST_CANT_DELETE_INUSE_TEXTSEARCH_INDEX_AREA", "Application code that calls the Content Engine API methods could not delete the {0} index area for IBM Content Search Services. The index area belongs to the {1} object store.", "FNRCP0035", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANT_SAVE_TEXTSEARCH_INDEX = new ExceptionCode("PERSIST_CANT_SAVE_TEXTSEARCH_INDEX", "Application code that calls the Content Engine API methods could not create an IBM Content Search Services index.", "FNRCP0036", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_TS_INVALID_ROOT_DIRECTORY_PATH = new ExceptionCode("PERSIST_TS_INVALID_ROOT_DIRECTORY_PATH", "IBM Content Search Services could not set the root directory path for the {0} index area. The following specified path for the root directory does not exist in the file system or is not accessible to IBM Content Search Services servers: {1}.", "FNRCP0037", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_TS_INVALID_MAX_INDEXES_CHANGE = new ExceptionCode("PERSIST_TS_INVALID_MAX_INDEXES_CHANGE", "IBM Content Search Services could not set the maximum number of indexes for the {1} index area. The specified maximum number is less than {0}, which is the current number of indexes in the index area.", "FNRCP0038", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_TS_ROOT_DIRECTORY_PATH_NO_WRITE = new ExceptionCode("PERSIST_TS_ROOT_DIRECTORY_PATH_NO_WRITE", "IBM Content Search Services could not write index information to the {1} index area with the following root directory path: {0}.", "FNRCP0039", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_TS_INDEXING_LANGUAGE_NOT_SET = new ExceptionCode("PERSIST_TS_INDEXING_LANGUAGE_NOT_SET", "Content Engine could not create an index area because the value of the Indexing Language property is null.", "FNRCP0040", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_TS_INVALID_INDEXING_LANGUAGE = new ExceptionCode("PERSIST_TS_INVALID_INDEXING_LANGUAGE", "Content Engine could not save the following value for the Indexing Language property because the value is not valid: {0}.", "FNRCP0041", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_RETENTION_COMPATIBILITY_MODE = new ExceptionCode("PERSIST_RETENTION_COMPATIBILITY_MODE", "The default retention period of the fixed storage area is invalid for an area operating in retention compatibility mode, : Storage area {0} Default Period {1}.", "FNRCP0042", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_RETENTION_CLOCK_SKEW = new ExceptionCode("PERSIST_RETENTION_CLOCK_SKEW", "The system and RDBMS clocks are skewed, event based retention cannot be applied: skew seconds {0}.", "FNRCP0043", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_RETENTION_CONSTRAINT_VIOLATED = new ExceptionCode("PERSIST_RETENTION_CONSTRAINT_VIOLATED", "The retention date of the object cannot be altered due to a retention constraint.", "FNRCP0044", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_RETENTION_DELETE_PREVENTED = new ExceptionCode("PERSIST_RETENTION_DELETE_PREVENTED", "The object cannot be deleted due to a retention constraint.", "FNRCP0045", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_RETENTION_PERIOD_PREVENTED = new ExceptionCode("PERSIST_RETENTION_PERIOD_PREVENTED", "The Retention Period property of the Storage Area cannot be changed to any value except NOT_ALLOWED: period {0}.", "FNRCP0046", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANT_CHANGE_INDEX_REQUEST_STATUS = new ExceptionCode("PERSIST_CANT_CHANGE_INDEX_REQUEST_STATUS", "Content Engine ignored the requested operation to change the status of the \"{0}\" index request.", "FNRCP0048", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_RETENTION_NOT_SUPPORTED = new ExceptionCode("PERSIST_RETENTION_NOT_SUPPORTED", "The retention feature is not currently supported.", "FNRCP0049", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_BAD_PUBLISH_REQUEST = new ExceptionCode("PUBLISH_BAD_PUBLISH_REQUEST", "The submitted publish request is invalid.", "FNRCU0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_BAD_PUBLISH_TEMPLATE = new ExceptionCode("PUBLISH_BAD_PUBLISH_TEMPLATE", "The provided publish template is invalid.", "FNRCU0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_NO_HANDLER = new ExceptionCode("PUBLISH_NO_HANDLER", "Unable to get a handler for the PublishRequest {0}.", "FNRCU0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_HANDLER_THREW = new ExceptionCode("PUBLISH_HANDLER_THREW", "The Publishing handler threw an exception.", "FNRCU0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_READING_REC_THREW = new ExceptionCode("PUBLISH_READING_REC_THREW", "Reading the RenditionEngineConnection threw.", "FNRCU0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_READING_PR_PUBLISHINGSTATUS_THREW = new ExceptionCode("PUBLISH_READING_PR_PUBLISHINGSTATUS_THREW", "Reading the PublishRequest.PublishingStatus threw", "FNRCU0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_CONTENT_REFERENCE_NOT_SUPPORTED = new ExceptionCode("PUBLISH_CONTENT_REFERENCE_NOT_SUPPORTED", "Publishing does not support a content reference as the first content element of the source document.", "FNRCU0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_CONTENT_ELEMENT_NOT_FOUND = new ExceptionCode("PUBLISH_CONTENT_ELEMENT_NOT_FOUND", "Publishing requires that the source document must contain a content element, but none was found.", "FNRCU0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode REPLICATION_LATER_VERSION_EXISTS = new ExceptionCode("REPLICATION_LATER_VERSION_EXISTS", "Can not replicate version {0}.{1} because a later version of {2}.{3} already exists in the target object store.", "FNRCY0001", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_ALL_PROPS_FROM_SAME_CLASS = new ExceptionCode("RETRIEVE_ALL_PROPS_FROM_SAME_CLASS", "When returning objects all properties selected must be from same class.", "FNRCR0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_AMBIGUOUS_PROPERTY = new ExceptionCode("RETRIEVE_AMBIGUOUS_PROPERTY", "Ambiguous property has no table specifier: {0}.", "FNRCR0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_APPEND_ACTIVE_CLAUSE = new ExceptionCode("RETRIEVE_BAD_APPEND_ACTIVE_CLAUSE", "Bad call to SelectStatementEx.appendActiveClause.", "FNRCR0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_CONTENT_ELEMENT_ID = new ExceptionCode("RETRIEVE_BAD_CONTENT_ELEMENT_ID", "Bad element id in Content table.  Document: {0}.", "FNRCR0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_CONTENT_ELEMENT_ORDINAL = new ExceptionCode("RETRIEVE_BAD_CONTENT_ELEMENT_ORDINAL", "Invalid ordinal {0} in element_id of content.  Document {1}.", "FNRCR0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_CONTINUATION_STRING = new ExceptionCode("RETRIEVE_BAD_CONTINUATION_STRING", "The continuation string is invalid: {0}", "FNRCR0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_GET_OBJECT_PARAMETERS = new ExceptionCode("RETRIEVE_BAD_GET_OBJECT_PARAMETERS", "Bad getObject parameters.", "FNRCR0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_GLOBAL_IDENTITY = new ExceptionCode("RETRIEVE_BAD_GLOBAL_IDENTITY", "Bad global identity.", "FNRCR0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_MULTI_SELECT_DISTINCT = new ExceptionCode("RETRIEVE_BAD_MULTI_SELECT_DISTINCT", "Can''t use select distinct if selected property not defined in all object stores of multi object store query: {0}.", "FNRCR0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_NAME_PROPERTY = new ExceptionCode("RETRIEVE_BAD_NAME_PROPERTY", "Name property not set up correctly in system metadata on class {0} (system error)", "FNRCR0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_OBJECT_ADDRESS = new ExceptionCode("RETRIEVE_BAD_OBJECT_ADDRESS", "Bad ObjectAddress.", "FNRCR0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_OBJECT_COLUMN_TYPE = new ExceptionCode("RETRIEVE_BAD_OBJECT_COLUMN_TYPE", "Invalid column type for object property {0}.", "FNRCR0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_ORDERBY_DATATYPE = new ExceptionCode("RETRIEVE_BAD_ORDERBY_DATATYPE", "Invalid datatype in order by.", "FNRCR0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_PROPERTY_FILTER_TYPE = new ExceptionCode("RETRIEVE_BAD_PROPERTY_FILTER_TYPE", "Unknown property type in PropertyFilter: {0}.", "FNRCR0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_REPOSITORY_SEARCH = new ExceptionCode("RETRIEVE_BAD_REPOSITORY_SEARCH", "Can''t call AdHocClassRetriever.executeSearch for anything other than a repository search.", "FNRCR0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CANT_COMPARE_TYPES = new ExceptionCode("RETRIEVE_CANT_COMPARE_TYPES", "Can''t compare dissimilar types.  Near: {0}", "FNRCR0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CANT_CREATE_RETRIEVER = new ExceptionCode("RETRIEVE_CANT_CREATE_RETRIEVER", "Can''t create retriever: {0}.", "FNRCR0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CANT_CREATE_SEARCH_TEMP_DIR = new ExceptionCode("RETRIEVE_CANT_CREATE_SEARCH_TEMP_DIR", "Can''t create temp file directory {0} for use with content search", "FNRCR0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CANT_GET_LOCAL_HOST = new ExceptionCode("RETRIEVE_CANT_GET_LOCAL_HOST", "Can''t determine local host", "FNRCR0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CANT_GET_OBJECT_ID = new ExceptionCode("RETRIEVE_CANT_GET_OBJECT_ID", "Not an independent or global object.  Can''t get object id.", "FNRCR0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CANT_MODIFY_ROOT_FOLDER = new ExceptionCode("RETRIEVE_CANT_MODIFY_ROOT_FOLDER", "Can''t modify root folder.", "FNRCR0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CANT_OPEN_COLLECTION = new ExceptionCode("RETRIEVE_CANT_OPEN_COLLECTION", "Can''t open Verity collection \"{0}\", error: {1}", "FNRCR0022", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CANT_OPEN_WORKSPACE = new ExceptionCode("RETRIEVE_CANT_OPEN_WORKSPACE", "Can''t open Verity workspace.  Error on create: \"{0}\", Error on open: \"{1}\"", "FNRCR0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CANT_SELECT_DISTINCT_PROP_WITH_NO_COLUMN = new ExceptionCode("RETRIEVE_CANT_SELECT_DISTINCT_PROP_WITH_NO_COLUMN", "No column defined on property used with \"distinct\": {0}.", "FNRCR0024", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CANT_SELECT_WITH_DISTINCT = new ExceptionCode("RETRIEVE_CANT_SELECT_WITH_DISTINCT", "Can''t select property with \"distinct\": {0}.", "FNRCR0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CONTENT_NOT_TRANSFER = new ExceptionCode("RETRIEVE_CONTENT_NOT_TRANSFER", "Content for document {0}, ordinal {1} is not ContentTransfer.", "FNRCR0026", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CONTENT_SEARCH_AND = new ExceptionCode("RETRIEVE_CONTENT_SEARCH_AND", "CONTAINS/FREETEXT must use AND if ContentSearch joined with inner join", "FNRCR0027", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CONTENT_SEARCH_FAILED = new ExceptionCode("RETRIEVE_CONTENT_SEARCH_FAILED", "The content search failed for search string=\"{0}\", type={1}, property=\"{2}\", class=\"{3}\", and object store=\"{4}\".", "FNRCR0028", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CONTENT_SEARCH_OR = new ExceptionCode("RETRIEVE_CONTENT_SEARCH_OR", "CONTAINS/FREETEXT must use OR if ContentSearch NOT joined with inner join", "FNRCR0029", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_DBCONTEXT_NULL = new ExceptionCode("RETRIEVE_DBCONTEXT_NULL", "DB context is unexpectedly null.", "FNRCR0030", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_EXCEEDED_BLOB_BUFFER = new ExceptionCode("RETRIEVE_EXCEEDED_BLOB_BUFFER", "Exceeded maximum length of blob buffer {0}.", "FNRCR0031", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_EXPECTED_ID = new ExceptionCode("RETRIEVE_EXPECTED_ID", "Expected id property (system error)", "FNRCR0032", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_INVALID_CLASSID_FOR_PROP = new ExceptionCode("RETRIEVE_INVALID_CLASSID_FOR_PROP", "Invalid class id ({0}) for property {1}.", "FNRCR0033", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_INVALID_DEPENDENT_FETCH = new ExceptionCode("RETRIEVE_INVALID_DEPENDENT_FETCH", "Attempt to get a dependent property by item index when property is not a dependent list: {0}", "FNRCR0034", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_INVALID_ISCLASS_ALIAS = new ExceptionCode("RETRIEVE_INVALID_ISCLASS_ALIAS", "Invalid class alias in isclass test {0}.", "FNRCR0035", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_INVALID_LIST_DATATYPE = new ExceptionCode("RETRIEVE_INVALID_LIST_DATATYPE", "Invalid list datatype for property {0}", "FNRCR0036", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_INVALID_OPERATOR_FOR_CONTAINS = new ExceptionCode("RETRIEVE_INVALID_OPERATOR_FOR_CONTAINS", "Invalid operator used with CONTAINS/FREETEXT: {0}", "FNRCR0037", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_INVALID_PROPERTY_VALUE = new ExceptionCode("RETRIEVE_INVALID_PROPERTY_VALUE", "Invalid property value type for property {0}.", "FNRCR0038", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_ITEM_INDEX_NEGATIVE = new ExceptionCode("RETRIEVE_ITEM_INDEX_NEGATIVE", "Item index is negative in request to retrieve dependent object.", "FNRCR0039", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_MISSING_CONTENTSEARCH_JOIN = new ExceptionCode("RETRIEVE_MISSING_CONTENTSEARCH_JOIN", "When using CONTAINS/FREETEXT, there must be a ContentSearch table joined to another table in the FROM clause", "FNRCR0040", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_MORE_THAN_ONE_CONTENT_TABLE = new ExceptionCode("RETRIEVE_MORE_THAN_ONE_CONTENT_TABLE", "Can''t have more than one ContentSearch table joined into a search", "FNRCR0041", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_MULTIPLE_COLUMN_NAMES = new ExceptionCode("RETRIEVE_MULTIPLE_COLUMN_NAMES", "Two properties with same table have different column names.  Property 1: {0}, Property 2: {1}, Table name: {2}.", "FNRCR0042", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_MULTIPLE_CONTAINSORFREETEXT = new ExceptionCode("RETRIEVE_MULTIPLE_CONTAINSORFREETEXT", "Can''t have more than one CONTAINS or FREETEXT clause in a search statement", "FNRCR0043", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_MULTIPLE_DATATYPES = new ExceptionCode("RETRIEVE_MULTIPLE_DATATYPES", "Two properties with same table have different data types.  Property 1: {0}, Property 2: {1}, Table name: {2}.", "FNRCR0044", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_MULTIPLE_ON_CONTENT = new ExceptionCode("RETRIEVE_MULTIPLE_ON_CONTENT", "An ON condition that references content search tables more than once is invalid.", "FNRCR0045", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NEED_SEARCH_SERVER = new ExceptionCode("RETRIEVE_NEED_SEARCH_SERVER", "Must have at least one search server specified for index area {0}", "FNRCR0046", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NOT_IMPLEMENTED = new ExceptionCode("RETRIEVE_NOT_IMPLEMENTED", "Not Implemented.", "FNRCR0047", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NOT_OBJECT = new ExceptionCode("RETRIEVE_NOT_OBJECT", "Property for getObject must be object: {0}.", "FNRCR0048", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NO_DISTINCT_MERGE = new ExceptionCode("RETRIEVE_NO_DISTINCT_MERGE", "\"Distinct\" not supported in merged scope queries.", "FNRCR0049", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NO_INDEX_AREA_FOR_COLLECTION = new ExceptionCode("RETRIEVE_NO_INDEX_AREA_FOR_COLLECTION", "No verity index area for collection id: {0}", "FNRCR0050", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NO_ITEM_INDEX = new ExceptionCode("RETRIEVE_NO_ITEM_INDEX", "No item index in request to retrieve dependent object.", "FNRCR0051", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NO_REQUIRED_CLASS = new ExceptionCode("RETRIEVE_NO_REQUIRED_CLASS", "Persistent property {0} has no required class.", "FNRCR0052", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NO_ROOT_FOLDER = new ExceptionCode("RETRIEVE_NO_ROOT_FOLDER", "Root folder not in cache.", "FNRCR0053", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NO_SELECTED_PROPERTY = new ExceptionCode("RETRIEVE_NO_SELECTED_PROPERTY", "Selected property not found in property list.", "FNRCR0054", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NO_VERITY_COLLECTION = new ExceptionCode("RETRIEVE_NO_VERITY_COLLECTION", "No verity collection for collection id: {0}", "FNRCR0055", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NULL_CONTENTSEARCH_JOIN = new ExceptionCode("RETRIEVE_NULL_CONTENTSEARCH_JOIN", "Can''t join null row to ContentSearch", "FNRCR0056", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NULL_TABLE_LIST = new ExceptionCode("RETRIEVE_NULL_TABLE_LIST", "Can''t use property ({0}) with null table for list cardinality.", "FNRCR0057", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_ORDER_BY_NOT_SELECTED = new ExceptionCode("RETRIEVE_ORDER_BY_NOT_SELECTED", "Order by property must be in selection list: {0}.", "FNRCR0058", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_ORDER_CLAUSE_PARSE_FAILURE = new ExceptionCode("RETRIEVE_ORDER_CLAUSE_PARSE_FAILURE", "Expected one child node of order property (system error)", "FNRCR0059", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_BAD_CARDINALITY = new ExceptionCode("RETRIEVE_PARSE_BAD_CARDINALITY", "The cardinality (list or single-valued property) does not match the cardinality of the operator expression for property {0}.", "FNRCR0060", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_BAD_CHILD_COUNT = new ExceptionCode("RETRIEVE_PARSE_BAD_CHILD_COUNT", "Unexpected number of child elements of \"{0}\"", "FNRCR0061", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_BAD_LONG_STRING = new ExceptionCode("RETRIEVE_PARSE_BAD_LONG_STRING", "Long string property {0} not allowed with given operator.", "FNRCR0062", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_BAD_ROOT_CHILD = new ExceptionCode("RETRIEVE_PARSE_BAD_ROOT_CHILD", "Unrecognized child of root query node.", "FNRCR0063", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_CANT_COMPARE_CONSTANTS = new ExceptionCode("RETRIEVE_PARSE_CANT_COMPARE_CONSTANTS", "Can''t compare two constants that are dates, booleans, or guids", "FNRCR0064", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_CONSTANT_NOT_ALLOWED = new ExceptionCode("RETRIEVE_PARSE_CONSTANT_NOT_ALLOWED", "Constant not allowed with operator {0}.  Near: {1}", "FNRCR0065", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_EXPRESSION_NOT_ALLOWED = new ExceptionCode("RETRIEVE_PARSE_EXPRESSION_NOT_ALLOWED", "Expression not allowed with operator {0}.  Near: {1}", "FNRCR0066", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_INVALID_FOLDER_SYNTAX = new ExceptionCode("RETRIEVE_PARSE_INVALID_FOLDER_SYNTAX", "Invalid folder syntax: {0}.", "FNRCR0067", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_INVALID_FREETEXT_PROPERTY = new ExceptionCode("RETRIEVE_PARSE_INVALID_FREETEXT_PROPERTY", "Invalid property used as first argument of the FREETEXT operator.  FREETEXT Can''t search individual properties and only supports \"*\"", "FNRCR0068", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_INVALID_NODE_TYPE = new ExceptionCode("RETRIEVE_PARSE_INVALID_NODE_TYPE", "Invalid node type: \"{0}\"", "FNRCR0069", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_INVALID_OBJECT_FUNCTION = new ExceptionCode("RETRIEVE_PARSE_INVALID_OBJECT_FUNCTION", "Invalid argument to object function: {0}.", "FNRCR0070", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_INVALID_QUERY_PROPERTY = new ExceptionCode("RETRIEVE_PARSE_INVALID_QUERY_PROPERTY", "Invalid property in query: {0}", "FNRCR0071", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_INVALID_RHS_FOLDER_OPERAND = new ExceptionCode("RETRIEVE_PARSE_INVALID_RHS_FOLDER_OPERAND", "Invalid operand on right hand side of INFOLDER", "FNRCR0072", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_NO_COLUMN_DEFINED = new ExceptionCode("RETRIEVE_PARSE_NO_COLUMN_DEFINED", "Property searched for ({0}) has no column defined.", "FNRCR0073", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_NO_FROM_CLAUSE = new ExceptionCode("RETRIEVE_PARSE_NO_FROM_CLAUSE", "No from clause specified in query.", "FNRCR0074", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_OBJECT_IN_FROM = new ExceptionCode("RETRIEVE_PARSE_OBJECT_IN_FROM", "OBJECT function not allowed in from clause.", "FNRCR0075", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_PROPERTY_NEEDS_CLASS = new ExceptionCode("RETRIEVE_PARSE_PROPERTY_NEEDS_CLASS", "Property {0} must be qualified by a class name.", "FNRCR0076", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_PROPERTY_NOT_ALLOWED = new ExceptionCode("RETRIEVE_PARSE_PROPERTY_NOT_ALLOWED", "Property {0} not allowed with operator {1}.", "FNRCR0077", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_UNEXPECTED_NODE = new ExceptionCode("RETRIEVE_PARSE_UNEXPECTED_NODE", "Unexpected node type in \"{0}\"", "FNRCR0078", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_UNEXPECTED_OPERATOR_DATATYPE = new ExceptionCode("RETRIEVE_PARSE_UNEXPECTED_OPERATOR_DATATYPE", "Unexpected datatype for operator: {0}.  Near: {1}", "FNRCR0079", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PATH_SLASH = new ExceptionCode("RETRIEVE_PATH_SLASH", "Path \"{0}\" does not start with the required ''/'' or ''\\''.", "FNRCR0080", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PROPERTY_NOT_DEFINED = new ExceptionCode("RETRIEVE_PROPERTY_NOT_DEFINED", "The property {0} is not defined.", "FNRCR0081", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PROPERTY_NOT_ORDERABLE = new ExceptionCode("RETRIEVE_PROPERTY_NOT_ORDERABLE", "Property not orderable: {0}.", "FNRCR0082", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SQL_SYNTAX_ERROR = new ExceptionCode("RETRIEVE_SQL_SYNTAX_ERROR", "There was a syntax error in a SQL query or filter expression at line {0}, position {1}.  Saw \"{2}\" but expected {3}.  The original text was: {4}.", "FNRCR0083", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_UNEXPECTED_PROP_CONSTRAINT = new ExceptionCode("RETRIEVE_UNEXPECTED_PROP_CONSTRAINT", "Unexpected property has constraint: {0}.", "FNRCR0084", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_UNEXPECTED_SELECTION = new ExceptionCode("RETRIEVE_UNEXPECTED_SELECTION", "Unexpected object property selection.", "FNRCR0085", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_UNRECOGNIZED_QUERY_DATE = new ExceptionCode("RETRIEVE_UNRECOGNIZED_QUERY_DATE", "Unrecognized query date \"{0}\".", "FNRCR0086", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_UNSELECT_ORDER_BY = new ExceptionCode("RETRIEVE_UNSELECT_ORDER_BY", "Unselected property in order by must be id column.", "FNRCR0087", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_MULTI_OBJECT_STORE_IN_TRAN = new ExceptionCode("RETRIEVE_MULTI_OBJECT_STORE_IN_TRAN", "Doing a multiple object store search while in a distributed transaction, such as executing inside event action, is not supported.", "FNRCR0088", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CONTENT_JOIN_INVALID = new ExceptionCode("RETRIEVE_CONTENT_JOIN_INVALID", "Join on content search is invalid.  A content search of class \"X\" must contain \"... JOIN ON ContentSearch.QueriedObject = X.This\"", "FNRCR0089", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NEED_MULTIPLE_OBJECT_STORES = new ExceptionCode("RETRIEVE_NEED_MULTIPLE_OBJECT_STORES", "At least two object stores must be supplied to a merged scope query.  #Supplied={0}", "FNRCR0090", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NULL_ENUM_COLUMN = new ExceptionCode("RETRIEVE_NULL_ENUM_COLUMN", "Attempt to retrieve an enumeration property that has a reflective property with no column defined.  Class={0}, Enumeration property={1}, Reflective property of enumeration={2}", "FNRCR0091", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_INVALID_REFLECTIVE_PROP = new ExceptionCode("RETRIEVE_INVALID_REFLECTIVE_PROP", "Invalid Reflective property(={0}) specified for Enum Propeorty(={1}). Reflective Property should present in either the \"Required Class\" or its sub classes.", "FNRCR0092", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NO_TEXTSEARCH_INDEX = new ExceptionCode("RETRIEVE_NO_TEXTSEARCH_INDEX", "No Text search Index for index id: {0}", "FNRCR0093", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_REQUIRED_ELEMENT_OR_ATTRIBUTE_NOT_PRESENT = new ExceptionCode("RETRIEVE_SEARCH_XML_REQUIRED_ELEMENT_OR_ATTRIBUTE_NOT_PRESENT", "The XML to use for the search is incomplete. The required element or attribute {0} is not present.", "FNRCA0094", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_REQUIRED_ELEMENT_OR_ATTRIBUTE_HAS_NO_VALUE = new ExceptionCode("RETRIEVE_SEARCH_XML_REQUIRED_ELEMENT_OR_ATTRIBUTE_HAS_NO_VALUE", "The XML to use for the search is invalid. The required element or attribute {0} does not have a value assigned.", "FNRCA0095", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_INVALID_ATTRIBUTE_VALUE = new ExceptionCode("RETRIEVE_SEARCH_XML_INVALID_ATTRIBUTE_VALUE", "The XML to use for the search is invalid. The {0} value assigned to the {1} attribute is invalid.", "FNRCA0096", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_INVALID_CHILD_NODE_COUNT = new ExceptionCode("RETRIEVE_SEARCH_XML_INVALID_CHILD_NODE_COUNT", "The XML to use for the search is not well-formed. There should be {1} child nodes for {0}, but {2} were found.", "FNRCA0097", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_INVALID_CONTENT_ITEM_COUNT = new ExceptionCode("RETRIEVE_SEARCH_XML_INVALID_CONTENT_ITEM_COUNT", "The XML to use for the search is invalid. You have attempted to add more content items than are allowed.", "FNRCA0098", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_INVALID_RESET_OF_CONTENT_ITEM = new ExceptionCode("RETRIEVE_SEARCH_XML_INVALID_RESET_OF_CONTENT_ITEM", "The XML to use for the search is invalid. You have attempted improperly to reset an existing content item.", "FNRCA0099", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_INVALID_RETRIEVE_OF_CONTENT_ITEM = new ExceptionCode("RETRIEVE_SEARCH_XML_INVALID_RETRIEVE_OF_CONTENT_ITEM", "The XML to use for the search is invalid. You have attempted to retrieve a nonexistent content item.", "FNRCA0100", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_INVALID_GROUPACTION_ATTRIBUTE = new ExceptionCode("RETRIEVE_SEARCH_XML_INVALID_GROUPACTION_ATTRIBUTE", "The XML to use for the search is invalid. When no operator is present, the groupaction attribute value must be \"none\".", "FNRCA0101", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_INVALID_WORKVARIATION_ATTRIBUTE = new ExceptionCode("RETRIEVE_SEARCH_XML_INVALID_WORKVARIATION_ATTRIBUTE", "The XML to use for the search is invalid. The specified wordvariation attribute value is not allowed with a case attribute value of {0}.", "FNRCA0102", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_CLAUSE_NOT_FOUND = new ExceptionCode("RETRIEVE_SEARCH_CLAUSE_NOT_FOUND", "The XML to use for the search is invalid. You have attempted to execute a query that does not contain a search clause for the {0} class.", "FNRCA0103", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_FOLDER_NOT_FOUND = new ExceptionCode("RETRIEVE_SEARCH_FOLDER_NOT_FOUND", "The XML to use for the search is invalid. The folder specified with the itemid {0} was not found in the search XML when merging the search parameters.", "FNRCA0104", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_SUBCLASS_NOT_FOUND = new ExceptionCode("RETRIEVE_SEARCH_SUBCLASS_NOT_FOUND", "The XML to use for the search is invalid. The subclass specified with the itemid {0} was not found in the search XML when merging the search parameters.", "FNRCA0105", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_INVALID_MIMETYPE = new ExceptionCode("RETRIEVE_SEARCH_INVALID_MIMETYPE", "The XML to use for the search is invalid. The mimetype attribute value {0} is not valid. Valid mimetype values are: application/x-filenet-searchtemplate or application/x-filenet-search.", "FNRCA0106", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_INVALID_XML_QUERY_FROM_CLASS = new ExceptionCode("RETRIEVE_SEARCH_INVALID_XML_QUERY_FROM_CLASS", "The XML to use for the search is invalid. The class attribute value {0} specified for the from clause is not valid. Valid values are document, folder and customobject.", "FNRCA0107", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_INVALID_PARAMETER_QUERY_FROM_CLASS = new ExceptionCode("RETRIEVE_SEARCH_INVALID_PARAMETER_QUERY_FROM_CLASS", "The searchClauseFromClass parameter for the SearchScope method to execute the stored search is invalid. The class {0} specified for the searchClauseFromClass parameter is invalid.", "FNRCA0108", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_REQUIRED_MERGE_DATA_NOT_PRESENT = new ExceptionCode("RETRIEVE_SEARCH_REQUIRED_MERGE_DATA_NOT_PRESENT", "The templateData parameter for the SearchScope method to execute the stored search is invalid. The SearchTemplateParameters instance did not contain the required value {1} in the {0} object.", "FNRCA0109", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_EXCLUDE_TARGET_NOT_PRESENT = new ExceptionCode("RETRIEVE_SEARCH_EXCLUDE_TARGET_NOT_PRESENT", "An object specified to be excluded from the search XML does not exist. The {0} object having itemId {1} was not found.", "FNRCA0110", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_ADD_ITEM_VALUES_NOT_SET = new ExceptionCode("RETRIEVE_SEARCH_ADD_ITEM_VALUES_NOT_SET", "An item to be added to the search XML does not have all of the required attribute values set. The {0} object having itemId {1} does not have all of the required values specified.", "FNRCA0111", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_CANNOT_MODIFY_NONEXISTENT_ITEM = new ExceptionCode("RETRIEVE_SEARCH_CANNOT_MODIFY_NONEXISTENT_ITEM", "An item to be modified was not found in the search XML. The {0} object having itemId {1} was not found.", "FNRCA0112", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_INVALID_ATTRIBUTE = new ExceptionCode("RETRIEVE_SEARCH_INVALID_ATTRIBUTE", "An attribute in search XML was assigned an invalid value. The {1} attribute on the {0} object was assigned a value of {2}. This value is not valid.", "FNRCA0113", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_INVALID_GROUPING = new ExceptionCode("RETRIEVE_SEARCH_INVALID_GROUPING", "A range for the search modifier was not specified in the search XML. The search modifier requires an associated search modifier range value for the {0} object having an itemId of {1} and a search modifier of {2}.", "FNRCA0114", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_INVALID_XML = new ExceptionCode("RETRIEVE_SEARCH_INVALID_XML", "The search XML is invalid. The XML does not conform to the Stored Search schema. The error was triggered when {0} was found, and {1} was expected.", "FNRCA0115", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_INVALID_SORT_LEVEL = new ExceptionCode("RETRIEVE_SEARCH_INVALID_SORT_LEVEL", "The sort level specified in the search XML is invalid. A non-sequential sort level was found. The sort level must be sequential.", "FNRCA0116", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_INVALID_VERSION = new ExceptionCode("RETRIEVE_SEARCH_INVALID_VERSION", "The version specified in the search XML is invalid. The dtd attribute value specified was {0}, and should be ''3.0''. The searchobject attribute value specified was {1}, and should be ''3''.", "FNRCA0117", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_INVALID_FUZZY_MODIFIER = new ExceptionCode("RETRIEVE_SEARCH_XML_INVALID_FUZZY_MODIFIER", "Invalid value for fuzzy search parameter, must be greater then 0.0 and less then 1.0, value = {0}.", "FNRCA0118", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_INVALID_PROXIMITY_MODIFIER = new ExceptionCode("RETRIEVE_SEARCH_XML_INVALID_PROXIMITY_MODIFIER", "Invalid value for proximity search parameter, value = {0}.", "FNRCA0119", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SCRIPT_ERROR = new ExceptionCode("SCRIPT_ERROR", "There was an error running the script.", "FNRCZ0001", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SCRIPT_LOAD_INVOKE_ERROR = new ExceptionCode("SCRIPT_LOAD_INVOKE_ERROR", "There was an error loading or invoking the script engine.", "FNRCZ0002", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SCRIPT_NO_SUCH_METHOD = new ExceptionCode("SCRIPT_NO_SUCH_METHOD", "No such method in script: {0}", "FNRCZ0003", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SCRIPT_SYNTAX_ERROR = new ExceptionCode("SCRIPT_SYNTAX_ERROR", "There was an error loading the script.", "FNRCZ0004", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_ANONYMOUS_DISALLOWED = new ExceptionCode("SECURITY_ANONYMOUS_DISALLOWED", "Access to Content Engine was not allowed because the request was made anonymously instead of by an authenticated user.", "FNRCS0001", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_EXCEPTION_READING_OBJECT = new ExceptionCode("SECURITY_EXCEPTION_READING_OBJECT", "Exception while reading a Security Descriptor, ACL or ACE.", "FNRCS0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_EXCEPTION_WRITING_OBJECT = new ExceptionCode("SECURITY_EXCEPTION_WRITING_OBJECT", "Exception while writing a Security Descriptor, ACL or ACE.", "FNRCS0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_INVALID_CONFIGURATION = new ExceptionCode("SECURITY_INVALID_CONFIGURATION", "Security configuration is invalid.", "FNRCS0004", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_INVALID_CREDENTIALS = new ExceptionCode("SECURITY_INVALID_CREDENTIALS", "Access to the Content Engine was not allowed because the Content Engine API library or the Web Service Interface (WSI) Listener could not find the required security context information.", "FNRCS0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_INVALID_DN = new ExceptionCode("SECURITY_INVALID_DN", "Invalid Distinguished Name: {0}", "FNRCS0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_INVALID_SECURITY_DESCRIPTOR = new ExceptionCode("SECURITY_INVALID_SECURITY_DESCRIPTOR", "An invalid security descriptor was found", "FNRCS0007", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_INVALID_SID_STRING = new ExceptionCode("SECURITY_INVALID_SID_STRING", "The Security Id string {0} is not a valid Security Id.", "FNRCS0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_MISSING_DEFAULT_INSTANCE_SECURITY = new ExceptionCode("SECURITY_MISSING_DEFAULT_INSTANCE_SECURITY", "The default instance security for class {0} is missing", "FNRCS0010", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_MISSING_SECURITY_ID = new ExceptionCode("SECURITY_MISSING_SECURITY_ID", "The security ID {0} cannot be found in the security descriptor table.", "FNRCS0011", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_SORT_TYPE_DESCENDING_NOT_SUPPORTED = new ExceptionCode("SECURITY_SORT_TYPE_DESCENDING_NOT_SUPPORTED", "Sort type specified {0} is not supported in eDirectory.", "FNRCS0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_TOO_MANY_MATCHES = new ExceptionCode("SECURITY_TOO_MANY_MATCHES", "More than one user or group {0} was found in the configured realms for the given attribute {1} and value {2}.", "FNRCS0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_UNEXPECTED_ACE_TYPE = new ExceptionCode("SECURITY_UNEXPECTED_ACE_TYPE", "Unexpected ACE type {0}.", "FNRCS0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_UNEXPECTED_VERSION = new ExceptionCode("SECURITY_UNEXPECTED_VERSION", "Unexpected Security Descriptor, ACL or ACE version {0}.", "FNRCS0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_WSI_NO_LOGIN_MODULES_SUCCEEDED = new ExceptionCode("SECURITY_WSI_NO_LOGIN_MODULES_SUCCEEDED", "Web services login failed: no login modules succeeded.", "FNRCS0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_WSI_KERBEROS_CREDENTIAL_INVALID = new ExceptionCode("SECURITY_WSI_KERBEROS_CREDENTIAL_INVALID", "Web services Kerberos credential invalid: {0}.", "FNRCS0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_WSI_KERBEROS_LOGIN_FAILED = new ExceptionCode("SECURITY_WSI_KERBEROS_LOGIN_FAILED", "Web services Kerberos login failed: {0}.", "FNRCS0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_DOMAIN_ENCRYPTION_UNDEFINED = new ExceptionCode("SECURITY_DOMAIN_ENCRYPTION_UNDEFINED", "The {0} property is undefined for this domain.  This property is automatically defined when the domain object is created, so if you have an old GCD, you may want to recreate the GCD.", "FNRCS0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_DEFAULT_CONFIG_EXCEPTION = new ExceptionCode("SECURITY_DEFAULT_CONFIG_EXCEPTION", "An unexpected exception occurred while parsing the default JAAS configuration file. Line number: {0}, Exception: {1}.", "FNRCS0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_DEFAULT_CONFIG_EXPAND_ERROR = new ExceptionCode("SECURITY_DEFAULT_CONFIG_EXPAND_ERROR", "Cannot expand Java system property {0} in the default JAAS configuration file. Line number: {1}.", "FNRCS0022", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_DEFAULT_CONFIG_PARSE_ERROR = new ExceptionCode("SECURITY_DEFAULT_CONFIG_PARSE_ERROR", "Error parsing the default JAAS configuration file. Line number: {0}, Expected token: {1}.", "FNRCS0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_INVALID_INHERITANCE = new ExceptionCode("SECURITY_INVALID_INHERITANCE", "This object {0} was designated as one that has inherited security and has no inheritable security object values.", "FNRCS0024", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_LDAP_PROVIDER_FAILED = new ExceptionCode("SECURITY_LDAP_PROVIDER_FAILED", "The server was not able to access the LDAP provider while attempting the operation {0} for the security principal {1}. The cause of the error is: {2}", "FNRCS0025", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_LDAP_UNSUPPORTED_OPERATION = new ExceptionCode("SECURITY_LDAP_UNSUPPORTED_OPERATION", "LDAP operation ''{0}'' not supported for principal ''{1}''. Root cause: {2}", "FNRCS0026", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_LDAP_AUTHENTICATION_FAILED = new ExceptionCode("SECURITY_LDAP_AUTHENTICATION_FAILED", "LDAP authentication failed when performing ''{0}'' for principal ''{1}''. Root cause: {2}", "FNRCS0027", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_SID_ATTRIBUTE_VALUE_SIZELIMIT_EXCEEDED = new ExceptionCode("SECURITY_SID_ATTRIBUTE_VALUE_SIZELIMIT_EXCEEDED", "The size of SID attribute {0} exceeded limitation of {1} bytes.", "FNRCS0066", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_MISSING_REQUIRED_LDAP_ATTRIBUTE_VALUE = new ExceptionCode("SECURITY_MISSING_REQUIRED_LDAP_ATTRIBUTE_VALUE", "The LDAP attribute value is null or empty.", "FNRCS0067", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_MISSING_IMPERSONATION_REGION_ID = new ExceptionCode("SECURITY_MISSING_IMPERSONATION_REGION_ID", "The CE isolated region object was not found. PEInit -K must be run on this isolated region to make it available to the CE. Isolated region ID: {0}", "FNRCS0068", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_CALL_CONTEXT_ALREADY_SETUP = new ExceptionCode("TRANSPORT_CALL_CONTEXT_ALREADY_SETUP", "The current thread already has a call context associated with it.", "FNRCT0001", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_CALL_CONTEXT_NOT_SETUP = new ExceptionCode("TRANSPORT_CALL_CONTEXT_NOT_SETUP", "The current thread has no call context associated to it.", "FNRCT0002", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_CORRELATION_ID_MISSING = new ExceptionCode("TRANSPORT_CORRELATION_ID_MISSING", "The server returned a response and the correlation id is missing.", "FNRCT0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_EXECUTE_CHG_MISSING_RESPONSE = new ExceptionCode("TRANSPORT_EXECUTE_CHG_MISSING_RESPONSE", "The server was expected to return a response for an execute change execution and it is missing.", "FNRCT0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_EXPECTED_CLASS_DESCRIPTION = new ExceptionCode("TRANSPORT_EXPECTED_CLASS_DESCRIPTION", "The server was expected to return a class description set result for a metadata search request; there is no response.", "FNRCT0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_EXPECTED_ENGINEOBJECTCOLLECTION_RESPONSE = new ExceptionCode("TRANSPORT_EXPECTED_ENGINEOBJECTCOLLECTION_RESPONSE", "The server was expected to return an engine object collection and it did not.", "FNRCT0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_EXPECTED_ENGINEOBJECT_RESPONSE = new ExceptionCode("TRANSPORT_EXPECTED_ENGINEOBJECT_RESPONSE", "The server was expected to return an engine object.", "FNRCT0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_EXPECTED_PROPERTY_RESPONSE = new ExceptionCode("TRANSPORT_EXPECTED_PROPERTY_RESPONSE", "The server was expected to return the value of the specified property {0}.", "FNRCT0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_EXPECTED_REPOSITORYROWCOLLECTION_RESPONSE = new ExceptionCode("TRANSPORT_EXPECTED_REPOSITORYROWCOLLECTION_RESPONSE", "The server was expected to return a repository row collection and it did not.", "FNRCT0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_FAILED_SERVER_CALL_CONTEXT_CREATE = new ExceptionCode("TRANSPORT_FAILED_SERVER_CALL_CONTEXT_CREATE", "Failed to create the server call context.", "FNRCT0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_INVALID_CORRELATION_ID = new ExceptionCode("TRANSPORT_INVALID_CORRELATION_ID", "The server returned a correlation id of {0} and there is no corresponding request.", "FNRCT0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_INVALID_SEARCH_REQUEST = new ExceptionCode("TRANSPORT_INVALID_SEARCH_REQUEST", "Invalid search request {0}.", "FNRCT0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_MISSING_SERVER_RESPONSE = new ExceptionCode("TRANSPORT_MISSING_SERVER_RESPONSE", "The server failed to return a response for each request.", "FNRCT0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_MUST_BE_SUBCLASS = new ExceptionCode("TRANSPORT_MUST_BE_SUBCLASS", "The class {0} must be a subclass of {1}.", "FNRCT0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_NO_INITIAL_CONTEXT = new ExceptionCode("TRANSPORT_NO_INITIAL_CONTEXT", "Unable to create a J2EE JNDI initial context.", "FNRCT0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_SCC_CANNOT_GET_USER_TRANSACTION = new ExceptionCode("TRANSPORT_SCC_CANNOT_GET_USER_TRANSACTION", "This exception code is not used as of CE 4.5.1", "FNRCT0016");
    public static final ExceptionCode TRANSPORT_SCC_DISALLOWED_MULTIPLE_TX_SUSPENSION = new ExceptionCode("TRANSPORT_SCC_DISALLOWED_MULTIPLE_TX_SUSPENSION", "Disallowed multiple transaction suspension.", "FNRCT0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_SCC_FAILED_REGISTER_SYNC = new ExceptionCode("TRANSPORT_SCC_FAILED_REGISTER_SYNC", "Failed registering the synchronization listener.", "FNRCT0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_SCC_NO_TRANSACTION = new ExceptionCode("TRANSPORT_SCC_NO_TRANSACTION", "No transaction exists in the current context.", "FNRCT0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_UNABLE_TO_LOCATE_EJB = new ExceptionCode("TRANSPORT_UNABLE_TO_LOCATE_EJB", "Unable to locate the servers EJB interface given the end point {0}.", "FNRCT0020", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_UNABLE_TO_LOCATE_EJB_SESSION = new ExceptionCode("TRANSPORT_UNABLE_TO_LOCATE_EJB_SESSION", "This exception code is not used as of CE 4.5.1", "FNRCT0021");
    public static final ExceptionCode TRANSPORT_WAITING_QUEUE_FULL = new ExceptionCode("TRANSPORT_WAITING_QUEUE_FULL", "Waiting queue exceeds upper limit {0}.", "FNRCT0022", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_COLLECTION_RESPONSE_EXPECTED = new ExceptionCode("TRANSPORT_WSI_COLLECTION_RESPONSE_EXPECTED", "This exception code is not used as of CE 4.5.1", "FNRCT0023");
    public static final ExceptionCode TRANSPORT_WSI_CONTENT_EXPECTED = new ExceptionCode("TRANSPORT_WSI_CONTENT_EXPECTED", "This exception code is not used as of CE 4.5.1", "FNRCT0024");
    public static final ExceptionCode TRANSPORT_WSI_CONTENT_GET_FAILED = new ExceptionCode("TRANSPORT_WSI_CONTENT_GET_FAILED", "An error occurred while retreiving content data for property {0}.", "FNRCT0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_CONTENT_RETRIEVAL_FAILED = new ExceptionCode("TRANSPORT_WSI_CONTENT_RETRIEVAL_FAILED", "This exception code is not used as of CE 4.5.1", "FNRCT0026");
    public static final ExceptionCode TRANSPORT_WSI_CONTENT_SEND_FAILED = new ExceptionCode("TRANSPORT_WSI_CONTENT_SEND_FAILED", "This exception code is not used as of CE 4.5.1", "FNRCT0027");
    public static final ExceptionCode TRANSPORT_WSI_CREATE_ACTION_TYPE_FAILURE = new ExceptionCode("TRANSPORT_WSI_CREATE_ACTION_TYPE_FAILURE", "An error occurred creating action type {0}.", "FNRCT0028", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_DESERIALIZATION_ERROR = new ExceptionCode("TRANSPORT_WSI_DESERIALIZATION_ERROR", "A web services instance of {0} could not be deserialized. The error is located at: {1}", "FNRCT0029", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_END_TOKEN_EXPECTED = new ExceptionCode("TRANSPORT_WSI_END_TOKEN_EXPECTED", "A Java object from a Content Engine Web Services XML element could not be deserialized.", "FNRCT0030", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_HEADER_REGISTRATION_FAILURE = new ExceptionCode("TRANSPORT_WSI_HEADER_REGISTRATION_FAILURE", "This exception code is not used as of CE 4.5.1", "FNRCT0031");
    public static final ExceptionCode TRANSPORT_WSI_INVALID_DEPENDENT_OBJ_ACTION = new ExceptionCode("TRANSPORT_WSI_INVALID_DEPENDENT_OBJ_ACTION", "An invalid dependent object action type {0} was detected.", "FNRCT0032", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_INVALID_HEADER_VALUE = new ExceptionCode("TRANSPORT_WSI_INVALID_HEADER_VALUE", "The SOAP header or XML element {0} must have a value.", "FNRCT0033", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_INVALID_INDEPENDENT = new ExceptionCode("TRANSPORT_WSI_INVALID_INDEPENDENT", "This exception code is not used as of CE 4.5.1", "FNRCT0034");
    public static final ExceptionCode TRANSPORT_WSI_INVALID_LIST_UPDATE_MODS = new ExceptionCode("TRANSPORT_WSI_INVALID_LIST_UPDATE_MODS", "A list of dependent objects was not properly sent as ListUpdate modifications.", "FNRCT0035", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_INVALID_MESSAGE_CONTEXT = new ExceptionCode("TRANSPORT_WSI_INVALID_MESSAGE_CONTEXT", "This exception code is not used as of CE 4.5.1", "FNRCT0036");
    public static final ExceptionCode TRANSPORT_WSI_INVALID_OBJECT_VALUE_TYPE = new ExceptionCode("TRANSPORT_WSI_INVALID_OBJECT_VALUE_TYPE", "An invalid object value of type {0} was received from the server for property {1}.", "FNRCT0037", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_INVALID_RESPONSE_NO_EO = new ExceptionCode("TRANSPORT_WSI_INVALID_RESPONSE_NO_EO", "Invalid server response; expected engine object.", "FNRCT0038", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_INVALID_SEARCH_REQUEST_TYPE = new ExceptionCode("TRANSPORT_WSI_INVALID_SEARCH_REQUEST_TYPE", "An ExecuteSearchRequest has an unrecognized search type: {0}.", "FNRCT0039", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_LOOKUP_FAILURE = new ExceptionCode("TRANSPORT_WSI_LOOKUP_FAILURE", "This exception code is not used as of CE 4.5.1", "FNRCT0040");
    public static final ExceptionCode TRANSPORT_WSI_MISSING_ACTION_TYPE = new ExceptionCode("TRANSPORT_WSI_MISSING_ACTION_TYPE", "The PendingAction {0} does not have a corresponding ActionType", "FNRCT0041", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_NETWORK_ERROR = new ExceptionCode("TRANSPORT_WSI_NETWORK_ERROR", "A network error occurred when processing a Web service request or response. See the nested exception for specific details.", "FNRCT0042", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_SERIALIZATION_ERROR = new ExceptionCode("TRANSPORT_WSI_SERIALIZATION_ERROR", "Error serializing a web services instance of {0}.", "FNRCT0043", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_SERIALIZATION_HANDLER_NOT_FOUND = new ExceptionCode("TRANSPORT_WSI_SERIALIZATION_HANDLER_NOT_FOUND", "The web services serialization handler for the XML element {0} was not found.", "FNRCT0044", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_SERIALIZATION_REGISTRY_NOT_FOUND = new ExceptionCode("TRANSPORT_WSI_SERIALIZATION_REGISTRY_NOT_FOUND", "The Content Engine Web Services WSDL URI {0} is not registered for Java-to-XML serialization.", "FNRCT0045", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_START_TOKEN_EXPECTED = new ExceptionCode("TRANSPORT_WSI_START_TOKEN_EXPECTED", "The web services opening element was expected, but it was not found.", "FNRCT0046", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_UNEXPECTED_RESPONSE = new ExceptionCode("TRANSPORT_WSI_UNEXPECTED_RESPONSE", "An unexpected CEWS response of object type {0} was received from the server.", "FNRCT0047", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_UNKNOWN_LIFECYCLE_CHANGE_TYPE = new ExceptionCode("TRANSPORT_WSI_UNKNOWN_LIFECYCLE_CHANGE_TYPE", "Unknown life cycle action type {0}.", "FNRCT0048", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_UNKNOWN_RESERVATION_TYPE = new ExceptionCode("TRANSPORT_WSI_UNKNOWN_RESERVATION_TYPE", "Unknown reservation type {0}.", "FNRCT0049", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_UNSUPPORTED_PROPERTY_TYPE = new ExceptionCode("TRANSPORT_WSI_UNSUPPORTED_PROPERTY_TYPE", "Unsupported property type {0}.", "FNRCT0050", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_VALUE_EXPECTED = new ExceptionCode("TRANSPORT_WSI_VALUE_EXPECTED", "A required value for an XML element or attribute was missing: {0}", "FNRCT0051", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_WSDL_FILE_NOT_FOUND = new ExceptionCode("TRANSPORT_WSI_WSDL_FILE_NOT_FOUND", "This exception code is not used as of CE 4.5.1", "FNRCT0052");
    public static final ExceptionCode TRANSPORT_WSI_INVALID_ENUM_VALUE = new ExceptionCode("TRANSPORT_WSI_INVALID_ENUM_VALUE", "The value {0} specified for the web services XML attribute {1} is not one of the permitted values in the WSDL", "FNRCT0053", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_INVALID_CONTENT_TYPE = new ExceptionCode("TRANSPORT_WSI_INVALID_CONTENT_TYPE", "The content attachment type {0} is not recognized.", "FNRCT0054", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_INVALID_CONTENT_RESPONSE_TYPE = new ExceptionCode("TRANSPORT_WSI_INVALID_CONTENT_RESPONSE_TYPE", "The ContentResponse type {0} is not recognized.", "FNRCT0055", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_CLASS_MISSING = new ExceptionCode("TRANSPORT_WSI_CLASS_MISSING", "This exception code is not used as of CE 5.0", "FNRCT0056");
    public static final ExceptionCode TRANSPORT_WSI_MULTIPART_PROBLEM = new ExceptionCode("TRANSPORT_WSI_MULTIPART_PROBLEM", "A multipart SOAP request or response could not be deserialized.", "FNRCT0057", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_UNEXPECTED_REQUEST = new ExceptionCode("TRANSPORT_WSI_UNEXPECTED_REQUEST", "An unexpected CEWS request of object type {0} was received from a client.", "FNRCT0058", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_SOAP_HEADER_NOT_UNDERSTOOD = new ExceptionCode("TRANSPORT_WSI_SOAP_HEADER_NOT_UNDERSTOOD", "A SOAP request included a header {0} with the mustUnderstand attribute, but that SOAP header is not understood by Content Engine Web Services (CEWS).", "FNRCT0059", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_HTTPS_REQUIRED = new ExceptionCode("TRANSPORT_WSI_HTTPS_REQUIRED", "A connection cannot be made to the server using the specified URI ''{0}''. HTTPS is required.", "FNRCT0060", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_NO_RUNTIME = new ExceptionCode("TRANSPORT_WSI_NO_RUNTIME", "The operation cannot be completed because a supported web service runtime is not present. Either Microsoft Web Services Extensions (WSE) 3.0 or the Windows Communication Foundation (WCF) is required.", "FNRCT0061", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_MALFORMED_VALUE = new ExceptionCode("TRANSPORT_WSI_MALFORMED_VALUE", "The deserialization parsing of data type {0} failed for the value {1}.", "FNRCT0062", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_DIME_UNSUPPORTED = new ExceptionCode("TRANSPORT_WSI_DIME_UNSUPPORTED", "The DIME protocol is not supported for CEWS. Change the Content Engine connection URI to FNCEWS40MTOM.", "FNRCT0063", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_EJB_UNABLE_TO_CREATE_CONTENT_UPLOAD_EJB = new ExceptionCode("TRANSPORT_EJB_UNABLE_TO_CREATE_CONTENT_UPLOAD_EJB", "Enterprise Java Bean (EJB) cannot be created to upload content. Server affinity is {0}.  EJB Home type is {1}.  EJB Home value is {2}.", "FNRCT0064", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_EJB_UNABLE_TO_CREATE_CONTENT_DOWNLOAD_EJB = new ExceptionCode("TRANSPORT_EJB_UNABLE_TO_CREATE_CONTENT_DOWNLOAD_EJB", "Enterprise Java Bean (EJB) cannot be created to retrieve content. Server affinity is {0}.  EJB Home type is {1}.  EJB Home value is {2}.", "FNRCT0065", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_EJB_UNABLE_TO_CONNECT = new ExceptionCode("TRANSPORT_EJB_UNABLE_TO_CONNECT", "Unable to connect to Content Engine.", "FNRCT0066", false, ErrorLoggingLevel.Required);
    private static final long serialVersionUID = -4846791583317622768L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    private ExceptionCode(String key, String englishString, String eid) {
        this.mKey = key;
        this.mEnglishString = englishString;
        this.id = eid;
        mapNameToExceptionCodeInstance.put(key, this);
    }

    private ExceptionCode(String key, String englishString, String eid, boolean isFatal, ErrorLoggingLevel errLogLevel) {
        this(key, englishString, eid);
        this.isFatal = isFatal;
        this.mErrorLoggingLevel = errLogLevel;
    }

    public boolean isFatal() {
        return this.isFatal;
    }

    public ErrorLoggingLevel getErrorLoggingLevel() {
        return this.mErrorLoggingLevel;
    }

    public String getKey() {
        return this.mKey;
    }

    public int getId() {
        int idInt = 0;
        try {
            String idTemp = this.id;
            idTemp = idTemp.replaceAll("[a-zA-Z]", "");
            idTemp = idTemp.trim();
            idInt = Integer.parseInt(idTemp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return idInt;
    }

    public String getErrorId() {
        return this.id;
    }

    public String getDefaultEnglishString() {
        return this.mEnglishString;
    }

    public String toString(Object[] args) {
        return this.toStringHelper(RES_BASE_NAME, stDefaultLocale, args);
    }

    public String toString(Locale le, Object[] args) {
        return this.toStringHelper(RES_BASE_NAME, le, args);
    }

    public static ExceptionCode getExceptionCode(String key) {
        return (ExceptionCode)mapNameToExceptionCodeInstance.get(key);
    }

    private synchronized String toStringHelper(String BaseName, Locale le, Object[] args) {
        String formattedString;
        String patternString;
        try {
            if (BaseName == null || le == null || this.mKey == null) {
                patternString = this.mEnglishString;
            } else {
                ResourceBundle bundle = ResourceBundle.getBundle(BaseName, le);
                patternString = bundle.getString(this.mKey);
            }
        }
        catch (MissingResourceException ex) {
            patternString = this.mEnglishString;
            le = Locale.US;
        }
        try {
            MessageFormat form = new MessageFormat(patternString, le);
            formattedString = form.format(args);
        }
        catch (Exception ex) {
            formattedString = this.mEnglishString;
            try {
                stLogger.error("Failed formating resource string: " + patternString, ex);
            }
            catch (Exception exx) {
                // empty catch block
            }
        }
        return formattedString;
    }

    private Object readResolve() throws ObjectStreamException {
        return ExceptionCode.getExceptionCode(this.mKey);
    }
}

