/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.exception;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ErrorRecord;
import com.filenet.api.exception.ExceptionCode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ErrorStack
implements Serializable {
    private ExceptionCode exceptionCode;
    private List errors = new ArrayList();
    private static final long serialVersionUID = -6092572408784667752L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public ErrorStack(EngineRuntimeException ere) {
        this.exceptionCode = ere.getExceptionCode();
        EngineRuntimeException parent = null;
        for (Throwable exception = ere; exception != null; exception = exception.getCause()) {
            ErrorStack stack;
            this.errors.add(new ErrorRecord(parent, exception));
            if (exception instanceof EngineRuntimeException && (stack = exception.getErrorStack()) != null) {
                this.errors.addAll(stack.errors);
                break;
            }
            parent = exception;
        }
    }

    public ErrorStack(String errorName, ErrorRecord[] recs) {
        this.exceptionCode = ExceptionCode.getExceptionCode(errorName);
        if (this.exceptionCode == null) {
            this.exceptionCode = ExceptionCode.E_SERVER_ERROR;
        }
        this.errors.addAll(Arrays.asList(recs));
    }

    public ErrorRecord[] getErrorRecords() {
        return this.errors.toArray(new ErrorRecord[this.errors.size()]);
    }

    public ExceptionCode getExceptionCode() {
        return this.exceptionCode;
    }

    public String getMessage() {
        if (this.errors.size() > 0) {
            return ((ErrorRecord)this.errors.get(0)).getDescription();
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(ErrorStack.bufferSize(this));
        this.toString(buffer);
        return buffer.toString();
    }

    void toString(StringBuffer buffer) {
        int start = buffer.length();
        int size = this.errors.size();
        for (int i = 0; i < size; ++i) {
            ErrorRecord record = (ErrorRecord)this.errors.get(i);
            if (record == null) {
                buffer.append('\n');
                continue;
            }
            if (buffer.length() > start) {
                buffer.append("Caused by: ");
            }
            record.toString(buffer);
        }
        if (buffer.length() == start) {
            buffer.append('\n');
        }
    }

    static int bufferSize(ErrorStack stack) {
        int count = stack == null ? 0 : stack.errors.size();
        return (count + 1) * 8192;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.exceptionCode);
        int size = this.errors.size();
        s.writeInt(size);
        for (int lp = 0; lp < size; ++lp) {
            s.writeObject(this.errors.get(lp));
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.errors = new ArrayList();
        this.exceptionCode = (ExceptionCode)s.readObject();
        int size = s.readInt();
        for (int lp = 0; lp < size; ++lp) {
            this.errors.add(s.readObject());
        }
    }
}

