/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.exception;

import com.filenet.api.exception.ErrorRecord;
import com.filenet.api.exception.ErrorStack;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.exception.Exceptions;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.SubSystem;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamField;
import java.util.Locale;

public class EngineRuntimeException
extends RuntimeException
implements Externalizable {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(EngineRuntimeException.class, SubSystem.Error);
    private ExceptionCode exceptionCode;
    private Object[] codeArgs;
    private ExceptionContext context;
    private Object[] ctxArgs;
    private ErrorStack errorStack;
    private Locale localeWhenThrown = null;
    private static ThreadLocal inGetAsErrorStack = new ThreadLocal();
    private static final long serialVersionUID = -6559592357494191011L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public EngineRuntimeException() {
        this.commonInit();
    }

    public EngineRuntimeException(ErrorStack errStack) {
        this.errorStack = errStack;
        this.commonInit();
    }

    public EngineRuntimeException(ExceptionCode code, Object[] codeArgs) {
        this.exceptionCode = code;
        this.codeArgs = codeArgs == null ? new Object[]{} : codeArgs;
        this.commonInit();
    }

    public EngineRuntimeException(ExceptionCode code) {
        this.exceptionCode = code;
        this.codeArgs = new Object[0];
        this.commonInit();
    }

    public EngineRuntimeException(ExceptionCode code, Object codeArg0) {
        Object[] objectArray;
        this.exceptionCode = code;
        if (codeArg0 == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = "(null)";
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = codeArg0;
        }
        this.codeArgs = objectArray;
        this.commonInit();
    }

    public EngineRuntimeException(Throwable cause, ExceptionCode code, Object[] codeArgs) {
        super(cause);
        this.exceptionCode = code;
        this.codeArgs = codeArgs == null ? new Object[]{} : codeArgs;
        this.commonInit();
    }

    public EngineRuntimeException(ExceptionCode code, Object[] codeArgs, ExceptionContext ctx, Object[] ctxArgs) {
        this.exceptionCode = code;
        this.codeArgs = codeArgs == null ? new Object[]{} : codeArgs;
        this.context = ctx;
        this.ctxArgs = ctxArgs == null ? new Object[]{} : ctxArgs;
        this.commonInit();
    }

    public EngineRuntimeException(Throwable cause, ExceptionCode code, Object[] codeArgs, ExceptionContext ctx, Object[] ctxArgs) {
        super(cause);
        this.exceptionCode = code;
        this.codeArgs = codeArgs == null ? new Object[]{} : codeArgs;
        this.context = ctx;
        this.ctxArgs = ctxArgs == null ? new Object[]{} : ctxArgs;
        this.commonInit();
    }

    public EngineRuntimeException(EngineRuntimeException cause, ExceptionContext ctx, Object[] ctxArgs) {
        super(cause);
        this.exceptionCode = cause.getExceptionCode();
        this.codeArgs = cause.getCodeArguments();
        this.context = ctx;
        this.ctxArgs = ctxArgs == null ? new Object[]{} : ctxArgs;
        this.commonInit();
    }

    private void commonInit() {
        if (logger.isSummaryTraceEnabled()) {
            logger.traceSummary(Exceptions.printStackTrace(this, null, true));
        }
        this.localeWhenThrown = UserContext.get().getLocale();
        if (ConnectionImpl.isSaveLastERE()) {
            ConnectionImpl.setLastERE(this);
        }
    }

    public ExceptionCode getExceptionCode() {
        return this.errorStack == null ? this.exceptionCode : this.errorStack.getExceptionCode();
    }

    public String getMessage() {
        return this.getMessageHelper(UserContext.get().getLocale());
    }

    public String getLocalizedMessage() {
        return this.getMessageHelper(UserContext.get().getLocale());
    }

    public ErrorStack getAsErrorStack() {
        return this.getAsErrorStack(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ErrorStack getAsErrorStack(Locale locale) {
        if (this.errorStack != null) {
            return this.errorStack;
        }
        inGetAsErrorStack.set(this);
        UserContext origUC = UserContext.get();
        UserContext tempUC = new UserContext();
        try {
            if (locale != null) {
                tempUC.setLocale(locale);
                UserContext.set(tempUC);
            }
            ErrorStack errorStack = this.errorStack = new ErrorStack(this);
            return errorStack;
        }
        finally {
            UserContext.set(origUC);
            inGetAsErrorStack.set(null);
        }
    }

    ErrorStack getErrorStack() {
        return this.errorStack;
    }

    private Object[] getCodeArguments() {
        return this.codeArgs;
    }

    private String getMessageHelper(Locale le) {
        StringBuffer buf = new StringBuffer();
        if (this.errorStack == null) {
            if (this.exceptionCode != null) {
                buf.append(this.exceptionCode.toString(le, this.codeArgs));
            }
            if ((inGetAsErrorStack.get() == null || this.exceptionCode != ExceptionCode.E_ACCESS_DENIED) && this.context != null) {
                if (this.exceptionCode != null) {
                    buf.append(" ");
                }
                buf.append(this.context.toString(le, this.ctxArgs));
            }
        } else {
            return this.errorStack.getMessage();
        }
        return buf.toString();
    }

    public String toString() {
        StringBuffer buffer;
        if (this.errorStack == null) {
            buffer = new StringBuffer(256);
            String source = this.getClass().getName();
            ExceptionCode exCode = this.getExceptionCode();
            String code = exCode == null ? null : exCode.getKey();
            String ibmCode = exCode == null ? null : exCode.getErrorId();
            String description = this.getLocalizedMessage();
            ErrorRecord.toString(buffer, source, ibmCode, code, description);
        } else {
            buffer = new StringBuffer(ErrorStack.bufferSize(this.errorStack));
            this.errorStack.toString(buffer);
            int index = buffer.indexOf("\n");
            if (index == 0) {
                buffer.insert(0, "errorStack={").append('}');
            } else if (index > 0) {
                buffer.insert(index, " errorStack={").append('}');
            }
        }
        return buffer.toString();
    }

    public void writeExternal(ObjectOutput s) throws IOException {
        s.writeShort(5);
        s.writeObject(this.getAsErrorStack(this.localeWhenThrown));
    }

    public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
        s.readShort();
        this.errorStack = (ErrorStack)s.readObject();
    }

    public static Throwable mergeStackTraces(Throwable current, Throwable backGround) {
        Throwable t = backGround;
        try {
            if (backGround instanceof EngineRuntimeException) {
                EngineRuntimeException ert = (EngineRuntimeException)backGround;
                t = new EngineRuntimeException(ert.getExceptionCode(), ert.getCodeArguments());
            } else {
                t = (Throwable)backGround.getClass().newInstance();
            }
            if (t == null) {
                return t;
            }
            StackTraceElement[] currentThreadStack = current.getStackTrace();
            StackTraceElement[] backGroundThreadStack = backGround.getStackTrace();
            StackTraceElement[] newStack = new StackTraceElement[currentThreadStack.length + backGroundThreadStack.length];
            System.arraycopy(backGroundThreadStack, 0, newStack, 0, backGroundThreadStack.length);
            System.arraycopy(currentThreadStack, 0, newStack, backGroundThreadStack.length, currentThreadStack.length);
            t.setStackTrace(newStack);
            t.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return t;
    }
}

