/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.engine;

import com.filenet.api.engine.PrincipalInfo;
import java.util.List;

public class UserInfo
implements PrincipalInfo {
    private byte[] mId;
    private String mName;
    private String mDisplayName;
    private String mShortName;
    private String mDistinguishedName;
    private String mEmailAddress;
    private String[] mMemberOfGroups;
    private List mMemberOfGroupList;
    private List mGroupList;
    private List mUserList;
    private boolean mListForMembers = false;

    public byte[] getId() {
        return this.mId;
    }

    public void setId(byte[] id) {
        this.mId = id;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public void setDisplayName(String displayName) {
        this.mDisplayName = displayName;
    }

    public String getShortName() {
        return this.mShortName;
    }

    public void setShortName(String shortName) {
        this.mShortName = shortName;
    }

    public String getDistinguishedName() {
        return this.mDistinguishedName;
    }

    public void setDistinguishedName(String distinguishedName) {
        this.mDistinguishedName = distinguishedName;
    }

    public String getEmailAddress() {
        return this.mEmailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.mEmailAddress = emailAddress;
    }

    public String[] getMemberOfGroups() {
        return this.mMemberOfGroups;
    }

    public void setMemberOfGroups(String[] memberOfGroups) {
        this.mMemberOfGroups = memberOfGroups;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append("\n\t ShortName=").append(this.mShortName);
        buf.append("\n\t DisplayName=").append(this.mDisplayName);
        buf.append("\n\t DistinguishedName=").append(this.mDistinguishedName);
        buf.append("\n\t Name=").append(this.mName);
        buf.append("\n\t EmailAddress=").append(this.mEmailAddress);
        buf.append("\n\t Id=").append(UserInfo.convertSidToSearchableSid(this.mId));
        if (this.mMemberOfGroups != null) {
            buf.append("\n\t MemberOfGroups=");
            for (int i = 0; i < this.mMemberOfGroups.length; ++i) {
                buf.append("\n\t\t ").append(this.mMemberOfGroups[i]);
            }
        }
        return buf.toString();
    }

    protected static String convertSidToSearchableSid(byte[] sid) {
        StringBuffer sb = new StringBuffer(sid.length * 2);
        for (int idx = 0; idx < sid.length; ++idx) {
            sb.append("\\");
            sb.append(Integer.toHexString((sid[idx] & 0xF0) >> 4).toUpperCase());
            sb.append(Integer.toHexString(sid[idx] & 0xF).toUpperCase());
        }
        return sb.toString();
    }

    public List getMemberOfGroupList() {
        return this.mMemberOfGroupList;
    }

    public void setMemberOfGroupList(List memberOfGroupList) {
        this.mMemberOfGroupList = memberOfGroupList;
        this.mListForMembers = true;
    }

    public List getGroupList() {
        return this.mGroupList;
    }

    public void setGroupList(List groupList) {
        this.mGroupList = groupList;
        this.mListForMembers = true;
    }

    public List getUserList() {
        return this.mUserList;
    }

    public void setUserList(List userList) {
        this.mUserList = userList;
        this.mListForMembers = true;
    }

    public boolean isList() {
        return this.mListForMembers;
    }
}

