/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.engine;

import com.filenet.api.engine.PrincipalInfo;
import java.util.List;

public class GroupInfo
implements PrincipalInfo {
    private byte[] mId;
    private String mName;
    private String mDisplayName;
    private String mShortName;
    private String mDistinguishedName;
    private String[] mMemberOfGroups;
    private String[] mGroups;
    private String[] mUsers;
    private List mMemberOfGroupList;
    private List mGroupList;
    private List mUserList;
    private List mMemberList;
    private boolean mListForMembers = false;

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public void setDisplayName(String displayName) {
        this.mDisplayName = displayName;
    }

    public String getDistinguishedName() {
        return this.mDistinguishedName;
    }

    public void setDistinguishedName(String distinguishedName) {
        this.mDistinguishedName = distinguishedName;
    }

    public String[] getGroups() {
        return this.mGroups;
    }

    public void setGroups(String[] groups) {
        this.mGroups = groups;
    }

    public byte[] getId() {
        return this.mId;
    }

    public void setId(byte[] id) {
        this.mId = id;
    }

    public String[] getMemberOfGroups() {
        return this.mMemberOfGroups;
    }

    public void setMemberOfGroups(String[] memberOfGroups) {
        this.mMemberOfGroups = memberOfGroups;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getShortName() {
        return this.mShortName;
    }

    public void setShortName(String shortName) {
        this.mShortName = shortName;
    }

    public String[] getUsers() {
        return this.mUsers;
    }

    public void setUsers(String[] users) {
        this.mUsers = users;
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer(128);
        buf.append("\n\t ShortName=").append(this.mShortName);
        buf.append("\n\t DisplayName=").append(this.mDisplayName);
        buf.append("\n\t DistinguishedName=").append(this.mDistinguishedName);
        buf.append("\n\t Name=").append(this.mName);
        buf.append("\n\t Id=").append(GroupInfo.convertSidToSearchableSid(this.mId));
        if (this.mMemberOfGroups != null) {
            buf.append("\n\t MemberOfGroups=");
            for (i = 0; i < this.mMemberOfGroups.length; ++i) {
                buf.append("\n\t\t ").append(this.mMemberOfGroups[i]);
            }
        }
        if (this.mGroups != null) {
            buf.append("\n\t Groups=");
            for (i = 0; i < this.mGroups.length; ++i) {
                buf.append("\n\t\t ").append(this.mGroups[i]);
            }
        }
        if (this.mUsers != null) {
            buf.append("\n\t Users=");
            for (i = 0; i < this.mUsers.length; ++i) {
                buf.append("\n\t\t ").append(this.mUsers[i]);
            }
        }
        return buf.toString();
    }

    protected static String convertSidToSearchableSid(byte[] sid) {
        StringBuffer sb = new StringBuffer(sid.length * 2);
        for (int idx = 0; idx < sid.length; ++idx) {
            sb.append("\\");
            sb.append(Integer.toHexString((sid[idx] & 0xF0) >> 4).toUpperCase());
            sb.append(Integer.toHexString(sid[idx] & 0xF).toUpperCase());
        }
        return sb.toString();
    }

    public List getMemberOfGroupList() {
        return this.mMemberOfGroupList;
    }

    public void setMemberOfGroupList(List memberOfGroupList) {
        this.mMemberOfGroupList = memberOfGroupList;
        this.mListForMembers = true;
    }

    private List getGroupList() {
        return this.mGroupList;
    }

    private void setGroupList(List groupList) {
        this.mGroupList = groupList;
        this.mListForMembers = true;
    }

    private List getUserList() {
        return this.mUserList;
    }

    private void setUserList(List userList) {
        this.mUserList = userList;
    }

    public boolean isList() {
        return this.mListForMembers;
    }

    public void setIsList(boolean isList) {
        this.mListForMembers = isList;
    }

    public List getMemberList() {
        return this.mMemberList;
    }

    public void setMemberList(List memberList) {
        this.mMemberList = memberList;
    }
}

