/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.engine;

import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;

public class DirectoryContext {
    private InitialLdapContext mContext;
    private String mUrl;
    private String mHost;
    private String mPort;
    private String mPrincipal;
    private String mCredential;
    private boolean mIsSSLenabled;

    public DirectoryContext(Hashtable env, String host, String port, String principal, String credential, boolean isSSLenalbed) throws NamingException {
        this.mHost = host;
        this.mPort = port;
        this.mPrincipal = principal;
        this.mCredential = credential;
        this.mIsSSLenabled = isSSLenalbed;
        this.mContext = new InitialLdapContext(env, null);
    }

    public InitialLdapContext getInitialLdapContext() {
        return this.mContext;
    }

    public void setInitialLdapContext(InitialLdapContext context) {
        this.mContext = context;
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.mContext.getEnvironment();
    }

    public String getUrl() {
        return this.mUrl;
    }

    public String getHost() {
        return this.mHost;
    }

    public String getPort() {
        return this.mPort;
    }

    public String getPrincipal() {
        return this.mPrincipal;
    }

    public String getCredential() {
        return this.mCredential;
    }

    public boolean isSSLenabled() {
        return this.mIsSSLenabled;
    }

    public void setRequestControls(Control[] requestCtrls) throws NamingException {
        this.mContext.setRequestControls(requestCtrls);
    }

    public NamingEnumeration search(String baseDN, String filter, SearchControls controls, boolean useCompositeName) throws NamingException {
        if (useCompositeName) {
            CompositeName name = new CompositeName();
            name.add(baseDN);
            return this.mContext.search((Name)name, filter, controls);
        }
        return this.mContext.search(baseDN, filter, controls);
    }

    public Attributes getAttributes(String principalDN, String[] searchAttributes, boolean useCompositeName) throws NamingException {
        if (useCompositeName) {
            CompositeName name = new CompositeName();
            name.add(principalDN);
            return this.mContext.getAttributes(name, searchAttributes);
        }
        return this.mContext.getAttributes(principalDN, searchAttributes);
    }

    public void close() throws NamingException {
        if (this.mContext != null) {
            this.mContext.close();
            this.mContext = null;
        }
    }
}

