/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.core;

import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Batch;
import com.filenet.api.core.BatchItemHandle;
import com.filenet.api.core.Domain;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyFilter;
import com.filenet.apiimpl.core.BatchItemHandleImpl;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.Session;
import com.filenet.apiimpl.exception.Exceptions;
import com.filenet.apiimpl.util.SessionLocator;
import java.util.Iterator;

public class UpdatingBatch
extends Batch {
    private RefreshMode refresh = null;

    private UpdatingBatch(Domain domain, RefreshMode refreshVal) {
        super(domain);
        this.refresh = refreshVal;
    }

    public static UpdatingBatch createUpdatingBatchInstance(Domain domain, RefreshMode refresh) {
        return new UpdatingBatch(domain, refresh);
    }

    public BatchItemHandle add(IndependentlyPersistableObject object, PropertyFilter filter) {
        BatchItemHandleImpl item = new BatchItemHandleImpl(object, filter);
        this.addHandle(item);
        return item;
    }

    public boolean hasPendingExecute() {
        boolean hasPending = false;
        Iterator iter = super.getBatchList().iterator();
        while (iter.hasNext()) {
            IndependentObject obj = ((BatchItemHandle)iter.next()).getObject();
            if (!(obj instanceof IndependentlyPersistableObject) || ((IndependentlyPersistableObject)obj).getPendingActions().length <= 0 && !((IndependentlyPersistableObject)obj).getProperties().isDirty()) continue;
            hasPending = true;
            break;
        }
        return hasPending;
    }

    public void updateBatch() {
        if (super.getBatchList().size() == 0) {
            throw new EngineRuntimeException(ExceptionCode.API_EMPTY_BATCH, null);
        }
        BatchItemHandleImpl[] batch = super.getBatchList().toArray(new BatchItemHandleImpl[0]);
        Session session = SessionLocator.getSession(super.getDomain().getConnection());
        try {
            session.executeChanges((ConnectionImpl)super.getDomain().getConnection(), this.refresh, batch);
        }
        catch (EngineRuntimeException ere) {
            int failedBatchItem = Exceptions.detectFailedBatchItem(ere);
            if (failedBatchItem >= 0 && failedBatchItem < batch.length) {
                BatchItemHandleImpl item = batch[failedBatchItem];
                item.setException(ere);
            }
            throw ere;
        }
    }
}

