/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.core;

import com.filenet.api.core.BatchItemHandle;
import com.filenet.api.core.Domain;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import java.util.ArrayList;
import java.util.List;

public abstract class Batch {
    private List batchList = null;
    private Domain domain = null;

    Batch(Domain domain) {
        if (domain == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "domain");
        }
        this.domain = domain;
        this.batchList = new ArrayList();
    }

    void addHandle(BatchItemHandle handle) {
        this.batchList.add(handle);
    }

    public List getBatchItemHandles(IndependentObject object) {
        ArrayList<BatchItemHandle> batchHandles = new ArrayList<BatchItemHandle>();
        if (object == null) {
            batchHandles.addAll(this.batchList);
        } else {
            for (BatchItemHandle item : this.batchList) {
                if (!object.equals(item.getObject())) continue;
                batchHandles.add(item);
            }
        }
        return batchHandles;
    }

    List getBatchList() {
        return this.batchList;
    }

    Domain getDomain() {
        return this.domain;
    }
}

