/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.authentication.jboss.login;

import com.filenet.apiimpl.authentication.util.AuthnUtil;
import com.filenet.apiimpl.authentication.util.J2EEAuthnUtilJB;
import com.filenet.apiimpl.exception.ExceptionAuthn;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class FnClientLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean isDebug;
    private boolean isTryFirstPass;
    private boolean isUseFirstPass;
    private Object principal;
    private Object credential;
    private Object token;
    private boolean loginOk;
    private boolean commitOk;
    private static final String FNAME = "[FnClientLoginModule] ";
    private static final String SHARED_PRINCIPAL = "javax.security.auth.login.name";
    private static final String SHARED_PASSWORD = "javax.security.auth.login.password";

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.isDebug = "true".equalsIgnoreCase((String)options.get("debug"));
        String opt = this.getStrOption("password-stacking");
        if (opt != null) {
            this.isUseFirstPass = true;
            this.isTryFirstPass = "tryFirstPass".equalsIgnoreCase(opt);
        } else {
            this.isUseFirstPass = false;
            this.isTryFirstPass = false;
        }
        if (this.isDebug) {
            System.out.println("[FnClientLoginModule] debug: " + this.isDebug + ", password-stacking: " + opt);
        }
        if (this.isDebug) {
            AuthnUtil.displayClassloaders(FNAME, this.getClass());
        }
    }

    public boolean login() throws LoginException {
        this.loginOk = false;
        if (this.isUseFirstPass) {
            this.principal = this.sharedState.get(SHARED_PRINCIPAL);
            if (this.principal != null) {
                if (this.principal instanceof String && ((String)this.principal).length() == 0) {
                    throw new LoginException(ExceptionAuthn.SECURITY_NAME_NULL_OR_EMPTY.toString());
                }
                this.credential = this.sharedState.get(SHARED_PASSWORD);
                this.loginOk = true;
                return true;
            }
            if (!this.isTryFirstPass) {
                throw new LoginException(ExceptionAuthn.SECURITY_NO_SHARED_FOR_USEFIRSTPASS.toString());
            }
        }
        if (this.callbackHandler == null) {
            throw new LoginException(ExceptionAuthn.SECURITY_CALLBACK_HANDLER_NULL.toString());
        }
        NameCallback nameCallback = new NameCallback("user name: ");
        PasswordCallback passwordCallback = new PasswordCallback("password: ", false);
        Callback[] cbs = new Callback[]{nameCallback, passwordCallback};
        try {
            this.callbackHandler.handle(cbs);
            this.principal = nameCallback.getName();
            this.credential = passwordCallback.getPassword();
        }
        catch (UnsupportedCallbackException uce) {
            if (this.isDebug) {
                System.out.println("[FnClientLoginModule] login UnsupportedCallbackException");
            }
            return false;
        }
        catch (Exception e) {
            String msg = ExceptionAuthn.SECURITY_CALLBACK_EXCEPTION.toString(new Object[]{e.getLocalizedMessage()});
            System.out.println(FNAME + msg);
            throw (LoginException)new LoginException(msg).initCause(e);
        }
        if (this.principal == null || this.principal instanceof String && ((String)this.principal).length() == 0) {
            throw new LoginException(ExceptionAuthn.SECURITY_NAME_NULL_OR_EMPTY.toString());
        }
        this.loginOk = true;
        return true;
    }

    private String getStrOption(String name) {
        String opt = (String)this.options.get(name);
        if (opt != null && opt.length() == 0) {
            opt = null;
        }
        return opt;
    }

    public boolean commit() {
        Set<Principal> s;
        if (!this.loginOk || this.commitOk) {
            return false;
        }
        if (!(this.principal instanceof Principal)) {
            this.principal = J2EEAuthnUtilJB.createPrincipal(this.principal.toString());
        }
        if (this.credential == null) {
            this.credential = new char[0];
        }
        if (this.isDebug) {
            System.out.println("[FnClientLoginModule] committing");
        }
        if (!(s = this.subject.getPrincipals()).contains(this.principal)) {
            s.add((Principal)this.principal);
        }
        this.token = J2EEAuthnUtilJB.cacheCred(this.credential);
        this.subject.getPrivateCredentials().add(this.token);
        if (this.isDebug) {
            AuthnUtil.displaySubject(FNAME, this.subject);
        }
        this.credential = null;
        this.commitOk = true;
        return true;
    }

    public boolean abort() {
        if (this.isDebug) {
            System.out.println("[FnClientLoginModule] aborting");
        }
        if (!this.loginOk) {
            return false;
        }
        this.doLogout();
        return true;
    }

    public boolean logout() {
        if (this.isDebug) {
            System.out.println("[FnClientLoginModule] logout called");
        }
        if (!this.commitOk) {
            return false;
        }
        this.doLogout();
        return true;
    }

    private void doLogout() {
        if (this.principal != null) {
            this.subject.getPrincipals().remove(this.principal);
        }
        if (this.token != null) {
            this.subject.getPrivateCredentials().remove(this.token);
            AuthnUtil.destroyCred(this.token);
            this.token = null;
        }
        this.credential = null;
        this.loginOk = false;
        this.commitOk = false;
    }
}

