/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util.encoding;

import com.ibm.xml.xlxp.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp.api.util.encoding.DataSourceFactory;
import com.ibm.xml.xlxp.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.scan.util.CharConversionError;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import java.io.IOException;
import java.io.InputStream;

public final class UCSEncodingSupport
implements EncodingSupport {
    public static final int UTF_16BE = 0;
    public static final int UTF_16LE = 1;
    public static final int UTF_32BE = 2;
    public static final int UTF_32LE = 3;
    public static final int UTF_16 = 4;
    public static final int ISO_10646_UCS_2 = 5;
    public static final int ISO_10646_UCS_4 = 6;
    private static UCSEncodingSupport[] fgSingletons = new UCSEncodingSupport[4];
    private final int fOriginalEncodingType;
    private int fEncodingType;
    private final boolean fPermitBOM;
    private final int fWidth;

    public static EncodingSupport getInstance(int n) {
        if (n <= 3) {
            if (fgSingletons[n] == null) {
                UCSEncodingSupport.fgSingletons[n] = new UCSEncodingSupport(n);
            }
            return fgSingletons[n];
        }
        return new UCSEncodingSupport(n);
    }

    public CharConversionError loadFromByteStream(ParsedEntity parsedEntity, InputStream inputStream, String string, boolean bl, boolean bl2, DataSourceFactory dataSourceFactory) {
        ByteStreamDataSource byteStreamDataSource = dataSourceFactory.allocateByteStreamDataSource();
        byteStreamDataSource.checkAvailable = bl2;
        byteStreamDataSource.setByteStream(inputStream, this, bl);
        return byteStreamDataSource.load(parsedEntity);
    }

    public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
        byte[] byArray = dataBuffer.bytes;
        int n = 0;
        try {
            if (byteStreamDataSource.checkForBOM) {
                CharConversionError charConversionError;
                if (this.fPermitBOM && (charConversionError = this.checkUCSBOM(byteStreamDataSource, this.fOriginalEncodingType)) != null) {
                    return charConversionError;
                }
                byteStreamDataSource.checkForBOM = false;
            }
            while (byteStreamDataSource.stream != null) {
                int n2 = 0;
                int n3 = byteStreamDataSource.bufferLength - byteStreamDataSource.byteOffset;
                if ((n3 &= ~(this.fWidth - 1)) > 0 && (n2 = byteStreamDataSource.stream.read(byteStreamDataSource.byteBuffer, byteStreamDataSource.byteOffset, n3)) == -1) {
                    byteStreamDataSource.stream.close();
                    byteStreamDataSource.stream = null;
                    if (byteStreamDataSource.byteOffset == 0) break;
                    n2 = 0;
                }
                n2 += byteStreamDataSource.byteOffset;
                switch (this.fEncodingType) {
                    case 0: {
                        n = this.convertFromUTF16BE(byteStreamDataSource, n2, byArray, n);
                        break;
                    }
                    case 1: {
                        n = this.convertFromUTF16LE(byteStreamDataSource, n2, byArray, n);
                        break;
                    }
                    case 2: {
                        n = this.convertFromUTF32BE(byteStreamDataSource, n2, byArray, n);
                        break;
                    }
                    case 3: {
                        n = this.convertFromUTF32LE(byteStreamDataSource, n2, byArray, n);
                        break;
                    }
                    default: {
                        dataBuffer.endOffset = n;
                        return CharConversionError.inconsistentEncoding();
                    }
                }
                if (n >= 0) {
                    if (byteStreamDataSource.byteOffset < n2) {
                        System.arraycopy(byteStreamDataSource.byteBuffer, byteStreamDataSource.byteOffset, byteStreamDataSource.byteBuffer, 0, n2 -= byteStreamDataSource.byteOffset);
                        byteStreamDataSource.byteOffset = n2;
                    } else {
                        byteStreamDataSource.byteOffset = 0;
                    }
                    if (n + 4 < byteStreamDataSource.bufferLength) continue;
                    break;
                }
                if (n == -1) {
                    return CharConversionError.invalidFirstHalfOfSurrogatePair();
                }
                return CharConversionError.invalidSecondHalfOfSurrogatePair();
            }
        }
        catch (IOException iOException) {
            return CharConversionError.runtimeIOError((IOException)iOException);
        }
        dataBuffer.endOffset = n;
        return null;
    }

    private UCSEncodingSupport(int n) {
        this.fOriginalEncodingType = n;
        this.fEncodingType = n;
        switch (n) {
            case 4: 
            case 5: {
                this.fEncodingType = 0;
                this.fPermitBOM = true;
                this.fWidth = 2;
                break;
            }
            case 0: 
            case 1: {
                this.fPermitBOM = false;
                this.fWidth = 2;
                break;
            }
            case 6: {
                this.fEncodingType = 2;
                this.fPermitBOM = true;
                this.fWidth = 4;
                break;
            }
            case 2: 
            case 3: {
                this.fPermitBOM = false;
                this.fWidth = 4;
                break;
            }
            default: {
                this.fPermitBOM = false;
                this.fWidth = 0;
            }
        }
    }

    private CharConversionError checkUCSBOM(ByteStreamDataSource byteStreamDataSource, int n) throws IOException {
        InputStream inputStream = byteStreamDataSource.stream;
        byte[] byArray = byteStreamDataSource.byteBuffer;
        byteStreamDataSource.byteOffset = 0;
        int n2 = inputStream.read();
        if (n2 == 254) {
            n2 = inputStream.read();
            if (n2 == 255) {
                this.fEncodingType = 0;
                return null;
            }
            if (n == 4) {
                return CharConversionError.byteOrderMarkRequired();
            }
            byArray[byteStreamDataSource.byteOffset++] = -2;
            if (n2 != -1) {
                byArray[byteStreamDataSource.byteOffset++] = (byte)n2;
                return null;
            }
        } else if (n2 == 255) {
            n2 = inputStream.read();
            if (n2 == 254) {
                if (this.fWidth == 2) {
                    this.fEncodingType = 1;
                    return null;
                }
                n2 = inputStream.read();
                if (n2 == 0) {
                    n2 = inputStream.read();
                    if (n2 == 0) {
                        this.fEncodingType = 3;
                        return null;
                    }
                    byArray[byteStreamDataSource.byteOffset++] = -1;
                    byArray[byteStreamDataSource.byteOffset++] = -2;
                    byArray[byteStreamDataSource.byteOffset++] = 0;
                    if (n2 != -1) {
                        byArray[byteStreamDataSource.byteOffset++] = (byte)n2;
                        return null;
                    }
                } else {
                    byArray[byteStreamDataSource.byteOffset++] = -1;
                    byArray[byteStreamDataSource.byteOffset++] = -2;
                    if (n2 != -1) {
                        byArray[byteStreamDataSource.byteOffset++] = (byte)n2;
                        return null;
                    }
                }
            } else {
                if (n == 4) {
                    return CharConversionError.byteOrderMarkRequired();
                }
                byArray[byteStreamDataSource.byteOffset++] = -2;
                if (n2 != -1) {
                    byArray[byteStreamDataSource.byteOffset++] = (byte)n2;
                    return null;
                }
            }
        } else {
            if (n == 4) {
                return CharConversionError.byteOrderMarkRequired();
            }
            if (n2 == 0 && this.fWidth == 4) {
                n2 = inputStream.read();
                if (n2 == 0) {
                    n2 = inputStream.read();
                    if (n2 == 254) {
                        n2 = inputStream.read();
                        if (n2 == 255) {
                            this.fEncodingType = 2;
                            return null;
                        }
                        byArray[byteStreamDataSource.byteOffset++] = 0;
                        byArray[byteStreamDataSource.byteOffset++] = 0;
                        byArray[byteStreamDataSource.byteOffset++] = -2;
                        if (n2 != -1) {
                            byArray[byteStreamDataSource.byteOffset++] = (byte)n2;
                            return null;
                        }
                    } else {
                        byArray[byteStreamDataSource.byteOffset++] = 0;
                        byArray[byteStreamDataSource.byteOffset++] = 0;
                        if (n2 != -1) {
                            byArray[byteStreamDataSource.byteOffset++] = (byte)n2;
                            return null;
                        }
                    }
                } else {
                    byArray[byteStreamDataSource.byteOffset++] = 0;
                    if (n2 != -1) {
                        byArray[byteStreamDataSource.byteOffset++] = (byte)n2;
                        return null;
                    }
                }
            } else if (n2 != -1) {
                byArray[byteStreamDataSource.byteOffset++] = (byte)n2;
                return null;
            }
        }
        byteStreamDataSource.stream = null;
        return null;
    }

    private int convertFromUTF16BE(ByteStreamDataSource byteStreamDataSource, int n, byte[] byArray, int n2) {
        int n3;
        block6: {
            block7: {
                block8: {
                    byte[] byArray2 = byteStreamDataSource.byteBuffer;
                    n3 = 0;
                    int n4 = 0;
                    int n5 = 0;
                    while (true) {
                        int n6;
                        int n7;
                        int n8;
                        int n9 = (n8 = n - n3) < (n7 = byteStreamDataSource.bufferLength - n2) << 1 ? n : n3 + (n7 << 1);
                        int n10 = 0;
                        while (n3 < n9) {
                            n4 = byArray2[n3++] & 0xFF;
                            n5 = byArray2[n3++] & 0xFF;
                            if (n4 == 0 && n5 < 128) {
                                byArray[n2++] = (byte)n5;
                                continue;
                            }
                            n10 = (n4 << 8) + n5;
                            break;
                        }
                        if (n10 == 0) break block6;
                        if (n2 + 4 > byteStreamDataSource.bufferLength) {
                            n3 -= 2;
                            break block6;
                        }
                        if (n10 < 2048) {
                            byArray[n2++] = (byte)(0xC0 | n10 >> 6);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n10);
                            continue;
                        }
                        if (n10 < 55296 || n10 >= 57344) {
                            byArray[n2++] = (byte)(0xE0 | n10 >> 12);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n10 >> 6);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n10);
                            continue;
                        }
                        if (n10 >= 56320) break block7;
                        if (n3 >= n) break block8;
                        if ((n6 = ((n4 = byArray2[n3++] & 0xFF) << 8) + (n5 = byArray2[n3++] & 0xFF)) < 56320 || n6 >= 57344) break;
                        n10 = 65536 + (n10 - 55296 << 10) + (n6 - 56320);
                        byArray[n2++] = (byte)(0xF0 | n10 >> 18);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n10 >> 12);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n10 >> 6);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n10);
                    }
                    return -2;
                }
                n3 -= 2;
                break block6;
            }
            return -1;
        }
        byteStreamDataSource.byteOffset = n3;
        return n2;
    }

    private int convertFromUTF16LE(ByteStreamDataSource byteStreamDataSource, int n, byte[] byArray, int n2) {
        int n3;
        block6: {
            block7: {
                block8: {
                    byte[] byArray2 = byteStreamDataSource.byteBuffer;
                    n3 = 0;
                    int n4 = 0;
                    int n5 = 0;
                    while (true) {
                        int n6;
                        int n7;
                        int n8;
                        int n9 = (n8 = n - n3) < (n7 = byteStreamDataSource.bufferLength - n2) << 1 ? n : n3 + (n7 << 1);
                        int n10 = 0;
                        while (n3 < n9) {
                            n4 = byArray2[n3++] & 0xFF;
                            if ((n5 = byArray2[n3++] & 0xFF) == 0 && n4 < 128) {
                                byArray[n2++] = (byte)n4;
                                continue;
                            }
                            n10 = (n5 << 8) + n4;
                            break;
                        }
                        if (n10 == 0) break block6;
                        if (n2 + 4 > byteStreamDataSource.bufferLength) {
                            n3 -= 2;
                            break block6;
                        }
                        if (n10 < 2048) {
                            byArray[n2++] = (byte)(0xC0 | n10 >> 6);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n10);
                            continue;
                        }
                        if (n10 < 55296 || n10 >= 57344) {
                            byArray[n2++] = (byte)(0xE0 | n10 >> 12);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n10 >> 6);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n10);
                            continue;
                        }
                        if (n10 >= 56320) break block7;
                        if (n3 >= n) break block8;
                        if ((n6 = ((n5 = byArray2[n3++] & 0xFF) << 8) + (n4 = byArray2[n3++] & 0xFF)) < 56320 || n6 >= 57344) break;
                        n10 = 65536 + (n10 - 55296 << 10) + (n6 - 56320);
                        byArray[n2++] = (byte)(0xF0 | n10 >> 18);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n10 >> 12);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n10 >> 6);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n10);
                    }
                    return -2;
                }
                n3 -= 2;
                break block6;
            }
            return -1;
        }
        byteStreamDataSource.byteOffset = n3;
        return n2;
    }

    private int convertFromUTF32BE(ByteStreamDataSource byteStreamDataSource, int n, byte[] byArray, int n2) {
        byte[] byArray2 = byteStreamDataSource.byteBuffer;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5 = byArray2[n3++] & 0xFF;
            int n6 = byArray2[n3++] & 0xFF;
            int n7 = byArray2[n3++] & 0xFF;
            int n8 = byArray2[n3++] & 0xFF;
            if (n5 == 0 && n6 == 0) {
                if (n7 == 0 && n8 < 128) {
                    byArray[n2++] = (byte)n8;
                    continue;
                }
                n4 = (n7 << 8) + n8;
                if (n4 < 2048) {
                    byArray[n2++] = (byte)(0xC0 | n4 >> 6);
                    byArray[n2++] = (byte)(0x80 | 0x3F & n4);
                    continue;
                }
                byArray[n2++] = (byte)(0xE0 | n4 >> 12);
                byArray[n2++] = (byte)(0x80 | 0x3F & n4 >> 6);
                byArray[n2++] = (byte)(0x80 | 0x3F & n4);
                continue;
            }
            n4 = (n5 << 24) + (n6 << 16) + (n7 << 8) + n8;
            byArray[n2++] = (byte)(0xF0 | n4 >> 18);
            byArray[n2++] = (byte)(0x80 | 0x3F & n4 >> 12);
            byArray[n2++] = (byte)(0x80 | 0x3F & n4 >> 6);
            byArray[n2++] = (byte)(0x80 | 0x3F & n4);
        }
        byteStreamDataSource.byteOffset = n3;
        return n2;
    }

    private int convertFromUTF32LE(ByteStreamDataSource byteStreamDataSource, int n, byte[] byArray, int n2) {
        byte[] byArray2 = byteStreamDataSource.byteBuffer;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5;
            int n6 = byArray2[n3++] & 0xFF;
            int n7 = byArray2[n3++] & 0xFF;
            int n8 = byArray2[n3++] & 0xFF;
            if ((n5 = byArray2[n3++] & 0xFF) == 0 && n8 == 0) {
                if (n7 == 0 && n6 < 128) {
                    byArray[n2++] = (byte)n6;
                    continue;
                }
                n4 = (n7 << 8) + n6;
                if (n4 < 2048) {
                    byArray[n2++] = (byte)(0xC0 | n4 >> 6);
                    byArray[n2++] = (byte)(0x80 | 0x3F & n4);
                    continue;
                }
                byArray[n2++] = (byte)(0xE0 | n4 >> 12);
                byArray[n2++] = (byte)(0x80 | 0x3F & n4 >> 6);
                byArray[n2++] = (byte)(0x80 | 0x3F & n4);
                continue;
            }
            n4 = (n5 << 24) + (n8 << 16) + (n7 << 8) + n6;
            byArray[n2++] = (byte)(0xF0 | n4 >> 18);
            byArray[n2++] = (byte)(0x80 | 0x3F & n4 >> 12);
            byArray[n2++] = (byte)(0x80 | 0x3F & n4 >> 6);
            byArray[n2++] = (byte)(0x80 | 0x3F & n4);
        }
        byteStreamDataSource.byteOffset = n3;
        return n2;
    }
}

