/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util.encoding;

import com.ibm.xml.xlxp.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp.api.util.encoding.DataSourceFactory;
import com.ibm.xml.xlxp.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.scan.util.CharConversionError;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import java.io.IOException;
import java.io.InputStream;

final class EBCDICEncodingSupport
implements EncodingSupport {
    public static final int CP037 = 0;
    public static final int CP273 = 1;
    public static final int CP277 = 2;
    public static final int CP278 = 3;
    public static final int CP280 = 4;
    public static final int CP284 = 5;
    public static final int CP285 = 6;
    public static final int CP297 = 7;
    public static final int CP500 = 8;
    public static final int CP871 = 9;
    public static final int CP1047 = 10;
    public static final int CP1140 = 11;
    public static final int CP1141 = 12;
    public static final int CP1142 = 13;
    public static final int CP1143 = 14;
    public static final int CP1144 = 15;
    public static final int CP1145 = 16;
    public static final int CP1146 = 17;
    public static final int CP1147 = 18;
    public static final int CP1148 = 19;
    public static final int CP1149 = 20;
    private static final int ENCODINGS_COUNT = 21;
    private char[] fCharMap;
    private static EncodingSupport[] fgSingletons;

    public static EncodingSupport getInstance(int n) {
        EncodingSupport encodingSupport;
        if (n < 0 || n > 20) {
            return null;
        }
        if (fgSingletons == null) {
            fgSingletons = new EncodingSupport[21];
        } else if (fgSingletons[n] != null) {
            return fgSingletons[n];
        }
        switch (n) {
            case 0: {
                encodingSupport = CP037Mappings.createEncodingSupport();
                break;
            }
            case 1: {
                encodingSupport = CP273Mappings.createEncodingSupport();
                break;
            }
            case 2: {
                encodingSupport = CP277Mappings.createEncodingSupport();
                break;
            }
            case 3: {
                encodingSupport = CP278Mappings.createEncodingSupport();
                break;
            }
            case 4: {
                encodingSupport = CP280Mappings.createEncodingSupport();
                break;
            }
            case 5: {
                encodingSupport = CP284Mappings.createEncodingSupport();
                break;
            }
            case 6: {
                encodingSupport = CP285Mappings.createEncodingSupport();
                break;
            }
            case 7: {
                encodingSupport = CP297Mappings.createEncodingSupport();
                break;
            }
            case 8: {
                encodingSupport = CP500Mappings.createEncodingSupport();
                break;
            }
            case 9: {
                encodingSupport = CP871Mappings.createEncodingSupport();
                break;
            }
            case 10: {
                encodingSupport = CP1047Mappings.createEncodingSupport();
                break;
            }
            case 11: {
                encodingSupport = CP1140Mappings.createEncodingSupport();
                break;
            }
            case 12: {
                encodingSupport = CP1141Mappings.createEncodingSupport();
                break;
            }
            case 13: {
                encodingSupport = CP1142Mappings.createEncodingSupport();
                break;
            }
            case 14: {
                encodingSupport = CP1143Mappings.createEncodingSupport();
                break;
            }
            case 15: {
                encodingSupport = CP1144Mappings.createEncodingSupport();
                break;
            }
            case 16: {
                encodingSupport = CP1145Mappings.createEncodingSupport();
                break;
            }
            case 17: {
                encodingSupport = CP1146Mappings.createEncodingSupport();
                break;
            }
            case 18: {
                encodingSupport = CP1147Mappings.createEncodingSupport();
                break;
            }
            case 19: {
                encodingSupport = CP1148Mappings.createEncodingSupport();
                break;
            }
            case 20: {
                encodingSupport = CP1149Mappings.createEncodingSupport();
                break;
            }
            default: {
                return null;
            }
        }
        EBCDICEncodingSupport.fgSingletons[n] = encodingSupport;
        return encodingSupport;
    }

    public CharConversionError loadFromByteStream(ParsedEntity parsedEntity, InputStream inputStream, String string, boolean bl, boolean bl2, DataSourceFactory dataSourceFactory) {
        ByteStreamDataSource byteStreamDataSource = dataSourceFactory.allocateByteStreamDataSource();
        byteStreamDataSource.checkAvailable = bl2;
        byteStreamDataSource.setByteStream(inputStream, this, bl);
        return byteStreamDataSource.load(parsedEntity);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
        byte[] byArray = dataBuffer.bytes;
        int n = 0;
        try {
            int n2 = byteStreamDataSource.bufferLength - 1 - byteStreamDataSource.byteOffset;
            while (byteStreamDataSource.stream != null) {
                block10: {
                    int n3;
                    int n4 = 0;
                    n2 = byteStreamDataSource.bufferLength - byteStreamDataSource.byteOffset;
                    if (n2 > 0) {
                        n3 = byteStreamDataSource.stream.read(byteStreamDataSource.byteBuffer, byteStreamDataSource.byteOffset, n2);
                        if (n3 == -1) {
                            byteStreamDataSource.stream.close();
                            byteStreamDataSource.stream = null;
                            break;
                        }
                        n4 = n3;
                    }
                    n4 += byteStreamDataSource.byteOffset;
                    byteStreamDataSource.byteOffset = 0;
                    while (true) {
                        if (byteStreamDataSource.byteOffset >= n4 || n + 4 >= byteStreamDataSource.bufferLength) {
                            if (byteStreamDataSource.byteOffset >= n4) break;
                            System.arraycopy(byteStreamDataSource.byteBuffer, byteStreamDataSource.byteOffset, byteStreamDataSource.byteBuffer, 0, n4 -= byteStreamDataSource.byteOffset);
                            byteStreamDataSource.byteOffset = n4;
                            break block10;
                        }
                        n3 = this.fCharMap[byteStreamDataSource.byteBuffer[byteStreamDataSource.byteOffset] & 0xFF];
                        ++byteStreamDataSource.byteOffset;
                        if (n3 < 128) {
                            byArray[n++] = (byte)n3;
                            continue;
                        }
                        if (n3 < 2048) {
                            byArray[n++] = (byte)(0xC0 | n3 >> 6);
                            byArray[n++] = (byte)(0x80 | 0x3F & n3);
                            continue;
                        }
                        byArray[n++] = (byte)(0xE0 | n3 >> 12);
                        byArray[n++] = (byte)(0x80 | 0x3F & n3 >> 6);
                        byArray[n++] = (byte)(0x80 | 0x3F & n3);
                    }
                    byteStreamDataSource.byteOffset = 0;
                }
                if (n + 4 < byteStreamDataSource.bufferLength) continue;
                break;
            }
        }
        catch (IOException iOException) {
            return CharConversionError.runtimeIOError((IOException)iOException);
        }
        dataBuffer.endOffset = n;
        return null;
    }

    protected EBCDICEncodingSupport(char[] cArray) {
        this.fCharMap = cArray;
    }

    static final class CP1149Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '\u00de', '.', '<', '(', '+', '!', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '\u00c6', '$', '*', ')', ';', '\u00d6', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '\u00f0', ':', '#', '\u00d0', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '`', '\u00fd', '{', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '}', '\u00b8', ']', '\u20ac', '\u00b5', '\u00f6', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '@', '\u00dd', '[', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\\', '\u00d7', '\u00fe', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '~', '\u00f2', '\u00f3', '\u00f5', '\u00e6', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\u00b4', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '^', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

        CP1149Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP1148Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '[', '.', '<', '(', '+', '!', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', ']', '$', '*', ')', ';', '^', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u20ac', '\u00b5', '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

        CP1148Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP1147Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '@', '\u00e1', '\u00e3', '\u00e5', '\\', '\u00f1', '\u00b0', '.', '<', '(', '+', '!', '&', '{', '\u00ea', '\u00eb', '}', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '\u00a7', '$', '*', ')', ';', '^', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00f9', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '\u00b5', ':', '\u00a3', '\u00e0', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '[', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u20ac', '`', '\u00a8', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '#', '\u00a5', '\u00b7', '\u00a9', ']', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '~', '\u00b4', '\u00d7', '\u00e9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '\u00e8', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00a6', '\u00fa', '\u00ff', '\u00e7', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

        CP1147Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP1146Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '$', '.', '<', '(', '+', '|', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '!', '\u00a3', '*', ')', ';', '\u00ac', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u20ac', '\u00b5', '\u00af', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '[', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '^', ']', '~', '\u00a8', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

        CP1146Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP1145Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00a6', '[', '.', '<', '(', '+', '|', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', ']', '$', '*', ')', ';', '\u00ac', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '#', '\u00f1', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '\u00d1', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u20ac', '\u00b5', '\u00a8', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '^', '!', '\u00af', '~', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

        CP1145Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP1144Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '{', '\u00e1', '\u00e3', '\u00e5', '\\', '\u00f1', '\u00b0', '.', '<', '(', '+', '!', '&', ']', '\u00ea', '\u00eb', '}', '\u00ed', '\u00ee', '\u00ef', '~', '\u00df', '\u00e9', '$', '*', ')', ';', '^', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00f2', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '\u00f9', ':', '\u00a3', '\u00a7', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '[', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u20ac', '\u00b5', '\u00ec', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '#', '\u00a5', '\u00b7', '\u00a9', '@', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '\u00e0', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00a6', '\u00f3', '\u00f5', '\u00e8', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '`', '\u00fa', '\u00ff', '\u00e7', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

        CP1144Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP1143Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '{', '\u00e0', '\u00e1', '\u00e3', '}', '\u00e7', '\u00f1', '\u00a7', '.', '<', '(', '+', '!', '&', '`', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '\u20ac', '\u00c5', '*', ')', ';', '^', '-', '/', '\u00c2', '#', '\u00c0', '\u00c1', '\u00c3', '$', '\u00c7', '\u00d1', '\u00f6', ',', '%', '_', '>', '?', '\u00f8', '\\', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '\u00e9', ':', '\u00c4', '\u00d6', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', ']', '\u00b5', '\u00fc', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '[', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '\u00e4', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00a6', '\u00f2', '\u00f3', '\u00f5', '\u00e5', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '~', '\u00f9', '\u00fa', '\u00ff', '\u00c9', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '@', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

        CP1143Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP1142Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '}', '\u00e7', '\u00f1', '#', '.', '<', '(', '+', '!', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '\u20ac', '\u00c5', '*', ')', ';', '^', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '$', '\u00c7', '\u00d1', '\u00f8', ',', '%', '_', '>', '?', '\u00a6', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '\u00c6', '\u00d8', '\'', '=', '\"', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '{', '\u00b8', '[', ']', '\u00b5', '\u00fc', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '\u00e6', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '\u00e5', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '~', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

        CP1142Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP1141Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '{', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '\u00c4', '.', '<', '(', '+', '!', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '~', '\u00dc', '$', '*', ')', ';', '^', '-', '/', '\u00c2', '[', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00f6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '\u00a7', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u20ac', '\u00b5', '\u00df', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '@', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '\u00e4', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00a6', '\u00f2', '\u00f3', '\u00f5', '\u00fc', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '}', '\u00f9', '\u00fa', '\u00ff', '\u00d6', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\\', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', ']', '\u00d9', '\u00da', '\u009f'};

        CP1141Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP1140Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '\u00a2', '.', '<', '(', '+', '|', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '!', '$', '*', ')', ';', '\u00ac', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u20ac', '\u00b5', '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '^', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '[', ']', '\u00af', '\u00a8', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

        CP1140Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP1047Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '\u00a2', '.', '<', '(', '+', '|', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '!', '$', '*', ')', ';', '^', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u00a4', '\u00b5', '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '[', '\u00de', '\u00ae', '\u00ac', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00dd', '\u00a8', '\u00af', ']', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

        CP1047Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP871Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '\u00de', '.', '<', '(', '+', '!', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '\u00c6', '$', '*', ')', ';', '\u00d6', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '\u00f0', ':', '#', '\u00d0', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '`', '\u00fd', '{', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '}', '\u00b8', ']', '\u00a4', '\u00b5', '\u00f6', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '@', '\u00dd', '[', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\\', '\u00d7', '\u00fe', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '~', '\u00f2', '\u00f3', '\u00f5', '\u00e6', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\u00b4', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '^', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

        CP871Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP500Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '[', '.', '<', '(', '+', '!', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', ']', '$', '*', ')', ';', '^', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u00a4', '\u00b5', '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

        CP500Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP297Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '@', '\u00e1', '\u00e3', '\u00e5', '\\', '\u00f1', '\u00b0', '.', '<', '(', '+', '!', '&', '{', '\u00ea', '\u00eb', '}', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '\u00a7', '$', '*', ')', ';', '^', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00f9', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '\u00b5', ':', '\u00a3', '\u00e0', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '[', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u00a4', '`', '\u00a8', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '#', '\u00a5', '\u00b7', '\u00a9', ']', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '~', '\u00b4', '\u00d7', '\u00e9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '\u00e8', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00a6', '\u00fa', '\u00ff', '\u00e7', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

        CP297Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP285Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '$', '.', '<', '(', '+', '|', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '!', '\u00a3', '*', ')', ';', '\u00ac', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u00a4', '\u00b5', '\u00af', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '[', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '^', ']', '~', '\u00a8', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

        CP285Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP284Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00a6', '[', '.', '<', '(', '+', '|', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', ']', '$', '*', ')', ';', '\u00ac', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '#', '\u00f1', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '\u00d1', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u00a4', '\u00b5', '\u00a8', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '^', '!', '\u00af', '~', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

        CP284Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP280Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '{', '\u00e1', '\u00e3', '\u00e5', '\\', '\u00f1', '\u00b0', '.', '<', '(', '+', '!', '&', ']', '\u00ea', '\u00eb', '}', '\u00ed', '\u00ee', '\u00ef', '~', '\u00df', '\u00e9', '$', '*', ')', ';', '^', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00f2', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '\u00f9', ':', '\u00a3', '\u00a7', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '[', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u00a4', '\u00b5', '\u00ec', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '#', '\u00a5', '\u00b7', '\u00a9', '@', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '\u00e0', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00a6', '\u00f3', '\u00f5', '\u00e8', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '`', '\u00fa', '\u00ff', '\u00e7', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

        CP280Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP278Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '{', '\u00e0', '\u00e1', '\u00e3', '}', '\u00e7', '\u00f1', '\u00a7', '.', '<', '(', '+', '!', '&', '`', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '\u00a4', '\u00c5', '*', ')', ';', '^', '-', '/', '\u00c2', '#', '\u00c0', '\u00c1', '\u00c3', '$', '\u00c7', '\u00d1', '\u00f6', ',', '%', '_', '>', '?', '\u00f8', '\\', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '\u00e9', ':', '\u00c4', '\u00d6', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', ']', '\u00b5', '\u00fc', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '[', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '\u00e4', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00a6', '\u00f2', '\u00f3', '\u00f5', '\u00e5', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '~', '\u00f9', '\u00fa', '\u00ff', '\u00c9', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '@', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

        CP278Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP277Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '}', '\u00e7', '\u00f1', '#', '.', '<', '(', '+', '!', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '\u00a4', '\u00c5', '*', ')', ';', '^', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '$', '\u00c7', '\u00d1', '\u00f8', ',', '%', '_', '>', '?', '\u00a6', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '\u00c6', '\u00d8', '\'', '=', '\"', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '{', '\u00b8', '[', ']', '\u00b5', '\u00fc', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '\u00e6', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '\u00e5', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '~', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

        CP277Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP273Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '{', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '\u00c4', '.', '<', '(', '+', '!', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '~', '\u00dc', '$', '*', ')', ';', '^', '-', '/', '\u00c2', '[', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00f6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '\u00a7', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u00a4', '\u00b5', '\u00df', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '@', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '\u00e4', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00a6', '\u00f2', '\u00f3', '\u00f5', '\u00fc', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '}', '\u00f9', '\u00fa', '\u00ff', '\u00d6', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\\', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', ']', '\u00d9', '\u00da', '\u009f'};

        CP273Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }

    static final class CP037Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '\u00a2', '.', '<', '(', '+', '|', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '!', '$', '*', ')', ';', '\u00ac', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u00a4', '\u00b5', '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '^', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '[', ']', '\u00af', '\u00a8', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};

        CP037Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap);
        }
    }
}

