/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.validate;

import com.filenet.api.core.ObjectStore;
import com.ibm.acm.sold.args.OneBPMArgs;
import com.ibm.acm.sold.args.TaskInfo;
import com.ibm.acm.sold.comm.CaseTypeData;
import com.ibm.acm.sold.common.Config;
import com.ibm.acm.sold.connector.onebpm.OneBPMValidator;
import com.ibm.acm.sold.diagrammer.AcmActivitySdfData;
import com.ibm.acm.sold.diagrammer.types.AcmActivity;
import com.ibm.acm.sold.exception.AcmConnectionFailure;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.acm.sold.util.ceutil;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypeType;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumWorkflowType;
import com.ibm.xmlns.prod.ecm.acm.sdf.SolutionType;
import com.ibm.xmlns.prod.ecm.acm.sdf.TaskType;
import com.ibm.xmlns.prod.ecm.acm.sdf.TasksType;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OneBPM {
    private OneBPMArgs validationArgs = new OneBPMArgs();
    private String objectStore = null;
    private ceutil ceUtil;
    private boolean OneBPMTask = false;
    private static final Log log = LogFactory.getLog((String)"CB");

    public OneBPM(Config conf) {
        this.ceUtil = new ceutil(conf);
    }

    public HashMap<String, List<String>> validate() throws AcmConnectionFailure, AcmException {
        HashMap<String, List<String>> errors = null;
        OneBPMValidator validator = new OneBPMValidator();
        this.ceUtil.connect();
        ObjectStore tos = this.ceUtil.getObjectStore(this.objectStore);
        log.debug((Object)"Trying to call IBPM Validator");
        errors = validator.validateBPM(tos, this.getValidationArgs());
        log.info((Object)"IBPM Validation success");
        this.ceUtil.closeSession();
        return errors;
    }

    public void fillSolutionLevelInfo(SolutionType solnType) throws AcmException {
        if (solnType.getOneBPMIntegrationInfo() == null) {
            Message msg = new Message("B6025E.SOLUTION_MISSING_PROCESS_INFORMATION");
            AcmException acmexc = new AcmException(msg);
            throw acmexc;
        }
        if (solnType.getOneBPMIntegrationInfo().getProcessApplicationName() == null) {
            Message msg = new Message("B6025E.SOLUTION_MISSING_PROCESS_INFORMATION");
            AcmException acmexc = new AcmException(msg);
            throw acmexc;
        }
        if (solnType.getOneBPMIntegrationInfo().getSnapshotName() == null) {
            Message msg = new Message("B6025E.SOLUTION_MISSING_PROCESS_INFORMATION");
            AcmException acmexc = new AcmException(msg);
            throw acmexc;
        }
        String cbProcessAppAcronym = solnType.getOneBPMIntegrationInfo().getProcessApplicationAcronym();
        if (cbProcessAppAcronym == null) {
            Message msg = new Message("B6025E.SOLUTION_MISSING_PROCESS_INFORMATION");
            AcmException acmexc = new AcmException(msg);
            throw acmexc;
        }
        this.validationArgs.setOneBPMIntegrationInfo(solnType.getOneBPMIntegrationInfo());
        log.debug((Object)"IBPM solution info filled");
    }

    public void fillCaseLevelInfo(CaseTypeData data) {
        log.trace((Object)">> prepare");
        if (data == null) {
            log.error((Object)" Invalid case Data, Validation in correct");
            return;
        }
        log.debug((Object)"Filling case level info");
        log.debug((Object)("Case name :" + data.getSymName()));
        this.validationArgs.getCaseType().setCaseIdentifier(data.getSymName());
        Map<String, AcmActivity> activities = data.getActivitiesMap();
        for (String activityName : activities.keySet()) {
            log.debug((Object)("Activity Name : " + activityName));
            AcmActivity activity = activities.get(activityName);
            if (activity != null) {
                AcmActivitySdfData sdfData = activity.getSdfData();
                if (sdfData != null) {
                    if (sdfData.getWorkflowType() != null && sdfData.getWorkflowType().equals((Object)EnumWorkflowType.ONE_BPM)) {
                        log.info((Object)("IBPM Activity : " + sdfData.getWorkflowName()));
                        this.validationArgs.getCaseType().getTaskList().add(this.createTaskInfo(sdfData));
                        this.setOneBPMTask(true);
                        continue;
                    }
                    log.debug((Object)"Not a IBPM Activity");
                    continue;
                }
                log.error((Object)"SDF DATA is NULL");
                continue;
            }
            log.error((Object)"Activity is NULL in Map");
        }
        log.trace((Object)"<< prepare");
    }

    public void fillCaseLevelInfo(CaseTypeType data) {
        log.trace((Object)">> prepare");
        if (data == null) {
            log.error((Object)" Invalid case Data, Validation in correct");
            return;
        }
        log.debug((Object)"Filling case level info");
        log.debug((Object)("Case name :" + data.getName()));
        this.validationArgs.getCaseType().setCaseIdentifier(data.getName());
        TasksType tasks = data.getTasks();
        List tasklist = tasks.getTask();
        if (tasklist != null && tasklist.size() > 0) {
            for (int i = 0; i < tasklist.size(); ++i) {
                TaskType task = (TaskType)tasklist.get(i);
                String activityName = task.getName();
                log.debug((Object)("Activity Name : " + activityName));
                if (task.getWorkflowType() == null || !task.getWorkflowType().equals((Object)EnumWorkflowType.ONE_BPM)) continue;
                log.debug((Object)("One BPM Activity : " + task.getWorkflowName()));
                this.validationArgs.getCaseType().getTaskList().add(this.createTaskInfo(task));
                this.setOneBPMTask(true);
            }
        }
        log.trace((Object)"<< prepare");
    }

    private TaskInfo createTaskInfo(AcmActivitySdfData sdfdata) {
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.setFieldList(sdfdata.getWorkflowPropertyMap());
        log.debug((Object)"Creating Task Info");
        taskInfo.setWorkFlowName(sdfdata.getWorkflowName());
        taskInfo.setCbTaskSymName(sdfdata.getSymbolicName());
        return taskInfo;
    }

    private TaskInfo createTaskInfo(TaskType task) {
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.setFieldList(task.getWorkflowPropertyMaps());
        log.debug((Object)"Creating Task Info");
        taskInfo.setWorkFlowName(task.getWorkflowName());
        taskInfo.setCbTaskSymName(task.getName());
        return taskInfo;
    }

    public OneBPMArgs getValidationArgs() {
        return this.validationArgs;
    }

    public String getObjectStore() {
        return this.objectStore;
    }

    public void setObjectStore(String objectStore) throws AcmException {
        if (objectStore == null) {
            Message msg = new Message("B0001E.INVALID_ARGUMENT", "targetOs");
            AcmException acmexc = new AcmException(msg);
            throw acmexc;
        }
        this.objectStore = objectStore;
    }

    public void setClientLocale(Locale clientLocale) {
        this.validationArgs.setClientLocale(clientLocale);
    }

    public Locale getClientLocale() {
        return this.validationArgs.getClientLocale();
    }

    public void setOneBPMTask(boolean oneBPMTask) {
        this.OneBPMTask = oneBPMTask;
    }

    public boolean isOneBPMTaskExists() {
        return this.OneBPMTask;
    }
}

