/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.util;

import com.filenet.api.core.Connection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.util.UserContext;
import com.ibm.acm.sold.common.Config;
import com.ibm.acm.sold.exception.AcmConnectionFailure;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ceutil {
    private Config config;
    private UserContext origUC;
    private Connection conn;
    private Subject m_subj;
    private Domain domain;
    private static final Log log = LogFactory.getLog((String)"CB");

    public ceutil(Config cfg) {
        this.config = cfg;
    }

    public synchronized void connect() throws AcmConnectionFailure, AcmException {
        log.trace((Object)">> OpenSession");
        this.origUC = UserContext.get();
        UserContext tempUC = new UserContext();
        tempUC.setLocale(this.origUC.getLocale());
        UserContext.set((UserContext)tempUC);
        try {
            this.conn = Factory.Connection.getConnection((String)this.config.getCeUri());
            log.debug((Object)("Connection :" + this.conn));
            if (!this.config.isJaasAuthentication()) {
                this.m_subj = UserContext.createSubject((Connection)this.conn, (String)this.config.getUserName(), (String)this.config.getPassword(), null);
                UserContext.get().pushSubject(this.m_subj);
            }
        }
        catch (EngineRuntimeException e) {
            log.error((Object)e.getLocalizedMessage());
            Message msg = new Message("B0005E.CONNECTION_FAILURE", e.getLocalizedMessage());
            throw new AcmConnectionFailure(msg);
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage());
            Message msg = new Message("B0005E.CONNECTION_FAILURE", e.getLocalizedMessage());
            throw new AcmConnectionFailure(msg);
        }
        if (this.conn == null) {
            Message msg = new Message("B0005E.CONNECTION_FAILURE");
            throw new AcmConnectionFailure(msg);
        }
        try {
            this.domain = Factory.Domain.getInstance((Connection)this.conn, null);
            log.debug((Object)("Domain :" + this.domain));
        }
        catch (EngineRuntimeException e) {
            log.error((Object)e, (Throwable)e);
            Message msg = new Message("B0006E.DOMAIN_FAILURE");
            throw new AcmConnectionFailure(msg);
        }
        try {
            this.domain.fetchProperty("ObjectStores", null);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            Message msg = new Message("B0006E.DOMAIN_FAILURE");
            throw new AcmConnectionFailure(msg, (Throwable)e);
        }
        log.trace((Object)"<< OpenSession");
    }

    public void closeSession() {
        log.trace((Object)">> closeSession");
        if (this.origUC != null) {
            UserContext.set((UserContext)this.origUC);
        }
        log.trace((Object)"<< closeSession");
    }

    public ObjectStore getObjectStore(String ObjectStoreName) {
        return Factory.ObjectStore.fetchInstance((Domain)this.domain, (String)ObjectStoreName, null);
    }
}

