/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.servlet;

import com.ibm.acm.casebuilder.response.AcmResponse;
import com.ibm.acm.sold.comm.CaseTypeData;
import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.diagrammer.AcmActivityEditorUtil;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.acm.sold.servlet.HttpServletHelper;
import com.ibm.acm.sold.validate.OneBPM;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypeType;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypesType;
import com.ibm.xmlns.prod.ecm.acm.sdf.SolutionType;
import filenet.vw.api.VWValidationError;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidateCaseActivitiesServlet
extends HttpServletHelper {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog((String)ValidateCaseActivitiesServlet.class.getName());

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.setClientLocaleForPE(request);
        response.setHeader("Cache-Control", "no-cache");
        SolutionData solData = (SolutionData)request.getSession().getAttribute("SolutionData");
        String caseTypeName = request.getParameter("file");
        String tosName = request.getParameter("TOS");
        PrintWriter out = response.getWriter();
        String sdfFile = "";
        try {
            sdfFile = AcmActivityEditorUtil.createSdfFromSolutionType(solData.getConverterData().getSolutionType());
        }
        catch (AcmException e1) {
            this.resetLocale();
            e1.printStackTrace();
            throw new ServletException((Throwable)e1);
        }
        String responseString = null;
        if (solData.getCasetypedata(caseTypeName) == null) {
            Message msg = new Message("B4032I.NO_TASKS_FOUND");
            AcmResponse result = new AcmResponse(0, msg.getFormattedText(request.getLocale()));
            responseString = result.toJson();
        } else {
            CaseTypeData OneBPMctData;
            List caseList;
            log.debug((Object)(" Trying to Validate Activities for caseType :" + caseTypeName));
            HashMap<String, List<String>> bpmErrors = null;
            SolutionType solType = null;
            if (solData.getSdfData() != null) {
                solType = solData.getSdfData().getSolutionType();
            }
            if (solType == null) {
                try {
                    solType = solData.getConverterData().getSolutionType();
                }
                catch (AcmException e) {
                    log.error((Object)"Error", (Throwable)e);
                }
            }
            OneBPM oneBPM = new OneBPM(handle.getConfig());
            CaseTypesType cases = solType.getCaseTypes();
            CaseTypeType searchCase = null;
            if (cases != null && (caseList = cases.getCaseType()) != null) {
                for (int idx = 0; idx < caseList.size(); ++idx) {
                    if (!((CaseTypeType)caseList.get(idx)).getName().equals(caseTypeName)) continue;
                    searchCase = (CaseTypeType)caseList.get(idx);
                    break;
                }
            }
            if (searchCase != null) {
                oneBPM.fillCaseLevelInfo(searchCase);
            }
            if ((OneBPMctData = solData.getCasetypedata(caseTypeName)) != null) {
                oneBPM.fillCaseLevelInfo(OneBPMctData);
            }
            if (oneBPM.isOneBPMTaskExists()) {
                ArrayList<String> err;
                oneBPM.setClientLocale(request.getLocale());
                try {
                    oneBPM.setObjectStore(tosName);
                    oneBPM.fillSolutionLevelInfo(solType);
                }
                catch (AcmException e) {
                    err = new ArrayList<String>();
                    err.add(e.getMessage(response.getLocale()));
                    bpmErrors = new HashMap();
                    bpmErrors.put("error", err);
                }
                try {
                    if (bpmErrors == null) {
                        bpmErrors = oneBPM.validate();
                    }
                }
                catch (AcmException e) {
                    err = new ArrayList();
                    err.add(e.getMessage(response.getLocale()));
                    bpmErrors = new HashMap();
                    bpmErrors.put("error", err);
                }
            } else {
                log.info((Object)"No  IBPM task available");
            }
            CaseTypeData ctData = solData.getCasetypedata(caseTypeName);
            try {
                if (ctData.reuseBPMtasksExists() && solData.getGlobalXPDLcollection() == null) {
                    solData.initGlobalXPDLCollection(handle.getConfig());
                }
                HashMap<String, VWValidationError[]> errorsMap = ctData.validateCaseActivities(solData.getPeconfigData().getSystemConfiguration(), sdfFile, solData.getGlobalXPDLcollection());
                log.debug((Object)"Trying do custom validation ");
                Map<String, List<String>> customErrorsMap = AcmActivityEditorUtil.doCustomValidationOfActivitiesMap(ctData.getActivitiesMap(), ctData.getWorkflowsWithNoActivity(), request.getLocale());
                if (errorsMap.containsKey("~CollectionKey")) {
                    errorsMap.remove("~CollectionKey");
                }
                Set keys = errorsMap.keySet();
                Iterator keysIterator = keys.iterator();
                JSONObject errorsWrapper = null;
                JSONObject errorsJSON = new JSONObject();
                errorsWrapper = new JSONObject();
                while (keysIterator.hasNext()) {
                    List<String> customErrors;
                    String key = (String)keysIterator.next();
                    VWValidationError[] error = (VWValidationError[])errorsMap.get(key);
                    JSONArray errors = new JSONArray();
                    if (error != null) {
                        for (int i = 0; i < error.length; ++i) {
                            errors.add((Object)(error[i].getName() + ": " + error[i].getMessage()));
                        }
                    }
                    if ((customErrors = customErrorsMap.get(key)) != null && customErrors.size() > 0) {
                        Iterator<String> errorIterator = customErrors.iterator();
                        while (errorIterator.hasNext()) {
                            errors.add((Object)errorIterator.next());
                        }
                    }
                    errorsWrapper.put((Object)key, (Object)errors);
                }
                if (bpmErrors != null) {
                    log.debug((Object)"IBPM errors exists");
                    Set bpmkeys = bpmErrors.keySet();
                    for (String bpmkey : bpmkeys) {
                        if (bpmkey == null) continue;
                        JSONArray errors = new JSONArray();
                        List BPMErrorstr = (List)bpmErrors.get(bpmkey);
                        if (BPMErrorstr != null && BPMErrorstr.size() > 0) {
                            for (int i = 0; i < BPMErrorstr.size(); ++i) {
                                log.debug((Object)("Error msg : " + bpmkey + "-" + (String)BPMErrorstr.get(i)));
                                errors.add(BPMErrorstr.get(i));
                            }
                        }
                        errorsWrapper.put((Object)bpmkey, (Object)errors);
                    }
                }
                if (errorsWrapper != null) {
                    errorsJSON.put((Object)"status", (Object)"1");
                    errorsJSON.put((Object)"errors", (Object)errorsWrapper);
                    responseString = errorsJSON.toString();
                } else {
                    Message msg = new Message("B4033I.VALIDATE_SUCCESS_CASETYPE");
                    AcmResponse result = new AcmResponse(0, "\"" + msg.getFormattedText(request.getLocale()) + "\"");
                    responseString = result.toJson();
                }
            }
            catch (AcmException ae) {
                AcmResponse result = new AcmResponse(1, ae.getMessage(request.getLocale()), ae.getUid());
                responseString = result.toJson();
            }
            this.resetLocale();
            log.debug((Object)("Response to UI :" + responseString));
            out.write(responseString);
            out.close();
        }
    }
}

