/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.servlet;

import com.ibm.acm.sold.comm.CaseTypeData;
import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.converter.AcmProcessWgAttach;
import com.ibm.acm.sold.diagrammer.types.AcmActivityAttachment;
import com.ibm.acm.sold.diagrammer.types.AcmStepProcessorListWrapper;
import com.ibm.acm.sold.diagrammer.types.AcmWorkGroupDefinition;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.servlet.HttpServletHelper;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StepEditorServlet
extends HttpServletHelper {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog((String)StepEditorServlet.class.getName());

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)">> doGet");
        SolutionData solData = (SolutionData)request.getSession().getAttribute("SolutionData");
        if (solData == null) {
            log.info((Object)"Invalid session");
            return;
        }
        String jsonstr = request.getParameter("jsonstr");
        JSONObject js = JSONObject.parse((String)jsonstr);
        String caseName = (String)js.get((Object)"caseSymbolicName");
        String activityName = (String)js.get((Object)"activitySymbolicName");
        if (solData.getCasetypedata(caseName) == null) {
            log.info((Object)"Invalid case");
            return;
        }
        Set<AcmWorkGroupDefinition> workgroups = solData.getCasetypedata(caseName).getActivityByName(activityName).getWorkgroupDef();
        Set<AcmActivityAttachment> attachments = solData.getCasetypedata(caseName).getActivityByName(activityName).getAttachments();
        JSONObject responseJSON = new JSONObject();
        JSONArray workgroupJSONArray = new JSONArray();
        if (workgroups != null) {
            Iterator<AcmWorkGroupDefinition> i1 = workgroups.iterator();
            while (i1.hasNext()) {
                workgroupJSONArray.add((Object)i1.next().toJSONObject());
            }
        }
        JSONArray attachmentJSONArray = new JSONArray();
        if (attachments != null) {
            Iterator<AcmActivityAttachment> i1 = attachments.iterator();
            while (i1.hasNext()) {
                attachmentJSONArray.add((Object)i1.next().toJSONObject());
            }
        }
        AcmStepProcessorListWrapper pages = new AcmStepProcessorListWrapper();
        pages.addPages(solData.getStepPagesList());
        pages.addLaunchStepPages(solData.getStepLaunchPagesList());
        responseJSON.put((Object)"Workgroups", (Object)workgroupJSONArray);
        responseJSON.put((Object)"Attachments", (Object)attachmentJSONArray);
        responseJSON.put((Object)"StepProcessorPages", (Object)pages.toJSONObject());
        String returnString = responseJSON.toString();
        PrintWriter out = response.getWriter();
        out.write(returnString);
        out.close();
        log.trace((Object)"<< doGet");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)">> doPost");
        response.setHeader("Cache-Control", "no-cache");
        String casetypename = null;
        PrintWriter out = response.getWriter();
        String jsonstr = request.getParameter("jsonstr");
        log.debug((Object)("Obtained JSON:" + jsonstr));
        JSONObject js = null;
        String wgjson = null;
        String attjson = null;
        try {
            js = JSONObject.parse((String)jsonstr);
            casetypename = (String)js.get((Object)"caseName");
            wgjson = js.get((Object)"workgroups").toString();
            attjson = js.get((Object)"attachments").toString();
        }
        catch (IOException e) {
            log.error((Object)"Error Parsing the JSON, Exception occured");
            e.printStackTrace();
            out.write(e.getLocalizedMessage());
            out.close();
            return;
        }
        HttpSession sess = request.getSession(true);
        log.info((Object)"Obtained Session object ---");
        SolutionData solData = (SolutionData)sess.getAttribute("SolutionData");
        AcmProcessWgAttach wgAttach = new AcmProcessWgAttach();
        if (solData != null) {
            try {
                CaseTypeData ct = solData.getCasetypedata(casetypename);
                wgAttach.updateWgDataFromJson(JSONObject.parse((String)wgjson), ct);
                wgAttach.updateAttachDataFromJson(JSONObject.parse((String)attjson), ct);
                solData.setCasetypedata(casetypename, ct);
            }
            catch (AcmException ae) {
                log.error((Object)"Exception occured, Processing in WgAttachUpdateServlet");
                ae.printStackTrace();
                out.write(ae.getLocalizedMessage());
                out.close();
                return;
            }
        }
        sess.setAttribute("SolutionData", (Object)solData);
        log.trace((Object)"<< doPost");
    }
}

