/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.servlet;

import com.ibm.acm.casebuilder.response.AcmResponse;
import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.common.Constants;
import com.ibm.acm.sold.diagrammer.AcmActivityEditorUtil;
import com.ibm.acm.sold.diagrammer.exceptions.DiagrammerException;
import com.ibm.acm.sold.diagrammer.listener.CreateActionListener;
import com.ibm.acm.sold.diagrammer.listener.DeleteActionListener;
import com.ibm.acm.sold.diagrammer.types.AcmActivity;
import com.ibm.acm.sold.diagrammer.types.AcmActivityAttachment;
import com.ibm.acm.sold.diagrammer.types.AcmCaseShareInfo;
import com.ibm.acm.sold.diagrammer.types.AcmRoleInbasketproperties;
import com.ibm.acm.sold.diagrammer.types.AcmWorkGroupDefinition;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.acm.sold.servlet.StepEditorDiagrammerServlet;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowDefinition;
import ilog.views.diagrammer.IlvDiagrammer;
import ilog.views.diagrammer.IlvDiagrammerException;
import ilog.views.diagrammer.faces.dhtml.servlet.IlvFacesDiagrammerSelectAction;
import ilog.views.diagrammer.faces.dhtml.servlet.IlvFacesDiagrammerSelectRectAction;
import ilog.views.diagrammer.faces.dhtml.servlet.IlvFacesDiagrammerServletSupport;
import ilog.views.servlet.ServerActionListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StepEditorDiagrammerServletSupport
extends IlvFacesDiagrammerServletSupport {
    private static final Log log = LogFactory.getLog((String)"CB");

    public StepEditorDiagrammerServletSupport(StepEditorDiagrammerServlet stepEditorDiagrammerServlet, ServletContext context) {
        super(context);
    }

    protected void addJSFActionListeners() {
        this.addServerActionListener((ServerActionListener)new IlvFacesDiagrammerSelectAction());
        this.addServerActionListener((ServerActionListener)new IlvFacesDiagrammerSelectRectAction());
        this.addServerActionListener((ServerActionListener)new CreateActionListener());
        this.addServerActionListener((ServerActionListener)new DeleteActionListener());
    }

    private void createDataFieldsForInBaskets(VWWorkflowDefinition workflowDef, Map<String, AcmRoleInbasketproperties> inbasketProps) {
        log.trace((Object)">>createDataFieldsForInBaskets");
        VWFieldDefinition[] fieldDefs = null;
        try {
            fieldDefs = workflowDef.getFields();
        }
        catch (VWException e) {
            e.printStackTrace();
        }
        for (AcmRoleInbasketproperties p : inbasketProps.values()) {
            boolean found = false;
            if (fieldDefs != null) {
                for (int i = 0; i < fieldDefs.length; ++i) {
                    if (!fieldDefs[i].getName().equals(p.getSymName())) continue;
                    found = true;
                }
            }
            if (found) continue;
            String defaultValue = AcmActivityEditorUtil.getDefaultValue(p.getDataType(), p.isArray());
            try {
                workflowDef.createFieldUsingString(p.getSymName(), defaultValue, p.getDataType(), p.isArray());
            }
            catch (VWException e) {
                e.printStackTrace();
            }
        }
        log.trace((Object)"<<createDataFieldsForInBaskets");
    }

    private void drawActivity(AcmActivity activity, IlvDiagrammer diagrammer) {
        AcmActivityEditorUtil.copyDiagrammerOld(activity.getDiagrammer(), diagrammer);
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String action = request.getParameter("request");
        HttpSession session = request.getSession(false);
        if (null == session) {
            PrintWriter out = response.getWriter();
            out.write("[ SESSION TIMED OUT ]");
            out.close();
            return true;
        }
        SolutionData solutionData = (SolutionData)session.getAttribute("SolutionData");
        if (null == solutionData) {
            PrintWriter out = response.getWriter();
            out.write("[ SESSION TIMED OUT ]");
            out.close();
            return true;
        }
        int statusCode = 0;
        String payLoad = new String();
        if (action.equalsIgnoreCase("CHECK_ACTIVITY")) {
            return true;
        }
        if (action.equalsIgnoreCase("LOAD_ACTIVITY") || action.equalsIgnoreCase("COMMIT_ACTIVITY") || action.equalsIgnoreCase("VALIDATE_ACTIVITY") || action.equalsIgnoreCase("DISCARD_ACTIVITY") || action.equalsIgnoreCase("SAVE_CLOSE_ACTIVITY")) {
            String activityJsonStr = request.getParameter("file");
            String workgroupsJsonStr = request.getParameter("workgroups");
            String attachmentsJsonStr = request.getParameter("attachments");
            JSONArray workgroupsJson = null;
            JSONArray attachmentsJson = null;
            if (action.equalsIgnoreCase("COMMIT_ACTIVITY") || action.equalsIgnoreCase("VALIDATE_ACTIVITY")) {
                try {
                    workgroupsJson = JSONArray.parse((String)workgroupsJsonStr);
                    attachmentsJson = JSONArray.parse((String)attachmentsJsonStr);
                }
                catch (IOException e) {
                    log.error((Object)("Error parsing JSON String :" + workgroupsJsonStr));
                    e.printStackTrace();
                    throw e;
                }
            }
            JSONObject json = null;
            try {
                json = JSONObject.parse((String)activityJsonStr);
            }
            catch (IOException e) {
                log.error((Object)("Error parsing JSON String :" + activityJsonStr));
                e.printStackTrace();
                throw e;
            }
            String caseName = (String)json.get(Constants.ACM_CASE_SYMBOLIC_NAME_STR);
            String activityName = (String)json.get(Constants.ACM_ACTIVITY_SYMBOLIC_NAME_STR);
            String launchMode = (String)json.get((Object)"startMode");
            if (caseName == null) {
                log.error((Object)"Case Name in StepEditorDiagrammerServletSupport : null");
            }
            if (activityName == null) {
                log.error((Object)"Activity Name in StepEditorDiagrammerServletSupport : null");
            }
            IlvDiagrammer diagrammer = this.getDiagrammer(this.getSDMView(request));
            AcmActivity activity = null;
            try {
                log.debug((Object)("CaseName:" + caseName + " ActivityName:" + activityName));
                activity = solutionData.getCasetypedata(caseName.trim()).getActivityByName(activityName);
                if (activity == null) {
                    log.error((Object)"Activity Object is null");
                }
                activity.setLaunchModeString(launchMode);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info((Object)e.getMessage(), (Throwable)e);
                statusCode = 1;
                payLoad = e.toString();
            }
            if (action.equalsIgnoreCase("LOAD_ACTIVITY")) {
                if (activity.isTaskForReuseWorkflow()) {
                    log.info((Object)"it is reused task, don't load activity");
                    return true;
                }
                statusCode = this.loadActivity(activity, diagrammer, payLoad);
                try {
                    diagrammer.refresh();
                    diagrammer.setSize(Integer.parseInt(request.getParameter("width")), Integer.parseInt(request.getParameter("height")));
                }
                catch (IlvDiagrammerException e) {
                    e.printStackTrace();
                }
                return true;
            }
            if (action.equalsIgnoreCase("COMMIT_ACTIVITY")) {
                if (statusCode != 1) {
                    ArrayList<AcmWorkGroupDefinition> workgroups = new ArrayList<AcmWorkGroupDefinition>();
                    ArrayList<AcmActivityAttachment> attachments = new ArrayList<AcmActivityAttachment>();
                    this.updateWorkgroupsAndAttachmentsFromJSON(workgroups, workgroupsJson, attachments, attachmentsJson);
                    statusCode = this.updateActivity(solutionData, session, caseName, activity, diagrammer, payLoad);
                    if (statusCode == 0) {
                        statusCode = this.updatePeModelWithDataFields(workgroups, attachments, activity, payLoad, solutionData.getCasetypedata(caseName.trim()).getSharedInfo());
                    }
                    AcmResponse acmResponse = new AcmResponse(statusCode, payLoad);
                    PrintWriter out = response.getWriter();
                    out.write(acmResponse.toJson());
                    out.close();
                }
                return true;
            }
            if (action.equalsIgnoreCase("DISCARD_ACTIVITY")) {
                if (statusCode != 1) {
                    statusCode = this.removeAllNodes(diagrammer);
                }
                return true;
            }
            if (action.equalsIgnoreCase("SAVE_CLOSE_ACTIVITY")) {
                if (statusCode != 1) {
                    statusCode = this.updateActivity(solutionData, session, caseName, activity, diagrammer, payLoad);
                    statusCode = this.removeAllNodes(diagrammer);
                }
                return true;
            }
            if (action.equalsIgnoreCase("VALIDATE_ACTIVITY")) {
                JSONObject responseJSON = new JSONObject();
                ArrayList<AcmWorkGroupDefinition> workgroups = new ArrayList<AcmWorkGroupDefinition>();
                ArrayList<AcmActivityAttachment> attachments = new ArrayList<AcmActivityAttachment>();
                this.updateWorkgroupsAndAttachmentsFromJSON(workgroups, workgroupsJson, attachments, attachmentsJson);
                statusCode = this.updateActivity(solutionData, session, caseName, activity, diagrammer, payLoad);
                if (statusCode != 0) {
                    AcmResponse acmResponse = new AcmResponse(statusCode, payLoad);
                    PrintWriter out = response.getWriter();
                    out.write(acmResponse.toJson());
                    out.close();
                    return true;
                }
                statusCode = this.updatePeModelWithDataFields(workgroups, attachments, activity, payLoad, solutionData.getCasetypedata(caseName.trim()).getSharedInfo());
                JSONArray errors = new JSONArray();
                try {
                    errors = this.validateActivity(activity, solutionData, request, response, caseName);
                }
                catch (AcmException e) {
                    e.printStackTrace();
                    throw new ServletException((Throwable)e);
                }
                if (errors.size() > 0) {
                    responseJSON.put((Object)"status", (Object)"1");
                    responseJSON.put((Object)"errors", (Object)errors);
                    payLoad = responseJSON.toString();
                } else {
                    payLoad = "{  \"status\" : \"0\", \"errors\" : [\"  No Errors \"] }";
                }
                PrintWriter out = response.getWriter();
                out.write(payLoad);
                out.close();
                return true;
            }
        } else if (action.equalsIgnoreCase("REMOVE_ALL")) {
            try {
                this.removeAllNodes(this.getDiagrammer(this.getSDMView(request)));
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            return true;
        }
        AcmResponse acmResponse = new AcmResponse(statusCode, payLoad);
        return super.handleRequest(request, response);
    }

    private int loadActivity(AcmActivity activity, IlvDiagrammer diagrammer, String payLoad) {
        this.drawActivity(activity, diagrammer);
        return 0;
    }

    private int removeAllNodes(IlvDiagrammer diagrammer) {
        Object selectedNode = null;
        ArrayList Temp = new ArrayList();
        Iterator selectedObjects = diagrammer.getAllObjects();
        while (selectedObjects.hasNext()) {
            selectedNode = selectedObjects.next();
            Temp.add(selectedNode);
        }
        for (int i = 0; i < Temp.size(); ++i) {
            diagrammer.removeObject(Temp.get(i));
        }
        return 0;
    }

    private Map<String, AcmRoleInbasketproperties> returnListOfCasePropertiesUsedAsInBaskets(Set<String> queueNamesUsedInActivity, AcmCaseShareInfo caseShareInfo) {
        HashMap<String, AcmRoleInbasketproperties> propertiesUsedAsInBaskets = new HashMap<String, AcmRoleInbasketproperties>();
        Map props = (Map)caseShareInfo.getObject(AcmCaseShareInfo.INBASKET_PROP_MAP);
        if (props == null) {
            return propertiesUsedAsInBaskets;
        }
        Set pr = (Set)props.get("Inbox");
        if (pr != null && pr.size() != 0) {
            for (AcmRoleInbasketproperties p : pr) {
                propertiesUsedAsInBaskets.put(p.getSymName(), p);
            }
        }
        if (queueNamesUsedInActivity == null) {
            return propertiesUsedAsInBaskets;
        }
        for (String queueName : queueNamesUsedInActivity) {
            pr = (Set)props.get(queueName);
            if (pr == null || pr.size() == 0) continue;
            for (AcmRoleInbasketproperties p : pr) {
                propertiesUsedAsInBaskets.put(p.getSymName(), p);
            }
        }
        return propertiesUsedAsInBaskets;
    }

    private int updateActivity(SolutionData solutionData, HttpSession session, String caseName, AcmActivity activity, IlvDiagrammer diagrammer, String payLoad) {
        int statusCode = 0;
        try {
            log.trace((Object)">> Inside the updateActivity");
            log.trace((Object)"Before calling updateModel()");
            log.trace((Object)("caseShareInfo = " + solutionData.getCasetypedata(caseName).getSharedInfo()));
            activity.updateModel(diagrammer, true, solutionData.getCasetypedata(caseName.trim()).getSharedInfo());
            activity.autoResolveSplits();
            log.trace((Object)"Before calling updateModel()");
        }
        catch (DiagrammerException e) {
            log.info((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            statusCode = 1;
            Message msg = new Message("B6016E.INVALID_TASK_APPLY_DIAGRAM");
            payLoad = msg + ": " + e.toString();
        }
        catch (Exception e) {
            log.info((Object)e.getMessage(), (Throwable)e);
            log.info((Object)"UNHANDLED EXCEPTION");
            e.printStackTrace();
            statusCode = 1;
            Message msg = new Message("B6016E.INVALID_TASK_APPLY_DIAGRAM");
            payLoad = msg + ": " + e.toString();
        }
        solutionData.getCasetypedata(caseName.trim()).addActivity(activity);
        this.updateSessionMemory(session, solutionData);
        log.trace((Object)"<< Exiting the updateActivity");
        return statusCode;
    }

    private int updatePeModelWithDataFields(List<AcmWorkGroupDefinition> workgroups, List<AcmActivityAttachment> attachments, AcmActivity activity, String payLoad, AcmCaseShareInfo caseShareInfo) {
        VWWorkflowDefinition workflowDef = activity.getWorkflowDef();
        Set casePropertiesList = (Set)caseShareInfo.getObject(AcmCaseShareInfo.CASE_PROPERTIES_SYMBOLIC_LIST);
        VWFieldDefinition[] fieldDefs = null;
        try {
            fieldDefs = workflowDef.getFields();
        }
        catch (VWException e) {
            e.printStackTrace();
        }
        HashMap<String, String> existingFieldsArrayTypeMapping = new HashMap<String, String>();
        HashMap<String, Object> existingFieldsValueMapping = new HashMap<String, Object>();
        if (fieldDefs != null) {
            for (int i = 0; i < fieldDefs.length; ++i) {
                VWFieldDefinition field = fieldDefs[i];
                if (field.getFieldType() != 32 && field.getFieldType() != 64) continue;
                try {
                    if (field.getName().startsWith("F_")) continue;
                    existingFieldsArrayTypeMapping.put(field.getName(), new Boolean(field.isArray()).toString());
                    existingFieldsValueMapping.put(field.getName(), field.getValue());
                    workflowDef.deleteField(field.getName());
                    continue;
                }
                catch (VWException e) {
                    payLoad = e.getLocalizedMessage();
                    e.printStackTrace();
                    return 1;
                }
            }
            for (AcmWorkGroupDefinition workgroup : workgroups) {
                try {
                    if (workgroup.getName().startsWith("F_")) continue;
                    boolean isArray = true;
                    String defaultValue = AcmActivityEditorUtil.getDefaultValue(64, isArray);
                    if (existingFieldsArrayTypeMapping.containsKey(workgroup.getName())) {
                        isArray = new Boolean((String)existingFieldsArrayTypeMapping.get(workgroup.getName()));
                    }
                    if (existingFieldsValueMapping.containsKey(workgroup.getName())) {
                        workflowDef.createFieldUsingObject(workgroup.getName(), existingFieldsValueMapping.get(workgroup.getName()));
                    } else {
                        workflowDef.createFieldUsingString(workgroup.getName(), defaultValue, 64, isArray);
                    }
                    workflowDef.getField(workgroup.getName()).setDescription(workgroup.getDescription());
                }
                catch (VWException e) {
                    payLoad = e.getLocalizedMessage();
                    e.printStackTrace();
                    return 1;
                }
            }
            if (workflowDef.getMainAttachmentName() != null) {
                String existingMainAttach = workflowDef.getMainAttachmentName().replaceAll("\"", "");
                try {
                    if (!attachments.contains(existingMainAttach)) {
                        workflowDef.setMainAttachmentName(null);
                    }
                }
                catch (VWException e) {
                    e.printStackTrace();
                }
            }
            for (AcmActivityAttachment attachment : attachments) {
                try {
                    boolean isArray = true;
                    String defaultValue = AcmActivityEditorUtil.getDefaultValue(32, isArray);
                    if (existingFieldsArrayTypeMapping.containsKey(attachment.getName())) {
                        isArray = new Boolean((String)existingFieldsArrayTypeMapping.get(attachment.getName()));
                    }
                    if (existingFieldsValueMapping.containsKey(attachment.getName())) {
                        workflowDef.createFieldUsingObject(attachment.getName(), existingFieldsValueMapping.get(attachment.getName()));
                    } else {
                        workflowDef.createFieldUsingString(attachment.getName(), defaultValue, 32, isArray);
                    }
                    workflowDef.getField(attachment.getName()).setDescription(attachment.getDescription());
                    workflowDef.getField(attachment.getName()).setMergeType(6);
                    List<String> fillingTypeList = activity.getSdfData().getFilingDocumentTypeList();
                    boolean adhocActivity = activity.getSdfData().getUserCreatable();
                    if (fillingTypeList != null && !adhocActivity) {
                        if (fillingTypeList.size() > 0) {
                            if (!attachment.isInitAttachment()) continue;
                            workflowDef.setMainAttachmentName("\"" + attachment.getName() + "\"");
                            VWStepDefinition launchStep = workflowDef.getLaunchStep();
                            VWParameterDefinition paramDef = this.getParameterDefinition(attachment.getName(), launchStep);
                            if (paramDef != null) continue;
                            launchStep.createParameter(attachment.getName(), 3, attachment.getName(), 32, attachment.isArray());
                            continue;
                        }
                        workflowDef.setMainAttachmentName(null);
                        continue;
                    }
                    workflowDef.setMainAttachmentName(null);
                }
                catch (VWException e) {
                    payLoad = e.getLocalizedMessage();
                    e.printStackTrace();
                    return 1;
                }
            }
        }
        Set<String> queueNamesUsedInActivity = activity.returnRoleLanesQueueNames(caseShareInfo);
        Map<String, AcmRoleInbasketproperties> inbasketPropsMap = this.returnListOfCasePropertiesUsedAsInBaskets(queueNamesUsedInActivity, caseShareInfo);
        Set<String> casePropertiesUsedAsInBaskets = inbasketPropsMap.keySet();
        Set<String> casePropertiesInUse = activity.getCasePropertiesInUse();
        Set<String> casePropertiesAlreadyExistingInWorkflow = null;
        try {
            casePropertiesAlreadyExistingInWorkflow = AcmActivityEditorUtil.createCasePropertiesListFromVWWorkflow(workflowDef, casePropertiesList);
        }
        catch (DiagrammerException e1) {
            e1.printStackTrace();
        }
        Set casePropertiesThatCanBeDeleted = AcmActivityEditorUtil.difference(casePropertiesAlreadyExistingInWorkflow, casePropertiesInUse);
        casePropertiesThatCanBeDeleted = AcmActivityEditorUtil.difference(casePropertiesThatCanBeDeleted, casePropertiesUsedAsInBaskets);
        if (casePropertiesThatCanBeDeleted.size() != 0) {
            Iterator i3 = casePropertiesThatCanBeDeleted.iterator();
            if (fieldDefs != null) {
                while (i3.hasNext()) {
                    String defName = (String)i3.next();
                    for (int i = 0; i < fieldDefs.length; ++i) {
                        if (!fieldDefs[i].getName().equals(defName)) continue;
                        try {
                            workflowDef.deleteField(fieldDefs[i].getName());
                            continue;
                        }
                        catch (VWException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        this.createDataFieldsForInBaskets(workflowDef, inbasketPropsMap);
        activity.setWorkflowDef(workflowDef);
        try {
            activity.setWorkgroupDef(AcmActivityEditorUtil.createAcmWorkGroupListFromVWWorkflow(workflowDef));
        }
        catch (DiagrammerException e) {
            e.printStackTrace();
        }
        try {
            activity.setAttachments(AcmActivityEditorUtil.createAcmAttachmentListFromVWWorkflow(workflowDef));
        }
        catch (DiagrammerException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private synchronized void updateSessionMemory(HttpSession session, SolutionData solutionData) {
        log.debug((Object)">> updateSessionMemory()");
        if (session != null) {
            session.setAttribute("SolutionData", (Object)solutionData);
        } else {
            log.info((Object)"Session is invalid. Could not update session memory.");
        }
        log.debug((Object)"<< updateSessionMemory()");
    }

    private void updateWorkgroupsAndAttachmentsFromJSON(List<AcmWorkGroupDefinition> workgroups, JSONArray workgroupsJson, List<AcmActivityAttachment> attachments, JSONArray attachmentsJson) {
        int i;
        for (i = 0; i < workgroupsJson.size(); ++i) {
            JSONObject workgroup = (JSONObject)workgroupsJson.get(i);
            workgroups.add(new AcmWorkGroupDefinition((String)workgroup.get((Object)"name"), (String)workgroup.get((Object)"description")));
        }
        for (i = 0; i < attachmentsJson.size(); ++i) {
            JSONObject attachment = (JSONObject)attachmentsJson.get(i);
            attachments.add(new AcmActivityAttachment((String)attachment.get((Object)"name"), (String)attachment.get((Object)"description"), Boolean.parseBoolean((String)attachment.get((Object)"isinitattachment"))));
        }
    }

    private JSONArray validateActivity(AcmActivity activity, SolutionData solutionData, HttpServletRequest request, HttpServletResponse reponse, String caseName) throws AcmException {
        VWSystemConfiguration config = null;
        JSONArray errors = new JSONArray();
        try {
            config = solutionData.getPeconfigData().getSystemConfiguration();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        VWValidationError[] error = null;
        String sdfFile = new String();
        sdfFile = AcmActivityEditorUtil.createSdfFromSolutionType(solutionData.getConverterData().getSolutionType());
        log.debug((Object)("SDF FILE:" + sdfFile));
        StringBuffer buff = new StringBuffer();
        try {
            config.toXML(buff);
        }
        catch (VWException e1) {
            e1.printStackTrace();
        }
        log.debug((Object)("PE CONFIG FILE:" + buff));
        activity.getWorkflowDef().setValidateFlag(true);
        try {
            error = AcmActivityEditorUtil.validateActivity(activity, config, sdfFile);
        }
        catch (NullPointerException e) {
            log.info((Object)"ERROR: Validation could not be executed");
            e.printStackTrace();
            error = null;
        }
        catch (DiagrammerException e) {
            e.printStackTrace();
        }
        try {
            log.debug((Object)solutionData.getCasetypedata(caseName.trim()).toXPDLString());
        }
        catch (DiagrammerException e) {
            e.printStackTrace();
        }
        List<String> customValidationErrors = AcmActivityEditorUtil.doCustomValidationOfActivity(activity, request.getLocale());
        if (error != null) {
            for (int i = 0; i < error.length; ++i) {
                errors.add((Object)(error[i].getName() + ": " + error[i].getMessage()));
            }
        }
        if (customValidationErrors.size() > 0) {
            Iterator<String> i1 = customValidationErrors.iterator();
            while (i1.hasNext()) {
                errors.add((Object)i1.next());
            }
        }
        return errors;
    }

    private VWParameterDefinition getParameterDefinition(String paramName, VWStepDefinition stepDef) {
        VWParameterDefinition paramDef = null;
        try {
            paramDef = stepDef.getParameterDefinition(paramName);
        }
        catch (VWException ex) {
            log.error((Object)("Parameter: " + paramName + " does not exist for the step"));
        }
        return paramDef;
    }
}

