/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.servlet;

import com.ibm.acm.casebuilder.response.AcmResponse;
import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.acm.sold.servlet.HttpServletHelper;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SaveServlet
extends HttpServletHelper {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog((String)"CB");

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)">> doGet");
        this.doPost(request, response);
        log.trace((Object)"<< doGet");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String result;
        log.trace((Object)">> doPost");
        this.setClientLocaleForPE(request);
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter out = response.getWriter();
        String jsonstr = this.readPayload(request);
        String userName = request.getRemoteUser();
        log.debug((Object)("- JSON String from Client : " + jsonstr));
        boolean isWizard = "wizard".equals(request.getParameter("mode"));
        SolutionData solData = this.getSessionData(request);
        if (null == solData) {
            out.write("[ SESSION TIMED OUT ]");
            out.close();
            return;
        }
        solData.setUserName(userName);
        AcmException acmEx = null;
        try {
            if (solData.getXpdlThread() != null && Thread.State.TERMINATED != solData.getXpdlThread().getState()) {
                solData.getXpdlThread().join();
            }
        }
        catch (InterruptedException e) {
            Message msg = new Message("B4043E.THREAD_INTERRUPTED");
            acmEx = new AcmException(msg, (Throwable)e);
        }
        if (acmEx != null) {
            log.error(acmEx, acmEx);
            AcmResponse acmResponse = new AcmResponse(1, acmEx.getMessage(request.getLocale()), acmEx.getUid());
            result = acmResponse.toJson();
        } else {
            result = handle.save(isWizard, jsonstr, solData, request.getLocale());
        }
        out.write(result);
        log.info((Object)("Response received from save servlet is :" + result));
        out.close();
        this.putSessionData(request, solData);
        response.setStatus(200);
        log.trace((Object)"<< doPost");
    }
}

