/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.servlet;

import com.ibm.acm.casebuilder.response.AcmResponse;
import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.acm.sold.servlet.HttpServletHelper;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReadReferenceInfoServlet
extends HttpServletHelper {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog((String)"CB");

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)">> doGet");
        this.doPost(request, response);
        log.trace((Object)"<< doGet");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String result;
        log.trace((Object)">> doPost");
        SolutionData solData = this.getSessionData(request);
        PrintWriter out = response.getWriter();
        if (null == solData) {
            out.write("[ SESSION TIMED OUT ]");
            out.close();
            return;
        }
        AcmException acmEx = null;
        try {
            if (solData.getXpdlThread() != null && Thread.State.TERMINATED != solData.getXpdlThread().getState()) {
                solData.getXpdlThread().join();
                log.info((Object)"XPDL threads are joined.");
            }
        }
        catch (InterruptedException e) {
            Message msg = new Message("B4043E.THREAD_INTERRUPTED");
            acmEx = new AcmException(msg, (Throwable)e);
        }
        if (acmEx != null) {
            log.error(acmEx, acmEx);
            AcmResponse acmResponse = new AcmResponse(1, acmEx.getMessage(request.getLocale()), acmEx.getUid());
            result = acmResponse.toJson();
        } else {
            result = handle.getBackReference(solData);
        }
        out.write(result);
        log.info((Object)("Response received from ReadReferenceInfoServlet servlet is :" + result));
        out.close();
        response.setStatus(200);
        log.trace((Object)"<< doPost");
    }
}

