/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.servlet;

import com.ibm.acm.casebuilder.response.AcmResponse;
import com.ibm.acm.sold.comm.CaseTypeData;
import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.diagrammer.types.AcmActivity;
import com.ibm.acm.sold.diagrammer.types.AcmStepProcessorListWrapper;
import com.ibm.acm.sold.diagrammer.types.ui.AcmActivityUI;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.servlet.HttpServletHelper;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadXpdlServlet
extends HttpServletHelper {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog((String)LoadXpdlServlet.class.getName());

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)">> doGet");
        this.doPost(request, response);
        log.trace((Object)"<< doGet");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)">> doPost");
        this.setClientLocaleForPE(request);
        response.setHeader("Cache-Control", "no-cache");
        String casetypename = null;
        PrintWriter out = response.getWriter();
        String jsonstr = this.readPayload(request);
        String userName = request.getRemoteUser();
        log.debug((Object)("Obtained JSON:" + jsonstr));
        JSONObject js = null;
        String solutionJson = null;
        try {
            js = JSONObject.parse((String)jsonstr);
            casetypename = (String)js.get((Object)"caseName");
            solutionJson = js.get((Object)"solution").toString();
        }
        catch (IOException e) {
            log.error((Object)"Error Parsing the JSON, Exception occured");
            e.printStackTrace();
            out.write(e.getLocalizedMessage());
            out.close();
            return;
        }
        HttpSession sess = request.getSession(true);
        log.debug((Object)"Obtained Session object ---");
        SolutionData solData = (SolutionData)sess.getAttribute("SolutionData");
        if (solData == null) {
            solData = new SolutionData(sess);
            CaseTypeData newctData = new CaseTypeData();
            newctData.setSymName(casetypename);
            solData.setCasetypedata(casetypename, newctData);
        }
        solData.setUserName(userName);
        AcmResponse xpdlResult = null;
        JSONArray jsonarray = new JSONArray();
        xpdlResult = handle.loadXPDL(solutionJson, casetypename, solData, request.getLocale(), jsonarray);
        sess.setAttribute("SolutionData", (Object)solData);
        AcmResponse result = null;
        if (xpdlResult != null && xpdlResult.statusCode == 0) {
            String solutionPrefix;
            JSONObject responseJSON = new JSONObject();
            try {
                solutionPrefix = solData.getConverterData().getSolutionType().getPrefix();
            }
            catch (AcmException e) {
                e.printStackTrace();
                throw new ServletException((Throwable)e);
            }
            CaseTypeData loadedCase = solData.getCasetypedata(casetypename);
            JSONObject activitiesUIData = new JSONObject();
            JSONArray activitiesUI = new JSONArray();
            if (loadedCase != null) {
                Map<String, AcmActivity> activitiesInCase = loadedCase.getActivitiesMap();
                Iterator<String> activityNames = activitiesInCase.keySet().iterator();
                while (activityNames.hasNext()) {
                    AcmActivity temp = activitiesInCase.get(activityNames.next());
                    if (temp.isTaskForReuseWorkflow() || temp.getWorkgroupDef() == null) continue;
                    activitiesUI.add((Object)new AcmActivityUI(temp, loadedCase.getSharedInfo()).getActivityUiJson());
                }
            }
            activitiesUIData.put((Object)"ACTIVITIES_UI_DATA", (Object)activitiesUI);
            activitiesUIData.put((Object)"STEP_PAGES", (Object)new AcmStepProcessorListWrapper(solutionPrefix, solData.getStepPagesList(), solData.getStepLaunchPagesList()).toJSONObject());
            responseJSON.put((Object)"STEP_EDITOR_RESPONSE", (Object)activitiesUIData);
            responseJSON.put((Object)"id", (Object)"-1");
            if (jsonarray.size() > 0) {
                responseJSON.put((Object)"ActivityProcessNameMap", (Object)jsonarray);
            }
            result = new AcmResponse(0, responseJSON.toString());
            log.debug((Object)("LoadXPDL  Response ... :" + responseJSON.toString()));
        }
        if (result == null) {
            result = xpdlResult;
            log.error((Object)("LoadXPDL  returned Error Response ... :" + xpdlResult.statusCode));
        }
        out.write(result.toJson());
        out.close();
        log.trace((Object)"<< doPost");
    }
}

