/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.servlet;

import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.common.Config;
import com.ibm.acm.sold.common.Handle;
import com.ibm.acm.sold.connector.Utility;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import filenet.vw.base.UserContextInfo;
import filenet.vw.base.VWString;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpServletHelper
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog((String)"CB");
    public static final String TIMEOUTSTRING = "[ SESSION TIMED OUT ]";
    public static boolean configFileRead = false;
    protected static Handle handle = new Handle();
    protected Locale m_defaultLocale = null;

    public HttpServletHelper() {
        if (this.m_defaultLocale == null) {
            this.m_defaultLocale = Locale.getDefault();
        }
    }

    public synchronized void readConfig(ServletConfig config) throws ServletException, AcmException {
        log.trace((Object)">>  readConfig");
        if (configFileRead) {
            return;
        }
        Config cred = new Config();
        String localsystem = config.getServletContext().getInitParameter("localSystem");
        handle.setLocalFileSystem(Boolean.valueOf(localsystem));
        String configfile = System.getProperty("cbconfig");
        String sdfSchema = config.getServletContext().getInitParameter("SDFSchema");
        String cmisSchema = config.getServletContext().getInitParameter("CMISSchema");
        String cmisSchemaPath = config.getServletContext().getRealPath(cmisSchema);
        String sdfSchemaPath = config.getServletContext().getRealPath(sdfSchema);
        Config.setCMISSchemaPath(cmisSchemaPath);
        Config.setSDFSchemaPath(sdfSchemaPath);
        log.debug((Object)("Connfig file is " + configfile));
        if (configfile == null) {
            configFileRead = true;
            log.info((Object)"Config file is null");
            Message msg = new Message("B0002E.CONFIG_FILE_MISSING", "casebuilder.properties");
            log.error((Object)msg.getFormattedText());
            Config.setErrMsg(msg);
            return;
        }
        configFileRead = true;
        InputStream inp = null;
        try {
            inp = Utility.getResourceAsStream(configfile);
            if (inp == null) {
                Message msg = new Message("B0002E.CONFIG_FILE_MISSING", "casebuilder.properties");
                log.error((Object)msg.getFormattedText());
                Config.setErrMsg(msg);
                return;
            }
        }
        catch (AcmException e1) {
            log.debug((Object)"problme in reading the configfile");
            e1.printStackTrace();
        }
        Properties p = new Properties();
        try {
            p.load(inp);
        }
        catch (IOException e) {
            Message msg = new Message("B0003E.CONFIG_FILE_ERROR");
            log.error((Object)msg.getFormattedText());
            Config.setErrMsg(msg);
            return;
        }
        String objStore = p.getProperty("CMDOS");
        if (objStore == null || objStore.equals("")) {
            log.error((Object)"Object store is not provided");
            Message msg = new Message("B0015E.MISSING_OBJECTSTORE");
            log.info((Object)msg.getFormattedText());
            Config.setErrMsg(msg);
            return;
        }
        objStore = Utility.readAsUTF8(objStore);
        log.debug((Object)("object store  == " + objStore));
        cred.setObjStore(objStore);
        String ceuri = p.getProperty("ceURI");
        ceuri = Utility.readAsUTF8(ceuri);
        log.debug((Object)("CEURI == " + ceuri));
        cred.setCeUri(ceuri);
        String ceDomain = p.getProperty("ceDomain");
        ceDomain = Utility.readAsUTF8(ceDomain);
        log.debug((Object)("CEDomain == " + ceDomain));
        cred.setCeDomain(ceDomain);
        String caseUrl = p.getProperty("caseURL");
        caseUrl = Utility.readAsUTF8(caseUrl);
        log.debug((Object)("CaseUrl == " + caseUrl));
        cred.setCaseUrl(caseUrl);
        String cmisUrl = p.getProperty("cmisURL");
        cmisUrl = Utility.readAsUTF8(cmisUrl);
        log.debug((Object)("CmisUrl == " + cmisUrl));
        cred.setCmisUrl(cmisUrl);
        cred.setAuthenticationType(p.getProperty("jaasAuthentication"));
        cred.setUserName(p.getProperty("userName"));
        cred.setPassword(p.getProperty("password"));
        cred.setSolutionFolder(Utility.readAsUTF8("Solutions"));
        cred.setTemplateFolder(Utility.readAsUTF8("Solution Templates"));
        cred.setRootFolder(Utility.readAsUTF8("IBM Case Manager"));
        handle.setConfig(cred);
        log.trace((Object)"<<  readConfig");
    }

    protected SolutionData getSessionData(HttpServletRequest request) {
        SolutionData data = null;
        log.trace((Object)">>  getSessionData");
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null) {
            data = (SolutionData)httpSession.getAttribute("SolutionData");
            log.debug((Object)"Data is retrieved from user session");
            if (data == null) {
                log.debug((Object)"Creating new SolutionData object.");
                data = new SolutionData(httpSession);
            }
        } else {
            log.debug((Object)"Session is invalid, further access might be wrong.");
            return null;
        }
        log.trace((Object)"<<  getSessionData");
        return data;
    }

    protected void putSessionData(HttpServletRequest request, SolutionData data) {
        log.trace((Object)">>  putSessionData");
        HttpSession httpSession = request.getSession(true);
        if (httpSession != null) {
            httpSession.setAttribute("SolutionData", (Object)data);
            log.debug((Object)"data is stored in user session");
        }
        log.trace((Object)"<<  putSessionData");
    }

    protected String readPayload(HttpServletRequest request) throws IOException {
        ServletInputStream in = request.getInputStream();
        int length = request.getContentLength();
        int totalBytesread = 0;
        byte[] buf = new byte[length];
        StringBuilder result = new StringBuilder(length);
        int bytesRead = in.read(buf, 0, length);
        log.debug((Object)"Data read from the payload : ");
        log.debug((Object)"-------------------------------------");
        log.debug((Object)("Content Length : " + length));
        while (bytesRead > 0) {
            result.append(new String(buf, 0, bytesRead, "UTF-8"));
            totalBytesread += bytesRead;
            log.debug((Object)("Count of Partially read data :" + bytesRead));
            bytesRead = in.read(buf, 0, length);
        }
        log.debug((Object)("Total bytes read :" + totalBytesread));
        log.debug((Object)"-------------------------------------");
        in.close();
        return result.toString();
    }

    public void setClientLocaleForPE(HttpServletRequest request) {
        this.m_defaultLocale = Locale.getDefault();
        UserContextInfo userContext = UserContextInfo.get();
        userContext.setLocale(request.getLocale());
        VWString.getStringFromKey((String)"test");
        Locale browserLocale = VWString.getResourceBundleLocale();
        userContext.setLocale(browserLocale);
    }

    public void resetLocale() {
        UserContextInfo userContext = UserContextInfo.get();
        userContext.setLocale(this.m_defaultLocale);
    }

    public void destroy() {
    }
}

