/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.servlet;

import com.ibm.acm.casebuilder.flows.AcmRequest;
import com.ibm.acm.casebuilder.flows.ResourcePath;
import com.ibm.acm.casebuilder.flows.handlers.IResourceRequestHandler;
import com.ibm.acm.casebuilder.response.AcmResponse;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.servlet.HttpServletHelper;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FlowEditorServlet
extends HttpServletHelper {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog((String)FlowEditorServlet.class.getName());

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doMethod(request, response, METHOD_TYPE.GET);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doMethod(request, response, METHOD_TYPE.PUT);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doMethod(HttpServletRequest request, HttpServletResponse response, METHOD_TYPE method) throws ServletException, IOException {
        ResourcePath rcPath = new ResourcePath();
        AcmRequest acmRequest = new AcmRequest(request, handle.getConfig());
        AcmResponse acmResponse = null;
        try {
            String className = rcPath.getHandler(acmRequest.getResourceRequestURI());
            IResourceRequestHandler handler = (IResourceRequestHandler)Class.forName(className).newInstance();
            switch (method) {
                case GET: {
                    acmResponse = handler.doGet(acmRequest);
                    return;
                }
                case PUT: {
                    acmResponse = handler.doPut(acmRequest);
                    return;
                }
                case POST: {
                    acmResponse = handler.doPost(acmRequest);
                    return;
                }
                case DELETE: {
                    acmResponse = handler.doGet(acmRequest);
                    return;
                }
            }
            return;
        }
        catch (AcmException e) {
            e.printStackTrace();
            if (acmResponse != null) return;
            acmResponse = new AcmResponse(1, e.getLocalizedMessage(), e.getUid());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (acmResponse != null) return;
            acmResponse = new AcmResponse(1, e.getLocalizedMessage());
            return;
        }
        finally {
            try {
                PrintWriter out = response.getWriter();
                out.write(acmResponse.toJson());
                out.close();
                response.setStatus(200);
            }
            catch (Exception e) {
                response.setStatus(500);
            }
            response.setLocale(request.getLocale());
        }
    }

    private static enum METHOD_TYPE {
        GET,
        PUT,
        POST,
        DELETE;

    }
}

