/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.messages;

import com.ibm.acm.sold.messages.cache.CacheEvictionHandler;
import com.ibm.acm.sold.messages.cache.CacheException;
import com.ibm.acm.sold.messages.cache.CacheLoader;
import com.ibm.acm.sold.messages.cache.ObjectCache;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public final class ResourceBundleObjectCache {
    private static ObjectCache<LookupKey, ResourceBundle> cache = null;
    public static final int DEFAULT_CACHE_SIZE = 5;

    private ResourceBundleObjectCache() {
    }

    public static synchronized ObjectCache<LookupKey, ResourceBundle> init(Properties properties) {
        if (null == properties) {
            return null;
        }
        Loader loader = new Loader();
        EvictionHandler handler = new EvictionHandler();
        cache = new ObjectCache(properties);
        cache.setCacheLoader(loader);
        cache.setEvictionHandler(handler);
        return cache;
    }

    public static synchronized ObjectCache<LookupKey, ResourceBundle> getObjectCache() {
        if (null == cache) {
            Properties cacheDefaulProperties = new Properties();
            cacheDefaulProperties.put("cache.name", ResourceBundleObjectCache.class.getName());
            cacheDefaulProperties.put("cache.size", (Object)5);
            return ResourceBundleObjectCache.init(cacheDefaulProperties);
        }
        return cache;
    }

    public static final class EvictionHandler
    implements CacheEvictionHandler<ResourceBundle> {
        @Override
        public void handle(ResourceBundle o) {
        }
    }

    public static final class Loader
    implements CacheLoader<LookupKey, ResourceBundle> {
        @Override
        public ResourceBundle load(LookupKey key) throws CacheException {
            if (null == key) {
                return null;
            }
            ResourceBundle bundle = null;
            try {
                bundle = ResourceBundle.getBundle(key.getResourceBundleName(), key.getLocale());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            return bundle;
        }
    }

    static final class LookupKey {
        private String bundleName = null;
        private Locale locale = null;

        LookupKey(String bundleName, Locale locale) {
            if (null == bundleName) {
                bundleName = "";
            }
            if (null == locale) {
                locale = Locale.getDefault();
            }
            this.bundleName = bundleName;
            this.locale = locale;
        }

        public String getResourceBundleName() {
            return this.bundleName;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public boolean equals(LookupKey key) {
            if (null == key || null == this.bundleName || null == this.locale || null == key.bundleName || null == key.locale) {
                return false;
            }
            return this.locale.equals(key.locale) && this.bundleName.equals(key.bundleName);
        }

        public boolean equals(Object toCompare) {
            boolean retValue = false;
            retValue = null != toCompare && toCompare instanceof LookupKey && this.equals((LookupKey)toCompare);
            return retValue;
        }

        public int hashCode() {
            return (this.locale.toString() + this.bundleName).hashCode();
        }
    }
}

