/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.messages;

import com.ibm.acm.sold.messages.ResourceBundleObjectCache;
import com.ibm.acm.sold.messages.XMLTagger;
import com.ibm.acm.sold.messages.cache.CacheException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Message
implements Serializable {
    private static final String STRING_URL_ENCODING = "UTF-8";
    private static final char SEPARATOR = ' ';
    private static final String SEPARATOR_FALLBACK_REPLACEMENT = "_";
    private static final char QUOTE = '\"';
    private static final char NULL_REPLACMENT_CHAR = '*';
    private static final String NULL_REPLACEMENT_STRING = Character.toString('*');
    private static final char PARAM_LONG = 'L';
    private static final char PARAM_DOUBLE = 'D';
    private static final String MESSAGE_KEY_CONVENTION = "[a-zA-Z][0-9][0-9][0-9][0-9][EWI]\\..+";
    private static final Pattern MessageKeyPattern = Pattern.compile("[a-zA-Z][0-9][0-9][0-9][0-9][EWI]\\..+");
    private static final String MessageElement = "message";
    private static final String KeyElement = "key";
    private static final String ArgElement = "arg";
    public static final String PRODUCT_CODE = "FNRP";
    public static final String RESOURCE_BUNDLE_PREFIX = "com.ibm.acm.sold.messages.text.FNRP";
    private static final String DEFAULT_MESSAGE = "G0001I.DEFAULT_MESSAGE";
    public static final String TRACE_MESSAGE = "G0002I.TRACE_MESSAGE";
    public static final String EXTERNAL_INFO_MESSAGE = "G0019I.EXTERNAL_INFO_MESSAGE";
    public static final String EXTERNAL_ERROR_MESSAGE = "G0020E.EXTERNAL_ERROR_MESSAGE";
    private static final long serialVersionUID = 7084319511074933149L;
    private String msgKey = "G0001I.DEFAULT_MESSAGE";
    private ArrayList<Object> args = new ArrayList(4);

    public Message() {
    }

    public Message(String key) {
        this.setKey(key);
    }

    public Message(String key, Object ... arguments) {
        this.setKey(key);
        this.addArguments(arguments);
    }

    public Message(Message msg) {
        this.setMessage(msg);
    }

    public Message(Throwable throwable) {
        this.setKey(EXTERNAL_ERROR_MESSAGE);
        this.addArgument(null == throwable ? "" : throwable.toString());
    }

    public boolean isValid() {
        return Message.isValid(this.msgKey);
    }

    public static boolean isValid(String key) {
        if (null == key) {
            return false;
        }
        Matcher matcher = MessageKeyPattern.matcher(key);
        return matcher.matches();
    }

    public void setMessage(Message msg) {
        if (null == msg) {
            return;
        }
        this.msgKey = msg.msgKey;
        this.args.addAll(msg.args);
    }

    public void setKey(String key) {
        this.msgKey = key != null && key.length() > 0 ? key : DEFAULT_MESSAGE;
        this.args.clear();
    }

    public String getKey() {
        return this.msgKey;
    }

    public MessageType getMessageType() {
        int pos = this.msgKey.indexOf(".");
        if (pos < 0) {
            return MessageType.INFORMATIONAL;
        }
        if (this.msgKey.charAt(pos - 1) == 'I' || this.msgKey.charAt(pos - 1) == 'i') {
            return MessageType.INFORMATIONAL;
        }
        if (this.msgKey.charAt(pos - 1) == 'W' || this.msgKey.charAt(pos - 1) == 'w') {
            return MessageType.WARNING;
        }
        return MessageType.ERROR;
    }

    public String getDisplayKey() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(PRODUCT_CODE);
        String fullKey = this.getKey();
        int dotIndex = fullKey.indexOf(46);
        if (dotIndex >= 0) {
            sb.append(fullKey.substring(0, dotIndex));
        } else {
            sb.append(fullKey);
        }
        return sb.toString();
    }

    public String getResourceBundleName() {
        return RESOURCE_BUNDLE_PREFIX + this.msgKey.charAt(0);
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        if (null == locale) {
            locale = Locale.getDefault();
        }
        ResourceBundleObjectCache.LookupKey key = new ResourceBundleObjectCache.LookupKey(this.getResourceBundleName(), locale);
        ResourceBundle resBundle = null;
        try {
            resBundle = ResourceBundleObjectCache.getObjectCache().get(key);
        }
        catch (CacheException e) {
            resBundle = null;
        }
        return resBundle;
    }

    public String getText(Locale locale) {
        ResourceBundle resBundle;
        String msgText = null;
        if (this.isValid() && null != (resBundle = this.getResourceBundle(locale))) {
            try {
                msgText = resBundle.getString(this.msgKey);
            }
            catch (MissingResourceException mre) {
                msgText = null;
            }
        }
        return msgText;
    }

    private String escapeQuotes(String str) {
        String newStr = str.replaceAll("''", "'");
        newStr = newStr.replaceAll("'", "''");
        newStr = newStr.replaceAll("\"", "''");
        return newStr;
    }

    public static String getText(String key, Locale locale) {
        return new Message(key).getText(locale);
    }

    public String getFormattedTextWithDisplayKey() {
        return this.getFormattedTextWithDisplayKey(Locale.getDefault());
    }

    public String getFormattedTextWithDisplayKey(Locale locale) {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getDisplayKey());
        sb.append(" ");
        sb.append(this.getFormattedText(locale));
        return sb.toString();
    }

    public String getFormattedText() {
        return this.getFormattedText(Locale.getDefault());
    }

    public String getFormattedText(Locale locale) {
        String msgText = null;
        Message msgToUse = this;
        if (!this.isValid()) {
            msgToUse = new Message(EXTERNAL_ERROR_MESSAGE);
            msgToUse.addArgument(this.toString());
        }
        if (null == locale) {
            locale = Locale.getDefault();
        }
        if (null != (msgText = msgToUse.getText(locale))) {
            msgText = this.escapeQuotes(msgText);
            MessageFormat msgFormat = new MessageFormat(msgText, locale);
            try {
                StringBuffer buffer = new StringBuffer(msgText.length());
                msgFormat.format(msgToUse.getArguments(), buffer, (FieldPosition)null);
                msgText = buffer.toString();
            }
            catch (IllegalArgumentException iae) {
                msgText = null;
            }
        }
        if (null == msgText) {
            msgText = msgToUse.toString();
        }
        return msgText;
    }

    public void addArgument(long arg) {
        this.args.add(arg);
    }

    public void addArgument(Long arg) {
        if (null == arg) {
            arg = 0L;
        }
        this.args.add(arg);
    }

    public void addArgument(double arg) {
        this.args.add(arg);
    }

    public void addArgument(Double arg) {
        if (null == arg) {
            arg = 0.0;
        }
        this.args.add(arg);
    }

    public void addArgument(String arg) {
        if (null == arg) {
            arg = "";
        }
        this.args.add(arg);
    }

    public void addArgument(Object arg) {
        if (arg == null) {
            this.addArgument("");
        } else if (arg instanceof Double) {
            this.addArgument((Double)arg);
        } else if (arg instanceof Long) {
            this.addArgument((Long)arg);
        } else if (arg instanceof String) {
            this.addArgument((String)arg);
        } else {
            this.addArgument(arg.toString());
        }
    }

    public void addArguments(Object[] arguments) {
        if (null == arguments) {
            return;
        }
        for (int i = 0; i < arguments.length; ++i) {
            this.addArgument(arguments[i]);
        }
    }

    public Object[] getArguments() {
        return this.args.toArray();
    }

    public StringBuffer toString(StringBuffer toAppend) {
        toAppend.append(this.msgKey);
        Object[] params = this.getArguments();
        if (null != params) {
            for (int i = 0; i < params.length; ++i) {
                toAppend.append(' ');
                toAppend.append('[');
                toAppend.append(null == params[i] ? "" : params[i].toString());
                toAppend.append(']');
            }
        }
        return toAppend;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        return this.toString(buffer).toString();
    }

    public boolean equalMsg(Message otherMsg) {
        boolean equal = false;
        if (otherMsg != null) {
            String otherMsgKey = otherMsg.getKey();
            if (this.msgKey != null && otherMsgKey != null && this.msgKey.equals(otherMsgKey)) {
                Object[] myParams = this.getArguments();
                Object[] otherParms = otherMsg.getArguments();
                if (myParams != null && otherParms != null && myParams.length == otherParms.length) {
                    equal = true;
                    for (int i = 0; i < myParams.length && equal; ++i) {
                        equal = myParams[i].equals(otherParms[i]);
                    }
                } else if (myParams == null && otherParms == null) {
                    equal = true;
                }
            }
        }
        return equal;
    }

    public void writeTo(XMLTagger xmlTagger) {
        xmlTagger.startElement(MessageElement);
        xmlTagger.startElement(KeyElement);
        xmlTagger.writeText(this.getKey());
        xmlTagger.endElement(KeyElement);
        if (this.args != null && this.args.size() > 0) {
            for (int i = 0; i < this.args.size(); ++i) {
                xmlTagger.startElement(ArgElement);
                xmlTagger.writeText(this.args.get(i).toString());
                xmlTagger.endElement(ArgElement);
            }
        }
        xmlTagger.endElement(MessageElement);
    }

    public void clearArguments() {
        this.args.clear();
    }

    public String toTextFormat() {
        StringBuilder sb = new StringBuilder(512);
        this.append(sb, this.msgKey);
        int count = 0;
        if (this.args != null) {
            count = this.args.size();
        }
        this.append(sb, count);
        Object curParam = null;
        for (int i = 0; i < count; ++i) {
            curParam = this.args.get(i);
            if (null == curParam) {
                this.appendParam(sb, null);
                continue;
            }
            if (curParam instanceof String) {
                this.appendParam(sb, (String)curParam);
                continue;
            }
            if (curParam instanceof Double) {
                this.appendParam(sb, (Double)curParam);
                continue;
            }
            if (curParam instanceof Long) {
                this.appendParam(sb, (Long)curParam);
                continue;
            }
            this.appendParam(sb, curParam.toString());
        }
        return sb.toString();
    }

    public static Message fromTextFormat(InputStream is) throws IOException {
        String key = Message.getNextElementFromStream(is);
        String paramCountStr = Message.getNextElementFromStream(is);
        int paramCount = Integer.parseInt(paramCountStr);
        Object[] parms = new Object[paramCount];
        for (int i = 0; i < parms.length; ++i) {
            parms[i] = Message.getNextParamFromStream(is);
        }
        Message msg = new Message(key);
        msg.addArguments(parms);
        return msg;
    }

    private void append(StringBuilder sb, String string) {
        if (null == string || 0 == string.trim().length()) {
            string = NULL_REPLACEMENT_STRING;
        }
        try {
            sb.append(URLEncoder.encode(string, STRING_URL_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            sb.append(string.replaceAll(Character.toString(' '), SEPARATOR_FALLBACK_REPLACEMENT));
        }
        sb.append(' ');
    }

    private void append(StringBuilder sb, long numeric) {
        sb.append(numeric);
        sb.append(' ');
    }

    private void appendParam(StringBuilder sb, String string) {
        if (null == string) {
            string = "";
        }
        sb.append('\"');
        sb.append(XMLTagger.escapeXMLValue(string));
        sb.append('\"');
        sb.append(' ');
    }

    private void appendParam(StringBuilder sb, long numeric) {
        sb.append(numeric);
        sb.append('L');
        sb.append(' ');
    }

    private void appendParam(StringBuilder sb, double numeric) {
        sb.append(numeric);
        sb.append('D');
        sb.append(' ');
    }

    private static String getNextElementFromStream(InputStream is) throws IOException {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(100);
        byteBuffer.reset();
        int lastReadByte = is.read();
        while (lastReadByte != -1 && lastReadByte != 32) {
            byteBuffer.write(lastReadByte);
            lastReadByte = is.read();
        }
        if (lastReadByte == -1) {
            return null;
        }
        String retString = byteBuffer.toString(STRING_URL_ENCODING);
        if (retString.equals(NULL_REPLACEMENT_STRING)) {
            retString = null;
        }
        return retString;
    }

    private static Object getNextParamFromStream(InputStream is) throws IOException {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(100);
        Object retParam = null;
        byteBuffer.reset();
        int lastReadByte = is.read();
        if (lastReadByte != 34) {
            while (lastReadByte != -1 && lastReadByte != 32) {
                byteBuffer.write(lastReadByte);
                lastReadByte = is.read();
            }
            String numericString = byteBuffer.toString(STRING_URL_ENCODING);
            char lastChar = numericString.charAt(numericString.length() - 1);
            retParam = lastChar == 'D' ? (Number)new Double(numericString.substring(0, numericString.length() - 1)) : (Number)new Long(numericString.substring(0, numericString.length() - 1));
        } else {
            lastReadByte = is.read();
            while (lastReadByte != -1 && lastReadByte != 34) {
                byteBuffer.write(lastReadByte);
                lastReadByte = is.read();
            }
            if (lastReadByte != 34) {
                return null;
            }
            lastReadByte = is.read();
            if (lastReadByte != 32) {
                return null;
            }
            String strParam = byteBuffer.toString(STRING_URL_ENCODING);
            retParam = (strParam = XMLTagger.unescapeXMLValue(strParam)).length() == 1 && strParam.charAt(0) == '\u0000' ? null : strParam;
        }
        return retParam;
    }

    public static void main(String[] args) {
        Message msg = new Message();
        msg.setKey(DEFAULT_MESSAGE);
        msg.setKey(TRACE_MESSAGE);
        msg.setKey("UNDEFINED_KEY");
    }

    public Object getArgument(int index) {
        return this.args.get(index);
    }

    public int getArgumentsCount() {
        return this.args.size();
    }

    public String getValue() {
        return this.msgKey;
    }

    public static enum MessageType {
        INFORMATIONAL,
        WARNING,
        ERROR;

    }
}

