/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.jaxb;

import com.ibm.acm.sold.common.Config;
import com.ibm.acm.sold.connector.Utility;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.jaxb.NamespacePrefixMapperImpl;
import com.ibm.acm.sold.messages.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public final class JAXBSingleton {
    private static final String JAXB_PACKAGE_LIST = "com.ibm.xmlns.prod.ecm.acm.sdf:org.oasis_open.docs.ns.cmis.core._200908:com.ibm.xmlns.prod.ecm.cmis.caseextensions";
    private static volatile JAXBSingleton me = null;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private static final Log log = LogFactory.getLog((String)JAXBSingleton.class.getName());

    public static JAXBSingleton getSingleton() {
        if (me == null) {
            me = new JAXBSingleton();
        }
        return me;
    }

    private JAXBSingleton() {
    }

    public Object deserialize(String input) throws JAXBException {
        JAXBElement j = null;
        this.loadMarshallerAndUnmarshaller();
        StringReader rdr = new StringReader(input);
        j = (JAXBElement)this.unmarshaller.unmarshal((Reader)rdr);
        return j.getValue();
    }

    private synchronized void loadMarshallerAndUnmarshaller() throws JAXBException {
        if (this.marshaller == null) {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGE_LIST);
            this.marshaller = jaxbContext.createMarshaller();
            this.unmarshaller = jaxbContext.createUnmarshaller();
            this.marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperImpl());
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        }
    }

    public synchronized InputStream writeOutput(Object o) throws JAXBException, AcmException {
        InputStream sdfStream;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)out, "UTF8");
        }
        catch (UnsupportedEncodingException e1) {
            Message msg = new Message("B4031E.CONVERSION_EXCEPTION");
            throw new AcmException(msg, (Throwable)e1);
        }
        String cmisSchemaPath = Config.getCMISSchemaPath();
        log.debug((Object)("CMIS schema path is :: " + cmisSchemaPath));
        String sdfSchemaPath = Config.getSDFSchemaPath();
        log.debug((Object)("SDF schema path is ::" + sdfSchemaPath));
        InputStream cmisStream = Utility.getResourceAsStream(cmisSchemaPath);
        if (cmisStream == null) {
            log.debug((Object)"CMIS schema file could not be found.");
        }
        if ((sdfStream = Utility.getResourceAsStream(sdfSchemaPath)) == null) {
            log.debug((Object)"SDF schema file could not be found.");
        }
        this.loadMarshallerAndUnmarshaller();
        try {
            InputStream[] schemaStreams = new InputStream[]{cmisStream, sdfStream};
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Source[] sources = new Source[schemaStreams.length];
            for (int i = 0; i < schemaStreams.length; ++i) {
                sources[i] = new StreamSource(schemaStreams[i]);
            }
            Schema schema = sf.newSchema(sources);
            this.marshaller.setSchema(schema);
            this.marshaller.marshal(o, (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (SAXException e) {
            e.printStackTrace();
            Message msg = new Message("B4030E.SOLUTION_CORRUPTED");
            throw new AcmException(msg, (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            Message msg = new Message("B4030E.SOLUTION_CORRUPTED", e.getLocalizedMessage());
            throw new AcmException(msg, (Throwable)e);
        }
        try {
            cmisStream.close();
            sdfStream.close();
        }
        catch (Exception e) {
            log.error((Object)("error in closing sdf/cmis streams :: " + e.getLocalizedMessage()));
            throw new AcmException(e);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(out.toByteArray());
        return inputStream;
    }
}

