/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.jaxb;

import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.jaxb.JAXBSingleton;
import com.ibm.acm.sold.messages.Message;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypeType;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypesType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ChoiceListDefinitionType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ChoiceListDefinitionsType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ChoiceListIntegerDefinitionType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ChoiceListStringDefinitionType;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumChoiceListType;
import com.ibm.xmlns.prod.ecm.acm.sdf.ObjectFactory;
import com.ibm.xmlns.prod.ecm.acm.sdf.PropertyDefinitionsType;
import com.ibm.xmlns.prod.ecm.acm.sdf.SolutionType;
import com.ibm.xmlns.prod.ecm.acm.sdf.TaskType;
import com.ibm.xmlns.prod.ecm.acm.sdf.TypeDefinitionsType;
import java.io.FileNotFoundException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.oasis_open.docs.ns.cmis.core._200908.CmisChoiceInteger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisChoiceString;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyIntegerDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyStringDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisTypeDefinitionType;

public class JAXBRetrieve {
    private static final String JAXB_PACKAGE_LIST = CaseTypeType.class.getPackage().getName() + ":" + CmisObjectType.class.getPackage().getName() + ":" + "com.ibm.xmlns.prod.ecm.cmis.caseextensions";
    private Marshaller marshaller;
    private String sdfContent;
    private static final Log log = LogFactory.getLog((String)JAXBRetrieve.class.getName());

    public JAXBRetrieve(String sdfContent) {
        this.sdfContent = sdfContent;
    }

    public JAXBRetrieve() {
    }

    public SolutionType retrieveSolution() throws AcmException, JAXBException {
        JAXBSingleton js = JAXBSingleton.getSingleton();
        Object sol = js.deserialize(this.sdfContent);
        SolutionType solntype = (SolutionType)sol;
        log.debug((Object)("retrieved solution name" + solntype.getName()));
        this.updateChoiceLists(solntype);
        return solntype;
    }

    private synchronized void loadMarshaller() throws AcmException {
        if (this.marshaller == null) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGE_LIST);
                this.marshaller = jaxbContext.createMarshaller();
            }
            catch (JAXBException e) {
                Message msg = new Message("B4030E.SOLUTION_CORRUPTED");
                throw new AcmException(msg, (Throwable)e);
            }
            try {
                this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            catch (PropertyException e) {
                Message msg = new Message("B4030E.SOLUTION_CORRUPTED");
                throw new AcmException(msg, (Throwable)e);
            }
        }
    }

    public String getConvXml(SolutionType solntype) throws JAXBException, FileNotFoundException, AcmException {
        ObjectFactory factory = new ObjectFactory();
        StringWriter writer = new StringWriter(10000);
        this.loadMarshaller();
        try {
            this.marshaller.marshal((Object)factory.createSolution(solntype), (Writer)writer);
        }
        catch (JAXBException e) {
            Message msg = new Message("B4030E.SOLUTION_CORRUPTED");
            throw new AcmException(msg, (Throwable)e);
        }
        return writer.toString();
    }

    public SolutionType getSolutionTypeObj() throws AcmException {
        SolutionType st = null;
        try {
            st = this.retrieveSolution();
        }
        catch (JAXBException e) {
            log.error((Object)("JaxB Exception" + (Object)((Object)e)));
            Message msg = new Message("B4030E.SOLUTION_CORRUPTED");
            throw new AcmException(msg, (Throwable)e);
        }
        return st;
    }

    public String retrieve() throws AcmException {
        String result = "";
        try {
            SolutionType rawSt = this.retrieveSolution();
            SolutionType st = JAXBRetrieve.updateSolutionObj(rawSt);
            try {
                result = this.getConvXml(st);
            }
            catch (FileNotFoundException e) {
                log.error((Object)("File not found while retrieving the solution" + e));
                Message msg = new Message("B4026E.CONTENT_RETRIEVAL_FAILED");
                throw new AcmException(msg, (Throwable)e);
            }
        }
        catch (JAXBException e) {
            log.error((Object)("JaxB Exception" + (Object)((Object)e)));
            Message msg = new Message("B4030E.SOLUTION_CORRUPTED");
            throw new AcmException(msg, (Throwable)e);
        }
        StringBuilder sbxml = new StringBuilder(result);
        int i = result.indexOf("name", 0);
        sbxml.delete(0, i - 5);
        result = sbxml.toString();
        result = result.replace("ns2:", "");
        result = result.replace("ns3:", "");
        log.debug((Object)("\nretrieve result in the JAXBRetrieve:" + result));
        return result;
    }

    public String updateAndRetrieve(SolutionType rawSt) throws AcmException {
        String result = "";
        try {
            SolutionType st = JAXBRetrieve.updateSolutionObj(rawSt);
            try {
                result = this.getConvXml(st);
            }
            catch (FileNotFoundException e) {
                log.error((Object)("File not found while retrieving the solution" + e));
                Message msg = new Message("B4026E.CONTENT_RETRIEVAL_FAILED");
                throw new AcmException(msg, (Throwable)e);
            }
        }
        catch (JAXBException e) {
            log.error((Object)("JaxB Exception" + (Object)((Object)e)));
            Message msg = new Message("B4030E.SOLUTION_CORRUPTED");
            throw new AcmException(msg, (Throwable)e);
        }
        StringBuilder sbxml = new StringBuilder(result);
        int i = result.indexOf("name", 0);
        sbxml.delete(0, i - 5);
        result = sbxml.toString();
        result = result.replace("ns2:", "");
        result = result.replace("ns3:", "");
        log.debug((Object)("\nretrieve result in the JAXBRetrieve:" + result));
        return result;
    }

    public static SolutionType updateSolutionObj(SolutionType soln) {
        ChoiceListDefinitionsType choiceListTypes;
        List cases;
        CaseTypesType caseTypes = new CaseTypesType();
        PropertyDefinitionsType props = new PropertyDefinitionsType();
        TypeDefinitionsType types = new TypeDefinitionsType();
        caseTypes = soln.getCaseTypes();
        if (caseTypes.getCaseType().size() == 0) {
            soln.setCaseTypes(null);
        }
        if ((types = soln.getTypes()).getTypeDefinition().size() == 0) {
            soln.setTypes(null);
        } else {
            for (CmisTypeDefinitionType d : types.getTypeDefinition()) {
                if (d.getId() == null || d.getId().length() <= 0) continue;
                d.setId("-1");
            }
        }
        props = soln.getProperties();
        if (props.getPropertyDefinition().size() == 0) {
            soln.setProperties(null);
        } else {
            for (CmisPropertyDefinitionType p : props.getPropertyDefinition()) {
                if (p.getId() == null || p.getId().length() <= 0) continue;
                p.setId("-1");
            }
        }
        if (soln != null && soln.getCaseTypes() != null && (cases = soln.getCaseTypes().getCaseType()) != null) {
            for (CaseTypeType caseType : cases) {
                if (caseType.getId() != null) {
                    caseType.setId("-1");
                }
                if (caseType.getTasks().getTask().size() == 0 && caseType.getTasks().getTaskGroup().size() == 0) {
                    caseType.setTasks(null);
                } else {
                    for (TaskType t : caseType.getTasks().getTask()) {
                        if (t.getId() == null) continue;
                        t.setId("-1");
                    }
                }
                if (caseType.getViews().getView().size() == 0) {
                    caseType.setViews(null);
                }
                if (caseType.getCaseProperties().getPropertyDefinition().size() == 0) {
                    caseType.setCaseProperties(null);
                    continue;
                }
                for (CmisPropertyDefinitionType p : caseType.getCaseProperties().getPropertyDefinition()) {
                    if (p.getId() == null) continue;
                    p.setId("-1");
                }
            }
        }
        if (soln != null && (choiceListTypes = soln.getChoiceLists()) != null) {
            log.debug((Object)"Choicelist is not empty");
            for (ChoiceListDefinitionType chlist : choiceListTypes.getChoiceListDefinition()) {
                if (chlist.getId() != null && chlist.getId().length() > 0) {
                    chlist.setId("-1");
                }
                log.debug((Object)"Solution object is updated with GUID of choice list set to -1");
            }
        }
        soln.setProductName(null);
        soln.setVendorName(null);
        soln.setProductVersion(null);
        return soln;
    }

    public void updateChoiceLists(SolutionType solutionType) {
        log.trace((Object)">updateChoiceLists");
        String schemaVersion = solutionType.getSchemaVersion();
        ChoiceListDefinitionsType choicelist = new ChoiceListDefinitionsType();
        if (schemaVersion.equals("1.0")) {
            log.info((Object)(" Version :" + schemaVersion + " Schema "));
            PropertyDefinitionsType props = solutionType.getProperties();
            if (props != null && props.getPropertyDefinition().size() != 0) {
                for (CmisPropertyDefinitionType p : props.getPropertyDefinition()) {
                    String modifiedListName;
                    String listName;
                    ChoiceListStringDefinitionType chd;
                    String propertyType = p.getPropertyType().toString();
                    if (propertyType.equalsIgnoreCase("string") && ((CmisPropertyStringDefinitionType)p).getChoice().size() > 0) {
                        log.debug((Object)"String type choice list");
                        chd = new ChoiceListStringDefinitionType();
                        CmisChoiceString stringChoiceList = new CmisChoiceString();
                        chd.setType(EnumChoiceListType.STRING);
                        listName = ((CmisChoiceString)((CmisPropertyStringDefinitionType)p).getChoice().get(0)).getDisplayName();
                        log.debug((Object)("Original list name " + listName));
                        modifiedListName = listName + "List";
                        if (listName.endsWith("List")) {
                            modifiedListName = listName;
                        }
                        stringChoiceList.getChoice().addAll(((CmisChoiceString)((CmisPropertyStringDefinitionType)p).getChoice().get(0)).getChoice());
                        stringChoiceList.setDisplayName(listName);
                        if (((CmisPropertyStringDefinitionType)p).getId() != null && ((CmisPropertyStringDefinitionType)p).getId().length() > 0) {
                            chd.setId(((CmisPropertyStringDefinitionType)p).getId());
                            stringChoiceList.setDisplayName(modifiedListName);
                            log.debug((Object)("Modified Choice list name :" + modifiedListName));
                            ((CmisChoiceString)((CmisPropertyStringDefinitionType)p).getChoice().get(0)).setDisplayName(modifiedListName);
                        }
                        chd.setChoice(stringChoiceList);
                        choicelist.getChoiceListDefinition().add(chd);
                        continue;
                    }
                    if (propertyType.equalsIgnoreCase("integer") && ((CmisPropertyIntegerDefinitionType)p).getChoice().size() > 0) {
                        log.debug((Object)"Integer type choice list");
                        chd = new ChoiceListIntegerDefinitionType();
                        CmisChoiceInteger integerChoiceList = new CmisChoiceInteger();
                        chd.setType(EnumChoiceListType.INTEGER);
                        listName = ((CmisChoiceInteger)((CmisPropertyIntegerDefinitionType)p).getChoice().get(0)).getDisplayName();
                        modifiedListName = listName + "List";
                        log.debug((Object)("Original list name " + listName));
                        if (listName.endsWith("List")) {
                            modifiedListName = listName;
                        }
                        integerChoiceList.getChoice().addAll(((CmisChoiceInteger)((CmisPropertyIntegerDefinitionType)p).getChoice().get(0)).getChoice());
                        integerChoiceList.setDisplayName(listName);
                        if (((CmisPropertyIntegerDefinitionType)p).getId() != null && ((CmisPropertyIntegerDefinitionType)p).getId().length() > 0) {
                            chd.setId(((CmisPropertyIntegerDefinitionType)p).getId());
                            ((CmisChoiceInteger)((CmisPropertyIntegerDefinitionType)p).getChoice().get(0)).setDisplayName(modifiedListName);
                            integerChoiceList.setDisplayName(modifiedListName);
                            log.debug((Object)("Modified Choice list name :" + modifiedListName));
                        }
                        chd.setChoice(integerChoiceList);
                        choicelist.getChoiceListDefinition().add(chd);
                        continue;
                    }
                    log.debug((Object)("Property doesn't have ChoiceList : " + propertyType));
                }
            }
            solutionType.setChoiceLists(choicelist);
        }
        log.trace((Object)"<updateChoiceLists");
    }
}

