/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.info;

import com.ibm.acm.sold.comm.CaseTypeData;
import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.common.type.RoleType;
import com.ibm.acm.sold.common.type.RolesType;
import com.ibm.acm.sold.diagrammer.exceptions.DiagrammerException;
import com.ibm.acm.sold.diagrammer.types.AcmActivity;
import com.ibm.acm.sold.diagrammer.types.AcmTask;
import com.ibm.acm.sold.diagrammer.types.AcmTaskParameter;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypeType;
import com.ibm.xmlns.prod.ecm.acm.sdf.CaseTypesType;
import com.ibm.xmlns.prod.ecm.acm.sdf.SolutionType;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;

public class ReferenceInfo {
    private static final Log log = LogFactory.getLog((String)"ReferenceInfo");
    private final SolutionData data;
    ArrayList<String> roleInUse = new ArrayList(100);
    ArrayList<String> propInUse = new ArrayList(100);

    public ArrayList<String> getRoleInUse() {
        return this.roleInUse;
    }

    public void setRoleInUse(String roleName) {
        this.roleInUse.add(roleName);
    }

    public ArrayList<String> getPropInUse() {
        return this.propInUse;
    }

    public void setPropInUse(String propName) {
        this.propInUse.add(propName);
    }

    public ReferenceInfo(SolutionData solData) {
        this.data = solData;
    }

    public String readReferenceInfo() throws DiagrammerException {
        int indexOfProperty;
        int lenghtOfRole;
        String newRoleRef;
        String fullReference = "";
        String roleReference = this.readRoleInfo();
        int indexOfRole = roleReference.indexOf("roleRefs");
        if (indexOfRole != -1 && !(newRoleRef = roleReference.substring(indexOfRole - 1, (lenghtOfRole = roleReference.length()) - 1)).equals("")) {
            fullReference = "{" + newRoleRef + "}";
        }
        log.debug((Object)("role reference info" + roleReference));
        String propertyReference = this.readPropertiesInfo();
        log.debug((Object)(" property reference info" + propertyReference));
        if (propertyReference != "" && (indexOfProperty = propertyReference.indexOf("propertyRefs")) != -1) {
            int lenghtOfProp = propertyReference.length();
            String newPropRef = propertyReference.substring(indexOfProperty - 1, lenghtOfProp - 1);
            if (!newPropRef.equals("") && fullReference.length() > 0) {
                fullReference = fullReference.substring(0, fullReference.length() - 1) + "," + newPropRef + "}";
            } else if (!newPropRef.equals("") && fullReference.length() == 0) {
                fullReference = "{" + newPropRef + "}";
            }
        }
        return fullReference;
    }

    private String readRoleInfo() throws DiagrammerException {
        String roleRef = "";
        JSONObject jCase = null;
        JSONArray jCaseArray = null;
        JSONObject jRole = new JSONObject();
        JSONObject jRoleRef = new JSONObject();
        if (this.data == null) {
            return null;
        }
        SolutionType uisolutionType = null;
        try {
            uisolutionType = this.data.getConverterData().getSolutionType();
        }
        catch (AcmException e) {
            log.error((Object)e, (Throwable)e);
        }
        RolesType roles = this.data.getRoles();
        if (roles != null) {
            for (RoleType tempRole : roles.getRoleTable().values()) {
                CaseTypesType caseTypes = uisolutionType.getCaseTypes();
                jCaseArray = new JSONArray();
                if (caseTypes != null) {
                    for (CaseTypeType caseType : caseTypes.getCaseType()) {
                        CaseTypeData caseData = this.data.getCasetypedata(caseType.getName());
                        if (caseData != null) {
                            Map<String, AcmActivity> activitiesMap = caseData.getActivitiesMap();
                            Boolean flag = false;
                            if (activitiesMap == null) continue;
                            Object taskName = null;
                            JSONArray taskArray = new JSONArray();
                            for (AcmActivity activity : activitiesMap.values()) {
                                if (activity == null) continue;
                                VWAttributeInfo attributes = null;
                                try {
                                    if (activity.getWorkflowDef() != null) {
                                        attributes = activity.getWorkflowDef().getAttributeInfo();
                                    }
                                    if (attributes == null) {
                                        log.info((Object)("Attributes are null in the current work flow" + activity.getName()));
                                        continue;
                                    }
                                    String[] swimLanesArray = (String[])attributes.getFieldValue("SwimLanes");
                                    for (int i = 0; i < swimLanesArray.length; ++i) {
                                        String[] params = swimLanesArray[i].split(",");
                                        if (params.length != 5) {
                                            throw new DiagrammerException("Invalid SwimLaneInfo");
                                        }
                                        String currentRole = params[0];
                                        if (!tempRole.getName().equals(currentRole) || !params[3].equalsIgnoreCase("ROLE")) continue;
                                        flag = true;
                                        taskArray.add((Object)activity.getSymbolicName());
                                        this.setRoleInUse(params[0]);
                                    }
                                }
                                catch (VWException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (!flag.booleanValue()) continue;
                            jCase = new JSONObject();
                            jCase.put((Object)caseType.getName(), (Object)taskArray);
                            jCaseArray.add((Object)jCase);
                            continue;
                        }
                        log.debug((Object)"CaseData in Role Reference is null");
                    }
                }
                if (jCaseArray.size() > 0) {
                    for (String role : this.roleInUse) {
                        if (!role.equals(tempRole.getName())) continue;
                        jRole.put((Object)tempRole.getName(), (Object)jCaseArray);
                    }
                }
                if (jRole.isEmpty()) continue;
                jRoleRef.put((Object)"roleRefs", (Object)jRole);
            }
            if (!jRoleRef.isEmpty()) {
                roleRef = jRoleRef.toString();
            }
        }
        return roleRef;
    }

    private String readPropertiesInfo() {
        log.trace((Object)">readPropertiesInfo");
        Boolean flag = false;
        String propertyRef = "";
        boolean i = false;
        JSONObject jCaseProp = null;
        JSONObject jPropRef = new JSONObject();
        JSONArray jCaseArrayProp = null;
        JSONObject jCaseP = new JSONObject();
        if (this.data == null) {
            return null;
        }
        SolutionType uisolutionType = null;
        try {
            uisolutionType = this.data.getConverterData().getSolutionType();
        }
        catch (AcmException e) {
            log.error((Object)e, (Throwable)e);
        }
        Iterator iterateCases = uisolutionType.getCaseTypes().getCaseType().iterator();
        while (iterateCases.hasNext()) {
            jCaseArrayProp = new JSONArray();
            CaseTypeType caseType = (CaseTypeType)iterateCases.next();
            if (caseType != null) {
                log.debug((Object)("*******case Type in propery reference" + caseType.getDisplayName()));
                CaseTypeData caseData = this.data.getCasetypedata(caseType.getName());
                if (caseData != null) {
                    Map<String, AcmActivity> activitiesMap = caseData.getActivitiesMap();
                    Iterator uiProps = caseType.getCaseProperties().getPropertyDefinition().iterator();
                    while (uiProps.hasNext()) {
                        if (uiProps == null) continue;
                        log.debug((Object)"Properties present in Case type data");
                        CmisPropertyDefinitionType uiProp = (CmisPropertyDefinitionType)uiProps.next();
                        if (uiProp != null) {
                            log.debug((Object)("Property in property ref " + uiProp.getDisplayName()));
                            if (activitiesMap != null) {
                                JSONArray taskArrayForProp = new JSONArray();
                                for (AcmActivity activity : activitiesMap.values()) {
                                    List<AcmTask> tasks;
                                    if (activity == null || (tasks = activity.getTasks()) == null) continue;
                                    block5: for (AcmTask step : tasks) {
                                        List<AcmTaskParameter> taskProperties;
                                        if (step == null || (taskProperties = step.getParameters()) == null) continue;
                                        for (AcmTaskParameter prop : taskProperties) {
                                            String taskPropertyName = prop.getName();
                                            if (!uiProp.getLocalName().equals(taskPropertyName)) continue;
                                            log.info((Object)("Property Added" + uiProp.getLocalName()));
                                            if (!taskArrayForProp.contains((Object)activity.getSymbolicName())) {
                                                taskArrayForProp.add((Object)activity.getSymbolicName());
                                            }
                                            this.setPropInUse(uiProp.getLocalName());
                                            flag = true;
                                            continue block5;
                                        }
                                    }
                                }
                                if (flag.booleanValue()) {
                                    jCaseProp = new JSONObject();
                                    jCaseProp.put((Object)uiProp.getLocalName(), (Object)taskArrayForProp);
                                    jCaseArrayProp.add((Object)jCaseProp);
                                    flag = false;
                                }
                            }
                            if (jCaseArrayProp.size() > 0) {
                                jCaseP.put((Object)caseType.getName(), (Object)jCaseArrayProp);
                                for (String prop : this.propInUse) {
                                    if (!prop.equals(uiProp.getLocalName())) continue;
                                    jCaseP.put((Object)caseType.getName(), (Object)jCaseArrayProp);
                                }
                            }
                        }
                        if (jCaseP.isEmpty()) continue;
                        jPropRef.put((Object)"propertyRefs", (Object)jCaseP);
                    }
                } else {
                    log.debug((Object)"Case Data in property reference is null");
                }
            }
            if (!jPropRef.isEmpty()) {
                propertyRef = jPropRef.toString();
            }
            log.trace((Object)"<readPropertiesInfo");
        }
        return propertyRef;
    }
}

