/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.exception;

import com.ibm.acm.sold.messages.Message;
import java.util.Locale;

public class AcmException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String uid = null;
    private Message msgObject = null;

    public AcmException() {
    }

    public AcmException(String message, Throwable cause) {
        super(message, cause);
    }

    public AcmException(String message, String id) {
        super(message);
        this.uid = id;
    }

    public AcmException(String message) {
        super(message);
    }

    public AcmException(Throwable cause) {
        super(cause);
    }

    public AcmException(Message msgObject) {
        this.msgObject = msgObject;
        this.uid = msgObject.getKey();
    }

    public AcmException(Message msgObject, Throwable cause) {
        this(cause);
        this.msgObject = msgObject;
        this.uid = msgObject.getKey();
    }

    public String getUid() {
        return this.uid;
    }

    public Message getMessageObject() {
        return this.msgObject;
    }

    @Override
    public String getMessage() {
        if (this.msgObject != null) {
            String result = this.msgObject.getFormattedText();
            result = result.replaceAll("\"", "");
            result = result.replaceAll("\n", "\\\\u000a");
            return result;
        }
        return super.getMessage();
    }

    public String getMessage(Locale locale) {
        if (this.msgObject != null) {
            String result = this.msgObject.getFormattedText(locale);
            result = result.replaceAll("\"", "");
            result = result.replaceAll("\n", "\\\\u000a");
            return result;
        }
        return super.getLocalizedMessage();
    }

    public String getMessage(Locale locale, Throwable cause) {
        if (this.msgObject != null) {
            String result = this.msgObject.getFormattedText(locale);
            result = result.replaceAll("\"", "");
            result = result.replaceAll("\n", "\\\\u000a");
            return result + cause.getLocalizedMessage();
        }
        return super.getLocalizedMessage();
    }

    @Override
    public String getLocalizedMessage() {
        if (this.msgObject != null) {
            String result = this.msgObject.getFormattedText();
            result = result.replaceAll("\"", "");
            result = result.replaceAll("\n", "\\\\u000a");
            return result;
        }
        return super.getLocalizedMessage();
    }
}

