/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.diagrammer.types.ui;

import com.ibm.acm.sold.common.Constants;
import com.ibm.acm.sold.diagrammer.types.AcmTask;
import com.ibm.acm.sold.diagrammer.types.AcmTaskParameterSetWrapper;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AcmTaskUI {
    private String stepId;
    private String name;
    private String description;
    private String participant;
    private List<String> responses;
    private Set<String> routeIdsConnected;
    public JSONObject obj;
    private String JSONString;

    public AcmTaskUI(AcmTask task) {
        this.stepId = task.getId();
        this.name = task.getName();
        this.description = task.getDescription();
        this.participant = task.getParticipant();
        this.responses = task.getResponses();
        this.routeIdsConnected = task.getRouteIdsConnected();
        JSONObject taskUI = new JSONObject();
        taskUI.put((Object)"TaskName", (Object)this.name);
        taskUI.put((Object)"TaskId", (Object)this.stepId);
        taskUI.put((Object)"TaskDesc", (Object)this.description);
        taskUI.put((Object)"TaskParticipant", (Object)this.participant);
        JSONArray taskResponses = new JSONArray();
        if (this.responses != null) {
            Iterator<String> i1 = this.responses.iterator();
            while (i1.hasNext()) {
                taskResponses.add((Object)i1.next());
            }
        }
        taskUI.put((Object)"TaskResponses", (Object)taskResponses);
        JSONArray routeIds = new JSONArray();
        if (this.routeIdsConnected != null) {
            Iterator<String> i2 = this.routeIdsConnected.iterator();
            while (i2.hasNext()) {
                routeIds.add((Object)i2.next());
            }
        }
        taskUI.put(Constants.ACM_UI_TASK_ROUTES_CONNECTED, (Object)routeIds);
        AcmTaskParameterSetWrapper paramSet = task.getParameterSet();
        JSONArray workgroupParams = new JSONArray();
        JSONArray attachmentParams = new JSONArray();
        if (paramSet != null) {
            Set<String> attachments;
            Set<String> workgroups = paramSet.getWorkgroupParameters();
            if (workgroups != null) {
                Iterator<String> i3 = workgroups.iterator();
                while (i3.hasNext()) {
                    workgroupParams.add((Object)i3.next());
                }
            }
            if ((attachments = paramSet.getAttachmentParameters()) != null) {
                Iterator<String> i3 = attachments.iterator();
                while (i3.hasNext()) {
                    attachmentParams.add((Object)i3.next());
                }
            }
        }
        taskUI.put(Constants.ACM_UI_WORKGROUP_PARAMS, (Object)workgroupParams);
        taskUI.put(Constants.ACM_UI_ATTACHMENT_PARAMS, (Object)attachmentParams);
        this.obj = taskUI;
        this.JSONString = taskUI.toString();
    }

    public JSONObject getJSONObject() {
        return this.obj;
    }

    public String getStepId() {
        return this.stepId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getParticipant() {
        return this.participant;
    }

    public List<String> getResponses() {
        return this.responses;
    }

    public String getJSONString() {
        return this.JSONString;
    }
}

