/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.diagrammer.types.ui;

import com.ibm.acm.sold.diagrammer.AcmActivityEditorUtil;
import com.ibm.acm.sold.diagrammer.types.AcmActivity;
import com.ibm.acm.sold.diagrammer.types.AcmActivityAttachment;
import com.ibm.acm.sold.diagrammer.types.AcmActivitySwimLane;
import com.ibm.acm.sold.diagrammer.types.AcmCaseShareInfo;
import com.ibm.acm.sold.diagrammer.types.AcmRoute;
import com.ibm.acm.sold.diagrammer.types.AcmTask;
import com.ibm.acm.sold.diagrammer.types.AcmWorkGroupDefinition;
import com.ibm.acm.sold.diagrammer.types.ui.AcmRouteUI;
import com.ibm.acm.sold.diagrammer.types.ui.AcmTaskUI;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AcmActivityUI {
    String symbolicName;
    String description;
    String mainAttachment;
    List<AcmTaskUI> tasks;
    List<AcmRouteUI> routes;
    JSONObject activityUiJson;
    JSONArray tasksJSON;
    JSONArray routesJSON;
    JSONArray lanesJSONArray;
    Set<AcmWorkGroupDefinition> workgroups;
    Set<AcmActivityAttachment> attachments;
    Map<String, AcmActivitySwimLane> lanes;
    Set<String> swimlanes;

    public AcmActivityUI(AcmActivity activity, AcmCaseShareInfo acmCaseShareInfo) {
        boolean widAuthored;
        block16: {
            this.symbolicName = activity.getSymbolicName();
            this.description = activity.getDescription();
            if (activity.getMainAttachment() != null) {
                this.mainAttachment = activity.getMainAttachment().replaceAll("\"", "");
            }
            this.lanes = new HashMap<String, AcmActivitySwimLane>();
            this.swimlanes = new HashSet<String>();
            this.tasks = new ArrayList<AcmTaskUI>();
            this.routes = new ArrayList<AcmRouteUI>();
            this.tasksJSON = new JSONArray();
            this.routesJSON = new JSONArray();
            this.activityUiJson = new JSONObject();
            this.lanesJSONArray = new JSONArray();
            List<AcmTask> tasksList = activity.getTasks();
            List<AcmRoute> routesList = activity.getRoutes();
            if (tasksList != null) {
                Iterator<AcmTask> i1 = tasksList.iterator();
                while (i1.hasNext()) {
                    AcmTaskUI taskUI = new AcmTaskUI(i1.next());
                    this.tasksJSON.add((Object)taskUI.getJSONObject());
                    this.tasks.add(taskUI);
                }
            }
            if (routesList != null) {
                Iterator<AcmRoute> i2 = routesList.iterator();
                while (i2.hasNext()) {
                    AcmRouteUI routeUI = new AcmRouteUI(i2.next());
                    this.routesJSON.add((Object)routeUI.getJSONObject());
                    this.routes.add(routeUI);
                }
            }
            this.workgroups = activity.getWorkgroupDef();
            this.attachments = activity.getAttachments();
            Map activityConfigInfo = (Map)acmCaseShareInfo.getObject(AcmCaseShareInfo.ACTIVITY_CONFIG_INFO);
            String NO_PARTICIPANT_LANE_NAME = null;
            String UNSUPPORTED_LANE_NAME = null;
            if (activityConfigInfo != null) {
                NO_PARTICIPANT_LANE_NAME = (String)activityConfigInfo.get("SWIMLANE_NAME_NO_PARTICPANT");
                UNSUPPORTED_LANE_NAME = (String)activityConfigInfo.get("SWIMLANE_NAME_UNSUPPORTED");
            } else {
                NO_PARTICIPANT_LANE_NAME = "Undefined Participants";
                UNSUPPORTED_LANE_NAME = "System";
            }
            if (activity != null && activity.getSwimLanesMap() != null) {
                this.swimlanes.addAll(activity.getSwimLanesMap().keySet());
                this.lanes = activity.getSwimLanesMap();
                Iterator<String> i5 = this.swimlanes.iterator();
                while (i5.hasNext()) {
                    JSONObject lanesJSON = new JSONObject();
                    String lane = i5.next();
                    AcmActivitySwimLane swimLane = this.lanes.get(lane);
                    String laneType = swimLane.getSwimLaneType();
                    if (!laneType.equalsIgnoreCase("ROLE") && !laneType.equalsIgnoreCase("WORKGROUP")) continue;
                    lanesJSON.put((Object)"name", (Object)swimLane.getSwimLaneName());
                    lanesJSON.put((Object)"type", (Object)laneType);
                    this.lanesJSONArray.add((Object)lanesJSON);
                }
            }
            widAuthored = false;
            try {
                List others = activity.getWorkflowDef().getOtherAuthorTools();
                if (others == null || others.size() <= 0) break block16;
                for (String tools : others) {
                    if (!tools.startsWith("WID:")) continue;
                    widAuthored = true;
                    break;
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        this.workgroups.addAll(AcmActivityEditorUtil.createWorkgroupSet(this.lanes));
        this.activityUiJson.put((Object)"ActivitySymbolicName", (Object)this.symbolicName);
        this.activityUiJson.put((Object)"ActivityDescription", (Object)this.description);
        this.activityUiJson.put((Object)"ActivityMainAttachment", (Object)this.mainAttachment);
        this.activityUiJson.put((Object)"Tasks", (Object)this.tasksJSON);
        this.activityUiJson.put((Object)"Routes", (Object)this.routesJSON);
        this.activityUiJson.put((Object)"LanesUsed", (Object)this.lanesJSONArray);
        this.activityUiJson.put((Object)"widAuthored", (Object)new Boolean(widAuthored).toString());
        JSONArray workgroupJSONArray = new JSONArray();
        if (this.workgroups != null) {
            Iterator<AcmWorkGroupDefinition> i3 = this.workgroups.iterator();
            HashSet<String> workgroupNamesSet = new HashSet<String>();
            while (i3.hasNext()) {
                AcmWorkGroupDefinition workgroup = i3.next();
                String workgroupName = workgroup.getName();
                if (workgroupName.contains("F_") && !workgroupName.equals("F_Originator") || workgroupNamesSet.contains(workgroupName)) continue;
                workgroupJSONArray.add((Object)workgroup.toJSONObject());
                workgroupNamesSet.add(workgroupName);
            }
        }
        JSONArray attachmentJSONArray = new JSONArray();
        if (this.attachments != null) {
            Iterator<AcmActivityAttachment> i4 = this.attachments.iterator();
            HashSet<String> attachmentNamesSet = new HashSet<String>();
            while (i4.hasNext()) {
                AcmActivityAttachment attachment = i4.next();
                String attachmentName = attachment.getName();
                if (attachmentNamesSet.contains(attachmentName)) continue;
                attachmentJSONArray.add((Object)attachment.toJSONObject());
                attachmentNamesSet.add(attachmentName);
            }
        }
        this.activityUiJson.put((Object)"Workgroups", (Object)workgroupJSONArray);
        this.activityUiJson.put((Object)"Attachments", (Object)attachmentJSONArray);
    }

    public JSONObject getActivityUiJson() {
        return this.activityUiJson;
    }

    public String getActivityUiJsonString() {
        return this.activityUiJson.toString();
    }

    public Set<AcmActivityAttachment> getAttachments() {
        return this.attachments;
    }

    public String getDescription() {
        return this.description;
    }

    public List<AcmRouteUI> getRoutes() {
        return this.routes;
    }

    public JSONArray getRoutesJSON() {
        return this.routesJSON;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public List<AcmTaskUI> getTasks() {
        return this.tasks;
    }

    public JSONArray getTasksJSON() {
        return this.tasksJSON;
    }

    public Set<AcmWorkGroupDefinition> getWorkgroups() {
        return this.workgroups;
    }
}

