/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.diagrammer.types;

import com.ibm.acm.sold.diagrammer.types.AcmActivityAttachment;
import com.ibm.acm.sold.diagrammer.types.AcmTaskParameter;
import com.ibm.acm.sold.diagrammer.types.AcmWorkGroupDefinition;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AcmTaskParameterSetWrapper {
    private Set<String> casePropertyParameters = new HashSet<String>();
    private Set<String> attachmentParameters = new HashSet<String>();
    private Set<String> workgroupParameters = new HashSet<String>();
    private Set<String> dataFieldParameters = new HashSet<String>();
    private Set<AcmWorkGroupDefinition> workgroupDefs = new HashSet<AcmWorkGroupDefinition>();
    private Set<AcmActivityAttachment> attachmentDefs = new HashSet<AcmActivityAttachment>();

    AcmTaskParameterSetWrapper(List<AcmTaskParameter> parameters, Set<String> caseProperties) {
        for (AcmTaskParameter param : parameters) {
            if (caseProperties.contains(param.getName())) {
                this.casePropertyParameters.add(param.getName());
                continue;
            }
            if (param.getDataType() == 32) {
                this.attachmentParameters.add(param.getName());
                this.attachmentDefs.add(new AcmActivityAttachment(param.getName(), param.getDescription(), param.isInitiateAttachment()));
                continue;
            }
            if (param.getDataType() == 64) {
                this.workgroupParameters.add(param.getName());
                this.workgroupDefs.add(new AcmWorkGroupDefinition(param.getName(), param.getDescription()));
                continue;
            }
            this.dataFieldParameters.add(param.getName());
        }
    }

    public Set<AcmWorkGroupDefinition> getWorkgroupDefs() {
        return this.workgroupDefs;
    }

    public Set<AcmActivityAttachment> getAttachmentDefs() {
        return this.attachmentDefs;
    }

    public void setCasePropertyParameters(Set<String> casePropertyParameters) {
        this.casePropertyParameters = casePropertyParameters;
    }

    public Set<String> getCasePropertyParameters() {
        return this.casePropertyParameters;
    }

    public Set<String> getAttachmentParameters() {
        return this.attachmentParameters;
    }

    public Set<String> getWorkgroupParameters() {
        return this.workgroupParameters;
    }

    public Set<String> getDataFieldParameters() {
        return this.dataFieldParameters;
    }

    public void setAttachmentParameters(Set<String> attachmentParameters) {
        this.attachmentParameters = attachmentParameters;
    }

    public void setWorkgroupParameters(Set<String> workgroupParameters) {
        this.workgroupParameters = workgroupParameters;
    }

    public void setDataFieldParameters(Set<String> dataFieldParameters) {
        this.dataFieldParameters = dataFieldParameters;
    }

    public Set<AcmWorkGroupDefinition> returnWorkGroupDefs() {
        return this.workgroupDefs;
    }
}

