/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.diagrammer.types;

import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWParameterDefinition;

public class AcmTaskParameter {
    private String name;
    private String description;
    private int mode;
    private String value;
    private int dataType;
    private boolean isArray;
    private boolean isInitiateAttachment;
    private VWParameterDefinition paramDef;

    public AcmTaskParameter(VWParameterDefinition parameterDefinition) {
        this.setParamDef(parameterDefinition);
        this.name = parameterDefinition.getName();
        this.description = parameterDefinition.getDescription();
        this.mode = parameterDefinition.getMode();
        this.value = parameterDefinition.getValue();
        this.dataType = parameterDefinition.getDataType();
        this.isArray = parameterDefinition.getIsArray();
    }

    public AcmTaskParameter(JSONObject caseObj) {
        this.name = (String)caseObj.get((Object)"name");
        if (caseObj.get((Object)"description") != null) {
            this.description = (String)caseObj.get((Object)"description");
        }
        if (caseObj.get((Object)"mode") != null) {
            boolean readOnly = Boolean.parseBoolean((String)caseObj.get((Object)"mode"));
            this.mode = readOnly ? 1 : 3;
        }
        if (caseObj.get((Object)"value") != null) {
            this.value = (String)caseObj.get((Object)"value");
        }
        if (caseObj.get((Object)"isInitiateAttachment") != null) {
            this.isInitiateAttachment = Boolean.parseBoolean((String)caseObj.get((Object)"isInitiateAttachment"));
        }
        if (caseObj.get((Object)"dataType") != null) {
            String type = (String)caseObj.get((Object)"dataType");
            if (type.equalsIgnoreCase("boolean")) {
                this.dataType = 4;
            }
            if (type.equalsIgnoreCase("float")) {
                this.dataType = 8;
            }
            if (type.equalsIgnoreCase("integer")) {
                this.dataType = 1;
            }
            if (type.equalsIgnoreCase("string")) {
                this.dataType = 2;
            }
            if (type.equalsIgnoreCase("datetime")) {
                this.dataType = 16;
            }
            if (type.equalsIgnoreCase("workgroup")) {
                this.dataType = 64;
            }
            if (type.equalsIgnoreCase("attachment")) {
                this.dataType = 32;
            }
        }
        if (caseObj.get((Object)"isArray") != null) {
            this.isArray = Boolean.parseBoolean((String)caseObj.get((Object)"isArray"));
        }
    }

    public AcmTaskParameter(String paramName) {
        this.name = paramName;
    }

    public int getDataType() {
        return this.dataType;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public VWParameterDefinition getParamDef() {
        return this.paramDef;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isInitiateAttachment() {
        return this.isInitiateAttachment;
    }

    public void setArray(boolean isArray) {
        this.isArray = isArray;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParamDef(VWParameterDefinition paramDef) {
        this.paramDef = paramDef;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toJSONString() {
        JSONObject params = new JSONObject();
        params.put((Object)"name", (Object)this.name);
        params.put((Object)"description", (Object)this.description);
        params.put((Object)"dataType", (Object)this.dataType);
        params.put((Object)"mode", (Object)this.mode);
        params.put((Object)"value", (Object)this.value);
        params.put((Object)"isArray", (Object)this.isArray);
        return params.toString();
    }

    public String toString() {
        return this.name + "::" + this.description + "::" + this.dataType + "::" + this.value;
    }

    public JSONObject toJSONObject() {
        JSONObject params = new JSONObject();
        params.put((Object)"name", (Object)this.name);
        params.put((Object)"description", (Object)this.description);
        if (this.mode == 1) {
            params.put((Object)"mode", (Object)"true");
        } else {
            params.put((Object)"mode", (Object)"false");
        }
        if (this.dataType == 4) {
            params.put((Object)"dataType", (Object)"boolean");
        } else if (this.dataType == 8) {
            params.put((Object)"dataType", (Object)"float");
        } else if (this.dataType == 1) {
            params.put((Object)"dataType", (Object)"integer");
        } else if (this.dataType == 2) {
            params.put((Object)"dataType", (Object)"string");
        } else if (this.dataType == 16) {
            params.put((Object)"dataType", (Object)"datetime");
        } else if (this.dataType == 64) {
            params.put((Object)"dataType", (Object)"workgroup");
        } else if (this.dataType == 32) {
            params.put((Object)"dataType", (Object)"attachment");
        }
        params.put((Object)"value", (Object)this.value);
        if (this.isArray) {
            params.put((Object)"isArray", (Object)"true");
        } else {
            params.put((Object)"isArray", (Object)"false");
        }
        return params;
    }

    public boolean equals(AcmTaskParameter param) {
        return this.name.equalsIgnoreCase(param.getName());
    }
}

