/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.diagrammer.types;

import com.ibm.acm.sold.diagrammer.AcmActivityEditorUtil;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcmTaskDuration {
    long deadlineTime;
    int deadlineUnit;
    long deadlineValue;
    long reminderTime;
    int reminderUnit;
    long reminderValue;
    private static final Log log = LogFactory.getLog((String)"com.ibm.acm.sold.diagrammer.type.AcmTaskDuration");

    public long convertDeadline(String deadlineReminderStr) throws AcmException {
        String deadlineStr;
        log.debug((Object)">> convertDeadline()");
        if (deadlineReminderStr.equals("0")) {
            return 0L;
        }
        if (deadlineReminderStr.equals("-1")) {
            return -1L;
        }
        try {
            JSONObject json = JSONObject.parse((String)deadlineReminderStr);
            deadlineStr = (String)json.get((Object)"deadline");
            this.deadlineTime = deadlineStr.isEmpty() ? 0L : Long.parseLong(deadlineStr);
            String deadlineUnitStr = (String)json.get((Object)"deadline_unit");
            this.deadlineUnit = this.parseUnit(deadlineUnitStr);
        }
        catch (IOException e) {
            Message msg = new Message("");
            throw new AcmException(msg, (Throwable)e);
        }
        if (this.deadlineTime == 0L || deadlineStr.length() == 0) {
            return 0L;
        }
        return AcmActivityEditorUtil.convertTimeToMinutes(this.deadlineTime, this.deadlineUnit);
    }

    public long convertReminder(String deadlineReminderStr) throws AcmException {
        String reminderStr;
        log.debug((Object)">> convertReminder()");
        if (deadlineReminderStr.equals("0")) {
            return 0L;
        }
        if (deadlineReminderStr.equals("-1")) {
            return -1L;
        }
        try {
            JSONObject json = JSONObject.parse((String)deadlineReminderStr);
            reminderStr = (String)json.get((Object)"reminder");
            this.reminderTime = reminderStr.isEmpty() ? 0L : Long.parseLong(reminderStr);
            String reminderUnitStr = (String)json.get((Object)"reminder_unit");
            this.reminderUnit = this.parseUnit(reminderUnitStr);
        }
        catch (IOException e) {
            Message msg = new Message("");
            throw new AcmException(msg, (Throwable)e);
        }
        if (this.reminderTime == 0L || reminderStr.length() == 0) {
            return 0L;
        }
        return AcmActivityEditorUtil.convertTimeToMinutes(this.reminderTime, this.reminderUnit);
    }

    public int parseUnit(String unit) {
        int unitValue = -1;
        if (unit.equals("Minutes")) {
            unitValue = 2;
        } else if (unit.equals("Hrs")) {
            unitValue = 3;
        } else if (unit.equals("Days")) {
            unitValue = 4;
        } else if (unit.equals("Weeks")) {
            unitValue = 5;
        }
        return unitValue;
    }
}

