/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.diagrammer.types;

import com.ibm.acm.casebuilder.logger.CBLogger;
import com.ibm.acm.sold.diagrammer.AcmActivityEditorUtil;
import com.ibm.acm.sold.diagrammer.AcmActivitySdfData;
import com.ibm.acm.sold.diagrammer.exceptions.AcmTaskParameterException;
import com.ibm.acm.sold.diagrammer.exceptions.DiagrammerException;
import com.ibm.acm.sold.diagrammer.types.AcmActivitySwimLane;
import com.ibm.acm.sold.diagrammer.types.AcmCaseShareInfo;
import com.ibm.acm.sold.diagrammer.types.AcmTaskDuration;
import com.ibm.acm.sold.diagrammer.types.AcmTaskParameter;
import com.ibm.acm.sold.diagrammer.types.AcmTaskParameterSetWrapper;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import ilog.views.diagrammer.IlvDiagrammer;
import ilog.views.sdm.model.IlvDefaultSDMNode;
import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcmTask {
    private String name;
    private String description;
    private String instruction;
    private long deadline;
    private long reminder;
    private String deadlineExpr;
    private boolean reassign;
    private List<String> responses;
    private String pageLayout;
    private int joinType;
    private int splitType;
    private String deadlineStr;
    private boolean isLaunchStep;
    private List<AcmTaskParameter> parameters;
    private String requestedURL;
    private VWMapNode stepDef;
    private String VWStepId;
    private String participant;
    private String participantType;
    private VWAttributeInfo miscInfo;
    private Set<String> routeIdsConnected;
    public Point position;
    private boolean isSupportedStep;
    private AcmTaskDuration taskDuration;
    private static final Log log = LogFactory.getLog((String)"com.ibm.acm.sold.diagrammer.type.AcmTask");
    private AcmTaskParameterSetWrapper parameterSet;

    public AcmTask(IlvDiagrammer diagrammer, IlvSDMNode node, VWMapDefinition mapDef) throws DiagrammerException {
        this.name = "Step";
        this.joinType = 3;
        this.splitType = 3;
        this.participant = null;
        this.position = new Point(-1, -1);
        CBLogger.trace(log, ">> AcmTask(diagrammer,node,mapDef)");
        this.isSupportedStep = !node.getTag().equalsIgnoreCase("stub");
        try {
            this.stepDef = this.isSupportedStep ? mapDef.createStep(this.VWStepId) : mapDef.createCompoundStep(this.VWStepId);
        }
        catch (VWException e) {
            log.info((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            throw new DiagrammerException("B6007E.ERROR_CREATING_TASK_MODEL");
        }
        if (!this.isLaunchStep()) {
            diagrammer.setObjectProperty((Object)node, "jviewsId", (Object)node.getID());
            ((IlvDefaultSDMNode)node).setID(AcmActivityEditorUtil.createAcmTaskIdFromStepId(this.stepDef.getStepId()));
            this.setVWStepId(AcmActivityEditorUtil.createAcmTaskIdFromStepId(this.stepDef.getStepId()));
            diagrammer.setID((Object)node, node.getID());
            this.setLaunchStep(false);
        }
        CBLogger.trace(log, "<< AcmTask(diagrammer,node,mapDef)");
    }

    public AcmTask(IlvDiagrammer diagrammer, VWMapDefinition mapDef) {
        this.name = "Step";
        this.joinType = 3;
        this.splitType = 3;
        this.participant = null;
        this.position = new Point(-1, -1);
    }

    public AcmTask(VWMapNode step, AcmCaseShareInfo shareInfo, boolean adhoc) throws DiagrammerException {
        String NO_PARTICIPANT_LANE_NAME;
        Map activityConfigInfo;
        block31: {
            this.name = "Step";
            this.joinType = 3;
            this.splitType = 3;
            this.participant = null;
            this.position = new Point(-1, -1);
            CBLogger.trace(log, ">> AcmTask() for " + step.getName());
            this.stepDef = step;
            activityConfigInfo = (Map)shareInfo.getObject(AcmCaseShareInfo.ACTIVITY_CONFIG_INFO);
            NO_PARTICIPANT_LANE_NAME = activityConfigInfo != null ? (String)activityConfigInfo.get("SWIMLANE_NAME_NO_PARTICPANT") : "Undefined Participants";
            try {
                CBLogger.trace(log, "Getting Step Position");
                this.miscInfo = this.stepDef.getAttributeInfo();
            }
            catch (VWException e1) {
                CBLogger.error(log, "Error getting step position: " + this.getId(), e1);
                e1.printStackTrace();
                throw new DiagrammerException(e1.getMessage());
            }
            if (this.miscInfo != null) {
                try {
                    CBLogger.trace(log, "Step Position Found");
                    if (this.miscInfo.getFieldValue("ACM_NODE_POSITION_X") == null || this.miscInfo.getFieldValue("ACM_NODE_POSITION_Y") == null) break block31;
                    try {
                        int x = (int)Float.parseFloat((String)this.miscInfo.getFieldValue("ACM_NODE_POSITION_X"));
                        int y = (int)Float.parseFloat((String)this.miscInfo.getFieldValue("ACM_NODE_POSITION_Y"));
                        this.position.x = x;
                        this.position.y = y;
                    }
                    catch (VWException e) {
                        CBLogger.error(log, "Error reading step position: " + this.getId(), e);
                        e.printStackTrace();
                        throw new DiagrammerException(e.getMessage());
                    }
                }
                catch (VWException e) {
                    CBLogger.error(log, "Error reading step position: " + this.getId(), e);
                    e.printStackTrace();
                    throw new DiagrammerException(e.getMessage());
                }
            }
        }
        this.name = step.getName();
        if (this.name.equalsIgnoreCase("LaunchStep")) {
            this.name = (String)activityConfigInfo.get("LAUNCH_STEP_NAME");
        }
        this.description = step.getDocumentation();
        this.instruction = step.getDescription();
        this.isLaunchStep = AcmActivityEditorUtil.isLaunchStep(step);
        this.VWStepId = AcmActivityEditorUtil.createAcmTaskIdFromStepId(step.getStepId());
        this.routeIdsConnected = new HashSet<String>();
        try {
            VWRouteDefinition[] routesConnected = this.stepDef.getNextRoutes();
            if (routesConnected != null) {
                for (int i = 0; i < routesConnected.length; ++i) {
                    this.routeIdsConnected.add(AcmActivityEditorUtil.createAcmRouteIdFromRouteId(routesConnected[i].getRouteId()));
                }
            }
        }
        catch (VWException e1) {
            e1.printStackTrace();
        }
        CBLogger.trace(log, "ACM Task:" + this.name + ". Task Id is :" + this.VWStepId + ". The VW id is :" + step.getStepId());
        this.joinType = step.getJoinType();
        this.splitType = step.getSplitType();
        if (step instanceof VWStepDefinition) {
            this.isSupportedStep = true;
            if (!this.isLaunchStep || this.isLaunchStep && adhoc) {
                try {
                    this.deadline = ((VWStepDefinition)step).getDeadline();
                    this.reminder = ((VWStepDefinition)step).getReminder();
                    this.deadlineExpr = ((VWStepDefinition)step).getDeadlineExpr();
                }
                catch (VWException e1) {
                    e1.printStackTrace();
                }
                this.deadlineStr = this.getDeadlineJson(this.deadline, this.reminder);
                if (!this.isLaunchStep) {
                    this.reassign = ((VWStepDefinition)step).getCanReassign();
                }
                if (((VWStepDefinition)step).getQueueName() == null) {
                    this.setParticipant(NO_PARTICIPANT_LANE_NAME);
                    this.setParticipantType("UNDEFINED");
                } else if (((VWStepDefinition)step).getQueueName().equalsIgnoreCase("Inbox")) {
                    this.setParticipant(((VWStepDefinition)step).getParticipants()[0].getParticipantName());
                    this.setParticipantType("WORKGROUP");
                } else {
                    String roleName = null;
                    String queueName = ((VWStepDefinition)step).getQueueName();
                    Map queueMap = (Map)shareInfo.getObject(AcmCaseShareInfo.QUEUE_ROLE_MAP);
                    if (queueName != null) {
                        roleName = AcmActivityEditorUtil.getValidRole(queueMap, queueName);
                        this.setParticipant(roleName);
                        this.setParticipantType("ROLE");
                    } else {
                        this.setParticipant(NO_PARTICIPANT_LANE_NAME);
                        this.setParticipantType("UNDEFINED");
                    }
                }
                this.parameters = new ArrayList<AcmTaskParameter>();
                try {
                    VWParameterDefinition[] params = ((VWStepDefinition)step).getParameterDefinitions();
                    if (params != null) {
                        for (int i = 0; i < params.length; ++i) {
                            this.parameters.add(new AcmTaskParameter(params[i]));
                        }
                    }
                }
                catch (VWException e) {
                    CBLogger.error(log, "Error adding task parameters: " + this.getId(), e);
                    throw new AcmTaskParameterException(e.getCauseDescription());
                }
                this.parameterSet = new AcmTaskParameterSetWrapper(this.parameters, (Set)shareInfo.getObject(AcmCaseShareInfo.CASE_PROPERTIES_SYMBOLIC_LIST));
                String[] stepResponses = ((VWStepDefinition)step).getResponses();
                this.responses = stepResponses != null ? Arrays.asList(stepResponses) : new ArrayList<String>();
                this.setPageLayout(((VWStepDefinition)step).getRequestedInterface());
            } else {
                this.setParticipant(NO_PARTICIPANT_LANE_NAME);
                this.setParticipantType("UNDEFINED");
            }
        } else {
            this.isSupportedStep = false;
            if (activityConfigInfo != null) {
                this.setParticipant((String)activityConfigInfo.get("SWIMLANE_NAME_UNSUPPORTED"));
            } else {
                this.setParticipant("System");
            }
            this.setParticipantType("UNSUPPORTED");
        }
        CBLogger.trace(log, "<< AcmTask() for" + this.name);
    }

    private void cleanupParamDef(VWWorkflowDefinition workflowDef, AcmCaseShareInfo shareInfo, AcmActivitySdfData sdfData, boolean adhoc) {
        CBLogger.trace(log, ">> cleanupParamDef()");
        try {
            VWParameterDefinition[] vwParamsExisting = ((VWStepDefinition)this.stepDef).getParameterDefinitions();
            Set casePropertiesDefined = (Set)shareInfo.getObject(AcmCaseShareInfo.CASE_PROPERTIES_LIST);
            HashSet<String> paramSet = new HashSet<String>();
            paramSet.addAll(this.parameterSet.getAttachmentParameters());
            paramSet.addAll(this.parameterSet.getCasePropertyParameters());
            paramSet.addAll(this.parameterSet.getWorkgroupParameters());
            paramSet.addAll(this.parameterSet.getDataFieldParameters());
            if (vwParamsExisting != null) {
                for (int i = 0; i < vwParamsExisting.length; ++i) {
                    String paramName = vwParamsExisting[i].getName();
                    if (paramSet.contains(paramName)) continue;
                    CBLogger.trace(log, "Removing from PE Model -- Parameter: " + paramName);
                    VWParameterDefinition paramDef = this.getParameterDefinition(paramName);
                    if (paramDef == null) continue;
                    ((VWStepDefinition)this.stepDef).deleteParameter(paramName);
                }
            }
        }
        catch (VWException e) {
            CBLogger.error(log, "Error removing parameter from PE Model.", e);
            e.printStackTrace();
        }
        CBLogger.trace(log, "<< cleanupParamDef()");
    }

    public boolean getCanReassign() {
        return this.reassign;
    }

    public long getDeadline() {
        return this.deadline;
    }

    public String getDeadlineExpr() {
        return this.deadlineExpr;
    }

    private String getDeadlineJson(long deadline, long reminder) {
        JSONObject deadlineJson = new JSONObject();
        if (deadline == -1L) {
            return "-1";
        }
        if (deadline == 0L) {
            return "0";
        }
        String deadline_unit = AcmActivityEditorUtil.convertMinutesToUnit(this.deadline);
        long deadline_val = AcmActivityEditorUtil.convertMinutesToValue(deadline, deadline_unit);
        String reminder_unit = AcmActivityEditorUtil.convertMinutesToUnit(this.reminder);
        long reminder_val = AcmActivityEditorUtil.convertMinutesToValue(reminder, reminder_unit);
        deadlineJson.put((Object)"deadline", (Object)Long.toString(deadline_val));
        deadlineJson.put((Object)"deadline_unit", (Object)deadline_unit);
        deadlineJson.put((Object)"reminder", (Object)Long.toString(reminder_val));
        deadlineJson.put((Object)"reminder_unit", (Object)reminder_unit);
        return deadlineJson.toString();
    }

    public String getDeadlineJsonStr() {
        return this.deadlineStr;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.VWStepId;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public int getJoinType() {
        return this.joinType;
    }

    public String getName() {
        if (this.name == null) {
            this.name = "Step";
        }
        return this.name.replaceAll("\"", "");
    }

    public String getPageLayout() {
        return this.pageLayout;
    }

    public AcmTaskParameter getParameterByName(String name) {
        for (AcmTaskParameter param : this.parameters) {
            if (!param.getName().equalsIgnoreCase(name)) continue;
            return param;
        }
        return null;
    }

    private VWParameterDefinition getParameterDefinition(String paramName) {
        VWParameterDefinition paramDef = null;
        try {
            paramDef = ((VWStepDefinition)this.stepDef).getParameterDefinition(paramName);
        }
        catch (VWException ex) {
            CBLogger.error(log, "Parameter: " + paramName + " does not exist for the step");
        }
        return paramDef;
    }

    public List<AcmTaskParameter> getParameters() {
        return this.parameters;
    }

    public AcmTaskParameterSetWrapper getParameterSet() {
        return this.parameterSet;
    }

    public String getParticipant() {
        return this.participant;
    }

    public String getParticipantType() {
        return this.participantType;
    }

    public long getReminder() {
        return this.reminder;
    }

    public String getRequestedURL() {
        return this.requestedURL;
    }

    public List<String> getResponses() {
        return this.responses;
    }

    public Set<String> getRouteIdsConnected() {
        return this.routeIdsConnected;
    }

    public int getSplitType() {
        return this.splitType;
    }

    public VWMapNode getStepDef() {
        return this.stepDef;
    }

    public String getVWStepId() {
        return this.VWStepId;
    }

    public boolean isLaunchStep() {
        return this.isLaunchStep;
    }

    public boolean isSupportedTask() {
        return this.isSupportedStep;
    }

    public void setDeadline(long deadline) {
        this.deadline = deadline;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public String[][] setExpressionsInPostAssignments(String[][] postAssignmentsToBeSet, String[][] oldPostAssignments) {
        if (oldPostAssignments != null) {
            String[][] postAssignments = new String[postAssignmentsToBeSet.length][2];
            for (int i = 0; i < postAssignmentsToBeSet.length; ++i) {
                boolean valueSet = false;
                for (int j = 0; j < oldPostAssignments.length; ++j) {
                    if (!postAssignmentsToBeSet[i][0].equalsIgnoreCase(oldPostAssignments[j][0])) continue;
                    postAssignments[i][0] = oldPostAssignments[j][0];
                    postAssignments[i][1] = oldPostAssignments[j][1];
                    valueSet = true;
                }
                if (valueSet) continue;
                postAssignments[i][0] = postAssignmentsToBeSet[i][0];
                postAssignments[i][1] = postAssignmentsToBeSet[i][1];
            }
            return postAssignments;
        }
        return postAssignmentsToBeSet;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public void setJoinType(int joinType) {
        this.joinType = joinType;
    }

    public void setLaunchStep(boolean isLaunchStep) {
        this.isLaunchStep = isLaunchStep;
    }

    public void setName(String n) {
        this.name = n.replaceAll("\"", "");
    }

    public void setPageLayout(String pageLayout) {
        this.pageLayout = pageLayout;
    }

    public void setParameters(List<AcmTaskParameter> parameters) {
        this.parameters = parameters;
    }

    public void setParameterSet(AcmTaskParameterSetWrapper parameterSet) {
        this.parameterSet = parameterSet;
    }

    public void setParticipant(String participant) {
        this.participant = participant;
    }

    public void setParticipantType(String string) {
        this.participantType = string;
    }

    public void setReassign(boolean canReassign) {
        this.reassign = canReassign;
    }

    public void setReminder(long reminder) {
        this.reminder = reminder;
    }

    public void setRequestedURL(String requestedURL) {
        this.requestedURL = requestedURL;
    }

    public void setResponses(List<String> responses) {
        this.responses = responses;
    }

    public void setRouteIdsConnected(Set<String> routeIdsConnected) {
        this.routeIdsConnected = routeIdsConnected;
    }

    public void setSplitType(int splitType) {
        this.splitType = splitType;
    }

    public void setStepDef(VWMapNode stepDef) {
        this.stepDef = stepDef;
    }

    public void setVWStepId(String stepId) {
        this.VWStepId = stepId;
    }

    public String toString() {
        return this.VWStepId + "::" + this.name + "::" + this.description + "::" + this.instruction + "::" + this.joinType + "::" + this.pageLayout + "::" + this.deadline + "::" + this.reminder + "::" + this.responses + "::" + this.isSupportedStep;
    }

    private AcmActivitySwimLane tryGettingLaneFromStepPosition(IlvSDMNode node, Map<String, AcmActivitySwimLane> swimLanesMap, IlvDiagrammer diagrammer) {
        CBLogger.trace(log, ">> tryGettingLaneFromStepPosition()");
        Iterator<String> i1 = swimLanesMap.keySet().iterator();
        String x = "-1";
        String y = "-1";
        try {
            x = diagrammer.getObjectProperty((Object)node, "sdm:x").toString();
            y = diagrammer.getObjectProperty((Object)node, "sdm:y").toString();
        }
        catch (NullPointerException e) {
            x = diagrammer.getObjectProperty((Object)node, "x").toString();
            y = diagrammer.getObjectProperty((Object)node, "y").toString();
        }
        float X = Float.parseFloat(x);
        float Y = Float.parseFloat(y);
        while (i1.hasNext()) {
            String laneName = i1.next();
            AcmActivitySwimLane laneObject = swimLanesMap.get(laneName);
            Point lanePosition = laneObject.getPosition();
            if (!(Y < (float)(lanePosition.y + laneObject.getSize())) || !(Y > (float)lanePosition.y) || !(X > 0.0f)) continue;
            CBLogger.trace(log, "<< tryGettingLaneFromStepPosition()");
            return laneObject;
        }
        CBLogger.trace(log, "<< tryGettingLaneFromStepPosition()");
        return null;
    }

    public void updateAcmModelForStep(IlvDiagrammer diagrammer, boolean diagrammerExists, IlvSDMNode node, Map<String, AcmActivitySwimLane> swimLanesMap, boolean adhoc, AcmCaseShareInfo shareInfo) throws DiagrammerException {
        String desc;
        String name;
        CBLogger.trace(log, ">> updateAcmModelForStep()");
        HashMap queueRoleMap = (HashMap)shareInfo.getObject(AcmCaseShareInfo.QUEUE_ROLE_MAP);
        String solPrefix = (String)shareInfo.getObject(AcmCaseShareInfo.SOL_PREFIX);
        CBLogger.trace(log, "Step :" + this.name + ", ID: " + this.getId());
        CBLogger.trace(log, "Supported : " + this.isSupportedStep);
        Object obj = diagrammer.getObjectProperty((Object)node, "sdm:Lane");
        Object movedLane = diagrammer.getObjectProperty((Object)node, "Lane");
        CBLogger.trace(log, "OBJ:" + obj);
        CBLogger.trace(log, "movedLane:" + movedLane);
        if (obj != null || movedLane != null) {
            String stepRole = new String();
            if (movedLane != null) {
                stepRole = movedLane.toString();
                if (stepRole.trim().length() < 1 && obj != null) {
                    stepRole = obj.toString();
                }
            } else {
                stepRole = obj.toString();
            }
            log.trace(swimLanesMap);
            stepRole = AcmActivityEditorUtil.removeJViewsPadding(stepRole);
            AcmActivitySwimLane lane = swimLanesMap.get(stepRole);
            if (lane == null && this.participant == null || stepRole.length() == 0) {
                try {
                    lane = this.tryGettingLaneFromStepPosition(node, swimLanesMap, diagrammer);
                    stepRole = lane.getSwimLaneName();
                    CBLogger.trace(log, "Updated stepRole using position:" + stepRole);
                }
                catch (Exception e) {
                    CBLogger.error(log, "tryGettingLaneFromStepPosition failed.");
                    e.printStackTrace();
                }
                if (lane == null) {
                    Message msg = new Message("B6011E.STEP_OUTSIDE_LANE", this.name + " (" + this.getId() + ")");
                    throw new DiagrammerException(msg);
                }
            } else if (lane == null) {
                lane = swimLanesMap.get(this.participant);
                stepRole = this.participant;
            }
            CBLogger.trace(log, "Participant:" + this.participant);
            CBLogger.trace(log, "stepRole:" + stepRole);
            if (lane == null) {
                try {
                    lane = this.tryGettingLaneFromStepPosition(node, swimLanesMap, diagrammer);
                    stepRole = lane.getSwimLaneName();
                    CBLogger.trace(log, "Updated stepRole using position:" + stepRole);
                }
                catch (Exception e) {
                    CBLogger.error(log, "tryGettingLaneFromStepPosition failed.");
                    e.printStackTrace();
                }
            }
            if (lane == null) {
                CBLogger.error(log, "tryGettingLaneFromStepPosition also failedd");
                Message msg = new Message("B6011E.STEP_OUTSIDE_LANE", this.name + " (" + this.getId() + ")");
                throw new DiagrammerException(msg);
            }
            if (lane.getSwimLaneType().equalsIgnoreCase("UNSUPPORTED")) {
                boolean supported = Boolean.getBoolean(diagrammer.getObjectProperty((Object)node, "Supported").toString());
                if (supported) {
                    Message message = new Message("B6012E.STEP_IN_UNSUPPORTED_LANE", this.name + "(" + this.getId() + ")");
                    throw new DiagrammerException(message);
                }
            } else if (lane.getSwimLaneType().equalsIgnoreCase("UNSUPPORTED") && ((String)diagrammer.getObjectProperty((Object)node, "Supported")).equalsIgnoreCase("false")) {
                this.setParticipantType("UNSUPPORTED");
                this.setParticipant(stepRole);
            } else if (lane.getSwimLaneType().equalsIgnoreCase("ROLE")) {
                this.setParticipantType("ROLE");
                this.setParticipant(stepRole);
            } else if (lane.getSwimLaneType().equalsIgnoreCase("WORKGROUP")) {
                this.setParticipantType("WORKGROUP");
                this.setParticipant(stepRole);
            } else {
                CBLogger.trace(log, "Lane Object:" + obj);
                this.setParticipantType("UNDEFINED");
                this.setParticipant(stepRole);
            }
        }
        if (!this.isSupportedStep) {
            CBLogger.trace(log, "<< updateAcmModelForStep()");
            if (diagrammer.getObjectProperty((Object)node, "Name") != null && !(name = diagrammer.getObjectProperty((Object)node, "Name").toString()).isEmpty() && name.length() > 0) {
                name = AcmActivityEditorUtil.removeJViewsPadding(name);
                this.setName(name);
            }
            if (diagrammer.getObjectProperty((Object)node, "Description") != null) {
                desc = diagrammer.getObjectProperty((Object)node, "Description").toString();
                this.setDescription(desc);
                if (desc.isEmpty() || desc.length() < 1) {
                    this.setDescription(null);
                }
            }
            return;
        }
        if (this.isLaunchStep() && adhoc || !this.isLaunchStep()) {
            String page;
            String reassign;
            String deadline;
            if (diagrammer.getObjectProperty((Object)node, "Name") != null && !(name = diagrammer.getObjectProperty((Object)node, "Name").toString()).isEmpty() && name.length() > 0) {
                name = AcmActivityEditorUtil.removeJViewsPadding(name);
                this.setName(name);
            }
            if (diagrammer.getObjectProperty((Object)node, "Description") != null) {
                desc = diagrammer.getObjectProperty((Object)node, "Description").toString();
                this.setDescription(desc);
                if (desc.isEmpty() || desc.length() < 1) {
                    this.setDescription(null);
                }
            }
            if (diagrammer.getObjectProperty((Object)node, "Instruction") != null) {
                String instr = diagrammer.getObjectProperty((Object)node, "Instruction").toString();
                this.setInstruction(instr);
                if (instr.isEmpty() || instr.length() < 1) {
                    this.setInstruction(null);
                }
            }
            if (diagrammer.getObjectProperty((Object)node, "Deadline") != null && (deadline = diagrammer.getObjectProperty((Object)node, "Deadline").toString()) != null && deadline.length() > 0) {
                this.taskDuration = new AcmTaskDuration();
                try {
                    this.setDeadline(this.taskDuration.convertDeadline(deadline));
                }
                catch (AcmException e) {
                    CBLogger.error(log, "Error setting deadline: " + deadline, e);
                    e.printStackTrace();
                    Message message = new Message("B6013E.INVALID_TASK_PROPERTY_DEADLINE", this.name + "(" + this.getId() + ")" + " ", deadline);
                    throw new DiagrammerException(message);
                }
                try {
                    this.setReminder(this.taskDuration.convertReminder(deadline));
                }
                catch (AcmException e) {
                    CBLogger.error(log, "Error setting reminder: " + this.reminder, e);
                    e.printStackTrace();
                    Message message = new Message("B6014E.INVALID_TASK_PROPERTY_REMINDER", this.name + "(" + this.getId() + ")" + " ", deadline);
                    throw new DiagrammerException(message);
                }
                this.deadlineStr = this.getDeadlineJson(this.deadline, this.reminder);
            }
            if (!this.isLaunchStep && diagrammer.getObjectProperty((Object)node, "Reassign") != null && !(reassign = diagrammer.getObjectProperty((Object)node, "Reassign").toString()).isEmpty() && reassign.length() > 0) {
                this.setReassign(Boolean.parseBoolean(reassign));
            }
            if (diagrammer.getObjectProperty((Object)node, "Responses") != null) {
                String resp = diagrammer.getObjectProperty((Object)node, "Responses").toString();
                String[] respStr = resp.split(",");
                this.setResponses(Arrays.asList(respStr));
                if (resp.isEmpty()) {
                    this.setResponses(null);
                }
            }
            if (diagrammer.getObjectProperty((Object)node, "PageLayout") != null) {
                page = diagrammer.getObjectProperty((Object)node, "PageLayout").toString();
                if (!page.isEmpty() && page.length() > 0) {
                    this.setPageLayout(page);
                } else {
                    this.setPageLayout(shareInfo.getObject(AcmCaseShareInfo.SOL_PREFIX) + "_CmAcmSTEP_DEFAULT_PAGE");
                }
            }
            if (diagrammer.getObjectProperty((Object)node, "LaunchPage") != null) {
                page = diagrammer.getObjectProperty((Object)node, "LaunchPage").toString();
                if (!page.isEmpty() && page.length() > 0) {
                    this.setPageLayout(page);
                } else {
                    this.setPageLayout(shareInfo.getObject(AcmCaseShareInfo.SOL_PREFIX) + "_CmAcmSTEP_LAUNCH_DEFAULT_PAGE");
                }
            }
            if (diagrammer.getObjectProperty((Object)node, "Join") != null) {
                String joinType = diagrammer.getObjectProperty((Object)node, "Join").toString();
                if (joinType.equalsIgnoreCase("AND")) {
                    this.setJoinType(1);
                } else if (joinType.equalsIgnoreCase("OR")) {
                    this.setJoinType(2);
                } else if (joinType.equalsIgnoreCase("AUTO")) {
                    this.setJoinType(3);
                }
            } else {
                this.setJoinType(3);
            }
            if (diagrammer.getObjectProperty((Object)node, "Split") != null) {
                String splitType = diagrammer.getObjectProperty((Object)node, "Split").toString();
                if (splitType.equalsIgnoreCase("AND")) {
                    this.setSplitType(1);
                } else if (splitType.equalsIgnoreCase("OR")) {
                    this.setSplitType(2);
                } else if (splitType.equalsIgnoreCase("AUTO")) {
                    this.setSplitType(3);
                }
            } else {
                this.setSplitType(3);
            }
            this.parameters = new ArrayList<AcmTaskParameter>();
            if (diagrammer.getObjectProperty((Object)node, "Parameters") != null) {
                String paramsJSON = (String)diagrammer.getObjectProperty((Object)node, "Parameters");
                try {
                    if (paramsJSON.length() != 0) {
                        int i;
                        JSONObject params = JSONObject.parse((String)paramsJSON);
                        String casePropParamJSON = params.get((Object)"CaseProperties_Params").toString();
                        String attachmentParamJSON = params.get((Object)"Attachments_Params").toString();
                        String workgroupParamJSON = params.get((Object)"Workgroups_Params").toString();
                        String dataFieldsParamJSON = params.get((Object)"DataFields_Params").toString();
                        JSONArray caseProps = JSONArray.parse((String)casePropParamJSON);
                        JSONArray attachmentParams = JSONArray.parse((String)attachmentParamJSON);
                        JSONArray workgroupParams = JSONArray.parse((String)workgroupParamJSON);
                        JSONArray dataFieldsParam = JSONArray.parse((String)dataFieldsParamJSON);
                        if (caseProps != null) {
                            for (i = 0; i < caseProps.size(); ++i) {
                                JSONObject caseObj = (JSONObject)caseProps.get(i);
                                this.parameters.add(new AcmTaskParameter(caseObj));
                            }
                        }
                        if (attachmentParams != null) {
                            for (i = 0; i < attachmentParams.size(); ++i) {
                                JSONObject attachment = (JSONObject)attachmentParams.get(i);
                                this.parameters.add(new AcmTaskParameter(attachment));
                            }
                        }
                        if (workgroupParams != null) {
                            for (i = 0; i < workgroupParams.size(); ++i) {
                                JSONObject workgroup = (JSONObject)workgroupParams.get(i);
                                this.parameters.add(new AcmTaskParameter(workgroup));
                            }
                        }
                        if (dataFieldsParam != null) {
                            for (i = 0; i < dataFieldsParam.size(); ++i) {
                                JSONObject dataField = (JSONObject)dataFieldsParam.get(i);
                                this.parameters.add(new AcmTaskParameter(dataField));
                            }
                        }
                    }
                    this.parameterSet = new AcmTaskParameterSetWrapper(this.parameters, (Set)shareInfo.getObject(AcmCaseShareInfo.CASE_PROPERTIES_SYMBOLIC_LIST));
                }
                catch (IOException e) {
                    CBLogger.error(log, "Error updating Task parameters in ACM model :" + paramsJSON, e.getCause());
                    e.printStackTrace();
                }
            }
        } else if (this.isLaunchStep() && !adhoc) {
            this.deadline = 0L;
            this.parameters = null;
            this.parameterSet = null;
            this.responses = null;
            this.taskDuration = null;
            this.pageLayout = shareInfo.getObject(AcmCaseShareInfo.SOL_PREFIX) + "_CmAcmSTEP_LAUNCH_DEFAULT_PAGE";
        }
        CBLogger.trace(log, "<< updateAcmModelForStep()");
    }

    public void updatePeModelForStep(IlvDiagrammer diagrammer, boolean diagrammerExists, IlvSDMNode node, Map<String, AcmActivitySwimLane> swimLanesMap, boolean adhoc, VWWorkflowDefinition workflowDef, AcmCaseShareInfo shareInfo, AcmActivitySdfData acmActivitySdfData) throws DiagrammerException {
        Map queueMap = (Map)shareInfo.getObject(AcmCaseShareInfo.QUEUE_ROLE_MAP);
        CBLogger.trace(log, " >> updatePeModelForStep()");
        if (this.stepDef == null) {
            CBLogger.info(log, "AcmTask.stepDef : " + this.stepDef);
            throw new DiagrammerException("B6005E.ERROR_UPDATING_PE_MODEL");
        }
        CBLogger.trace(log, "Step: " + this.name + ", ID:" + this.getId());
        CBLogger.trace(log, "Supported step: " + this.isSupportedStep);
        if (!this.isSupportedStep) {
            CBLogger.trace(log, " << updatePeModelForStep()");
            try {
                if (this.name != null && this.name.length() > 0) {
                    ((VWCompoundStepDefinition)this.stepDef).setName(this.getName());
                }
                if (this.description != null && this.description.length() > 0) {
                    ((VWCompoundStepDefinition)this.stepDef).setDescription(this.getDescription());
                } else {
                    ((VWCompoundStepDefinition)this.stepDef).setDocumentation(null);
                }
                ((VWCompoundStepDefinition)this.stepDef).setJoinType(this.getJoinType());
                ((VWCompoundStepDefinition)this.stepDef).setSplitType(this.getSplitType());
                this.miscInfo = this.miscInfo != null ? this.stepDef.getAttributeInfo() : new VWAttributeInfo();
                String x = "-1";
                String y = "-1";
                try {
                    x = diagrammer.getObjectProperty((Object)node, "sdm:x").toString();
                    y = diagrammer.getObjectProperty((Object)node, "sdm:y").toString();
                }
                catch (NullPointerException e) {
                    x = diagrammer.getObjectProperty((Object)node, "x").toString();
                    y = diagrammer.getObjectProperty((Object)node, "y").toString();
                }
                diagrammer.setObjectProperty((Object)node, "x", (Object)x);
                diagrammer.setObjectProperty((Object)node, "y", (Object)y);
                diagrammer.setObjectProperty((Object)node, "sdm:x", (Object)x);
                diagrammer.setObjectProperty((Object)node, "sdm:y", (Object)y);
                if (this.miscInfo != null) {
                    this.miscInfo.setFieldValue("ACM_NODE_POSITION_X", (Object)x);
                    this.miscInfo.setFieldValue("ACM_NODE_POSITION_Y", (Object)y);
                }
                ((VWCompoundStepDefinition)this.stepDef).setAttributeInfo(this.miscInfo);
            }
            catch (VWException e) {
                CBLogger.error(log, e.getMessage(), e);
                e.printStackTrace();
                throw new DiagrammerException("B6005E.ERROR_UPDATING_PE_MODEL");
            }
            return;
        }
        try {
            if (this.isLaunchStep() && adhoc || !this.isLaunchStep()) {
                if (this.name != null && this.name.length() > 0) {
                    ((VWStepDefinition)this.stepDef).setName(this.getName());
                }
                if (this.description != null && this.description.length() > 0) {
                    ((VWStepDefinition)this.stepDef).setDocumentation(this.getDescription());
                } else {
                    ((VWStepDefinition)this.stepDef).setDocumentation(null);
                }
                if (this.instruction != null && this.instruction.length() > 0) {
                    ((VWStepDefinition)this.stepDef).setDescription(this.getInstruction());
                } else {
                    ((VWStepDefinition)this.stepDef).setDescription(null);
                }
                if (this.deadlineStr != null && this.deadlineStr.length() > 0) {
                    if (this.getDeadline() != -1L) {
                        ((VWStepDefinition)this.stepDef).setDeadline(this.getDeadline());
                        ((VWStepDefinition)this.stepDef).setReminder(this.getReminder());
                    }
                    if (this.getDeadline() == -1L) {
                        ((VWStepDefinition)this.stepDef).setDeadlineExpr(this.getDeadlineExpr());
                    }
                }
                if (!this.isLaunchStep) {
                    ((VWStepDefinition)this.stepDef).setCanReassign(this.getCanReassign());
                }
                if (this.responses != null && this.responses.size() > 0) {
                    String[] stepResponses = new String[this.getResponses().size()];
                    this.getResponses().toArray(stepResponses);
                    ((VWStepDefinition)this.stepDef).setResponses(stepResponses);
                } else {
                    ((VWStepDefinition)this.stepDef).setResponses(null);
                }
                if (this.getParticipantType() == "ROLE") {
                    String roleName = this.getParticipant();
                    String queueName = null;
                    queueName = AcmActivityEditorUtil.getQueueForRole(queueMap, roleName);
                    if (queueMap.containsKey(queueName)) {
                        ((VWStepDefinition)this.stepDef).setQueueName(queueName);
                    } else {
                        ((VWStepDefinition)this.stepDef).setQueueName(this.participant);
                    }
                    ((VWStepDefinition)this.stepDef).setParticipants(null);
                } else if (this.getParticipantType() == "WORKGROUP") {
                    VWParticipant[] participants;
                    ((VWStepDefinition)this.stepDef).setQueueName("Inbox");
                    VWFieldDefinition fieldDef = null;
                    try {
                        fieldDef = workflowDef.getField(this.getParticipant());
                    }
                    catch (VWException ex) {
                        // empty catch block
                    }
                    if (fieldDef == null && !this.getParticipant().startsWith("F_")) {
                        fieldDef = workflowDef.createFieldUsingObject(this.getParticipant(), (Object)new VWParticipant[0]);
                    }
                    if ((participants = ((VWStepDefinition)this.stepDef).getParticipants()) != null && participants.length > 1) {
                        ((VWStepDefinition)this.stepDef).setParticipants(participants);
                    } else {
                        VWParticipant[] participant = new VWParticipant[]{new VWParticipant(this.getParticipant())};
                        ((VWStepDefinition)this.stepDef).setParticipants(participant);
                    }
                }
                if (this.pageLayout != null && this.pageLayout.length() > 0) {
                    ((VWStepDefinition)this.stepDef).setRequestedInterface(this.pageLayout);
                } else {
                    ((VWStepDefinition)this.stepDef).setRequestedInterface(null);
                }
                ((VWStepDefinition)this.stepDef).setJoinType(this.getJoinType());
                ((VWStepDefinition)this.stepDef).setSplitType(this.getSplitType());
                if (this.parameters != null && this.parameters.size() > 0) {
                    Iterator<AcmTaskParameter> params = this.parameters.iterator();
                    int j = 0;
                    while (params.hasNext()) {
                        AcmTaskParameter param = params.next();
                        try {
                            VWParameterDefinition paramDef = this.getParameterDefinition(param.getName());
                            if (paramDef != null) {
                                ((VWStepDefinition)this.stepDef).deleteParameter(param.getName());
                            }
                        }
                        catch (VWException e) {
                            // empty catch block
                        }
                        try {
                            String prefix = "";
                            if (this.parameterSet.getCasePropertyParameters().contains(param.getName())) {
                                prefix = "F_CaseFolder.";
                            }
                            CBLogger.trace(log, "Creating paameter:" + param);
                            VWParameterDefinition paramDef = this.getParameterDefinition(param.getName());
                            if (paramDef == null) {
                                VWParameterDefinition paramCreated = ((VWStepDefinition)this.stepDef).createParameter(param.getName(), param.getMode(), prefix + param.getName(), param.getDataType(), param.isArray());
                                paramCreated.setDescription(param.getDescription());
                            }
                            if (param.getName().startsWith("F_")) continue;
                            VWFieldDefinition field = null;
                            try {
                                field = workflowDef.getField(param.getName());
                            }
                            catch (VWException e) {
                                // empty catch block
                            }
                            if (field == null) {
                                workflowDef.createFieldUsingString(param.getName(), AcmActivityEditorUtil.getDefaultValue(param.getDataType(), param.isArray()), param.getDataType(), param.isArray());
                                field = workflowDef.getField(param.getName());
                            }
                            field.setDescription(param.getDescription());
                            if (field.getFieldType() != 32) continue;
                            field.setMergeType(6);
                        }
                        catch (VWException ex) {
                            CBLogger.error(log, "Error occured while creating parameters in PE model:" + param.getName(), ex);
                            ex.printStackTrace();
                        }
                    }
                    this.cleanupParamDef(workflowDef, shareInfo, acmActivitySdfData, adhoc);
                    VWParameterDefinition[] def = ((VWStepDefinition)this.stepDef).getParameterDefinitions();
                    if (def != null) {
                        j = 0;
                        String[][] postAssignments = new String[def.length][2];
                        boolean foundPostAssignments = false;
                        if (def.length > 0) {
                            for (int i = 0; i < def.length; ++i) {
                                if (!this.parameterSet.getCasePropertyParameters().contains(def[i].getName()) && !this.parameterSet.getDataFieldParameters().contains(def[i].getName()) || def[i].getMode() != 3 && def[i].getMode() != 2) continue;
                                log.trace((Object)("Setting post assignment for: " + def[i].getName()));
                                postAssignments[j][0] = def[i].getName();
                                postAssignments[j][1] = def[i].getValue();
                                foundPostAssignments = true;
                                ++j;
                            }
                        }
                        if (foundPostAssignments) {
                            String[][] previousPostAssignments = ((VWStepDefinition)this.stepDef).getPostAssignments();
                            if (j != def.length) {
                                String[][] postAssignmentsToBeSet = new String[j][2];
                                for (int i = 0; i < j; ++i) {
                                    postAssignmentsToBeSet[i][0] = postAssignments[i][0];
                                    postAssignmentsToBeSet[i][1] = postAssignments[i][1];
                                }
                                ((VWStepDefinition)this.stepDef).setPostAssignments(this.setExpressionsInPostAssignments(postAssignmentsToBeSet, previousPostAssignments));
                            } else {
                                ((VWStepDefinition)this.stepDef).setPostAssignments(this.setExpressionsInPostAssignments(postAssignments, previousPostAssignments));
                            }
                        } else {
                            ((VWStepDefinition)this.stepDef).setPostAssignments(new String[0][0]);
                        }
                    } else {
                        ((VWStepDefinition)this.stepDef).setPostAssignments(new String[0][0]);
                    }
                } else if (this.parameters.size() == 0) {
                    this.cleanupParamDef(workflowDef, shareInfo, acmActivitySdfData, adhoc);
                    ((VWStepDefinition)this.stepDef).setPostAssignments((String[][])null);
                }
            } else {
                ((VWStepDefinition)this.stepDef).setSplitType(3);
                ((VWStepDefinition)this.stepDef).setJoinType(3);
                ((VWStepDefinition)this.stepDef).setReminder(0L);
                ((VWStepDefinition)this.stepDef).setDeadline(0L);
                ((VWStepDefinition)this.stepDef).setRequestedInterface(this.pageLayout);
            }
            this.miscInfo = new VWAttributeInfo();
            String x = "-1";
            String y = "-1";
            try {
                x = diagrammer.getObjectProperty((Object)node, "sdm:x").toString();
                y = diagrammer.getObjectProperty((Object)node, "sdm:y").toString();
            }
            catch (NullPointerException e) {
                x = diagrammer.getObjectProperty((Object)node, "x").toString();
                y = diagrammer.getObjectProperty((Object)node, "y").toString();
            }
            diagrammer.setObjectProperty((Object)node, "x", (Object)x);
            diagrammer.setObjectProperty((Object)node, "y", (Object)y);
            diagrammer.setObjectProperty((Object)node, "sdm:x", (Object)x);
            diagrammer.setObjectProperty((Object)node, "sdm:y", (Object)y);
            this.miscInfo.setFieldValue("ACM_NODE_POSITION_X", (Object)x);
            this.miscInfo.setFieldValue("ACM_NODE_POSITION_Y", (Object)y);
            this.stepDef.setAttributeInfo(this.miscInfo);
        }
        catch (VWException e) {
            CBLogger.error(log, e.getMessage(), e);
            e.printStackTrace();
            throw new DiagrammerException("B6005E.ERROR_UPDATING_PE_MODEL");
        }
        CBLogger.trace(log, "<< updatePeModelForStep()");
    }
}

