/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.diagrammer.types;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AcmStepProcessorListWrapper {
    private Set<String> pages;
    private Set<String> launchStepPages;

    public AcmStepProcessorListWrapper() {
        this.pages = new HashSet<String>();
        this.launchStepPages = new HashSet<String>();
    }

    public AcmStepProcessorListWrapper(String solutionPrefix, Set<String> stepPagesList, Set<String> stepLaunchPagesList) {
        this.pages = stepPagesList;
        this.launchStepPages = stepLaunchPagesList;
        if (this.pages == null) {
            this.pages = new HashSet<String>();
        }
        if (this.pages.size() == 0) {
            this.pages.add(solutionPrefix + "_CmAcmSTEP_DEFAULT_PAGE");
        }
        if (this.launchStepPages == null) {
            this.launchStepPages = new HashSet<String>();
        }
        if (this.launchStepPages.size() == 0) {
            this.launchStepPages.add(solutionPrefix + "_CmAcmSTEP_LAUNCH_DEFAULT_PAGE");
        }
    }

    public void addLaunchStepPages(Set<String> pages) {
        this.launchStepPages.addAll(pages);
    }

    public void addPages(Set<String> pages) {
        this.pages.addAll(pages);
    }

    public Set<String> getLaunchStepPages() {
        return this.launchStepPages;
    }

    public Set<String> getPages() {
        return this.pages;
    }

    public void setLaunchStepPages(Set<String> launchStepPages) {
        this.launchStepPages = launchStepPages;
    }

    public void setPages(Set<String> pages) {
        this.pages = pages;
    }

    public JSONObject toJSONObject() {
        JSONObject obj = new JSONObject();
        JSONArray pagesJSONArray = new JSONArray();
        JSONArray launchPagesJSONArray = new JSONArray();
        Iterator<String> i1 = this.pages.iterator();
        while (i1.hasNext()) {
            JSONObject pageObj = new JSONObject();
            pageObj.put((Object)"Page", (Object)i1.next());
            pagesJSONArray.add((Object)pageObj);
        }
        i1 = this.launchStepPages.iterator();
        while (i1.hasNext()) {
            JSONObject launchPageObj = new JSONObject();
            launchPageObj.put((Object)"Page", (Object)i1.next());
            launchPagesJSONArray.add((Object)launchPageObj);
        }
        obj.put((Object)"StepPages", (Object)pagesJSONArray);
        obj.put((Object)"LaunchStepPages", (Object)launchPagesJSONArray);
        return obj;
    }
}

