/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.diagrammer.types;

import com.ibm.acm.sold.diagrammer.AcmActivityEditorUtil;
import com.ibm.acm.sold.diagrammer.exceptions.DiagrammerException;
import filenet.vw.api.VWException;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import ilog.views.diagrammer.IlvDiagrammer;
import ilog.views.sdm.model.IlvSDMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcmRoute {
    private String name;
    private String description;
    public String condition;
    private String sourceTaskId;
    private String destinationTaskId;
    private String routeId;
    private VWRouteDefinition route;
    private boolean conditionalRoute = false;
    private static final Log log = LogFactory.getLog((String)AcmRoute.class.getName());

    public AcmRoute(IlvDiagrammer diagrammer, IlvSDMNode node, VWMapDefinition mapDef) throws DiagrammerException {
        log.trace((Object)">> AcmRoute()");
        IlvSDMNode source = (IlvSDMNode)diagrammer.getSourceNode((Object)node);
        IlvSDMNode target = (IlvSDMNode)diagrammer.getTargetNode((Object)node);
        VWMapNode sourceStep = null;
        VWMapNode targetStep = null;
        try {
            sourceStep = mapDef.getStep(AcmActivityEditorUtil.createStepIdFromAcmTaskId(source.getID()));
            targetStep = mapDef.getStep(AcmActivityEditorUtil.createStepIdFromAcmTaskId(target.getID()));
            VWRouteDefinition existingRoute = null;
            try {
                existingRoute = sourceStep.getRouteTo(targetStep.getStepId());
                if (existingRoute != null) {
                    sourceStep.deleteRoute(existingRoute.getRouteId());
                }
            }
            catch (VWException e) {
                log.error((Object)"Error occured while delete existing route", (Throwable)e);
            }
            sourceStep.createRoute(targetStep.getStepId());
            this.route = targetStep.getRouteFrom(sourceStep.getStepId());
            this.setRouteId(AcmActivityEditorUtil.createAcmRouteIdFromRouteId(this.route.getRouteId()));
            diagrammer.setObjectProperty((Object)node, "jviewsid", (Object)node.getID());
            diagrammer.setID((Object)node, this.routeId);
            diagrammer.setObjectProperty((Object)node, "sourceStep", (Object)source.getID());
            diagrammer.setObjectProperty((Object)node, "targetStep", (Object)target.getID());
            log.trace((Object)("Source:" + sourceStep.getName() + " , Target :" + targetStep.getName()));
        }
        catch (VWException e) {
            e.printStackTrace();
            log.error((Object)("Source:" + sourceStep.getName() + " , Target :" + targetStep.getName()));
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new DiagrammerException("B6005E.ERROR_UPDATING_PE_MODEL");
        }
        log.trace((Object)"<< AcmRoute()");
    }

    public AcmRoute(IlvDiagrammer diagrammer, VWMapDefinition mapDef) {
    }

    public AcmRoute(VWRouteDefinition routeDefinition) {
        log.trace((Object)">> AcmRoute(routeDefinition)");
        this.route = routeDefinition;
        this.name = routeDefinition.getName();
        this.description = routeDefinition.getDescription();
        this.routeId = AcmActivityEditorUtil.createAcmRouteIdFromRouteId(routeDefinition.getRouteId());
        this.sourceTaskId = AcmActivityEditorUtil.createAcmTaskIdFromStepId(routeDefinition.getSourceStepId());
        this.destinationTaskId = AcmActivityEditorUtil.createAcmTaskIdFromStepId(routeDefinition.getDestinationStepId());
        this.condition = routeDefinition.getCondition();
        if (this.condition != null) {
            if (this.condition.contains("ALL(")) {
                this.conditionalRoute = false;
                this.condition = this.condition.substring(4, this.condition.length() - 1);
            } else {
                this.conditionalRoute = true;
            }
        }
        log.trace((Object)"<< AcmRoute(routeDefinition)");
    }

    public String getCondition() {
        return this.condition;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDestinationTaskId() {
        return this.destinationTaskId;
    }

    public String getName() {
        return this.name;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public String getSourceTaskId() {
        return this.sourceTaskId;
    }

    public VWRouteDefinition getVWRouteDefinition() {
        return this.route;
    }

    public void setCondition(String conditions) {
        this.condition = conditions;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDestinationTaskId(String destinationTaskId) {
        this.destinationTaskId = destinationTaskId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public void setSourceTaskId(String sourceTaskId) {
        this.sourceTaskId = sourceTaskId;
    }

    public String toString() {
        return this.routeId + "::" + this.name + "::" + this.description + "::" + this.sourceTaskId + "::" + this.destinationTaskId + "::" + this.condition;
    }

    public void updateAcmModelForRoute(IlvDiagrammer diagrammer, IlvSDMNode node) {
        log.trace((Object)">> updateAcmModelForRoute()");
        if (diagrammer.getObjectProperty((Object)node, "Name") != null) {
            this.setName((String)diagrammer.getObjectProperty((Object)node, "Name"));
        }
        if (diagrammer.getObjectProperty((Object)node, "Description") != null) {
            this.setDescription((String)diagrammer.getObjectProperty((Object)node, "Description"));
        }
        if (diagrammer.getObjectProperty((Object)node, "Conditions") != null) {
            if (diagrammer.getObjectProperty((Object)node, "Conditions").toString().equalsIgnoreCase("None") || diagrammer.getObjectProperty((Object)node, "Conditions").toString().equalsIgnoreCase("")) {
                this.setCondition(null);
            } else if (!diagrammer.getObjectProperty((Object)node, "Conditions").toString().equalsIgnoreCase("") && !diagrammer.getObjectProperty((Object)node, "Conditions").toString().equalsIgnoreCase("None")) {
                if (!this.conditionalRoute) {
                    this.setCondition("ALL(" + diagrammer.getObjectProperty((Object)node, "Conditions").toString() + ")");
                } else {
                    this.setCondition(diagrammer.getObjectProperty((Object)node, "Conditions").toString());
                }
            }
        }
        log.trace((Object)"<< updateAcmModelForRoute()");
    }

    public void updatePeModelForRoute() {
        log.trace((Object)">> updatePeModelForRoute()");
        if (this.getName() != null) {
            this.route.setName(this.getName());
        }
        if (this.getDescription() != null) {
            this.route.setDescription(this.getDescription());
        }
        if (this.getCondition() != null) {
            if (this.getCondition().equalsIgnoreCase("Conditions")) {
                this.route.setCondition(null);
            } else {
                this.route.setCondition(this.getCondition());
            }
        }
        log.trace((Object)"<< updatePeModelForRoute()");
    }
}

