/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.diagrammer.types;

import com.ibm.acm.sold.diagrammer.AcmActivityEditorUtil;
import com.ibm.acm.sold.diagrammer.exceptions.DiagrammerException;
import ilog.views.diagrammer.IlvDiagrammer;
import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcmActivitySwimLane {
    private String activityName;
    private String swimLaneName;
    private String swimLaneType;
    private Point position;
    private String description;
    private int size = 100;
    private List<String> taskIdsContained = new ArrayList<String>();
    public static final String SWIMLANE_ROLE = "ROLE";
    public static final String SWIMLANE_WORKGROUP = "WORKGROUP";
    public static final String SWIMLANE_UNSUPPORTED = "UNSUPPORTED";
    public static final String SWIMLANE_TEMP = "UNDEFINED";
    public static final String SWIMLANE_NAME_UNSUPPORTED = "System";
    public static final String SWIMLANE_NAME_NO_PARTICPANT = "Undefined Participants";
    public static final int SWIMLANE_GAP = 0;
    public static final int SWIMLANE_HEIGHT = 100;
    private static final Log log = LogFactory.getLog((String)AcmActivitySwimLane.class.getName());

    public AcmActivitySwimLane() {
    }

    public AcmActivitySwimLane(IlvDiagrammer diagrammer, IlvSDMNode node) throws DiagrammerException {
        log.debug((Object)">> AcmActivitySwimLane()");
        String laneType = (String)diagrammer.getObjectProperty((Object)node, "Type");
        String lane = null;
        lane = laneType.equalsIgnoreCase(SWIMLANE_ROLE) ? (String)diagrammer.getObjectProperty((Object)node, "Role") : (laneType.equalsIgnoreCase(SWIMLANE_WORKGROUP) ? (String)diagrammer.getObjectProperty((Object)node, "Workgroup") : (String)diagrammer.getObjectProperty((Object)node, "Name"));
        lane = AcmActivityEditorUtil.removeJViewsPadding(lane);
        if (lane != null && lane.length() != 0) {
            this.setSwimLaneName(lane);
        } else {
            log.error((Object)("Invalid swimlane name" + lane));
            this.setSwimLaneName("");
        }
        if (laneType == null || lane == null) {
            log.error((Object)("Lane :" + lane + ", LaneType :" + laneType));
            throw new DiagrammerException("B6006E.ERROR_READING_DIAGRAM");
        }
        this.setActivityName("");
        if (laneType != null) {
            if (laneType.equalsIgnoreCase(SWIMLANE_WORKGROUP)) {
                this.setSwimLaneType(SWIMLANE_WORKGROUP);
            } else if (laneType.equalsIgnoreCase(SWIMLANE_ROLE)) {
                this.setSwimLaneType(SWIMLANE_ROLE);
            } else if (laneType.equalsIgnoreCase(SWIMLANE_UNSUPPORTED)) {
                this.setSwimLaneType(SWIMLANE_UNSUPPORTED);
            } else {
                this.setSwimLaneType(SWIMLANE_TEMP);
            }
        }
        this.position = new Point();
        try {
            if (diagrammer.getObjectProperty((Object)node, "sdm:LaneSize") != null) {
                this.size = (int)Float.parseFloat(diagrammer.getObjectProperty((Object)node, "sdm:LaneSize").toString());
            }
            this.position.x = (int)Float.parseFloat(diagrammer.getObjectProperty((Object)node, "sdm:x").toString());
            this.position.y = (int)Float.parseFloat(diagrammer.getObjectProperty((Object)node, "sdm:y").toString());
        }
        catch (NullPointerException e) {
            this.position.x = (int)Float.parseFloat(diagrammer.getObjectProperty((Object)node, "x").toString());
            this.position.y = (int)Float.parseFloat(diagrammer.getObjectProperty((Object)node, "y").toString());
        }
        diagrammer.setObjectProperty((Object)node, "x", (Object)this.position.x);
        diagrammer.setObjectProperty((Object)node, "y", (Object)this.position.y);
        diagrammer.setObjectProperty((Object)node, "sdm:x", (Object)this.position.x);
        diagrammer.setObjectProperty((Object)node, "sdm:y", (Object)this.position.y);
        this.addTaskId(node.getID());
        log.debug((Object)"<< AcmActivitySwimLane()");
    }

    public void addTaskId(String taskId) {
        this.taskIdsContained.add(taskId);
    }

    public String getActivityName() {
        return this.activityName;
    }

    public Point getPosition() {
        return this.position;
    }

    public String getSwimLaneName() {
        return this.swimLaneName;
    }

    public String getSwimLaneType() {
        return this.swimLaneType;
    }

    public List<String> getTaskIdsContained() {
        return this.taskIdsContained;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public void setSwimLaneName(String swimLaneName) {
        this.swimLaneName = swimLaneName;
    }

    public void setSwimLaneType(String i) {
        this.swimLaneType = i;
    }

    public void setTaskIdsContained(List<String> taskIdsContained) {
        this.taskIdsContained = taskIdsContained;
    }

    public String infoString() {
        return this.swimLaneName + "," + this.position.x + "," + this.position.y + "," + this.getSwimLaneType() + "," + this.size;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }
}

