/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.diagrammer.types;

import com.ibm.acm.sold.connector.PEConfig;
import com.ibm.acm.sold.diagrammer.AcmActivityEditorUtil;
import com.ibm.acm.sold.diagrammer.AcmActivitySdfData;
import com.ibm.acm.sold.diagrammer.exceptions.AcmMapDefinitionException;
import com.ibm.acm.sold.diagrammer.exceptions.DiagrammerException;
import com.ibm.acm.sold.diagrammer.types.AcmActivityAttachment;
import com.ibm.acm.sold.diagrammer.types.AcmActivitySwimLane;
import com.ibm.acm.sold.diagrammer.types.AcmCaseShareInfo;
import com.ibm.acm.sold.diagrammer.types.AcmRoute;
import com.ibm.acm.sold.diagrammer.types.AcmTask;
import com.ibm.acm.sold.diagrammer.types.AcmTaskParameter;
import com.ibm.acm.sold.diagrammer.types.AcmTaskParameterSetWrapper;
import com.ibm.acm.sold.diagrammer.types.AcmWorkGroupDefinition;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumWorkflowType;
import com.ibm.xmlns.prod.ecm.acm.sdf.PropertyMapType;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import ilog.views.diagrammer.IlvDiagrammer;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.model.IlvSDMNode;
import ilog.views.sdm.renderer.IlvLaneRenderer;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcmActivity {
    private String name;
    private String symbolicName;
    private String description;
    private IlvDiagrammer diagrammer;
    private List<AcmTask> tasks;
    private List<AcmRoute> routes;
    private Set<AcmActivityAttachment> attachments;
    private String mainAttachment;
    private VWWorkflowDefinition workflowDef;
    private AcmTask launchStep;
    private VWMapDefinition mapDef;
    private List<IlvSDMNode> renderLast;
    private Map<String, AcmActivitySwimLane> swimLanesMap;
    public static int DEFAULT_STARTING_XPOSITION_OF_NODES = 50;
    private Map<String, Integer> xPosOfNodesInLanes = new HashMap<String, Integer>();
    public static int DEFAULT_HORIZONTAL_NODE_SPACING = 130;
    private AcmActivitySdfData sdfData;
    private Set<String> casePropertiesInUse;
    private Set<AcmWorkGroupDefinition> workgroups;
    private Set<String> pagesUsed;
    private Set<String> launchStepPagesUsed;
    private static final Log log = LogFactory.getLog((String)"com.ibm.acm.sold.diagrammer.type.AcmActivity");
    public static String MAINMAP = "Workflow";
    public static String CASEUPDATE = "CaseUpdate";
    public static String ASSIGNMENTS = "Assignments";
    public static String TERMINATE = "Terminate";
    public static String CALL = "Call";
    public boolean isTaskForReuseWorkflow = false;
    public String BaseWorkClassName = "CaseWorkObject";

    public AcmActivity() throws DiagrammerException {
        try {
            this.workflowDef = new VWWorkflowDefinition();
        }
        catch (VWException e) {
            e.printStackTrace();
        }
    }

    public AcmActivity(VWWorkflowDefinition wfDef) {
        this.workflowDef = wfDef;
        this.description = this.workflowDef.getDescription();
        this.setTaskForReuseWorkflow(true);
        this.BaseWorkClassName = this.workflowDef.getBaseWorkClassName();
    }

    public AcmActivity(VWWorkflowDefinition wfDef, AcmCaseShareInfo acmCaseShareInfo, boolean adhoc) throws DiagrammerException {
        log.trace((Object)">> AcmActivity(wfDef,caseShareInfo");
        this.workflowDef = wfDef;
        try {
            this.description = this.workflowDef.getDescription();
            this.tasks = new ArrayList<AcmTask>();
            this.routes = new ArrayList<AcmRoute>();
            this.swimLanesMap = AcmActivityEditorUtil.getSwimLanes(this.workflowDef, acmCaseShareInfo);
            this.workgroups = AcmActivityEditorUtil.createAcmWorkGroupListFromVWWorkflow(wfDef);
            this.attachments = AcmActivityEditorUtil.createAcmAttachmentListFromVWWorkflow(wfDef);
            this.BaseWorkClassName = this.workflowDef.getBaseWorkClassName();
            this.mainAttachment = this.workflowDef.getMainAttachmentName();
            this.mapDef = this.workflowDef.getMainMap();
            if (this.mapDef == null) {
                log.error((Object)"No Map found in VWWorkflowDefinition object. Cannot create activity");
                throw new AcmMapDefinitionException("No Map found in VWWorkflowDefinition object. Cannot create activity");
            }
            VWMapNode[] nodes = this.mapDef.getSteps();
            HashSet<String> routeSet = new HashSet<String>();
            this.launchStep = new AcmTask((VWMapNode)wfDef.getLaunchStep(), acmCaseShareInfo, adhoc);
            if (nodes != null) {
                for (int i = 0; i < nodes.length; ++i) {
                    AcmTask task = new AcmTask(nodes[i], acmCaseShareInfo, adhoc);
                    this.tasks.add(task);
                    VWRouteDefinition[] routeDef = nodes[i].getNextRoutes();
                    if (!adhoc && routeDef != null && routeDef[0].getSourceStep().getName().equals("LaunchStep")) {
                        routeDef[0].setCondition("");
                    }
                    if (routeDef == null) continue;
                    for (int j = 0; j < routeDef.length; ++j) {
                        if (routeSet.contains(AcmActivityEditorUtil.createAcmRouteIdFromRouteId(routeDef[j].getRouteId()))) continue;
                        this.routes.add(new AcmRoute(routeDef[j]));
                        routeSet.add(AcmActivityEditorUtil.createAcmRouteIdFromRouteId(routeDef[j].getRouteId()));
                    }
                }
            }
        }
        catch (VWException e) {
            log.error((Object)("Error creating Activity:" + this.name), (Throwable)e);
            e.printStackTrace();
            throw new DiagrammerException(e.getCauseDescription());
        }
    }

    public void addRoute(IlvDiagrammer diagrammer, String[] params) {
        AcmRoute newRoute = new AcmRoute(diagrammer, this.getMapDef());
        this.routes.add(newRoute);
    }

    public void addSwimLaneToCanvas(IlvDiagrammer diagrammer, AcmActivitySwimLane lane, IlvSDMEngine engine, IlvLaneRenderer laneRenderer) {
        log.trace((Object)(">> addswimLaneToCanvas() for " + lane.getSwimLaneName()));
        Object Lane = null;
        if (lane.getSwimLaneType().equalsIgnoreCase("ROLE")) {
            Lane = diagrammer.createNode("LaneRole");
            diagrammer.setObjectProperty(Lane, "Role", (Object)lane.getSwimLaneName());
            diagrammer.setObjectProperty(Lane, "Type", (Object)"ROLE");
        } else if (lane.getSwimLaneType().equalsIgnoreCase("WORKGROUP")) {
            Lane = diagrammer.createNode("LaneWorkgroup");
            diagrammer.setObjectProperty(Lane, "Workgroup", (Object)lane.getSwimLaneName());
            diagrammer.setObjectProperty(Lane, "Workgroup", (Object)lane.getSwimLaneName());
            diagrammer.setObjectProperty(Lane, "Type", (Object)"WORKGROUP");
        } else {
            Lane = diagrammer.createNode("Lane");
            diagrammer.setObjectProperty(Lane, "Name", (Object)lane.getSwimLaneName());
        }
        diagrammer.setObjectProperty(Lane, "BiDiLabel", (Object)AcmActivityEditorUtil.addJViewsPadding(lane.getSwimLaneName()));
        if (lane.getSwimLaneType().equalsIgnoreCase("UNSUPPORTED")) {
            diagrammer.setObjectProperty(Lane, "Type", (Object)"UNSUPPORTED");
        }
        if (lane.getSwimLaneType().equalsIgnoreCase("UNDEFINED")) {
            diagrammer.setObjectProperty(Lane, "Type", (Object)"UNDEFINED");
        }
        diagrammer.setObjectProperty(Lane, "x", (Object)lane.getPosition().x);
        diagrammer.setObjectProperty(Lane, "y", (Object)lane.getPosition().y);
        diagrammer.setObjectProperty(Lane, "LaneName", (Object)lane.getSwimLaneName());
        diagrammer.setObjectProperty(Lane, "LaneSize", (Object)lane.getSize());
        this.xPosOfNodesInLanes.put(lane.getSwimLaneName(), new Integer(DEFAULT_STARTING_XPOSITION_OF_NODES));
        diagrammer.addObject(Lane, null);
        log.trace((Object)("Added swimlane:" + lane.infoString()));
        log.trace((Object)("<< addSwimLaneToCanvas() for" + lane.getSwimLaneName()));
    }

    public void addTask(IlvDiagrammer diagrammer, String[] params) {
        AcmTask newTask = new AcmTask(diagrammer, this.getMapDef());
        this.tasks.add(newTask);
    }

    public void autoResolveSplits() {
        log.trace((Object)">> autoResolveSplits");
        Iterator<AcmTask> i1 = this.tasks.iterator();
        ArrayList<AcmTask> tasksUpdated = new ArrayList<AcmTask>();
        while (i1.hasNext()) {
            AcmTask task = i1.next();
            List<String> responses = task.getResponses();
            if (responses != null) {
                HashSet<String> conditionSet = new HashSet<String>();
                VWRouteDefinition[] routeDef = null;
                try {
                    routeDef = task.getStepDef().getNextRoutes();
                }
                catch (VWException e) {
                    log.error((Object)("Error getting routeDefinition for step:" + task.getId()));
                    e.printStackTrace();
                }
                if (routeDef != null && routeDef.length > 0) {
                    for (int i = 0; i < routeDef.length; ++i) {
                        if (routeDef[i].getCondition() == null) continue;
                        if (routeDef[i].getCondition().length() > 0) {
                            conditionSet.add(routeDef[i].getCondition());
                            continue;
                        }
                        conditionSet.add("None");
                    }
                }
                if (task.getSplitType() == 3 || task.getSplitType() == 3) {
                    if (conditionSet.size() <= 1) {
                        task.setSplitType(3);
                    } else if (conditionSet.size() == routeDef.length && !conditionSet.contains("None")) {
                        task.setSplitType(2);
                    } else {
                        task.setSplitType(1);
                    }
                }
                tasksUpdated.add(task);
            }
            log.trace((Object)("Updated splits in :" + tasksUpdated.size() + " steps"));
            i1 = tasksUpdated.iterator();
            while (i1.hasNext()) {
                this.updateTaskById(i1.next());
            }
        }
        log.trace((Object)"<< autoResolveSplits");
    }

    private String convertTaskParamsToJSON(List<AcmTaskParameter> params, AcmTaskParameterSetWrapper list) {
        log.trace((Object)">> convertTaskParamsToJSON(ACMparams,wrapperList)");
        JSONObject parameters = new JSONObject();
        JSONArray caseProps = new JSONArray();
        JSONArray attachments = new JSONArray();
        JSONArray workgroups = new JSONArray();
        JSONArray dataFields = new JSONArray();
        for (AcmTaskParameter param : params) {
            if (list.getCasePropertyParameters().contains(param.getName())) {
                caseProps.add((Object)param.toJSONObject());
                continue;
            }
            if (list.getAttachmentParameters().contains(param.getName())) {
                attachments.add((Object)param.toJSONObject());
                continue;
            }
            if (list.getWorkgroupParameters().contains(param.getName())) {
                workgroups.add((Object)param.toJSONObject());
                continue;
            }
            dataFields.add((Object)param.toJSONObject());
        }
        parameters.put((Object)"CaseProperties_Params", (Object)caseProps);
        parameters.put((Object)"Attachments_Params", (Object)attachments);
        parameters.put((Object)"Workgroups_Params", (Object)workgroups);
        parameters.put((Object)"DataFields_Params", (Object)dataFields);
        String paramString = parameters.toString();
        log.trace((Object)("Parameters created:" + paramString));
        log.trace((Object)"<<convertTaskParamsToJSON(ACMparams,wrapperList)");
        return paramString;
    }

    public Set<AcmActivityAttachment> getAttachments() {
        return this.attachments;
    }

    public Set<String> getCasePropertiesInUse() {
        return this.casePropertiesInUse;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMainAttachment() {
        return this.mainAttachment;
    }

    public IlvDiagrammer getDiagrammer() {
        return this.diagrammer;
    }

    public AcmTask getLaunchStep() {
        return this.launchStep;
    }

    public Set<String> getLaunchStepPagesUsed() {
        return this.launchStepPagesUsed;
    }

    public VWMapDefinition getMapDef() {
        return this.mapDef;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getPagesUsed() {
        return this.pagesUsed;
    }

    private AcmRoute getRoute(String name2) {
        return null;
    }

    public AcmRoute getRouteById(String id) {
        Iterator<AcmRoute> routeIterator = this.routes.iterator();
        AcmRoute route = null;
        if (routeIterator != null) {
            while (routeIterator.hasNext()) {
                route = routeIterator.next();
                if (!id.equals(route.getRouteId())) continue;
                return route;
            }
        }
        return null;
    }

    public AcmRoute getRouteByName(String routeName) {
        Iterator<AcmRoute> routeIterator = this.routes.iterator();
        AcmRoute route = null;
        if (routeIterator != null) {
            while (routeIterator.hasNext()) {
                route = routeIterator.next();
                if (!routeName.equals(route.getName())) continue;
                return route;
            }
        }
        return null;
    }

    public List<AcmRoute> getRoutes() {
        return this.routes;
    }

    public AcmActivitySdfData getSdfData() {
        return this.sdfData;
    }

    public Map<String, AcmActivitySwimLane> getSwimLanesMap() {
        return this.swimLanesMap;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public AcmTask getTaskById(String id) {
        Iterator<AcmTask> taskIterator = this.tasks.iterator();
        AcmTask task = null;
        if (taskIterator != null) {
            while (taskIterator.hasNext()) {
                task = taskIterator.next();
                if (!id.equals(task.getId())) continue;
                return task;
            }
        }
        return null;
    }

    public AcmTask getTaskByName(String taskName) {
        Iterator<AcmTask> taskIterator = this.tasks.iterator();
        AcmTask task = null;
        if (taskIterator != null) {
            while (taskIterator.hasNext()) {
                task = taskIterator.next();
                if (!taskName.equals(task.getName())) continue;
                return task;
            }
        }
        return null;
    }

    public List<AcmTask> getTasks() {
        return this.tasks;
    }

    public VWWorkflowDefinition getVWWorkflowDefinition() {
        return this.workflowDef;
    }

    public VWWorkflowDefinition getWorkflowDef() {
        return this.workflowDef;
    }

    public Set<AcmWorkGroupDefinition> getWorkgroupDef() {
        return this.workgroups;
    }

    public void initAcmActivity(AcmCaseShareInfo shareInfo) throws AcmException {
        try {
            log.trace((Object)">> initAcmActivity()");
            log.trace((Object)("Creating Activity:" + this.name));
            this.tasks = new ArrayList<AcmTask>();
            this.routes = new ArrayList<AcmRoute>();
            this.swimLanesMap = new HashMap<String, AcmActivitySwimLane>();
            this.diagrammer = new IlvDiagrammer();
            if (this.workflowDef == null) {
                this.workflowDef = new VWWorkflowDefinition();
            }
            this.updateBasicWorkflowProperties(shareInfo);
            if (this.isTaskForReuseWorkflow()) {
                log.info((Object)"Reused work flow, don't initialize any diagrammer fields ");
                return;
            }
            this.mapDef = this.workflowDef.getMainMap();
            VWStepDefinition launchStep = (VWStepDefinition)this.mapDef.getStartStep();
            this.launchStep = new AcmTask((VWMapNode)launchStep, shareInfo, this.sdfData.getUserCreatable());
            this.launchStep.setLaunchStep(true);
            this.tasks.add(this.launchStep);
            IlvSDMNode launchNode = (IlvSDMNode)this.diagrammer.createNode(this.launchStep.getName());
            IlvSDMEngine engine = this.diagrammer.getEngine();
            IlvLaneRenderer laneRenderer = new IlvLaneRenderer();
            String participantName = null;
            Map activityConfig = (Map)shareInfo.getObject(AcmCaseShareInfo.ACTIVITY_CONFIG_INFO);
            AcmActivitySwimLane noParticipantLane = new AcmActivitySwimLane();
            Point position2 = new Point(0, 0);
            if (activityConfig != null) {
                participantName = (String)activityConfig.get("SWIMLANE_NAME_NO_PARTICPANT");
            }
            if (participantName == null) {
                participantName = "Undefined Participants";
            }
            noParticipantLane.setSwimLaneName(participantName);
            noParticipantLane.setSwimLaneType("UNDEFINED");
            noParticipantLane.setPosition(position2);
            this.swimLanesMap.put(participantName, noParticipantLane);
            this.addSwimLaneToCanvas(this.diagrammer, noParticipantLane, engine, laneRenderer);
            AcmActivitySwimLane laneUnSupport = new AcmActivitySwimLane();
            Point position1 = new Point(0, 100);
            participantName = null;
            if (activityConfig != null) {
                participantName = (String)activityConfig.get("SWIMLANE_NAME_UNSUPPORTED");
            }
            if (participantName == null) {
                participantName = "System";
            }
            laneUnSupport.setSwimLaneName(participantName);
            laneUnSupport.setSwimLaneType("UNSUPPORTED");
            laneUnSupport.setPosition(position1);
            this.swimLanesMap.put(participantName, laneUnSupport);
            this.addSwimLaneToCanvas(this.diagrammer, laneUnSupport, engine, laneRenderer);
            participantName = (String)activityConfig.get("SWIMLANE_NAME_NO_PARTICPANT");
            log.info((Object)("participantName :" + participantName));
            if (null == participantName) {
                participantName = "Undefined Participants";
            }
            int x = this.xPosOfNodesInLanes.get(participantName);
            float y = this.swimLanesMap.get((Object)participantName).getPosition().y;
            y = y >= 100.0f ? y + 50.0f - 25.0f : 25.0f;
            this.xPosOfNodesInLanes.remove(participantName);
            this.xPosOfNodesInLanes.put(participantName, new Integer(x += DEFAULT_HORIZONTAL_NODE_SPACING));
            this.diagrammer.setObjectProperty((Object)launchNode, "x", (Object)DEFAULT_STARTING_XPOSITION_OF_NODES);
            this.diagrammer.setObjectProperty((Object)launchNode, "y", (Object)Float.valueOf(y));
            this.diagrammer.setID((Object)launchNode, this.launchStep.getId());
            this.diagrammer.setObjectProperty((Object)launchNode, "jviewsid", (Object)this.launchStep.getId());
            if (this.sdfData.getUserCreatable()) {
                this.diagrammer.setObjectProperty((Object)launchNode, "Instruction", (Object)"");
                this.diagrammer.setObjectProperty((Object)launchNode, "Deadline", (Object)"");
                this.diagrammer.setObjectProperty((Object)launchNode, "Reminder", (Object)"");
                this.diagrammer.setObjectProperty((Object)launchNode, "Responses", (Object)"");
                this.diagrammer.setObjectProperty((Object)launchNode, "Parameters", (Object)"");
                this.diagrammer.setObjectProperty((Object)launchNode, "LaunchPage", (Object)(shareInfo.getObject(AcmCaseShareInfo.SOL_PREFIX) + "_CmAcmSTEP_LAUNCH_DEFAULT_PAGE"));
                this.diagrammer.setObjectProperty((Object)launchNode, "LaunchMode", (Object)"userCreated");
                this.diagrammer.setObjectProperty((Object)launchNode, "Split", (Object)"");
                this.diagrammer.setObjectProperty((Object)launchNode, "Join", (Object)"");
            }
            this.diagrammer.setObjectProperty((Object)launchNode, "Name", (Object)this.launchStep.getName());
            this.diagrammer.setObjectProperty((Object)launchNode, "BiDiLabel", (Object)AcmActivityEditorUtil.addJViewsPadding(this.launchStep.getName()));
            this.diagrammer.setObjectProperty((Object)launchNode, "Description", (Object)this.launchStep.getDescription());
            this.diagrammer.setObjectProperty((Object)launchNode, "StartStep", (Object)"true");
            this.diagrammer.setObjectProperty((Object)launchNode, "Supported", (Object)"true");
            this.diagrammer.setObjectProperty((Object)launchNode, "Lane", (Object)noParticipantLane.getSwimLaneName());
            this.diagrammer.setObjectProperty((Object)launchNode, "sdm:Lane", (Object)noParticipantLane.getSwimLaneName());
            this.diagrammer.addObject((Object)launchNode, null);
            this.updateModel(this.diagrammer, false, shareInfo);
        }
        catch (VWException e) {
            log.error((Object)"Error in initAcmActivity()", (Throwable)e);
            e.printStackTrace();
            throw new DiagrammerException(e.getMessage());
        }
        log.trace((Object)"<< initAcmActivity()");
    }

    public void removeRoute(String id) {
        this.routes.remove(this.getRoute(this.name));
    }

    public void removeTask(String name) {
        this.tasks.remove(this.getTaskByName(name));
    }

    public Set<String> returnRoleLanesQueueNames(AcmCaseShareInfo shareInfo) {
        HashSet<String> roleLaneQueueNames = new HashSet<String>();
        String solPrefix = (String)shareInfo.getObject(AcmCaseShareInfo.SOL_PREFIX);
        if (this.swimLanesMap != null) {
            Iterator<String> i1 = this.swimLanesMap.keySet().iterator();
            while (i1.hasNext()) {
                AcmActivitySwimLane lane = this.swimLanesMap.get(i1.next());
                if (!lane.getSwimLaneType().equalsIgnoreCase("ROLE")) continue;
                roleLaneQueueNames.add(solPrefix + "_" + PEConfig.removeSpecialCharacters(lane.getSwimLaneName()));
            }
        }
        return roleLaneQueueNames;
    }

    public void setAttachments(Set<AcmActivityAttachment> attachments) {
        this.attachments = attachments;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDiagrammer(IlvDiagrammer diagrammer) {
        this.diagrammer = new IlvDiagrammer();
        AcmActivityEditorUtil.copyDiagrammerOld(diagrammer, this.diagrammer);
    }

    public void setGuid(String caseTypeGuid, String activityGuid) throws VWException {
        log.trace((Object)">> setGuid()");
        log.info((Object)("CaseType Guid :" + caseTypeGuid));
        log.info((Object)("Activity Guid :" + activityGuid));
        VWFieldDefinition caseFolderDef = null;
        try {
            caseFolderDef = this.workflowDef.getField("F_CaseFolder");
        }
        catch (VWException e) {
            // empty catch block
        }
        if (caseFolderDef == null) {
            caseFolderDef = this.workflowDef.createFieldUsingString("F_CaseFolder", AcmActivityEditorUtil.getDefaultValue(512, false), 512, false);
        }
        caseFolderDef.setRequiredClass(new VWGuid(caseTypeGuid));
        VWFieldDefinition caseActivityDef = null;
        try {
            caseActivityDef = this.workflowDef.getField("F_CaseTask");
        }
        catch (VWException e) {
            // empty catch block
        }
        if (caseActivityDef == null) {
            caseActivityDef = this.workflowDef.createFieldUsingString("F_CaseTask", AcmActivityEditorUtil.getDefaultValue(512, false), 512, false);
        }
        caseActivityDef.setRequiredClass(new VWGuid(activityGuid));
        log.trace((Object)"<< setGuid()");
    }

    public void setLaunchModeString(String launchMode) {
    }

    public void setLaunchStep(AcmTask launchStep) {
        this.launchStep = launchStep;
    }

    public void setLaunchStepPagesUsed(Set<String> launchStepPagesUsed) {
        this.launchStepPagesUsed = launchStepPagesUsed;
    }

    public void setMapDef(VWMapDefinition mapDef) {
        this.mapDef = mapDef;
    }

    public void setName(String dname) {
        this.name = dname;
    }

    public void setPagesUsed(Set<String> pagesUsed) {
        this.pagesUsed = pagesUsed;
    }

    public void setSdfData(AcmActivitySdfData sdfData) {
        this.sdfData = sdfData;
    }

    public void setSwimLanesMap(Map<String, AcmActivitySwimLane> swimLanesMap) {
        this.swimLanesMap = swimLanesMap;
    }

    public void setSymbolicName(String sname) {
        this.symbolicName = sname;
    }

    public void setWorkflowDef(VWWorkflowDefinition workflowDef) {
        this.workflowDef = workflowDef;
    }

    public void setWorkgroupDef(Set<AcmWorkGroupDefinition> workgroupDef) {
        this.workgroups = workgroupDef;
    }

    public IlvDiagrammer toDiagrammerModel(IlvDiagrammer diagrammer, AcmCaseShareInfo acmCaseShareInfo) throws DiagrammerException {
        int x;
        log.trace((Object)"toDiagrammerModel(diagrammer)");
        Map activityConfigInfo = (Map)acmCaseShareInfo.getObject(AcmCaseShareInfo.ACTIVITY_CONFIG_INFO);
        String NO_PARTICIPANT_LANE_NAME = activityConfigInfo != null ? (String)activityConfigInfo.get("SWIMLANE_NAME_NO_PARTICPANT") : "Undefined Participants";
        this.renderLast = new ArrayList<IlvSDMNode>();
        IlvSDMEngine engine = diagrammer.getEngine();
        IlvLaneRenderer laneRenderer = new IlvLaneRenderer();
        laneRenderer.setHorizontal(true);
        laneRenderer.setProcessMouseMoveEvents(true);
        laneRenderer.setSpacing(0.0f);
        List<AcmActivitySwimLane> lanes = null;
        if (this.swimLanesMap != null) {
            lanes = AcmActivityEditorUtil.sortByLanePosition(this.swimLanesMap);
            for (AcmActivitySwimLane lane : lanes) {
                this.addSwimLaneToCanvas(diagrammer, lane, engine, laneRenderer);
            }
        } else {
            log.error((Object)"SwimLanes not found.");
            throw new DiagrammerException("SwimLanes not found.");
        }
        Iterator<AcmTask> tasks = this.tasks.iterator();
        Iterator<AcmRoute> routes = this.routes.iterator();
        while (tasks.hasNext()) {
            AcmTask task = tasks.next();
            Object object = diagrammer.createNode(task.getName());
            boolean adhoc = false;
            if (task.isLaunchStep() && this.sdfData.getUserCreatable()) {
                adhoc = true;
            }
            if (task.isLaunchStep()) {
                diagrammer.setID(object, this.launchStep.getId());
                diagrammer.setObjectProperty(object, "jviewsid", (Object)this.launchStep.getId());
                diagrammer.setObjectProperty(object, "Name", (Object)task.getName());
                diagrammer.setObjectProperty(object, "BiDiLabel", (Object)AcmActivityEditorUtil.addJViewsPadding(task.getName()));
                diagrammer.setObjectProperty(object, "Description", (Object)task.getDescription());
                diagrammer.setObjectProperty(object, "StartStep", (Object)"true");
                diagrammer.setObjectProperty(object, "Supported", (Object)"true");
                diagrammer.setObjectProperty(object, "Lane", (Object)NO_PARTICIPANT_LANE_NAME);
                diagrammer.setObjectProperty(object, "sdm:Lane", (Object)NO_PARTICIPANT_LANE_NAME);
            }
            diagrammer.setObjectProperty(object, "Supported", (Object)task.isSupportedTask());
            if (!task.isLaunchStep() && task.isSupportedTask() || adhoc) {
                if (adhoc) {
                    diagrammer.setObjectProperty(object, "LaunchMode", (Object)"userCreated");
                }
                if (!adhoc) {
                    diagrammer.setObjectProperty(object, "tag_roundtrip", (Object)"step_roundtrip");
                }
                diagrammer.setObjectProperty(object, "StartStep", (Object)task.isLaunchStep());
                if (task.getName() != null && !task.getName().isEmpty() && task.getName().length() > 0) {
                    diagrammer.setObjectProperty(object, "BiDiLabel", (Object)AcmActivityEditorUtil.addJViewsPadding(task.getName()));
                    diagrammer.setObjectProperty(object, "Name", (Object)task.getName());
                }
                if (task.getDescription() != null) {
                    diagrammer.setObjectProperty(object, "Description", (Object)task.getDescription());
                } else {
                    diagrammer.setObjectProperty(object, "Description", (Object)"");
                }
                if (task.getInstruction() != null) {
                    diagrammer.setObjectProperty(object, "Instruction", (Object)task.getInstruction());
                } else {
                    diagrammer.setObjectProperty(object, "Instruction", (Object)"");
                }
                diagrammer.setObjectProperty(object, "Reassign", (Object)task.getCanReassign());
                if (task.getDeadlineJsonStr() != null && !task.getDeadlineJsonStr().isEmpty() && task.getDeadlineJsonStr().length() > 0) {
                    diagrammer.setObjectProperty(object, "Deadline", (Object)task.getDeadlineJsonStr());
                }
                if (task.getJoinType() == 3) {
                    diagrammer.setObjectProperty(object, "Join", (Object)"AUTO");
                } else if (task.getJoinType() == 1) {
                    diagrammer.setObjectProperty(object, "Join", (Object)"AND");
                } else if (task.getJoinType() == 2) {
                    diagrammer.setObjectProperty(object, "Join", (Object)"OR");
                } else {
                    diagrammer.setObjectProperty(object, "Join", (Object)"AUTO");
                }
                if (task.getSplitType() == 3) {
                    diagrammer.setObjectProperty(object, "Split", (Object)"NONE");
                } else if (task.getSplitType() == 1) {
                    diagrammer.setObjectProperty(object, "Split", (Object)"AND");
                } else if (task.getSplitType() == 2) {
                    diagrammer.setObjectProperty(object, "Split", (Object)"OR");
                } else {
                    diagrammer.setObjectProperty(object, "Split", (Object)"AUTO");
                }
                if (task.getResponses() != null && !task.getResponses().isEmpty() && task.getResponses().size() > 0) {
                    diagrammer.setObjectProperty(object, "Responses", (Object)AcmActivityEditorUtil.convertToString(task.getResponses()));
                }
                if (!adhoc && task.getPageLayout() != null && !task.getPageLayout().isEmpty() && task.getPageLayout().length() > 0) {
                    diagrammer.setObjectProperty(object, "PageLayout", (Object)task.getPageLayout());
                }
                if (adhoc && task.getPageLayout() != null && !task.getPageLayout().isEmpty() && task.getPageLayout().length() > 0) {
                    diagrammer.setObjectProperty(object, "LaunchPage", (Object)task.getPageLayout());
                }
                if (task.getParameters() != null && !task.getParameters().isEmpty() && task.getParameters().size() > 0) {
                    diagrammer.setObjectProperty(object, "Parameters", (Object)this.convertTaskParamsToJSON(task.getParameters(), task.getParameterSet()));
                }
            }
            if (!task.isSupportedTask()) {
                if (task.getName() != null && !task.getName().isEmpty() && task.getName().length() > 0) {
                    diagrammer.setObjectProperty(object, "BiDiLabel", (Object)AcmActivityEditorUtil.addJViewsPadding(task.getName()));
                    diagrammer.setObjectProperty(object, "Name", (Object)task.getName());
                }
                if (task.getDescription() != null) {
                    diagrammer.setObjectProperty(object, "Description", (Object)task.getDescription());
                }
                if (task.getInstruction() != null) {
                    diagrammer.setObjectProperty(object, "Description", (Object)task.getInstruction());
                }
            }
            log.trace((Object)(object + " :->" + task.getParticipant()));
            diagrammer.setID(object, task.getId());
            diagrammer.setObjectProperty(object, "jviewsid", (Object)task.getId());
            diagrammer.setObjectProperty(object, "Participant", (Object)task.getParticipant());
            diagrammer.setObjectProperty(object, "RoleAssociate", (Object)task.getParticipant());
            diagrammer.setObjectProperty(object, "Lane", (Object)task.getParticipant());
            diagrammer.setObjectProperty(object, "sdm:Lane", (Object)task.getParticipant());
            if (AcmActivityEditorUtil.isNodeAtCorrectLocation(task, this.swimLanesMap.get(task.getParticipant()))) {
                x = task.position.x;
                int y = task.position.y;
                diagrammer.setObjectProperty(object, "x", (Object)x);
                diagrammer.setObjectProperty(object, "y", (Object)y);
                log.trace((Object)(object + " @" + x + "," + y));
                if (x > this.xPosOfNodesInLanes.get(task.getParticipant())) {
                    this.xPosOfNodesInLanes.remove(task.getParticipant());
                    this.xPosOfNodesInLanes.put(task.getParticipant(), new Integer(x));
                }
                diagrammer.addObject(object, null);
                continue;
            }
            this.renderLast.add((IlvSDMNode)object);
        }
        for (IlvSDMNode ilvSDMNode : this.renderLast) {
            String participantLane = (String)diagrammer.getObjectProperty((Object)ilvSDMNode, "Participant");
            x = this.xPosOfNodesInLanes.get(participantLane);
            float y = this.swimLanesMap.get((Object)participantLane).getPosition().y;
            int size = this.swimLanesMap.get(participantLane).getSize();
            log.trace((Object)("y pos of lane" + participantLane + ":" + y));
            y = y >= (float)size ? y + (float)size / 2.0f - (float)size / 4.0f : (float)size / 2.0f - (float)size / 4.0f;
            this.xPosOfNodesInLanes.remove(participantLane);
            this.xPosOfNodesInLanes.put(participantLane, new Integer(x += DEFAULT_HORIZONTAL_NODE_SPACING));
            diagrammer.setObjectProperty((Object)ilvSDMNode, "x", (Object)x);
            diagrammer.setObjectProperty((Object)ilvSDMNode, "y", (Object)Float.valueOf(y));
            log.trace((Object)(ilvSDMNode + " @" + x + "," + y + " and Lane:" + participantLane));
            diagrammer.addObject((Object)ilvSDMNode, null);
        }
        while (routes.hasNext()) {
            AcmRoute acmRoute = routes.next();
            Object from = diagrammer.getObject(acmRoute.getSourceTaskId());
            Object to = diagrammer.getObject(acmRoute.getDestinationTaskId());
            Object routeNode = diagrammer.createLink(acmRoute.getName(), from, to);
            diagrammer.setID(routeNode, acmRoute.getRouteId());
            diagrammer.setObjectProperty(routeNode, "jviewsid", (Object)acmRoute.getRouteId());
            diagrammer.setObjectProperty(routeNode, "Name", (Object)acmRoute.getName());
            diagrammer.setObjectProperty(routeNode, "BiDiLabel", (Object)AcmActivityEditorUtil.addJViewsPadding(acmRoute.getCondition()));
            diagrammer.setObjectProperty(routeNode, "Description", (Object)acmRoute.getDescription());
            diagrammer.setObjectProperty(routeNode, "Conditions", (Object)acmRoute.getCondition());
            diagrammer.setObjectProperty(routeNode, "sourceUI", (Object)acmRoute.getSourceTaskId());
            diagrammer.addObject(routeNode, null);
        }
        this.setDiagrammer(diagrammer);
        log.trace((Object)"<< toDiagrammerMode()");
        return diagrammer;
    }

    private void updateAttachmentsUsed() {
        this.attachments = new HashSet<AcmActivityAttachment>();
        for (AcmTask task : this.tasks) {
            Set<String> attachmentListInTask;
            if (task.getParameterSet() == null || (attachmentListInTask = task.getParameterSet().getAttachmentParameters()) == null) continue;
            Iterator<String> i2 = attachmentListInTask.iterator();
            while (i2.hasNext()) {
                AcmTaskParameter param = task.getParameterByName(i2.next());
                if (param == null) continue;
                this.attachments.add(new AcmActivityAttachment(param.getName(), param.getDescription(), param.isInitiateAttachment()));
            }
        }
    }

    public void updateBasicWorkflowProperties(AcmCaseShareInfo shareInfo) {
        try {
            if (!this.sdfData.isEditable()) {
                log.info((Object)"Reuse work flow is set");
                this.setTaskForReuseWorkflow(true);
                if (this.sdfData.getWorkflowType() != null && this.sdfData.getWorkflowType().equals((Object)EnumWorkflowType.PE)) {
                    this.deleteMap(MAINMAP);
                    this.deleteMap(CASEUPDATE);
                    this.deleteMap(TERMINATE);
                    log.info((Object)"Deleted the Workflow map");
                    this.updateMapFieldsInWorkflow();
                } else {
                    log.info((Object)"Returning as it is One BPM");
                    return;
                }
            }
            this.workflowDef.setBaseWorkClassName(this.BaseWorkClassName);
            this.workflowDef.setName(this.getSymbolicName());
            this.workflowDef.setDescription(this.getDescription());
            this.workflowDef.setAuthorTool("IBM Case Builder");
            String rostername = (String)shareInfo.getObject(AcmCaseShareInfo.ROSTER_NAME);
            if (rostername != null) {
                this.workflowDef.setRosterName(rostername);
            }
            String solutionName = (String)shareInfo.getObject(AcmCaseShareInfo.SOL_NAME);
            String eventLogName = (String)shareInfo.getObject(AcmCaseShareInfo.EVENT_LOG_NAME);
            if (eventLogName != null) {
                this.workflowDef.setEventLogName(eventLogName);
            }
            String solutionIdentifier = (String)shareInfo.getObject(AcmCaseShareInfo.SOL_PREFIX) + "_" + solutionName;
            try {
                this.workflowDef.createFieldUsingString("SolutionIdentifier", "\"" + solutionIdentifier + "\"", 2, false);
            }
            catch (VWException e) {}
        }
        catch (VWException vwe) {
            vwe.printStackTrace();
        }
    }

    public void updateCasePropertiesUsedSet() {
    }

    private void updateDeletions(Set<String> taskIdCheck, Set<String> routeIdCheck) {
        log.debug((Object)">> updateDeletions()");
        if (this.tasks.size() == taskIdCheck.size() && routeIdCheck.size() == this.routes.size()) {
            return;
        }
        Iterator<AcmRoute> i1 = this.routes.iterator();
        while (i1.hasNext()) {
            AcmRoute route = i1.next();
            if (routeIdCheck.contains(route.getRouteId())) continue;
            VWRouteDefinition routeDef = route.getVWRouteDefinition();
            if (routeDef != null) {
                int routeId = routeDef.getRouteId();
                try {
                    routeDef.getSourceStep().deleteRoute(routeId);
                }
                catch (VWException e) {
                    log.warn((Object)"VW Route may have already been deleted if a route is deleted and drawn again without commiting diagram");
                }
            }
            i1.remove();
        }
        Iterator<AcmTask> i2 = this.tasks.iterator();
        while (i2.hasNext()) {
            VWStepDefinition stepDef;
            AcmTask task = i2.next();
            if (taskIdCheck.contains(task.getId())) continue;
            if (task.isSupportedTask()) {
                stepDef = (VWStepDefinition)task.getStepDef();
                try {
                    this.mapDef.deleteStep(stepDef.getStepId());
                }
                catch (VWException e) {
                    log.error((Object)("Error deleting step " + stepDef.getStepId()), (Throwable)e);
                    e.printStackTrace();
                }
                i2.remove();
                continue;
            }
            if (task.isSupportedTask()) continue;
            stepDef = (VWCompoundStepDefinition)task.getStepDef();
            try {
                this.mapDef.deleteStep(stepDef.getStepId());
            }
            catch (VWException e) {
                log.error((Object)("Error deleting system step " + stepDef.getStepId()), (Throwable)e);
                e.printStackTrace();
            }
            i2.remove();
        }
        log.debug((Object)" updateDeletions()");
    }

    public void updateLaunchStep(AcmCaseShareInfo sharedInfo) {
        log.trace((Object)">> updateLaunchStep()");
        if (this.isTaskForReuseWorkflow()) {
            log.info((Object)" Reused Workflow hence returning from updateLaunchStep");
            return;
        }
        log.info((Object)"Normal workflows");
        IlvSDMNode launchNode = (IlvSDMNode)this.diagrammer.getObject(this.launchStep.getId());
        log.trace((Object)("User creatable : " + this.sdfData.getUserCreatable()));
        if (this.sdfData.getUserCreatable()) {
            this.diagrammer.setObjectProperty((Object)launchNode, "Instruction", (Object)"");
            this.diagrammer.setObjectProperty((Object)launchNode, "Deadline", (Object)"");
            this.diagrammer.setObjectProperty((Object)launchNode, "Reminder", (Object)"");
            this.diagrammer.setObjectProperty((Object)launchNode, "Responses", (Object)"");
            this.diagrammer.setObjectProperty((Object)launchNode, "Parameters", (Object)"");
            this.diagrammer.setObjectProperty((Object)launchNode, "LaunchPage", (Object)(sharedInfo.getObject(AcmCaseShareInfo.SOL_PREFIX) + "_CmAcmSTEP_LAUNCH_DEFAULT_PAGE"));
            this.diagrammer.setObjectProperty((Object)launchNode, "LaunchMode", (Object)"userCreated");
            this.diagrammer.setObjectProperty((Object)launchNode, "Split", (Object)"");
            this.diagrammer.setObjectProperty((Object)launchNode, "Join", (Object)"");
        } else {
            this.diagrammer.setObjectProperty((Object)launchNode, "LaunchMode", (Object)"Automatic");
        }
        log.trace((Object)"<< updateLaunchStep()");
    }

    public VWWorkflowDefinition updateModel(IlvDiagrammer diagrammer, boolean copyDiagrammer, AcmCaseShareInfo shareInfo) throws AcmException {
        IlvSDMNode node;
        Object object;
        log.trace((Object)">> updateModel()");
        this.swimLanesMap = new HashMap<String, AcmActivitySwimLane>();
        this.pagesUsed = new HashSet<String>();
        this.launchStepPagesUsed = new HashSet<String>();
        this.workgroups = new HashSet<AcmWorkGroupDefinition>();
        this.attachments = new HashSet<AcmActivityAttachment>();
        HashSet<String> taskIdCheck = new HashSet<String>();
        HashSet<String> routeIdCheck = new HashSet<String>();
        this.casePropertiesInUse = new HashSet<String>();
        if (this.workflowDef == null) {
            log.warn((Object)"WorkflowDef was null. Shouldn't happen. Creating new instance.");
            try {
                this.workflowDef = new VWWorkflowDefinition();
                this.mapDef = this.workflowDef.getMainMap();
            }
            catch (VWException e) {
                e.printStackTrace();
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AcmException("B6005E.ERROR_UPDATING_PE_MODEL");
            }
        }
        Iterator i1 = diagrammer.getAllObjects();
        while (i1.hasNext()) {
            Message msg;
            object = i1.next();
            node = (IlvSDMNode)object;
            if (diagrammer.isLink((Object)node) || !node.getTag().equals("Lane") && !node.getTag().equals("LaneWorkgroup") && !node.getTag().equals("LaneRole")) continue;
            String type = (String)diagrammer.getObjectProperty((Object)node, "Type");
            String lane = type.equalsIgnoreCase("ROLE") ? (String)diagrammer.getObjectProperty((Object)node, "Role") : (type.equalsIgnoreCase("WORKGROUP") ? (String)diagrammer.getObjectProperty((Object)node, "Workgroup") : (String)diagrammer.getObjectProperty((Object)node, "LaneName"));
            if ((lane = AcmActivityEditorUtil.removeJViewsPadding(lane)) == null) {
                log.error((Object)"Lane has invalid name");
                msg = new Message("B6009E.INVALID_SWIMLANE_NAME", lane);
                throw new AcmException(msg);
            }
            if (lane.length() < 1 || lane.equals("")) {
                log.error((Object)"Lane has invalid name");
                msg = new Message("B6009E.INVALID_SWIMLANE_NAME", lane);
                throw new AcmException(msg);
            }
            log.trace((Object)("lane:" + lane));
            if (this.swimLanesMap.get(lane) == null) {
                log.trace((Object)("lane:" + lane + " does not exist. Creating map entry"));
                AcmActivitySwimLane newLane = new AcmActivitySwimLane(diagrammer, node);
                this.swimLanesMap.put(lane, newLane);
                this.xPosOfNodesInLanes.put(newLane.getSwimLaneName(), new Integer(DEFAULT_STARTING_XPOSITION_OF_NODES));
                continue;
            }
            log.error((Object)"There are two swimlanes with the same name in the diagram.");
            msg = new Message("B6010E.SWIMLANE_EXISTS");
            throw new AcmException(msg);
        }
        i1 = diagrammer.getAllObjects();
        while (i1.hasNext()) {
            boolean isSupportedStep;
            AcmTask newTask;
            object = i1.next();
            node = (IlvSDMNode)object;
            if (diagrammer.isLink((Object)node)) {
                AcmRoute newRoute;
                if (this.getRouteById(node.getID()) == null) {
                    newRoute = new AcmRoute(diagrammer, node, this.mapDef);
                    this.routes.add(newRoute);
                } else {
                    newRoute = this.getRouteById(node.getID());
                }
                routeIdCheck.add(node.getID());
                newRoute.updateAcmModelForRoute(diagrammer, node);
                newRoute.updatePeModelForRoute();
                continue;
            }
            if (node.getTag().equals("Lane") || node.getTag().equals("LaneWorkgroup") || node.getTag().equals("LaneRole")) continue;
            if (this.getTaskById(node.getID()) == null) {
                newTask = new AcmTask(diagrammer, node, this.mapDef);
                this.tasks.add(newTask);
            } else {
                newTask = this.getTaskById(node.getID());
            }
            int location = this.tasks.indexOf(newTask);
            taskIdCheck.add(node.getID());
            if (this.sdfData == null) {
                log.error((Object)("AcmActivity.sdfData: " + this.sdfData));
                throw new DiagrammerException("B6004E.INVALID_TASK_OBJECT");
            }
            boolean adhocLaunchStep = this.sdfData.getUserCreatable();
            try {
                newTask.updateAcmModelForStep(diagrammer, copyDiagrammer, node, this.swimLanesMap, adhocLaunchStep, shareInfo);
            }
            catch (DiagrammerException e) {
                log.error((Object)"Error updating ACM model for step", (Throwable)e);
                e.printStackTrace();
                throw e;
            }
            newTask.updatePeModelForStep(diagrammer, copyDiagrammer, node, this.swimLanesMap, adhocLaunchStep, this.workflowDef, shareInfo, this.sdfData);
            this.tasks.remove(location);
            this.tasks.add(location, newTask);
            if (newTask.getParameterSet() != null && newTask.getParameterSet().getCasePropertyParameters() != null) {
                this.casePropertiesInUse.addAll(newTask.getParameterSet().getCasePropertyParameters());
            }
            if (!(isSupportedStep = Boolean.parseBoolean(diagrammer.getObjectProperty((Object)node, "Supported").toString()))) continue;
            boolean isLaunchStep = Boolean.parseBoolean(diagrammer.getObjectProperty((Object)node, "StartStep").toString());
            if (isLaunchStep) {
                this.launchStepPagesUsed.add(newTask.getPageLayout());
                continue;
            }
            this.pagesUsed.add(newTask.getPageLayout());
        }
        this.updateDeletions(taskIdCheck, routeIdCheck);
        this.workflowDef = AcmActivityEditorUtil.updatePeModelWithSwimLanes(this.workflowDef, this.swimLanesMap, shareInfo);
        for (AcmTask task : this.tasks) {
            HashSet<String> routeIdsConnected = new HashSet<String>();
            try {
                VWRouteDefinition[] routesConnected = task.getStepDef().getNextRoutes();
                if (routesConnected != null) {
                    for (int i = 0; i < routesConnected.length; ++i) {
                        routeIdsConnected.add(AcmActivityEditorUtil.createAcmRouteIdFromRouteId(routesConnected[i].getRouteId()));
                    }
                }
            }
            catch (VWException e1) {
                e1.printStackTrace();
            }
            task.setRouteIdsConnected(routeIdsConnected);
        }
        this.workgroups = AcmActivityEditorUtil.createAcmWorkGroupListFromVWWorkflow(this.workflowDef);
        this.attachments = AcmActivityEditorUtil.createAcmAttachmentListFromVWWorkflow(this.workflowDef);
        if (copyDiagrammer) {
            this.setDiagrammer(diagrammer);
        }
        return this.workflowDef;
    }

    public boolean updateTaskById(AcmTask task) {
        for (AcmTask temp : this.tasks) {
            if (!temp.getId().equalsIgnoreCase(task.getId())) continue;
            this.tasks.remove(temp);
            this.tasks.add(task);
            return true;
        }
        return false;
    }

    public boolean isTaskForReuseWorkflow() {
        return this.isTaskForReuseWorkflow;
    }

    public void setTaskForReuseWorkflow(boolean isTaskForReuseWorkflow) {
        this.isTaskForReuseWorkflow = isTaskForReuseWorkflow;
    }

    public String getBaseWorkClassName() {
        return this.workflowDef.getBaseWorkClassName();
    }

    public void setBaseWorkClassName(String baseWorkClassName) {
        this.BaseWorkClassName = baseWorkClassName;
    }

    public void updateMapFieldsInWorkflow() throws VWException {
        VWMapDefinition map = this.workflowDef.createMap(CASEUPDATE);
        VWMapNode startStep = map.getStartStep();
        startStep.setLocation(new Point(DEFAULT_STARTING_XPOSITION_OF_NODES, DEFAULT_STARTING_XPOSITION_OF_NODES));
        String[][] assignPairs = this.createAssignmentPair();
        if (assignPairs != null) {
            VWCompoundStepDefinition assignStep = map.createCompoundStep(ASSIGNMENTS);
            assignStep.setLocation(new Point(3 * DEFAULT_STARTING_XPOSITION_OF_NODES, DEFAULT_STARTING_XPOSITION_OF_NODES));
            assignStep.createAssignInstruction(assignPairs);
            startStep.createRoute(assignStep.getStepId());
            log.info((Object)"Created Assignments");
        } else {
            log.info((Object)"Assignments NULL");
        }
        log.info((Object)(" Created " + CASEUPDATE));
        map = this.workflowDef.createMap(TERMINATE);
        startStep = map.getStartStep();
        startStep.setLocation(new Point(DEFAULT_STARTING_XPOSITION_OF_NODES, DEFAULT_STARTING_XPOSITION_OF_NODES));
        VWCompoundStepDefinition callStep = map.createCompoundStep(CALL);
        callStep.setLocation(new Point(3 * DEFAULT_STARTING_XPOSITION_OF_NODES, DEFAULT_STARTING_XPOSITION_OF_NODES));
        callStep.createCallInstruction(CASEUPDATE);
        startStep.createRoute(callStep.getStepId());
    }

    private String[][] createAssignmentPair() {
        List mapType = null;
        if (this.sdfData.getWorkflowPropertyMap() != null) {
            mapType = this.sdfData.getWorkflowPropertyMap().getPropertyMap();
            if (mapType != null && mapType.size() > 0) {
                String[][] fieldPairs = new String[mapType.size()][0];
                Iterator mapIterator = mapType.iterator();
                int i = 0;
                while (mapIterator.hasNext()) {
                    PropertyMapType mapElement = (PropertyMapType)mapIterator.next();
                    fieldPairs[i] = new String[]{"F_CaseFolder." + mapElement.getPropertyName(), mapElement.getWorkflowFieldName()};
                    log.info((Object)("Added  :" + fieldPairs[i].toString()));
                    ++i;
                }
                return fieldPairs;
            }
            log.info((Object)"Property Map size is zero");
        } else {
            log.info((Object)"Property Map is NULL");
        }
        return null;
    }

    private void deleteMap(String mapName) {
        log.info((Object)("Deleting map :" + mapName));
        try {
            if (this.workflowDef.getMap(mapName) != null) {
                this.workflowDef.deleteMap(mapName);
                log.info((Object)("Deleted map :" + mapName));
            }
        }
        catch (VWException e) {
            log.info((Object)("Exception while deleting map :" + mapName));
            log.error((Object)e);
        }
    }
}

