/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.diagrammer.listener;

import ilog.views.diagrammer.IlvDiagrammer;
import ilog.views.diagrammer.servlet.IlvDiagrammerDeleteActionListener;
import ilog.views.diagrammer.servlet.IlvDiagrammerServletSupport;
import ilog.views.sdm.IlvSDMView;
import ilog.views.sdm.model.IlvSDMNode;
import ilog.views.servlet.ServerActionEvent;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteActionListener
extends IlvDiagrammerDeleteActionListener {
    private static final Log log = LogFactory.getLog((String)"com.ibm.acm.sold.diagrammer.listener.DeleteActionListener");
    String ACTION_NAME = "deleteObject";

    public void actionPerformed(ServerActionEvent event) throws ServletException {
        if (this.ACTION_NAME.equals(event.getActionName())) {
            log.trace((Object)"Deletions event");
            IlvSDMView view = (IlvSDMView)event.getManagerView();
            IlvDiagrammer diagrammer = ((IlvDiagrammerServletSupport)event.getServletSupport()).getDiagrammer(view);
            if (diagrammer.isEditingAllowed() && diagrammer.isEditable()) {
                Iterator i1 = diagrammer.getSelectedObjects();
                while (i1.hasNext()) {
                    IlvSDMNode node = (IlvSDMNode)i1.next();
                    if (this.canDeleteNode(node, diagrammer)) {
                        diagrammer.delete();
                        continue;
                    }
                    log.trace((Object)"Node(s) can not be deleted");
                }
            } else {
                log.trace((Object)"The workflow (diagrammer) is not allowed to be edited");
            }
        }
    }

    private boolean canDeleteNode(IlvSDMNode node, IlvDiagrammer diagrammer) {
        if (node.getTag().equals("LaunchStep")) {
            log.trace((Object)"LaunchStep: can not be deleted");
            return false;
        }
        if (node.getTag().equals("Lane")) {
            log.trace((Object)"Default Lanes: can not be deleted");
            return false;
        }
        return true;
    }
}

