/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.diagrammer.listener;

import com.ibm.acm.sold.diagrammer.listener.IlvDiagrammerServletUtil;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.diagrammer.IlvDiagrammer;
import ilog.views.diagrammer.servlet.IlvDiagrammerCreateActionListener;
import ilog.views.diagrammer.servlet.IlvDiagrammerServletSupport;
import ilog.views.sdm.IlvSDMView;
import ilog.views.sdm.model.IlvSDMNode;
import ilog.views.servlet.ServerActionEvent;
import java.text.Collator;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateActionListener
extends IlvDiagrammerCreateActionListener {
    private static final Log log = LogFactory.getLog((String)"com.ibm.acm.sold.diagrammer.listener.CreateActionListener");
    String CREATE_ACTION_NAME = "createObject";
    boolean allowed = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void actionPerformed(ServerActionEvent event) throws ServletException {
        if ("createObject".equals(event.getActionName())) {
            view = (IlvSDMView)event.getManagerView();
            servletSupport = event.getServletSupport();
            if (!(servletSupport instanceof IlvDiagrammerServletSupport)) {
                Logger.getLogger("ilog.views.diagrammer.servlet").log(Level.FINEST, "servlet support is not an IlvDiagrammerServletSupport");
                return;
            }
            diagrammer = ((IlvDiagrammerServletSupport)servletSupport).getDiagrammer(view);
            if (!diagrammer.isEditingAllowed() || !diagrammer.isEditable()) {
                Logger.getLogger("ilog.views.diagrammer.servlet").log(Level.WARNING, "IlvDiagrammer instance is not editable");
                return;
            }
            engine = diagrammer.getEngine();
            topManager = engine.getGrapher();
            x = event.getIntParameter(0);
            y = event.getIntParameter(1);
            node = Boolean.valueOf(event.getStringParameter(2));
            tag = event.getStringParameter(3);
            if (engine.processServerAction(x, y, (IlvManagerView)view)) {
                return;
            }
            pt = new IlvPoint((float)x, (float)y);
            if (node) {
                diagrammer.getEngine().setAdjusting(true);
            }
            if (node) {
                obj = this.createNode(event, diagrammer, tag);
                t = view.getTransformer();
                if (t != null) {
                    t.inverse(pt);
                }
                if ("Lane".equals(tag) || "Pool".equals(tag) || "LaneRole".equals(tag) || "LaneWorkgroup".equals(tag)) {
                    pt.y = new Float(pt.y).floatValue();
                    this.allowed = true;
                    maxAllowedPos = this.getLanePosition(diagrammer, y);
                    pt.y = this.allowed != false ? (float)y : maxAllowedPos;
                    diagrammer.getEngine().getModel().setObjectProperty(obj, "x", (Object)new Float(pt.x));
                    diagrammer.getEngine().getModel().setObjectProperty(obj, "y", (Object)Float.valueOf(pt.y));
                } else {
                    diagrammer.getEngine().updateObjectProperties(obj, "x", (Object)new Float(pt.x), null);
                    diagrammer.getEngine().updateObjectProperties(obj, "y", (Object)new Float(pt.y), null);
                }
                parent = engine.getParent((IlvManagerView)view, (float)x, (float)y, false);
            } else {
                source = engine.getObject(pt, (IlvManagerView)view, true);
                if (source == null) {
                    Logger.getLogger("ilog.views.diagrammer.servlet").log(Level.FINEST, "no source for link creation");
                    return;
                }
                parent = diagrammer.getParent(source);
                p = new IlvPoint((float)event.getIntParameter(4), (float)event.getIntParameter(5));
                target = engine.getObject(p, (IlvManagerView)view, true);
                if (target == null) {
                    Logger.getLogger("ilog.views.diagrammer.servlet").log(Level.FINEST, "no target for link creation");
                    return;
                }
                sourceNode = (IlvSDMNode)source;
                targetNode = (IlvSDMNode)target;
                isSourceLane = false;
                isTargetLane = false;
                isTargetLaunch = false;
                isSourceTargetSame = false;
                if (sourceNode.getTag().equals("Lane") || sourceNode.getTag().equals("LaneRole") || sourceNode.getTag().equals("LaneWorkgroup")) {
                    isSourceLane = true;
                }
                if (targetNode.getTag().equals("Lane") || targetNode.getTag().equals("LaneRole") || targetNode.getTag().equals("LaneWorkgroup")) {
                    isTargetLane = true;
                }
                if (targetNode.getID() == sourceNode.getID()) {
                    isSourceTargetSame = true;
                }
                if (diagrammer.getObjectProperty((Object)targetNode, "StartStep") != null) {
                    isTargetLaunch = diagrammer.getObjectProperty((Object)targetNode, "StartStep").equals("true");
                }
                if (!(diagrammer.isLink(source) || diagrammer.isLink(target) || isSourceLane || isTargetLane || isTargetLaunch || isSourceTargetSame)) {
                    obj = this.createLink(event, diagrammer, tag, source, target);
                } else {
                    CreateActionListener.log.trace((Object)"Can not create the link joining the two nodes");
                    Logger.getLogger("ilog.views.diagrammer.servlet").log(Level.FINEST, "invalid target or source for link creation");
                    return;
                }
            }
            diagrammer.addObject(obj, parent);
            if (node) {
                diagrammer.getEngine().setAdjusting(false);
            }
            if ((ilv = engine.getGraphic(obj, false)) != null) {
                manager = (IlvManager)ilv.getGraphicBag();
                if (manager.isSelectable(ilv) && !manager.isSelected(ilv)) {
                    IlvDiagrammerServletUtil.beforeAfterSelection((IlvManager)topManager, (IlvGraphicBag)manager, true);
                    try {
                        topManager.deSelectAll(true, false);
                        manager.setSelected(ilv, true, false);
                        selectionSupport = servletSupport.getSelectionSupport();
                        if (selectionSupport == null) ** GOTO lbl89
                        selectionSupport.setLastSelectedObject(servletSupport.getContext(), (Object)view, (Object)ilv);
                    }
                    finally {
                        IlvDiagrammerServletUtil.beforeAfterSelection((IlvManager)topManager, (IlvGraphicBag)manager, false);
                    }
                }
            } else {
                Logger.getLogger("ilog.views.diagrammer.servlet").log(Level.INFO, "no graphic object was found after object creation");
            }
lbl89:
            // 4 sources

            i1 = diagrammer.getSelectedObjects();
            while (i1.hasNext()) {
                draggedNode = (IlvSDMNode)i1.next();
                if (!this.canCreateNode(draggedNode, diagrammer)) {
                    if (!draggedNode.getTag().equals("step") && !draggedNode.getTag().equals("stub")) continue;
                    CreateActionListener.log.trace((Object)("Node:" + draggedNode + "is not allowed to be created. Node not created"));
                    diagrammer.delete();
                    continue;
                }
                if (draggedNode.getTag().equals("step")) {
                    diagrammer.getEngine().getModel().setObjectProperty((Object)draggedNode, "x", (Object)new Float(pt.x));
                    diagrammer.getEngine().getModel().setObjectProperty((Object)draggedNode, "y", (Object)new Float(pt.y));
                    diagrammer.setObjectProperty((Object)draggedNode, "RoleAssociate", (Object)((String)diagrammer.getObjectProperty((Object)draggedNode, "sdm:Lane")));
                    diagrammer.setObjectProperty((Object)draggedNode, "Lane", (Object)((String)diagrammer.getObjectProperty((Object)draggedNode, "sdm:Lane")));
                } else if (draggedNode.getTag().equals("stub")) {
                    diagrammer.getEngine().getModel().setObjectProperty((Object)draggedNode, "x", (Object)new Float(pt.x));
                    diagrammer.getEngine().getModel().setObjectProperty((Object)draggedNode, "y", (Object)new Float(pt.y));
                } else if (diagrammer.isLink((Object)draggedNode)) {
                    source = (IlvSDMNode)diagrammer.getSourceNode((Object)draggedNode);
                    diagrammer.setObjectProperty((Object)draggedNode, "sourceUI", (Object)source.getID());
                    if (source.getProperty("jviewsId") != null) {
                        diagrammer.setObjectProperty((Object)draggedNode, "sourceJviewsId", source.getProperty("jviewsId"));
                    }
                }
                CreateActionListener.log.trace((Object)("Node:" + draggedNode + "is created successfully"));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean canCreateNode(IlvSDMNode draggedNode, IlvDiagrammer diagrammer) {
        Iterator nodesItr;
        String laneAssociated;
        if (!draggedNode.getTag().equals("step")) {
            if (!draggedNode.getTag().equals("stub")) return true;
            if (diagrammer.getObjectProperty((Object)draggedNode, "sdm:Lane") == null) {
                log.trace((Object)("Node :" + draggedNode + "is drag-dropped out side of any lane. This is not allowed"));
                return false;
            }
            laneAssociated = (String)diagrammer.getObjectProperty((Object)draggedNode, "sdm:Lane");
            nodesItr = diagrammer.getObjects();
        } else {
            if (diagrammer.getObjectProperty((Object)draggedNode, "sdm:Lane") == null) {
                log.trace((Object)("Node :" + draggedNode + "is drag-dropped out side of any lane. This is not allowed"));
                return false;
            }
            String laneAssociated2 = (String)diagrammer.getObjectProperty((Object)draggedNode, "sdm:Lane");
            Iterator nodesItr2 = diagrammer.getObjects();
            while (nodesItr2.hasNext()) {
                String laneType;
                IlvSDMNode node = (IlvSDMNode)nodesItr2.next();
                if (!node.getTag().equals("Lane") && !node.getTag().equals("LaneRole") && !node.getTag().equals("LaneWorkgroup")) continue;
                String laneName = node.getTag().equalsIgnoreCase("LaneRole") ? (String)diagrammer.getObjectProperty((Object)node, "Role") : (node.getTag().equalsIgnoreCase("LaneWorkgroup") ? (String)diagrammer.getObjectProperty((Object)node, "Workgroup") : (String)diagrammer.getObjectProperty((Object)node, "LaneName"));
                if (!Collator.getInstance().equals(laneAssociated2, laneName) || !(laneType = (String)diagrammer.getObjectProperty((Object)node, "Type")).equals("UNSUPPORTED") && !laneType.equals("UNDEFINED")) continue;
                return false;
            }
            return true;
        }
        while (nodesItr.hasNext()) {
            String laneType;
            IlvSDMNode node = (IlvSDMNode)nodesItr.next();
            if (!node.getTag().equals("Lane") && !node.getTag().equals("LaneRole") && !node.getTag().equals("LaneWorkgroup")) continue;
            String laneName = node.getTag().equalsIgnoreCase("LaneRole") ? (String)diagrammer.getObjectProperty((Object)node, "Role") : (node.getTag().equalsIgnoreCase("LaneWorkgroup") ? (String)diagrammer.getObjectProperty((Object)node, "Workgroup") : (String)diagrammer.getObjectProperty((Object)node, "LaneName"));
            if (!Collator.getInstance().equals(laneAssociated, laneName) || (laneType = (String)diagrammer.getObjectProperty((Object)node, "Type")).equals("UNSUPPORTED")) continue;
            return false;
        }
        return true;
    }

    private float getLanePosition(IlvDiagrammer diagrammer, float y) {
        float maxY = 0.0f;
        Iterator itr = diagrammer.getAllObjects();
        while (itr.hasNext()) {
            float laneYActual;
            Object object = itr.next();
            IlvSDMNode node = (IlvSDMNode)object;
            String tag = node.getTag();
            float laneYPos = 0.0f;
            float laneHeight = 0.0f;
            if (!"Lane".equals(tag) && !"Pool".equals(tag) && !"LaneRole".equals(tag) && !"LaneWorkgroup".equals(tag)) continue;
            if (diagrammer.getObjectProperty((Object)node, "sdm:y") != null) {
                laneYPos = Float.parseFloat(diagrammer.getObjectProperty((Object)node, "sdm:y").toString());
            } else if (diagrammer.getObjectProperty((Object)node, "y") != null) {
                laneYPos = Float.parseFloat(diagrammer.getObjectProperty((Object)node, "y").toString());
            }
            if (diagrammer.getObjectProperty((Object)node, "sdm:LaneSize") != null) {
                laneHeight = Float.parseFloat(diagrammer.getObjectProperty((Object)node, "sdm:LaneSize").toString());
            }
            if ((laneYActual = laneYPos + laneHeight) >= maxY) {
                maxY = laneYActual;
            }
            if (!(y < laneYActual) || !(y > laneYPos)) continue;
            this.allowed = false;
        }
        return maxY;
    }
}

