/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.diagrammer.demo.editing;

import com.ibm.acm.sold.comm.SolutionData;
import com.ibm.acm.sold.diagrammer.AcmActivityEditorUtil;
import com.ibm.acm.sold.diagrammer.demo.editing.PropertyAccessor;
import com.ibm.acm.sold.diagrammer.exceptions.DiagrammerException;
import com.ibm.acm.sold.diagrammer.types.AcmActivity;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWValidationError;
import ilog.views.diagrammer.IlvDiagrammer;
import ilog.views.diagrammer.IlvDiagrammerException;
import ilog.views.diagrammer.faces.dhtml.component.IlvFacesDiagrammerPropertyAccessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessingBean {
    private SolutionData solutionData;
    private String caseName;
    private String activityName;
    private String launchMode;
    private List<String> roles;
    private Set<String> caseProperties;
    private static final Log log = LogFactory.getLog((String)ProcessingBean.class.getName());
    private IlvDiagrammer diagrammer;
    AcmActivity activity = null;
    private IlvFacesDiagrammerPropertyAccessor propertyAccessor = new PropertyAccessor();

    public void addRoute(IlvDiagrammer diagrammer, String[] params) {
    }

    public void addTask(IlvDiagrammer diagrammer, String[] params) {
    }

    public IlvFacesDiagrammerPropertyAccessor getPropertyAccessor() {
        return this.propertyAccessor;
    }

    public IlvDiagrammer getDiagrammer() {
        return this.diagrammer;
    }

    public void initAcmModel(IlvDiagrammer diagrammer, String[] params) throws DiagrammerException {
        log.info((Object)">> initAcmModel()");
        this.LoadSession();
        this.LoadJsonData(params);
        this.LoadActivity(diagrammer);
        log.info((Object)"<< initAcmModel()");
    }

    public synchronized void putDiagrammerOnSession(IlvDiagrammer diagrammer, String[] params) {
    }

    public void LoadActivity(IlvDiagrammer diagrammer) throws DiagrammerException {
        log.debug((Object)">> LoadActivity()");
        try {
            log.debug((Object)("Loading Activity:" + this.activityName + "Loading Case:" + this.caseName));
            this.activity = this.solutionData.getCasetypedata(this.caseName.trim()).getActivityByName(this.activityName);
            this.activity.setLaunchModeString(this.launchMode);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)e.getMessage(), (Throwable)e);
            throw new DiagrammerException("B6004E.INVALID_TASK_OBJECT");
        }
        this.diagrammer = this.activity.getDiagrammer();
        AcmActivityEditorUtil.copyDiagrammerOld(this.activity.getDiagrammer(), diagrammer);
        log.debug((Object)"<< LoadActivity()");
    }

    public void LoadJsonData(String[] params) throws DiagrammerException {
        log.debug((Object)">> LoadJsonData()");
        if (params == null) {
            throw new DiagrammerException("B6002E.LOAD_BEAN_JSON_FAILED");
        }
        String activityJsonStr = AcmActivityEditorUtil.arrayToString(params);
        try {
            JSONObject json = JSONObject.parse((String)activityJsonStr);
            this.caseName = (String)json.get((Object)"caseSymbolicName");
            this.activityName = (String)json.get((Object)"taskSymbolicName");
            this.launchMode = (String)json.get((Object)"startMode");
            log.info((Object)("CaseName :" + this.caseName + " , ActivityName :" + this.activityName + " , LaunchMode:" + this.launchMode));
            if (this.caseName == null || this.activityName == null || this.launchMode == null) {
                throw new DiagrammerException("B6003E.ERROR_INVALID_JSON");
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            log.info((Object)e1.getMessage(), (Throwable)e1);
            throw new DiagrammerException("B6003E.ERROR_INVALID_JSON");
        }
        log.debug((Object)"<< LoadJsondata()");
    }

    public void LoadSession() throws DiagrammerException {
        log.debug((Object)">> LoadSession()");
        FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpSession session = (HttpSession)facesContext.getExternalContext().getSession(false);
        if (session == null) {
            throw new DiagrammerException("B6001E.LOAD_SESSION_FAILED");
        }
        this.solutionData = (SolutionData)session.getAttribute("SolutionData");
        session.setAttribute("STEP_EDITOR_VALIDATION_FLAG", (Object)new Boolean(false));
        log.debug((Object)"<< LoadSession()");
    }

    public void okayButton(IlvDiagrammer diagrammer, String[] params) throws IlvDiagrammerException, IOException, DiagrammerException, AcmException {
        log.debug((Object)">> OkayButton()");
        try {
            this.activity.updateModel(diagrammer, true, this.solutionData.getCasetypedata(this.caseName.trim()).getSharedInfo());
            this.activity.autoResolveSplits();
        }
        catch (DiagrammerException e) {
            log.info((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            throw e;
        }
        this.solutionData.getCasetypedata(this.caseName.trim()).addActivity(this.activity);
        this.updateSessionMemory();
        log.debug((Object)"<< OkayButton()");
    }

    public void removeAllNode(IlvDiagrammer diagrammer, String[] params) {
        Object selectedNode = null;
        ArrayList Temp = new ArrayList();
        Iterator selectedObjects = diagrammer.getAllObjects();
        while (selectedObjects.hasNext()) {
            selectedNode = selectedObjects.next();
            Temp.add(selectedNode);
        }
        for (int i = 0; i < Temp.size(); ++i) {
            diagrammer.removeObject(Temp.get(i));
        }
    }

    public void refresh(IlvDiagrammer diagrammer, String[] params) {
    }

    void removeNode(IlvDiagrammer diagrammer, String[] params) {
        Object selectedNode = null;
        Iterator selectedObjects = diagrammer.getSelectedObjects();
        while (selectedObjects.hasNext()) {
            selectedNode = selectedObjects.next();
            if (diagrammer.isLink(selectedNode)) {
                this.activity.removeRoute(selectedNode.toString());
                continue;
            }
            this.activity.removeTask(selectedNode.toString());
        }
    }

    private synchronized void updateSessionMemory() throws DiagrammerException {
        log.debug((Object)">> updateSessionMemory()");
        FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpSession session = (HttpSession)facesContext.getExternalContext().getSession(false);
        if (session == null) {
            log.info((Object)"Session is invalid. Could not update session memory.");
            throw new DiagrammerException("B6001E.LOAD_SESSION_FAILED");
        }
        session.setAttribute("SolutionData", (Object)this.solutionData);
        log.debug((Object)"<< updateSessionMemory()");
    }

    public synchronized VWValidationError[] validateButton(IlvDiagrammer diagrammer, String[] params) throws DiagrammerException, AcmException {
        log.info((Object)"Validate pressed");
        try {
            log.info((Object)"Forcing commit changes to the model");
            this.activity.updateModel(diagrammer, true, this.solutionData.getCasetypedata(this.caseName.trim()).getSharedInfo());
            this.activity.autoResolveSplits();
        }
        catch (DiagrammerException e) {
            log.info((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            throw e;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpSession session = (HttpSession)facesContext.getExternalContext().getSession(false);
        VWSystemConfiguration config = null;
        try {
            config = this.solutionData.getPeconfigData().getSystemConfiguration();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        VWValidationError[] error = null;
        String sdfFile = new String();
        sdfFile = AcmActivityEditorUtil.createSdfFromSolutionType(this.solutionData.getConverterData().getSolutionType());
        StringBuffer buff = new StringBuffer();
        try {
            config.toXML(buff);
        }
        catch (VWException e1) {
            e1.printStackTrace();
        }
        this.activity.getWorkflowDef().setValidateFlag(true);
        try {
            error = AcmActivityEditorUtil.validateActivity(this.activity, config, sdfFile);
        }
        catch (NullPointerException e) {
            log.error((Object)"ERROR: Validation could not be executed");
            e.printStackTrace();
            error = null;
            log.info((Object)"Proceeding to generate XPDL");
        }
        while (((Boolean)session.getAttribute("STEP_EDITOR_VALIDATION_FLAG")).booleanValue()) {
        }
        if (session != null) {
            session.setAttribute("ValidationErrorsObject", (Object)error);
        }
        if (session != null) {
            session.setAttribute("STEP_EDITOR_VALIDATION_FLAG", (Object)new Boolean(true));
        }
        log.info((Object)this.solutionData.getCasetypedata(this.caseName.trim()).toXPDLString());
        return error;
    }
}

