/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.diagrammer;

import com.ibm.acm.sold.diagrammer.AcmActivitySdfData;
import com.ibm.acm.sold.diagrammer.exceptions.DiagrammerException;
import com.ibm.acm.sold.diagrammer.types.AcmActivity;
import com.ibm.acm.sold.diagrammer.types.AcmActivityAttachment;
import com.ibm.acm.sold.diagrammer.types.AcmActivitySwimLane;
import com.ibm.acm.sold.diagrammer.types.AcmCaseShareInfo;
import com.ibm.acm.sold.diagrammer.types.AcmTask;
import com.ibm.acm.sold.diagrammer.types.AcmWorkGroupDefinition;
import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.jaxb.JAXBRetrieve;
import com.ibm.acm.sold.messages.Message;
import com.ibm.xmlns.prod.ecm.acm.sdf.EnumWorkflowType;
import com.ibm.xmlns.prod.ecm.acm.sdf.SolutionType;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import ilog.views.diagrammer.IlvDiagrammer;
import ilog.views.sdm.model.IlvSDMLink;
import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcmActivityEditorUtil {
    public static final int ACM_LAUNCH_STEP = 1;
    private static final String ROUTE_PREFIX = "ROUTE";
    private static final String TASK_PREFIX = "TASK";
    private static final int SECONDS = 1;
    private static final int MINUTES = 2;
    private static final int HOURS = 3;
    private static final int DAYS = 4;
    private static final int WEEKS = 5;
    private static final int MONTHS = 6;
    private static final Log log = LogFactory.getLog((String)AcmActivityEditorUtil.class.getName());

    public static String addJViewsPadding(String name) {
        if (name != null && !name.isEmpty() && name.length() > 0) {
            name = "\u202a" + name + "\u202c";
        }
        return name;
    }

    public static String arrayToString(String[] params) {
        String outStr = params[0];
        for (int i = 1; i < params.length; ++i) {
            outStr = outStr + "," + params[i];
        }
        return outStr;
    }

    public static String convertMinutesToUnit(long minutes) {
        String unit = "Hrs";
        int HOURS = 60;
        int DAYS = 1440;
        int WEEKS = 10080;
        unit = minutes == 0L ? "Hrs" : (minutes % (long)WEEKS == 0L ? "Weeks" : (minutes % (long)DAYS == 0L ? "Days" : (minutes % (long)HOURS == 0L ? "Hrs" : "Minutes")));
        return unit;
    }

    public static long convertMinutesToValue(long minutes, String deadline_unit) {
        if (deadline_unit.equalsIgnoreCase("Minutes")) {
            return minutes;
        }
        if (deadline_unit.equalsIgnoreCase("Hrs")) {
            return minutes / 60L;
        }
        if (deadline_unit.equalsIgnoreCase("Days")) {
            return minutes / 1440L;
        }
        if (deadline_unit.equalsIgnoreCase("Weeks")) {
            return minutes / 10080L;
        }
        return -1L;
    }

    public static long convertTimeToMinutes(long time, int currentUnits) {
        switch (currentUnits) {
            case 1: {
                if (time % 60L == 0L) {
                    return time / 60L;
                }
            }
            case 2: {
                return time;
            }
            case 3: {
                return time * 60L;
            }
            case 4: {
                return time * 60L * 24L;
            }
            case 5: {
                return time * 60L * 24L * 7L;
            }
            case 6: {
                return time * 60L * 24L * 7L * 30L;
            }
        }
        return -1L;
    }

    public static String convertToString(List<String> lst) {
        String str = "";
        for (int i = 0; i < lst.size(); ++i) {
            str = i != 0 ? str + ", " + lst.get(i) : str + lst.get(i);
        }
        return str;
    }

    public static void copyDiagrammerOld(IlvDiagrammer source, IlvDiagrammer target) {
        log.trace((Object)">> copyDiagrammerOld()");
        AcmActivityEditorUtil.removeAllNode(target);
        Iterator i1 = source.getAllObjects();
        while (i1.hasNext()) {
            Object node = i1.next();
            if (source.isLink(node)) continue;
            Object copyNode = AcmActivityEditorUtil.copyObject(node);
            target.setAdjusting(true);
            target.addObject(copyNode, null);
            target.setAdjusting(false);
        }
        Iterator i2 = source.getAllObjects();
        while (i2.hasNext()) {
            Object node = i2.next();
            if (!source.isLink(node)) continue;
            Object sourceNode = source.getSourceNode(node);
            Object targetNode = source.getTargetNode(node);
            Object adhocSourceNode = target.getObject(((IlvSDMNode)sourceNode).getID());
            Object adhocTargetNode = target.getObject(((IlvSDMNode)targetNode).getID());
            Object link = target.createLink(((IlvSDMLink)node).getTag(), adhocSourceNode, adhocTargetNode);
            target.setID(link, ((IlvSDMNode)node).getID());
            String[] linkProperties = ((IlvSDMNode)node).getPropertyNames();
            if (linkProperties != null) {
                for (int i = 0; i < linkProperties.length; ++i) {
                    Object property = source.getObjectProperty(node, linkProperties[i]);
                    target.setObjectProperty(link, linkProperties[i], property);
                }
            }
            target.addObject(link, null);
        }
        log.debug((Object)"<< copyDiagrammerOld()");
    }

    public static Object copyObject(Object orig) {
        Object obj = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(orig);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            obj = in.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        return obj;
    }

    public static Map<String, AcmActivity> createAcmActivitiesFromVWCollection(Map<String, AcmActivity> activities, VWWorkflowCollectionDefinition collection, AcmCaseShareInfo acmCaseShareInfo, boolean checkOut) throws DiagrammerException {
        HashMap<String, AcmActivity> newActivitiesMap;
        block7: {
            String solPrefix = (String)acmCaseShareInfo.getObject(AcmCaseShareInfo.SOL_PREFIX);
            newActivitiesMap = new HashMap<String, AcmActivity>();
            try {
                VWWorkflowDefinition[] workflows = collection.getWorkflows();
                if (workflows != null) {
                    for (int i = 0; i < workflows.length; ++i) {
                        String symbolicName = workflows[i].getName();
                        log.info((Object)("Searching for the activity :" + symbolicName));
                        if (!activities.containsKey(symbolicName)) continue;
                        AcmActivity activity = activities.get(symbolicName);
                        AcmActivitySdfData data = activity.getSdfData();
                        AcmActivity xpdlActivity = null;
                        if (workflows[i].getBaseWorkClassName() != null && !workflows[i].getBaseWorkClassName().equals("CaseWorkObject") && !AcmActivityEditorUtil.baseWorkClassInherited(workflows[i].getBaseWorkClassName(), activities)) {
                            xpdlActivity = new AcmActivity(workflows[i]);
                            xpdlActivity.setSdfData(data);
                            log.info((Object)"Reuse task populated");
                        } else {
                            xpdlActivity = new AcmActivity(workflows[i], acmCaseShareInfo, data.getUserCreatable());
                            xpdlActivity.setSdfData(data);
                            if (checkOut) {
                                IlvDiagrammer diagrammer = new IlvDiagrammer();
                                xpdlActivity.toDiagrammerModel(diagrammer, acmCaseShareInfo);
                                log.info((Object)"Normal task populated");
                            }
                        }
                        xpdlActivity.setName(activity.getName());
                        xpdlActivity.setSymbolicName(symbolicName);
                        newActivitiesMap.put(symbolicName, xpdlActivity);
                    }
                    break block7;
                }
                return activities;
            }
            catch (VWException e) {
                e.printStackTrace();
                throw new DiagrammerException(e.getMessage());
            }
        }
        return newActivitiesMap;
    }

    private static boolean baseWorkClassInherited(String baseWorkClassName, Map<String, AcmActivity> activities) {
        boolean inherited = false;
        if (activities != null && activities.size() > 0) {
            for (AcmActivity temp : activities.values()) {
                if (!temp.getSymbolicName().equals(baseWorkClassName)) continue;
                inherited = true;
                break;
            }
        }
        return inherited;
    }

    public static Set<VWWorkflowDefinition> getWorkflowsWithNoActivities(Map<String, AcmActivity> activities, VWWorkflowCollectionDefinition collection) throws DiagrammerException {
        HashSet<VWWorkflowDefinition> wfWithNoActivities = new HashSet<VWWorkflowDefinition>();
        try {
            VWWorkflowDefinition[] workflows = collection.getWorkflows();
            if (workflows != null) {
                for (int i = 0; i < workflows.length; ++i) {
                    String symbolicName = workflows[i].getName();
                    if (activities.containsKey(symbolicName)) continue;
                    wfWithNoActivities.add(workflows[i]);
                }
            }
        }
        catch (VWException e) {
            e.printStackTrace();
            throw new DiagrammerException(e.getMessage());
        }
        return wfWithNoActivities;
    }

    public static Set<AcmActivityAttachment> createAcmAttachmentListFromVWWorkflow(VWWorkflowDefinition wflDef) throws DiagrammerException {
        HashSet<AcmActivityAttachment> attachmentSet = new HashSet<AcmActivityAttachment>();
        try {
            VWFieldDefinition[] fields = wflDef.getFields();
            if (fields != null) {
                for (int j = 0; j < fields.length; ++j) {
                    if (fields[j].getFieldType() != 32) continue;
                    attachmentSet.add(new AcmActivityAttachment(fields[j]));
                }
            }
        }
        catch (VWException e) {
            e.printStackTrace();
            throw new DiagrammerException(e.getMessage());
        }
        return attachmentSet;
    }

    public static String createAcmRouteIdFromRouteId(int id) {
        return ROUTE_PREFIX + new Integer(id).toString();
    }

    public static String createAcmTaskIdFromStepId(int id) {
        return TASK_PREFIX + new Integer(id).toString();
    }

    public static Set<AcmWorkGroupDefinition> createAcmWorkGroupListFromAcmActivities(Map<String, AcmActivity> activitiesMap) throws DiagrammerException {
        HashSet<AcmWorkGroupDefinition> workgroupsSet = new HashSet<AcmWorkGroupDefinition>();
        Iterator<String> i1 = activitiesMap.keySet().iterator();
        while (i1.hasNext()) {
            workgroupsSet.addAll(activitiesMap.get(i1.next()).getWorkgroupDef());
        }
        return workgroupsSet;
    }

    public static Set<AcmWorkGroupDefinition> createAcmWorkGroupListFromVWCollection(VWWorkflowCollectionDefinition collection) throws DiagrammerException {
        HashSet<AcmWorkGroupDefinition> workgroupsSet = new HashSet<AcmWorkGroupDefinition>();
        try {
            VWWorkflowDefinition[] workflows = collection.getWorkflows();
            for (int i = 0; i < workflows.length; ++i) {
                Set<AcmWorkGroupDefinition> tmpSet = AcmActivityEditorUtil.createAcmWorkGroupListFromVWWorkflow(workflows[i]);
                workgroupsSet.addAll(tmpSet);
            }
        }
        catch (VWException e) {
            e.printStackTrace();
            throw new DiagrammerException(e.getMessage());
        }
        return workgroupsSet;
    }

    public static Set<AcmWorkGroupDefinition> createAcmWorkGroupListFromVWWorkflow(VWWorkflowDefinition def) throws DiagrammerException {
        HashSet<AcmWorkGroupDefinition> workgroupsSet = new HashSet<AcmWorkGroupDefinition>();
        try {
            VWFieldDefinition[] fields = def.getFields();
            if (fields != null) {
                for (int j = 0; j < fields.length; ++j) {
                    if (fields[j].getFieldType() != 64) continue;
                    workgroupsSet.add(new AcmWorkGroupDefinition(fields[j]));
                }
            }
        }
        catch (VWException e) {
            e.printStackTrace();
            throw new DiagrammerException(e.getMessage());
        }
        return workgroupsSet;
    }

    public static Set<String> createCasePropertiesListFromVWWorkflow(VWWorkflowDefinition wflDef, Set<String> casePropertiesList) throws DiagrammerException {
        HashSet<String> casePropertiesSet = new HashSet<String>();
        try {
            VWFieldDefinition[] fields = wflDef.getFields();
            if (fields != null) {
                for (int j = 0; j < fields.length; ++j) {
                    if (fields[j].getFieldType() == 32 || fields[j].getFieldType() == 64 || fields[j].getFieldType() == 512 || !casePropertiesList.contains(fields[j].getName())) continue;
                    casePropertiesSet.add(fields[j].getName());
                }
            }
        }
        catch (VWException e) {
            e.printStackTrace();
            throw new DiagrammerException(e.getMessage());
        }
        return casePropertiesSet;
    }

    public static int createRouteIdFromAcmRouteId(String Id2) {
        return Integer.parseInt(Id2.replace(ROUTE_PREFIX, ""));
    }

    public static String createSdfFromSolutionType(SolutionType solType) {
        String sdfFile = null;
        try {
            sdfFile = new JAXBRetrieve().getConvXml(solType);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (AcmException e) {
            e.printStackTrace();
        }
        return sdfFile;
    }

    public static int createStepIdFromAcmTaskId(String Id2) {
        return Integer.parseInt(Id2.replace(TASK_PREFIX, ""));
    }

    public static VWWorkflowCollectionDefinition createVWCollectionFromActivites(Map<String, AcmActivity> activities, Set<VWWorkflowDefinition> wfWithNoActivities) throws DiagrammerException {
        VWWorkflowCollectionDefinition collection = new VWWorkflowCollectionDefinition();
        if (activities.size() > 0) {
            Iterator<AcmActivity> activityIterator = activities.values().iterator();
            while (activityIterator.hasNext()) {
                try {
                    AcmActivity tempActivity = activityIterator.next();
                    if (tempActivity.getSdfData() != null) {
                        if (tempActivity.getSdfData().getWorkflowType() != null) {
                            if (tempActivity.getSdfData().getWorkflowType().equals((Object)EnumWorkflowType.ONE_BPM)) {
                                log.info((Object)("Ignoring workflow : " + tempActivity.getName()));
                                continue;
                            }
                            log.info((Object)"work flow is not one bpm");
                        } else {
                            log.info((Object)"work flow type is null");
                        }
                    } else {
                        log.info((Object)"SDF is null");
                    }
                    log.info((Object)("Adding workflow : " + tempActivity.getName()));
                    collection.addWorkflow(tempActivity.getVWWorkflowDefinition());
                }
                catch (VWException e) {
                    log.error((Object)e, (Throwable)e);
                    throw new DiagrammerException(e.getCauseDescription());
                }
            }
        }
        if (wfWithNoActivities != null && wfWithNoActivities.size() > 0) {
            for (VWWorkflowDefinition wfDef : wfWithNoActivities) {
                try {
                    if (wfDef.getName().equals("")) continue;
                    collection.addWorkflow(wfDef);
                }
                catch (VWException e) {
                    e.printStackTrace();
                }
            }
        }
        return collection;
    }

    public static VWWorkflowCollectionDefinition createVWCollectionFromActivites(AcmCaseShareInfo shareInfo, Map<String, AcmActivity> activities, Set<VWWorkflowDefinition> wfWithNoActivities, VWWorkflowCollectionDefinition gblColl) throws DiagrammerException {
        VWWorkflowCollectionDefinition collection = new VWWorkflowCollectionDefinition();
        VWWorkflowCollectionDefinition gblcollection = new VWWorkflowCollectionDefinition();
        if (activities.size() > 0) {
            Iterator<AcmActivity> activityIterator = activities.values().iterator();
            while (activityIterator.hasNext()) {
                try {
                    AcmActivity tempActivity = activityIterator.next();
                    log.info((Object)("Checking workflow : " + tempActivity.getName()));
                    if (tempActivity.isTaskForReuseWorkflow()) {
                        log.info((Object)("Found ReUSed workflow : " + tempActivity.getName()));
                        if (tempActivity.getSdfData() != null && tempActivity.getSdfData().getWorkflowType() != null && tempActivity.getSdfData().getWorkflowType().equals((Object)EnumWorkflowType.PE)) {
                            collection.addWorkflow(tempActivity.getVWWorkflowDefinition());
                            continue;
                        }
                        log.info((Object)"Ignoring IBPM task");
                        continue;
                    }
                    collection.addWorkflow(tempActivity.getVWWorkflowDefinition());
                }
                catch (VWException e) {
                    log.error((Object)e, (Throwable)e);
                    throw new DiagrammerException(e.getCauseDescription());
                }
            }
            try {
                if (gblColl != null) {
                    collection.registerExternalWorkflowsFromCollection(gblColl);
                }
            }
            catch (VWException e) {
                log.error((Object)e, (Throwable)e);
                throw new DiagrammerException(e.getCauseDescription());
            }
        }
        if (wfWithNoActivities != null && wfWithNoActivities.size() > 0) {
            for (VWWorkflowDefinition wfDef : wfWithNoActivities) {
                try {
                    collection.addWorkflow(wfDef);
                }
                catch (VWException e) {
                    e.printStackTrace();
                }
            }
        }
        return collection;
    }

    public static Set<AcmWorkGroupDefinition> createWorkgroupSet(Map<String, AcmActivitySwimLane> swimLanesMap) {
        log.debug((Object)">> createWorkgroupSet");
        HashSet<AcmWorkGroupDefinition> workgroup = new HashSet<AcmWorkGroupDefinition>();
        AcmActivitySwimLane[] lanesArray = new AcmActivitySwimLane[swimLanesMap.size()];
        swimLanesMap.values().toArray(lanesArray);
        for (int i = 0; i < lanesArray.length; ++i) {
            if (!lanesArray[i].getSwimLaneType().equalsIgnoreCase("WORKGROUP")) continue;
            workgroup.add(new AcmWorkGroupDefinition(lanesArray[i].getSwimLaneName(), lanesArray[i].getDescription()));
        }
        log.debug((Object)"<< createWorkgroupSet");
        return workgroup;
    }

    public static Set difference(Set A, Set B) {
        HashSet set = new HashSet();
        set.addAll(A);
        set.removeAll(B);
        return set;
    }

    public static Map<String, List<String>> doCustomValidationOfActivitiesMap(Map<String, AcmActivity> activities, Set<VWWorkflowDefinition> wfWithNoActivities, Locale locale) {
        HashMap<String, List<String>> customErrorsMap = new HashMap<String, List<String>>();
        for (String activityName : activities.keySet()) {
            if (activities.get(activityName) != null && activities.get((Object)activityName).isTaskForReuseWorkflow) {
                log.info((Object)("Skipping custom validation for :" + activityName));
                continue;
            }
            log.info((Object)("Doing custom validation for :" + activityName));
            List<String> errors = AcmActivityEditorUtil.doCustomValidationOfActivity(activities.get(activityName), locale);
            customErrorsMap.put(activityName, errors);
        }
        if (wfWithNoActivities == null) {
            log.info((Object)"work flow without activity is null");
            return customErrorsMap;
        }
        for (VWWorkflowDefinition wf : wfWithNoActivities) {
            ArrayList errors = new ArrayList();
            customErrorsMap.put(wf.getName(), errors);
        }
        return customErrorsMap;
    }

    public static List<String> doCustomValidationOfActivity(AcmActivity activity, Locale locale) {
        ArrayList<String> errors = new ArrayList<String>();
        errors.addAll(AcmActivityEditorUtil.validateLanes(activity, locale));
        return errors;
    }

    public static String generateSymbolicName(String prefix, String name) {
        String badChars = " \t\\&^%$#@!-+=*/<>:;[]{}`~()|,.?\"'";
        String result = prefix;
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (badChars.indexOf(ch) >= 0) continue;
            result = result + ch;
        }
        return result;
    }

    public static String getDefaultValue(int nFieldType, boolean bIsArray) {
        switch (nFieldType) {
            case 32: {
                VWAttachment vwAtt = new VWAttachment();
                if (bIsArray) {
                    return "{\"" + vwAtt.toString() + "\"}";
                }
                return "\"" + vwAtt.toString() + "\"";
            }
            case 4: {
                if (bIsArray) {
                    return "{true}";
                }
                return "true";
            }
            case 8: {
                if (bIsArray) {
                    return "{0.0}";
                }
                return "0.0";
            }
            case 512: {
                try {
                    VWGuid vwGuid = new VWGuid();
                    if (bIsArray) {
                        return "{\"" + vwGuid.toString() + "\"}";
                    }
                    return "\"" + vwGuid.toString() + "\"";
                }
                catch (VWException e) {
                    e.printStackTrace();
                }
            }
            case 1: {
                if (bIsArray) {
                    return "{0}";
                }
                return "0";
            }
            case 2: 
            case 64: 
            case 128: {
                if (bIsArray) {
                    return "{\"\"}";
                }
                return "\"\"";
            }
            case 16: {
                if (bIsArray) {
                    return "{null(time)}";
                }
                return "null(time)";
            }
        }
        return "";
    }

    private static Point getMaxLanePosition(Map<String, AcmActivitySwimLane> swimLanesMap, Integer sizeOfLastLane) {
        Iterator<AcmActivitySwimLane> lanes = swimLanesMap.values().iterator();
        Point max = new Point(0, 0);
        while (lanes.hasNext()) {
            AcmActivitySwimLane lane = lanes.next();
            if (lane.getPosition().y <= max.y) continue;
            max = lane.getPosition();
            sizeOfLastLane = lane.getSize();
        }
        return max;
    }

    public static Map<String, AcmActivitySwimLane> getSwimLanes(VWWorkflowDefinition workflowDef, AcmCaseShareInfo caseShareInfo) throws DiagrammerException {
        String UNSUPPORTED_LANE_NAME;
        String NO_PARTICIPANT_LANE_NAME;
        HashMap<String, AcmActivitySwimLane> swimLanesMap = null;
        VWAttributeInfo attribute = null;
        HashMap queueRoleMap = (HashMap)caseShareInfo.getObject(AcmCaseShareInfo.QUEUE_ROLE_MAP);
        String solPrefix = (String)caseShareInfo.getObject(AcmCaseShareInfo.SOL_PREFIX);
        Map activityConfigInfo = (Map)caseShareInfo.getObject(AcmCaseShareInfo.ACTIVITY_CONFIG_INFO);
        if (activityConfigInfo != null) {
            NO_PARTICIPANT_LANE_NAME = (String)activityConfigInfo.get("SWIMLANE_NAME_NO_PARTICPANT");
            UNSUPPORTED_LANE_NAME = (String)activityConfigInfo.get("SWIMLANE_NAME_UNSUPPORTED");
        } else {
            NO_PARTICIPANT_LANE_NAME = "Undefined Participants";
            UNSUPPORTED_LANE_NAME = "System";
        }
        String activityName = workflowDef.getName();
        try {
            attribute = workflowDef.getAttributeInfo();
        }
        catch (VWException e1) {
            e1.printStackTrace();
            swimLanesMap = null;
            throw new DiagrammerException("Error fetching Attribute Info from PE Workflow");
        }
        if (attribute != null) {
            try {
                String[] swimLanesArray = (String[])attribute.getFieldValue("SwimLanes");
                swimLanesMap = new HashMap<String, AcmActivitySwimLane>();
                for (int i = 0; i < swimLanesArray.length; ++i) {
                    AcmActivitySwimLane lane = new AcmActivitySwimLane();
                    String[] params = swimLanesArray[i].split(",");
                    if (params.length != 5) {
                        throw new DiagrammerException("Invalid SwimLaneInfo");
                    }
                    if (params[3].equalsIgnoreCase("UNDEFINED")) {
                        lane.setSwimLaneName(NO_PARTICIPANT_LANE_NAME);
                    } else if (params[3].equals("UNSUPPORTED")) {
                        lane.setSwimLaneName(UNSUPPORTED_LANE_NAME);
                    } else {
                        lane.setSwimLaneName(params[0]);
                    }
                    Point position = new Point();
                    position.x = Integer.parseInt(params[1]);
                    position.y = Integer.parseInt(params[2]);
                    lane.setPosition(position);
                    lane.setSwimLaneType(params[3]);
                    lane.setSize(Integer.parseInt(params[4]));
                    swimLanesMap.put(lane.getSwimLaneName(), lane);
                }
            }
            catch (VWException e) {
                e.printStackTrace();
                swimLanesMap = null;
                throw new DiagrammerException("Error fetching SwimLanes");
            }
            catch (ClassCastException e) {
                e.printStackTrace();
                swimLanesMap = null;
                throw new DiagrammerException("Invalid SwimLane Object");
            }
        } else {
            swimLanesMap = null;
        }
        Point maxLanePosition = null;
        if (swimLanesMap != null) {
            Integer sizeOfLastLane = 100;
            maxLanePosition = AcmActivityEditorUtil.getMaxLanePosition(swimLanesMap, sizeOfLastLane);
            maxLanePosition = new Point(0, maxLanePosition.y + sizeOfLastLane);
        } else {
            maxLanePosition = new Point(0, 0);
            swimLanesMap = new HashMap();
            AcmActivitySwimLane unsupportedLane = new AcmActivitySwimLane();
            if (activityConfigInfo != null) {
                unsupportedLane.setSwimLaneName((String)activityConfigInfo.get("SWIMLANE_NAME_UNSUPPORTED"));
            } else {
                unsupportedLane.setSwimLaneName("System");
            }
            unsupportedLane.setSwimLaneType("UNSUPPORTED");
            unsupportedLane.setPosition(maxLanePosition);
            swimLanesMap.put(unsupportedLane.getSwimLaneName(), unsupportedLane);
            maxLanePosition = new Point(0, maxLanePosition.y + 100);
            AcmActivitySwimLane noPartcipantLane = new AcmActivitySwimLane();
            if (activityConfigInfo != null) {
                noPartcipantLane.setSwimLaneName((String)activityConfigInfo.get("SWIMLANE_NAME_NO_PARTICPANT"));
            } else {
                noPartcipantLane.setSwimLaneName("Undefined Participants");
            }
            noPartcipantLane.setSwimLaneType("UNDEFINED");
            noPartcipantLane.setPosition(maxLanePosition);
            swimLanesMap.put(noPartcipantLane.getSwimLaneName(), noPartcipantLane);
            maxLanePosition = new Point(0, maxLanePosition.y + 100);
        }
        log.trace(swimLanesMap);
        try {
            VWMapNode[] nodes = workflowDef.getMainMap().getSteps();
            for (int i = 0; i < nodes.length; ++i) {
                String queueName;
                AcmActivitySwimLane lane = new AcmActivitySwimLane();
                lane.setActivityName(activityName);
                String participantName = null;
                if (!(nodes[i] instanceof VWStepDefinition)) continue;
                participantName = queueName = ((VWStepDefinition)nodes[i]).getQueueName();
                if (queueName == null) {
                    participantName = NO_PARTICIPANT_LANE_NAME;
                    lane.setSwimLaneType("UNDEFINED");
                    lane.setSwimLaneName(participantName);
                } else if (queueName.equalsIgnoreCase("Inbox")) {
                    participantName = ((VWStepDefinition)nodes[i]).getParticipants()[0].getParticipantName();
                    lane.setSwimLaneType("WORKGROUP");
                    if (participantName == null) {
                        participantName = NO_PARTICIPANT_LANE_NAME;
                        lane.setSwimLaneType("UNDEFINED");
                    }
                    lane.setSwimLaneName(participantName);
                } else {
                    if (queueRoleMap.containsKey(participantName)) {
                        participantName = AcmActivityEditorUtil.getValidRole(queueRoleMap, participantName);
                        lane.setSwimLaneName(participantName);
                    } else {
                        lane.setSwimLaneName(participantName);
                    }
                    lane.setSwimLaneType("ROLE");
                }
                if (swimLanesMap.containsKey(participantName)) continue;
                lane.setPosition(maxLanePosition);
                maxLanePosition = new Point(maxLanePosition.x, maxLanePosition.y + 100);
                swimLanesMap.put(participantName, lane);
            }
        }
        catch (VWException e) {
            e.printStackTrace();
        }
        return swimLanesMap;
    }

    public static Comparator<AcmActivitySwimLane> IncreasingYPositionOfLanes() {
        class CompareLanesByIncreasingYPosition
        implements Comparator<AcmActivitySwimLane> {
            CompareLanesByIncreasingYPosition() {
            }

            @Override
            public int compare(AcmActivitySwimLane lane1, AcmActivitySwimLane lane2) {
                if (lane1.getPosition().y < lane2.getPosition().y) {
                    return 1;
                }
                if (lane1.getPosition().y > lane2.getPosition().y) {
                    return -1;
                }
                return 0;
            }
        }
        return new CompareLanesByIncreasingYPosition();
    }

    public static boolean isLaunchStep(VWMapNode node) {
        return node.getNodeType() == 1;
    }

    public static boolean isNodeAtCorrectLocation(AcmTask task, AcmActivitySwimLane lane) {
        Point taskPosition = task.position;
        Point lanePosition = lane.getPosition();
        if (task.getParticipant() != null && !task.getParticipant().equals(lane.getSwimLaneName())) {
            return false;
        }
        if (task.position.x < 0 || taskPosition.y <= 0) {
            return false;
        }
        return taskPosition.y < lanePosition.y + lane.getSize() && taskPosition.y > lanePosition.y && task.position.x > 0;
    }

    public static VWWorkflowDefinition openDefinitionFromFile(String wfDefFile) {
        VWWorkflowCollectionDefinition coll = null;
        VWWorkflowDefinition wflDef = null;
        Log log = LogFactory.getLog((String)AcmActivityEditorUtil.class.getName());
        try {
            log.info((Object)("Reading XPDL file:" + wfDefFile));
            coll = VWWorkflowCollectionDefinition.readFromFile((String)wfDefFile);
            wflDef = coll.getMainWorkflow();
            log.info((Object)"XPDL file read successfully.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return wflDef;
    }

    public static void printDiagrammerContents(IlvDiagrammer diagrammer) {
        Iterator i1 = diagrammer.getAllObjects();
        while (i1.hasNext()) {
            Object object = i1.next();
            if (!diagrammer.isLink(object)) continue;
            Object source = diagrammer.getSourceNode(object);
            Object target = diagrammer.getTargetNode(object);
            System.out.println(object + " connects " + source + " and " + target);
        }
    }

    private static void removeAllNode(IlvDiagrammer target) {
        Object selectedNode = null;
        ArrayList Temp = new ArrayList();
        Iterator selectedObjects = target.getAllObjects();
        while (selectedObjects.hasNext()) {
            selectedNode = selectedObjects.next();
            Temp.add(selectedNode);
        }
        for (int i = 0; i < Temp.size(); ++i) {
            target.removeObject(Temp.get(i));
        }
    }

    public static String removeJViewsPadding(String name) {
        if (name != null && !name.isEmpty() && name.length() > 0 && name.codePointAt(0) == 8234) {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    public static List<AcmActivitySwimLane> sortByLanePosition(Map<String, AcmActivitySwimLane> swimLanesMap) {
        ArrayList<AcmActivitySwimLane> swimLanes = new ArrayList();
        AcmActivitySwimLane[] lanesArray = new AcmActivitySwimLane[swimLanesMap.size()];
        swimLanesMap.values().toArray(lanesArray);
        Arrays.sort(lanesArray, AcmActivityEditorUtil.IncreasingYPositionOfLanes());
        swimLanes = Arrays.asList(lanesArray);
        return swimLanes;
    }

    public static VWWorkflowDefinition updatePeModelWithSwimLanes(VWWorkflowDefinition workflowDef, Map<String, AcmActivitySwimLane> swimLanesMap, AcmCaseShareInfo shareInfo) throws DiagrammerException {
        log.debug((Object)">> updatePeModelWithSwimLanes()");
        try {
            List<AcmActivitySwimLane> swimLanes = AcmActivityEditorUtil.sortByLanePosition(swimLanesMap);
            Iterator<AcmActivitySwimLane> i1 = swimLanes.iterator();
            VWAttributeInfo swimLaneInfo = new VWAttributeInfo();
            String[] swimLanesPositions = new String[swimLanes.size()];
            int i = 0;
            swimLaneInfo.isFieldArray("SwimLanes");
            while (i1.hasNext()) {
                AcmActivitySwimLane lane = i1.next();
                swimLanesPositions[i] = lane.infoString();
                ++i;
            }
            swimLaneInfo.setFieldValue("SwimLanes", (Object)swimLanesPositions);
            workflowDef.setAttributeInfo(swimLaneInfo);
        }
        catch (VWException e) {
            log.info((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            throw new DiagrammerException("B6005E.ERROR_UPDATING_PE_MODEL");
        }
        log.debug((Object)"<< updatePeModelWithSwimLanes()");
        return workflowDef;
    }

    public static HashMap<String, VWValidationError[]> validateActivites(AcmCaseShareInfo shareInfo, Map<String, AcmActivity> activities, VWSystemConfiguration config, String sdfFile, Set<VWWorkflowDefinition> wfWithNoActivities, VWWorkflowCollectionDefinition gblColl) throws DiagrammerException {
        VWWorkflowCollectionDefinition collection = AcmActivityEditorUtil.createVWCollectionFromActivites(shareInfo, activities, wfWithNoActivities, gblColl);
        HashMap validationMap = null;
        try {
            validationMap = collection.validate(null, config, sdfFile);
        }
        catch (VWException e) {
            e.printStackTrace();
        }
        return validationMap;
    }

    public static VWValidationError[] validateActivity(AcmActivity activity, VWSystemConfiguration config, String sdfFile) throws DiagrammerException {
        VWValidationError[] error = null;
        try {
            error = activity.getVWWorkflowDefinition().validate(null, config, sdfFile);
        }
        catch (VWException e) {
            e.printStackTrace();
        }
        return error;
    }

    public static List<String> validateLanes(AcmActivity activity, Locale locale) {
        ArrayList<String> errors = new ArrayList<String>();
        if (activity.isTaskForReuseWorkflow()) {
            return errors;
        }
        Map<String, AcmActivitySwimLane> lanes = activity.getSwimLanesMap();
        if (lanes == null) {
            return errors;
        }
        Iterator<String> i1 = lanes.keySet().iterator();
        Message msg = new Message("B6009E.INVALID_SWIMLANE_NAME");
        while (i1.hasNext()) {
            String lane = i1.next();
            if (lane == null) {
                errors.add(msg.getFormattedTextWithDisplayKey(locale) + ": " + lane);
                continue;
            }
            if (!lane.equalsIgnoreCase("") && !lane.equalsIgnoreCase("null")) continue;
            errors.add(msg.getFormattedTextWithDisplayKey(locale) + ": " + lane);
        }
        return errors;
    }

    public static void updateEventLogChanges(AcmCaseShareInfo shareInfo, VWWorkflowDefinition workflowDef) throws DiagrammerException {
        String workflowEventLog;
        String eventLog = (String)shareInfo.getObject(AcmCaseShareInfo.EVENT_LOG_NAME);
        if (!eventLog.equals(workflowEventLog = workflowDef.getEventLogName())) {
            try {
                workflowDef.setEventLogName(eventLog);
            }
            catch (VWException e) {
                e.printStackTrace();
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new DiagrammerException("B6005E.ERROR_UPDATING_PE_MODEL");
            }
        }
    }

    public static Set<String> getPagesUsedInWorkflow(VWWorkflowDefinition wfDef) {
        HashSet<String> pagesUsed = new HashSet<String>();
        try {
            VWMapNode[] steps = wfDef.getMainMap().getSteps();
            VWStepDefinition launchStep = wfDef.getLaunchStep();
            for (int i = 0; i < steps.length; ++i) {
                if (!(steps[i] instanceof VWStepDefinition) || steps[i].equals(launchStep)) continue;
                pagesUsed.add(((VWStepDefinition)steps[i]).getRequestedInterface());
            }
        }
        catch (VWException e) {
            e.printStackTrace();
        }
        return pagesUsed;
    }

    public static Set<String> getLaunchStepPage(VWWorkflowDefinition wfDef) {
        HashSet<String> launchPagesUsed = new HashSet<String>();
        try {
            launchPagesUsed.add(wfDef.getLaunchStep().getRequestedInterface());
        }
        catch (VWException e) {
            e.printStackTrace();
        }
        return launchPagesUsed;
    }

    public static String getValidRole(Map queueRoleMap, String queueName) {
        String role = null;
        if (queueRoleMap.containsKey(queueName)) {
            Set roleSet = (Set)queueRoleMap.get(queueName);
            if (roleSet.size() >= 1) {
                role = (String)roleSet.toArray()[0];
            } else if (roleSet.size() == 0) {
                role = queueName;
            }
        } else {
            role = queueName;
        }
        return role;
    }

    public static String getQueueForRole(Map<String, Set<String>> queueMap, String roleName) {
        String queueAssociated = null;
        block0: for (Map.Entry<String, Set<String>> mapEntry : queueMap.entrySet()) {
            Set<String> roleSet = mapEntry.getValue();
            for (String role : roleSet) {
                if (!role.equals(roleName)) continue;
                queueAssociated = mapEntry.getKey();
                continue block0;
            }
        }
        return queueAssociated;
    }
}

