/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.acm.sold.converter;

import com.ibm.acm.sold.exception.AcmException;
import com.ibm.acm.sold.messages.Message;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateTime {
    private static final Log log = LogFactory.getLog((String)DateTime.class.getName());

    public static XMLGregorianCalendar getXMLGregorianCalendar(String df) throws AcmException {
        log.trace((Object)">getXMLGregorianCalendar");
        String offset = "";
        Locale loc = new Locale("en", "Us");
        Pattern p = Pattern.compile("(?:\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2})([+-]\\d{2}:\\d{2})");
        Matcher m = p.matcher(df);
        while (m.find()) {
            offset = m.group(1);
            df = df.replace(offset, "");
            String newOffset = offset.replace(":", "");
            df = df + newOffset;
        }
        String Pattern2 = "yyyy-MM-dd'T'HH:mm:ssZ";
        SimpleDateFormat formatter1 = new SimpleDateFormat(Pattern2, loc);
        Date real = null;
        try {
            real = formatter1.parse(df);
        }
        catch (ParseException e) {
            log.error((Object)" error ::  ", (Throwable)e);
            String errorMessage = e.getLocalizedMessage();
            if (errorMessage == null) {
                errorMessage = e.getClass().getName() + " : " + e.getStackTrace()[0].getFileName() + " : " + e.getStackTrace()[0].getLineNumber();
            }
            Message msg = new Message("B0014E.SYSTEM_ERROR", errorMessage);
            throw new AcmException(msg);
        }
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(real);
        XMLGregorianCalendar xg = null;
        try {
            xg = DatatypeFactory.newInstance().newXMLGregorianCalendar(g);
        }
        catch (DatatypeConfigurationException e) {
            log.error((Object)" error ::  ", (Throwable)e);
            String errorMessage = e.getLocalizedMessage();
            if (errorMessage == null) {
                errorMessage = e.getClass().getName() + " : " + e.getStackTrace()[0].getFileName() + " : " + e.getStackTrace()[0].getLineNumber();
            }
            Message msg = new Message("B0014E.SYSTEM_ERROR", errorMessage);
            throw new AcmException(msg);
        }
        log.trace((Object)"<getXMLGregorianCalendar");
        return xg;
    }

    public static String listDate(Date d) {
        log.trace((Object)">listDate");
        String Pattern1 = "yyyy-MM-dd'T'HH:mm:ssZ";
        SimpleDateFormat formatter1 = new SimpleDateFormat(Pattern1);
        String d1 = formatter1.format(d);
        log.debug((Object)("list retrieved date before format: " + d + " after: " + d1));
        log.trace((Object)"<listDate");
        return d1;
    }
}

